/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;

public class TableManagerHelper {
    protected TableManager tableManager;
    public static final String SQL_FROM = "FROM";
    public static final String SQL_INTO = "INTO";
    public static final String CR = " \r\n ";

    public Object invokeTableManger(Context ctx, String methodName, Class[] paramTypes, Object[] params) throws BOSException, EASBizException {
        Object obj = null;
        try {
            if (null == this.tableManager) {
                this.tableManager = TableManager.getTableManager((Context)ctx);
            }
            Method method = TableManager.class.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            obj = method.invoke((Object)this.tableManager, params);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return obj;
    }

    public String generateTableName(Context ctx) throws BOSException, EASBizException {
        Object obj = this.invokeTableManger(ctx, "generateTableName", null, null);
        return obj == null ? null : obj.toString();
    }

    public static String getLinkedField(String field) {
        if (!StringUtils.isEmpty((String)field) && field.split("\\.").length > 1) {
            return "\"" + field + "\"";
        }
        return field;
    }

    protected String createIndexName(Context ctx) throws BOSException, EASBizException {
        Object obj = this.invokeTableManger(ctx, "createIndexName", null, null);
        return obj == null ? null : obj.toString();
    }

    public String createIndexWithTx(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        if (StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columns)) {
            return null;
        }
        columns = columns.trim();
        String indexName = this.createIndexName(ctx);
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : (isClustered ? "CREATE CLUSTERED INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")");
        DbUtil.execute((Context)ctx, (String)sql);
        return indexName;
    }

    public int getTxLevel(Context ctx) throws BOSException {
        int level = 4;
        try {
            if (null == this.tableManager) {
                this.tableManager = TableManager.getTableManager((Context)ctx);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return level;
    }

    public String fetchDataIntoTempTable(Context ctx, String entryIdField, String selectSql) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)selectSql)) {
            return null;
        }
        String tableName = this.generateTableName(ctx);
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        int idx = selectSql.indexOf(SQL_FROM);
        if (idx < 0) {
            return null;
        }
        String selectFields = selectSql.substring(0, idx);
        StringBuilder buf = new StringBuilder(selectSql.length() + tableName.length() + 8);
        buf.append(selectFields).append(CR).append(SQL_INTO).append(" ").append(tableName).append(CR).append(selectSql.substring(idx));
        DbUtil.execute((Context)ctx, (String)buf.toString());
        try {
            this.createIndexWithTx(ctx, tableName, "ID," + TableManagerHelper.getLinkedField(entryIdField), false, true);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }
}

