/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.graphml;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import com.mxgraph.io.graphml.mxGraphMlData;
import com.mxgraph.io.graphml.mxGraphMlUtils;
import com.mxgraph.util.mxConstants;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGraphMlEdge {
    private String edgeId;
    private String edgeSource;
    private String edgeSourcePort;
    private String edgeTarget;
    private String edgeTargetPort;
    private String edgeDirected;
    private mxGraphMlData edgeData;
    private HashMap<String, mxGraphMlData> edgeDataMap = new HashMap();

    public mxGraphMlEdge(String edgeSource, String edgeTarget, String edgeSourcePort, String edgeTargetPort) {
        this.edgeId = "";
        this.edgeSource = edgeSource;
        this.edgeSourcePort = edgeSourcePort;
        this.edgeTarget = edgeTarget;
        this.edgeTargetPort = edgeTargetPort;
        this.edgeDirected = "";
    }

    public mxGraphMlEdge(Element edgeElement) {
        this.edgeId = edgeElement.getAttribute(mxGraphMlConstants.ID);
        this.edgeSource = edgeElement.getAttribute(mxGraphMlConstants.EDGE_SOURCE);
        this.edgeSourcePort = edgeElement.getAttribute(mxGraphMlConstants.EDGE_SOURCE_PORT);
        this.edgeTarget = edgeElement.getAttribute(mxGraphMlConstants.EDGE_TARGET);
        this.edgeTargetPort = edgeElement.getAttribute(mxGraphMlConstants.EDGE_TARGET_PORT);
        this.edgeDirected = edgeElement.getAttribute(mxGraphMlConstants.EDGE_DIRECTED);
        List<Element> dataList = mxGraphMlUtils.childsTags(edgeElement, mxGraphMlConstants.DATA);
        for (Element dataElem : dataList) {
            mxGraphMlData data = new mxGraphMlData(dataElem);
            String key = data.getDataKey();
            this.edgeDataMap.put(key, data);
        }
    }

    public String getEdgeDirected() {
        return this.edgeDirected;
    }

    public void setEdgeDirected(String edgeDirected) {
        this.edgeDirected = edgeDirected;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public String getEdgeSource() {
        return this.edgeSource;
    }

    public void setEdgeSource(String edgeSource) {
        this.edgeSource = edgeSource;
    }

    public String getEdgeSourcePort() {
        return this.edgeSourcePort;
    }

    public void setEdgeSourcePort(String edgeSourcePort) {
        this.edgeSourcePort = edgeSourcePort;
    }

    public String getEdgeTarget() {
        return this.edgeTarget;
    }

    public void setEdgeTarget(String edgeTarget) {
        this.edgeTarget = edgeTarget;
    }

    public String getEdgeTargetPort() {
        return this.edgeTargetPort;
    }

    public void setEdgeTargetPort(String edgeTargetPort) {
        this.edgeTargetPort = edgeTargetPort;
    }

    public HashMap<String, mxGraphMlData> getEdgeDataMap() {
        return this.edgeDataMap;
    }

    public void setEdgeDataMap(HashMap<String, mxGraphMlData> nodeEdgeMap) {
        this.edgeDataMap = nodeEdgeMap;
    }

    public mxGraphMlData getEdgeData() {
        return this.edgeData;
    }

    public void setEdgeData(mxGraphMlData egdeData) {
        this.edgeData = egdeData;
    }

    public Element generateElement(Document document) {
        Element edge = document.createElement(mxGraphMlConstants.EDGE);
        if (!this.edgeId.equals("")) {
            edge.setAttribute(mxGraphMlConstants.ID, this.edgeId);
        }
        edge.setAttribute(mxGraphMlConstants.EDGE_SOURCE, this.edgeSource);
        edge.setAttribute(mxGraphMlConstants.EDGE_TARGET, this.edgeTarget);
        if (!this.edgeSourcePort.equals("")) {
            edge.setAttribute(mxGraphMlConstants.EDGE_SOURCE_PORT, this.edgeSourcePort);
        }
        if (!this.edgeTargetPort.equals("")) {
            edge.setAttribute(mxGraphMlConstants.EDGE_TARGET_PORT, this.edgeTargetPort);
        }
        if (!this.edgeDirected.equals("")) {
            edge.setAttribute(mxGraphMlConstants.EDGE_DIRECTED, this.edgeDirected);
        }
        Element dataElement = this.edgeData.generateEdgeElement(document);
        edge.appendChild(dataElement);
        return edge;
    }

    public String getEdgeStyle() {
        String style = "";
        Hashtable<String, Object> styleMap = new Hashtable<String, Object>();
        if (this.edgeDirected.equals("true")) {
            styleMap.put(mxConstants.STYLE_ENDARROW, "classic");
            style = mxGraphMlUtils.getStyleString(styleMap, "=");
        } else if (this.edgeDirected.equals("false")) {
            styleMap.put(mxConstants.STYLE_ENDARROW, mxConstants.NONE);
            style = mxGraphMlUtils.getStyleString(styleMap, "=");
        }
        return style;
    }
}

