/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.graphml;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGraphMlKey {
    private String keyDefault;
    private String keyId;
    private keyForValues keyFor;
    private String keyName;
    private keyTypeValues keyType;

    public mxGraphMlKey(String keyId, keyForValues keyFor, String keyName, keyTypeValues keyType) {
        this.keyId = keyId;
        this.keyFor = keyFor;
        this.keyName = keyName;
        this.keyType = keyType;
        this.keyDefault = this.defaultValue();
    }

    public mxGraphMlKey(Element keyElement) {
        this.keyId = keyElement.getAttribute(mxGraphMlConstants.ID);
        this.keyFor = this.enumForValue(keyElement.getAttribute(mxGraphMlConstants.KEY_FOR));
        this.keyName = keyElement.getAttribute(mxGraphMlConstants.KEY_NAME);
        this.keyType = this.enumTypeValue(keyElement.getAttribute(mxGraphMlConstants.KEY_TYPE));
        this.keyDefault = this.defaultValue();
    }

    public String getKeyDefault() {
        return this.keyDefault;
    }

    public void setKeyDefault(String keyDefault) {
        this.keyDefault = keyDefault;
    }

    public keyForValues getKeyFor() {
        return this.keyFor;
    }

    public void setKeyFor(keyForValues keyFor) {
        this.keyFor = keyFor;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public keyTypeValues getKeyType() {
        return this.keyType;
    }

    public void setKeyType(keyTypeValues keyType) {
        this.keyType = keyType;
    }

    private String defaultValue() {
        String val = "";
        switch (this.keyType) {
            case BOOLEAN: {
                val = "false";
                break;
            }
            case DOUBLE: {
                val = "0";
                break;
            }
            case FLOAT: {
                val = "0";
                break;
            }
            case INT: {
                val = "0";
                break;
            }
            case LONG: {
                val = "0";
                break;
            }
            case STRING: {
                val = "";
            }
        }
        return val;
    }

    public Element generateElement(Document document) {
        Element key = document.createElement(mxGraphMlConstants.KEY);
        if (!this.keyName.equals("")) {
            key.setAttribute(mxGraphMlConstants.KEY_NAME, this.keyName);
        }
        key.setAttribute(mxGraphMlConstants.ID, this.keyId);
        if (!this.keyName.equals("")) {
            key.setAttribute(mxGraphMlConstants.KEY_FOR, this.stringForValue(this.keyFor));
        }
        if (!this.keyName.equals("")) {
            key.setAttribute(mxGraphMlConstants.KEY_TYPE, this.stringTypeValue(this.keyType));
        }
        if (!this.keyName.equals("")) {
            key.setTextContent(this.keyDefault);
        }
        return key;
    }

    public keyForValues enumForValue(String value) {
        keyForValues enumVal = keyForValues.ALL;
        if (value.equals(mxGraphMlConstants.GRAPH)) {
            enumVal = keyForValues.GRAPH;
        } else if (value.equals(mxGraphMlConstants.NODE)) {
            enumVal = keyForValues.NODE;
        } else if (value.equals(mxGraphMlConstants.EDGE)) {
            enumVal = keyForValues.EDGE;
        } else if (value.equals(mxGraphMlConstants.HYPEREDGE)) {
            enumVal = keyForValues.HYPEREDGE;
        } else if (value.equals(mxGraphMlConstants.PORT)) {
            enumVal = keyForValues.PORT;
        } else if (value.equals(mxGraphMlConstants.ENDPOINT)) {
            enumVal = keyForValues.ENDPOINT;
        } else if (value.equals(mxGraphMlConstants.ALL)) {
            enumVal = keyForValues.ALL;
        }
        return enumVal;
    }

    public String stringForValue(keyForValues value) {
        String val = mxGraphMlConstants.ALL;
        switch (value) {
            case GRAPH: {
                val = mxGraphMlConstants.GRAPH;
                break;
            }
            case NODE: {
                val = mxGraphMlConstants.NODE;
                break;
            }
            case EDGE: {
                val = mxGraphMlConstants.EDGE;
                break;
            }
            case HYPEREDGE: {
                val = mxGraphMlConstants.HYPEREDGE;
                break;
            }
            case PORT: {
                val = mxGraphMlConstants.PORT;
                break;
            }
            case ENDPOINT: {
                val = mxGraphMlConstants.ENDPOINT;
                break;
            }
            case ALL: {
                val = mxGraphMlConstants.ALL;
            }
        }
        return val;
    }

    public keyTypeValues enumTypeValue(String value) {
        keyTypeValues enumVal = keyTypeValues.STRING;
        if (value.equals("boolean")) {
            enumVal = keyTypeValues.BOOLEAN;
        } else if (value.equals("double")) {
            enumVal = keyTypeValues.DOUBLE;
        } else if (value.equals("float")) {
            enumVal = keyTypeValues.FLOAT;
        } else if (value.equals("int")) {
            enumVal = keyTypeValues.INT;
        } else if (value.equals("long")) {
            enumVal = keyTypeValues.LONG;
        } else if (value.equals("string")) {
            enumVal = keyTypeValues.STRING;
        }
        return enumVal;
    }

    public String stringTypeValue(keyTypeValues value) {
        String val = "string";
        switch (value) {
            case BOOLEAN: {
                val = "boolean";
                break;
            }
            case DOUBLE: {
                val = "double";
                break;
            }
            case FLOAT: {
                val = "float";
                break;
            }
            case INT: {
                val = "int";
                break;
            }
            case LONG: {
                val = "long";
                break;
            }
            case STRING: {
                val = "string";
            }
        }
        return val;
    }

    public static enum keyTypeValues {
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING;

    }

    public static enum keyForValues {
        GRAPH,
        NODE,
        EDGE,
        HYPEREDGE,
        PORT,
        ENDPOINT,
        ALL;

    }
}

