/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;

public class mxPerimeter {
    public static mxPerimeterFunction RectanglePerimeter = new mxPerimeterFunction(){

        @Override
        public mxPoint apply(mxRectangle bounds, mxCellState vertex, mxPoint next, boolean orthogonal) {
            double cx = bounds.getCenterX();
            double cy = bounds.getCenterY();
            double dx = next.getX() - cx;
            double dy = next.getY() - cy;
            double alpha = Math.atan2(dy, dx);
            mxPoint p = new mxPoint();
            double pi = Math.PI;
            double pi2 = 1.5707963267948966;
            double beta = pi2 - alpha;
            double t = Math.atan2(bounds.getHeight(), bounds.getWidth());
            if (alpha < -pi + t || alpha > pi - t) {
                p.setX(bounds.getX());
                p.setY(cy - bounds.getWidth() * Math.tan(alpha) / 2.0);
            } else if (alpha < -t) {
                p.setY(bounds.getY());
                p.setX(cx - bounds.getHeight() * Math.tan(beta) / 2.0);
            } else if (alpha < t) {
                p.setX(bounds.getX() + bounds.getWidth());
                p.setY(cy + bounds.getWidth() * Math.tan(alpha) / 2.0);
            } else {
                p.setY(bounds.getY() + bounds.getHeight());
                p.setX(cx + bounds.getHeight() * Math.tan(beta) / 2.0);
            }
            if (orthogonal) {
                if (next.getX() >= bounds.getX() && next.getX() <= bounds.getX() + bounds.getWidth()) {
                    p.setX(next.getX());
                } else if (next.getY() >= bounds.getY() && next.getY() <= bounds.getY() + bounds.getHeight()) {
                    p.setY(next.getY());
                }
                if (next.getX() < bounds.getX()) {
                    p.setX(bounds.getX());
                } else if (next.getX() > bounds.getX() + bounds.getWidth()) {
                    p.setX(bounds.getX() + bounds.getWidth());
                }
                if (next.getY() < bounds.getY()) {
                    p.setY(bounds.getY());
                } else if (next.getY() > bounds.getY() + bounds.getHeight()) {
                    p.setY(bounds.getY() + bounds.getHeight());
                }
            }
            return p;
        }
    };
    public static mxPerimeterFunction EllipsePerimeter = new mxPerimeterFunction(){

        @Override
        public mxPoint apply(mxRectangle bounds, mxCellState vertex, mxPoint next, boolean orthogonal) {
            double x = bounds.getX();
            double y = bounds.getY();
            double a = bounds.getWidth() / 2.0;
            double b = bounds.getHeight() / 2.0;
            double cx = x + a;
            double cy = y + b;
            double px = next.getX();
            double py = next.getY();
            double dx = px - cx;
            double dy = py - cy;
            if (dx == 0.0 && dy != 0.0) {
                return new mxPoint(cx, cy + b * dy / Math.abs(dy));
            }
            if (dx == 0.0 && dy == 0.0) {
                return new mxPoint(px, py);
            }
            if (orthogonal) {
                if (py >= y && py <= y + bounds.getHeight()) {
                    double ty = py - cy;
                    double tx = Math.sqrt(a * a * (1.0 - ty * ty / (b * b)));
                    if (Double.isNaN(tx)) {
                        tx = 0.0;
                    }
                    if (px <= x) {
                        tx = -tx;
                    }
                    return new mxPoint(cx + tx, py);
                }
                if (px >= x && px <= x + bounds.getWidth()) {
                    double tx = px - cx;
                    double ty = Math.sqrt(b * b * (1.0 - tx * tx / (a * a)));
                    if (Double.isNaN(ty)) {
                        ty = 0.0;
                    }
                    if (py <= y) {
                        ty = -ty;
                    }
                    return new mxPoint(px, cy + ty);
                }
            }
            double d = dy / dx;
            double h = cy - d * cx;
            double e = a * a * d * d + b * b;
            double f = -2.0 * cx * e;
            double g = a * a * d * d * cx * cx + b * b * cx * cx - a * a * b * b;
            double det = Math.sqrt(f * f - 4.0 * e * g);
            double xout1 = (-f + det) / (2.0 * e);
            double xout2 = (-f - det) / (2.0 * e);
            double yout1 = d * xout1 + h;
            double yout2 = d * xout2 + h;
            double dist1 = Math.sqrt(Math.pow(xout1 - px, 2.0) + Math.pow(yout1 - py, 2.0));
            double dist2 = Math.sqrt(Math.pow(xout2 - px, 2.0) + Math.pow(yout2 - py, 2.0));
            double xout = 0.0;
            double yout = 0.0;
            if (dist1 < dist2) {
                xout = xout1;
                yout = yout1;
            } else {
                xout = xout2;
                yout = yout2;
            }
            return new mxPoint(xout, yout);
        }
    };
    public static mxPerimeterFunction RhombusPerimeter = new mxPerimeterFunction(){

        @Override
        public mxPoint apply(mxRectangle bounds, mxCellState vertex, mxPoint next, boolean orthogonal) {
            double x = bounds.getX();
            double y = bounds.getY();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            double cx = x + w / 2.0;
            double cy = y + h / 2.0;
            double px = next.getX();
            double py = next.getY();
            if (cx == px) {
                if (cy > py) {
                    return new mxPoint(cx, y);
                }
                return new mxPoint(cx, y + h);
            }
            if (cy == py) {
                if (cx > px) {
                    return new mxPoint(x, cy);
                }
                return new mxPoint(x + w, cy);
            }
            double tx = cx;
            double ty = cy;
            if (orthogonal) {
                if (px >= x && px <= x + w) {
                    tx = px;
                } else if (py >= y && py <= y + h) {
                    ty = py;
                }
            }
            if (px < cx) {
                if (py < cy) {
                    return mxUtils.intersection(px, py, tx, ty, cx, y, x, cy);
                }
                return mxUtils.intersection(px, py, tx, ty, cx, y + h, x, cy);
            }
            if (py < cy) {
                return mxUtils.intersection(px, py, tx, ty, cx, y, x + w, cy);
            }
            return mxUtils.intersection(px, py, tx, ty, cx, y + h, x + w, cy);
        }
    };
    public static mxPerimeterFunction TrianglePerimeter = new mxPerimeterFunction(){

        @Override
        public mxPoint apply(mxRectangle bounds, mxCellState vertex, mxPoint next, boolean orthogonal) {
            String direction = vertex != null ? mxUtils.getString(vertex.style, mxConstants.STYLE_DIRECTION, "east") : "east";
            boolean vertical = direction.equals("north") || direction.equals("south");
            double x = bounds.getX();
            double y = bounds.getY();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            double cx = x + w / 2.0;
            double cy = y + h / 2.0;
            mxPoint start = new mxPoint(x, y);
            mxPoint corner = new mxPoint(x + w, cy);
            mxPoint end = new mxPoint(x, y + h);
            if (direction.equals("north")) {
                start = end;
                corner = new mxPoint(cx, y);
                end = new mxPoint(x + w, y + h);
            } else if (direction.equals("south")) {
                corner = new mxPoint(cx, y + h);
                end = new mxPoint(x + w, y);
            } else if (direction.equals("west")) {
                start = new mxPoint(x + w, y);
                corner = new mxPoint(x, cy);
                end = new mxPoint(x + w, y + h);
            }
            double dx = next.getX() - cx;
            double dy = next.getY() - cy;
            double alpha = vertical ? Math.atan2(dx, dy) : Math.atan2(dy, dx);
            double t = vertical ? Math.atan2(w, h) : Math.atan2(h, w);
            boolean base = false;
            base = direction.equals("north") || direction.equals("west") ? alpha > -t && alpha < t : alpha < -Math.PI + t || alpha > Math.PI - t;
            mxPoint result = null;
            if (base) {
                if (orthogonal && (vertical && next.getX() >= start.getX() && next.getX() <= end.getX() || !vertical && next.getY() >= start.getY() && next.getY() <= end.getY())) {
                    result = vertical ? new mxPoint(next.getX(), start.getY()) : new mxPoint(start.getX(), next.getY());
                } else if (direction.equals("east")) {
                    result = new mxPoint(x, y + h / 2.0 - w * Math.tan(alpha) / 2.0);
                } else if (direction.equals("north")) {
                    result = new mxPoint(x + w / 2.0 + h * Math.tan(alpha) / 2.0, y + h);
                } else if (direction.equals("south")) {
                    result = new mxPoint(x + w / 2.0 - h * Math.tan(alpha) / 2.0, y);
                } else if (direction.equals("west")) {
                    result = new mxPoint(x + w, y + h / 2.0 + w * Math.tan(alpha) / 2.0);
                }
            } else {
                if (orthogonal) {
                    mxPoint pt = new mxPoint(cx, cy);
                    if (next.getY() >= y && next.getY() <= y + h) {
                        pt.setX(vertical ? cx : (direction.equals("west") ? x + w : x));
                        pt.setY(next.getY());
                    } else if (next.getX() >= x && next.getX() <= x + w) {
                        pt.setX(next.getX());
                        pt.setY(!vertical ? cy : (direction.equals("north") ? y + h : y));
                    }
                    dx = next.getX() - pt.getX();
                    dy = next.getY() - pt.getY();
                    cx = pt.getX();
                    cy = pt.getY();
                }
                result = vertical && next.getX() <= x + w / 2.0 || !vertical && next.getY() <= y + h / 2.0 ? mxUtils.intersection(next.getX(), next.getY(), cx, cy, start.getX(), start.getY(), corner.getX(), corner.getY()) : mxUtils.intersection(next.getX(), next.getY(), cx, cy, corner.getX(), corner.getY(), end.getX(), end.getY());
            }
            if (result == null) {
                result = new mxPoint(cx, cy);
            }
            return result;
        }
    };
    public static mxPerimeterFunction HexagonPerimeter = new mxPerimeterFunction(){

        @Override
        public mxPoint apply(mxRectangle bounds, mxCellState vertex, mxPoint next, boolean orthogonal) {
            double x = bounds.getX();
            double y = bounds.getY();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            double cx = bounds.getCenterX();
            double cy = bounds.getCenterY();
            double px = next.getX();
            double py = next.getY();
            double dx = px - cx;
            double dy = py - cy;
            double alpha = -Math.atan2(dy, dx);
            double pi = Math.PI;
            double pi2 = 1.5707963267948966;
            mxPoint result = new mxPoint(cx, cy);
            String direction = vertex != null ? mxUtils.getString(vertex.style, mxConstants.STYLE_DIRECTION, "east") : "east";
            boolean vertical = direction.equals("north") || direction.equals("south");
            mxPoint a = new mxPoint();
            mxPoint b = new mxPoint();
            if (px < x && py < y || px < x && py > y + h || px > x + w && py < y || px > x + w && py > y + h) {
                orthogonal = false;
            }
            if (orthogonal) {
                if (vertical) {
                    if (px == cx) {
                        if (py <= y) {
                            return new mxPoint(cx, y);
                        }
                        if (py >= y + h) {
                            return new mxPoint(cx, y + h);
                        }
                    } else if (px < x) {
                        if (py == y + h / 4.0) {
                            return new mxPoint(x, y + h / 4.0);
                        }
                        if (py == y + 3.0 * h / 4.0) {
                            return new mxPoint(x, y + 3.0 * h / 4.0);
                        }
                    } else if (px > x + w) {
                        if (py == y + h / 4.0) {
                            return new mxPoint(x + w, y + h / 4.0);
                        }
                        if (py == y + 3.0 * h / 4.0) {
                            return new mxPoint(x + w, y + 3.0 * h / 4.0);
                        }
                    } else if (px == x) {
                        if (py < cy) {
                            return new mxPoint(x, y + h / 4.0);
                        }
                        if (py > cy) {
                            return new mxPoint(x, y + 3.0 * h / 4.0);
                        }
                    } else if (px == x + w) {
                        if (py < cy) {
                            return new mxPoint(x + w, y + h / 4.0);
                        }
                        if (py > cy) {
                            return new mxPoint(x + w, y + 3.0 * h / 4.0);
                        }
                    }
                    if (py == y) {
                        return new mxPoint(cx, y);
                    }
                    if (py == y + h) {
                        return new mxPoint(cx, y + h);
                    }
                    if (px < cx) {
                        if (py > y + h / 4.0 && py < y + 3.0 * h / 4.0) {
                            a = new mxPoint(x, y);
                            b = new mxPoint(x, y + h);
                        } else if (py < y + h / 4.0) {
                            a = new mxPoint(x - (double)((int)(0.5 * w)), y + (double)((int)(0.5 * h)));
                            b = new mxPoint(x + w, y - (double)((int)(0.25 * h)));
                        } else if (py > y + 3.0 * h / 4.0) {
                            a = new mxPoint(x - (double)((int)(0.5 * w)), y + (double)((int)(0.5 * h)));
                            b = new mxPoint(x + w, y + (double)((int)(1.25 * h)));
                        }
                    } else if (px > cx) {
                        if (py > y + h / 4.0 && py < y + 3.0 * h / 4.0) {
                            a = new mxPoint(x + w, y);
                            b = new mxPoint(x + w, y + h);
                        } else if (py < y + h / 4.0) {
                            a = new mxPoint(x, y - (double)((int)(0.25 * h)));
                            b = new mxPoint(x + (double)((int)(1.5 * w)), y + (double)((int)(0.5 * h)));
                        } else if (py > y + 3.0 * h / 4.0) {
                            a = new mxPoint(x + (double)((int)(1.5 * w)), y + (double)((int)(0.5 * h)));
                            b = new mxPoint(x, y + (double)((int)(1.25 * h)));
                        }
                    }
                } else {
                    if (py == cy) {
                        if (px <= x) {
                            return new mxPoint(x, y + h / 2.0);
                        }
                        if (px >= x + w) {
                            return new mxPoint(x + w, y + h / 2.0);
                        }
                    } else if (py < y) {
                        if (px == x + w / 4.0) {
                            return new mxPoint(x + w / 4.0, y);
                        }
                        if (px == x + 3.0 * w / 4.0) {
                            return new mxPoint(x + 3.0 * w / 4.0, y);
                        }
                    } else if (py > y + h) {
                        if (px == x + w / 4.0) {
                            return new mxPoint(x + w / 4.0, y + h);
                        }
                        if (px == x + 3.0 * w / 4.0) {
                            return new mxPoint(x + 3.0 * w / 4.0, y + h);
                        }
                    } else if (py == y) {
                        if (px < cx) {
                            return new mxPoint(x + w / 4.0, y);
                        }
                        if (px > cx) {
                            return new mxPoint(x + 3.0 * w / 4.0, y);
                        }
                    } else if (py == y + h) {
                        if (px < cx) {
                            return new mxPoint(x + w / 4.0, y + h);
                        }
                        if (py > cy) {
                            return new mxPoint(x + 3.0 * w / 4.0, y + h);
                        }
                    }
                    if (px == x) {
                        return new mxPoint(x, cy);
                    }
                    if (px == x + w) {
                        return new mxPoint(x + w, cy);
                    }
                    if (py < cy) {
                        if (px > x + w / 4.0 && px < x + 3.0 * w / 4.0) {
                            a = new mxPoint(x, y);
                            b = new mxPoint(x + w, y);
                        } else if (px < x + w / 4.0) {
                            a = new mxPoint(x - (double)((int)(0.25 * w)), y + h);
                            b = new mxPoint(x + (double)((int)(0.5 * w)), y - (double)((int)(0.5 * h)));
                        } else if (px > x + 3.0 * w / 4.0) {
                            a = new mxPoint(x + (double)((int)(0.5 * w)), y - (double)((int)(0.5 * h)));
                            b = new mxPoint(x + (double)((int)(1.25 * w)), y + h);
                        }
                    } else if (py > cy) {
                        if (px > x + w / 4.0 && px < x + 3.0 * w / 4.0) {
                            a = new mxPoint(x, y + h);
                            b = new mxPoint(x + w, y + h);
                        } else if (px < x + w / 4.0) {
                            a = new mxPoint(x - (double)((int)(0.25 * w)), y);
                            b = new mxPoint(x + (double)((int)(0.5 * w)), y + (double)((int)(1.5 * h)));
                        } else if (px > x + 3.0 * w / 4.0) {
                            a = new mxPoint(x + (double)((int)(0.5 * w)), y + (double)((int)(1.5 * h)));
                            b = new mxPoint(x + (double)((int)(1.25 * w)), y);
                        }
                    }
                }
                double tx = cx;
                double ty = cy;
                if (px >= x && px <= x + w) {
                    tx = px;
                    ty = py < cy ? y + h : y;
                } else if (py >= y && py <= y + h) {
                    ty = py;
                    tx = px < cx ? x + w : x;
                }
                result = mxUtils.intersection(tx, ty, next.getX(), next.getY(), a.getX(), a.getY(), b.getX(), b.getY());
            } else {
                if (vertical) {
                    double beta = Math.atan2(h / 4.0, w / 2.0);
                    if (alpha == beta) {
                        return new mxPoint(x + w, y + (double)((int)(0.25 * h)));
                    }
                    if (alpha == pi2) {
                        return new mxPoint(x + (double)((int)(0.5 * w)), y);
                    }
                    if (alpha == pi - beta) {
                        return new mxPoint(x, y + (double)((int)(0.25 * h)));
                    }
                    if (alpha == -beta) {
                        return new mxPoint(x + w, y + (double)((int)(0.75 * h)));
                    }
                    if (alpha == -pi2) {
                        return new mxPoint(x + (double)((int)(0.5 * w)), y + h);
                    }
                    if (alpha == -pi + beta) {
                        return new mxPoint(x, y + (double)((int)(0.75 * h)));
                    }
                    if (alpha < beta && alpha > -beta) {
                        a = new mxPoint(x + w, y);
                        b = new mxPoint(x + w, y + h);
                    } else if (alpha > beta && alpha < pi2) {
                        a = new mxPoint(x, y - (double)((int)(0.25 * h)));
                        b = new mxPoint(x + (double)((int)(1.5 * w)), y + (double)((int)(0.5 * h)));
                    } else if (alpha > pi2 && alpha < pi - beta) {
                        a = new mxPoint(x - (double)((int)(0.5 * w)), y + (double)((int)(0.5 * h)));
                        b = new mxPoint(x + w, y - (double)((int)(0.25 * h)));
                    } else if (alpha > pi - beta && alpha <= pi || alpha < -pi + beta && alpha >= -pi) {
                        a = new mxPoint(x, y);
                        b = new mxPoint(x, y + h);
                    } else if (alpha < -beta && alpha > -pi2) {
                        a = new mxPoint(x + (double)((int)(1.5 * w)), y + (double)((int)(0.5 * h)));
                        b = new mxPoint(x, y + (double)((int)(1.25 * h)));
                    } else if (alpha < -pi2 && alpha > -pi + beta) {
                        a = new mxPoint(x - (double)((int)(0.5 * w)), y + (double)((int)(0.5 * h)));
                        b = new mxPoint(x + w, y + (double)((int)(1.25 * h)));
                    }
                } else {
                    double beta = Math.atan2(h / 2.0, w / 4.0);
                    if (alpha == beta) {
                        return new mxPoint(x + (double)((int)(0.75 * w)), y);
                    }
                    if (alpha == pi - beta) {
                        return new mxPoint(x + (double)((int)(0.25 * w)), y);
                    }
                    if (alpha == pi || alpha == -pi) {
                        return new mxPoint(x, y + (double)((int)(0.5 * h)));
                    }
                    if (alpha == 0.0) {
                        return new mxPoint(x + w, y + (double)((int)(0.5 * h)));
                    }
                    if (alpha == -beta) {
                        return new mxPoint(x + (double)((int)(0.75 * w)), y + h);
                    }
                    if (alpha == -pi + beta) {
                        return new mxPoint(x + (double)((int)(0.25 * w)), y + h);
                    }
                    if (alpha > 0.0 && alpha < beta) {
                        a = new mxPoint(x + (double)((int)(0.5 * w)), y - (double)((int)(0.5 * h)));
                        b = new mxPoint(x + (double)((int)(1.25 * w)), y + h);
                    } else if (alpha > beta && alpha < pi - beta) {
                        a = new mxPoint(x, y);
                        b = new mxPoint(x + w, y);
                    } else if (alpha > pi - beta && alpha < pi) {
                        a = new mxPoint(x - (double)((int)(0.25 * w)), y + h);
                        b = new mxPoint(x + (double)((int)(0.5 * w)), y - (double)((int)(0.5 * h)));
                    } else if (alpha < 0.0 && alpha > -beta) {
                        a = new mxPoint(x + (double)((int)(0.5 * w)), y + (double)((int)(1.5 * h)));
                        b = new mxPoint(x + (double)((int)(1.25 * w)), y);
                    } else if (alpha < -beta && alpha > -pi + beta) {
                        a = new mxPoint(x, y + h);
                        b = new mxPoint(x + w, y + h);
                    } else if (alpha < -pi + beta && alpha > -pi) {
                        a = new mxPoint(x - (double)((int)(0.25 * w)), y);
                        b = new mxPoint(x + (double)((int)(0.5 * w)), y + (double)((int)(1.5 * h)));
                    }
                }
                result = mxUtils.intersection(cx, cy, next.getX(), next.getY(), a.getX(), a.getY(), b.getX(), b.getY());
            }
            if (result == null) {
                return new mxPoint(cx, cy);
            }
            return result;
        }
    };

    public static interface mxPerimeterFunction {
        public mxPoint apply(mxRectangle var1, mxCellState var2, mxPoint var3, boolean var4);
    }
}

