/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractCarryBillFeeFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.CarryBillClientUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class CarryBillFeeFilterUI
extends AbstractCarryBillFeeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CarryBillFeeFilterUI.class);

    public CarryBillFeeFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo));
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        elements.add((FilterElement)new SingleFilterElement("distributionType", (Component)this.cbxDistributionType, (Object)DistributionTypeEnum.isNull));
        SingleFilterElement mainOrgElement = new SingleFilterElement("transportOrgUnit.number", (Component)this.prmtTransportOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, CarryBillClientUtils.getResource("transportOrgUnitCantNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("sendLine.number", (Component)this.prmtCarryLine));
        elements.add((FilterElement)new SingleFilterElement("mainCarrier.number", (Component)this.prmtCarrier));
        elements.add((FilterElement)new SingleFilterElement("transportType", (Component)this.cbxTransportType, (Object)TransportTypeEnum.isNull));
        elements.add((FilterElement)new RangeFilterElement("sourceBillType.number", (Component)this.prmtSourceBillTypeFrom, (Component)this.prmtSourceBillTypeTo));
        elements.add((FilterElement)new SingleFilterElement("feeItem.number", (Component)this.prmtEntryFeeItem));
        elements.add((FilterElement)new SingleFilterElement("feeEntry.feeTransType", (Component)this.cbxEntryTransportType, (Object)TransportTypeEnum.isNull));
        elements.add((FilterElement)new SingleFilterElement("feeCarryLine.number", (Component)this.prmtEntryDeliveryLine));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cbxBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "transportOrgUnit.id");
        this.setBizSupplierF7(this.prmtCarrier, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtCarrier});
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtTransportOrgUnit;
    }

    protected String getViewPermission() {
        return "carrybill_view_fee";
    }

    private void setF7Filter() throws Exception {
        EntityViewInfo viewNumber = DtUtils.getBizTransportFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewNumber);
        this.prmtNumberTo.setEntityViewInfo(viewNumber);
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.pkBizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.pkBizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.cbxBaseStatus);
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.prmtEntryFeeItem.setValue(null);
        TransportOrgUnitInfo tou = new TransportOrgUnitInfo();
        try {
            ITransportOrgUnit tof = TransportOrgUnitFactory.getRemoteInstance();
            BOSUuid uuid = BOSUuid.read((String)ids);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            tou = tof.getTransportOrgUnitInfo((IObjectPK)pk);
            CompanyOrgUnitInfo touTOcou = DtUtils.getCompanyInfo(null, tou);
            DtUtils.setExpenseTypeFilter(this.prmtEntryFeeItem, (CoreUIObject)this, true, "CarryBill", touTOcou, false);
            this.prmtEntryFeeItem.setDisplayFormat("$name$");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

