/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFacadeFactory;
import com.kingdee.eas.scm.im.dt.CarryBillFactory;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractCheckInUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.CarryBillClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckInUI
extends AbstractCheckInUI
implements KDTEditListener {
    private static final Logger logger = CoreUIObject.getLogger(CheckInUI.class);
    private String billID = null;
    private CarryBillInfo billInfo = null;
    private SCMFetchData fetchData = new SCMFetchData();
    private boolean needRefresh = false;
    private static final String TB_ENTRYID = "entry.id";
    private static final String TB_SEQ = "seq";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_ASSISTPROPERTY = "assistProperty";
    private static final String TB_LOT = "lot";
    private static final String TB_UNIT = "unit";
    private static final String TB_QTY = "qty";
    private static final String TB_OUTQTYACTUAL = "outQtyActual";
    private static final String TB_QTYACTUAL = "qtyActual";
    private static final String TB_OBEYQTY = "obeyQty";
    private static final String TB_QTYLOSS = "qtyLoss";
    private static final String TB_CHECKINREMARK = "checkInRemark";
    private static final String TB_RECEIVEDQTY = "receivedQty";
    private static final String TB_RECEIVEDLOSTQTY = "receivedLostQty";
    private static final String TB_APPROWASNUM = "approWasNum";
    private static final String[] TBS_QTY = new String[]{"qty", "outQtyActual", "qtyActual", "obeyQty", "qtyLoss", "receivedQty", "receivedLostQty", "approWasNum"};
    private static final String TB_CARRIER = "carrier";
    private static final String TB_CAR = "car";
    private static final String TB_DRIVER = "driver";
    private static final String TB_AUDITDATE = "auditDate";
    private static final String TB_APPROWASRATIO = "approWasRatio";

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public String getBillID() {
        return this.billID;
    }

    public void setBillID(String billID) {
        this.billID = billID;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.checkIn();
        this.setNeedRefresh(true);
        this.destroyWindow();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("8B07BBDB"), null, (String)this.billInfo.getNumber(), (String)"carryBill_checkIn");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.setNeedRefresh(false);
        super.actionExitCurrent_actionPerformed(e);
    }

    private void checkIn() throws BOSException, EASBizException {
        int entrySize = this.mainTable.getRowCount();
        Map[] checkInMap = new HashMap[entrySize];
        String entryID = null;
        BigDecimal outQtyActual = null;
        BigDecimal qtyActual = null;
        BigDecimal obeyQty = null;
        BigDecimal qtyLoss = null;
        String checkInRemark = null;
        BigDecimal receivedQty = null;
        BigDecimal receivedLostQty = null;
        MeasureUnitInfo unit = null;
        MaterialInfo material = null;
        Date checkInDate = null;
        BigDecimal approWasQty = null;
        BigDecimal approWasbaseQty = null;
        int n = entrySize;
        for (int i = 0; i < n; ++i) {
            checkInMap[i] = new HashMap();
            entryID = (String)this.mainTable.getCell(i, TB_ENTRYID).getValue();
            ((HashMap)checkInMap[i]).put("entryID", entryID);
            outQtyActual = (BigDecimal)this.mainTable.getCell(i, TB_OUTQTYACTUAL).getValue();
            outQtyActual = outQtyActual == null ? DtUtils.ZERO : outQtyActual;
            ((HashMap)checkInMap[i]).put(TB_OUTQTYACTUAL, outQtyActual);
            qtyActual = (BigDecimal)this.mainTable.getCell(i, TB_QTYACTUAL).getValue();
            qtyActual = qtyActual == null ? DtUtils.ZERO : qtyActual;
            ((HashMap)checkInMap[i]).put(TB_QTYACTUAL, qtyActual);
            obeyQty = (BigDecimal)this.mainTable.getCell(i, TB_OBEYQTY).getValue();
            obeyQty = obeyQty == null ? DtUtils.ZERO : obeyQty;
            ((HashMap)checkInMap[i]).put(TB_OBEYQTY, obeyQty);
            qtyLoss = (BigDecimal)this.mainTable.getCell(i, TB_QTYLOSS).getValue();
            qtyLoss = qtyLoss == null ? DtUtils.ZERO : qtyLoss;
            ((HashMap)checkInMap[i]).put(TB_QTYLOSS, qtyLoss);
            checkInRemark = (String)this.mainTable.getCell(i, TB_CHECKINREMARK).getValue();
            checkInRemark = checkInRemark == null ? "" : checkInRemark;
            ((HashMap)checkInMap[i]).put(TB_CHECKINREMARK, checkInRemark);
            receivedQty = (BigDecimal)this.mainTable.getCell(i, TB_RECEIVEDQTY).getValue();
            receivedQty = receivedQty == null ? DtUtils.ZERO : receivedQty;
            ((HashMap)checkInMap[i]).put(TB_RECEIVEDQTY, receivedQty);
            receivedLostQty = (BigDecimal)this.mainTable.getCell(i, TB_RECEIVEDLOSTQTY).getValue();
            receivedLostQty = receivedLostQty == null ? DtUtils.ZERO : receivedLostQty;
            ((HashMap)checkInMap[i]).put(TB_RECEIVEDLOSTQTY, receivedLostQty);
            unit = (MeasureUnitInfo)this.mainTable.getCell(i, TB_UNIT).getValue();
            material = (MaterialInfo)this.mainTable.getCell(i, TB_MATERIALNAME).getValue();
            BigDecimal coefficient = DtUtils.ONE;
            if (material != null && unit != null) {
                coefficient = InvClientUtils.getBaseUnitQty(unit, material, coefficient);
            }
            ((HashMap)checkInMap[i]).put("coefficient", coefficient);
            checkInDate = (Date)this.mainTable.getCell(i, TB_AUDITDATE).getValue();
            ((HashMap)checkInMap[i]).put("checkInDate", checkInDate);
            approWasQty = (BigDecimal)this.mainTable.getCell(i, TB_APPROWASNUM).getValue();
            approWasQty = approWasQty == null ? DtUtils.ZERO : approWasQty;
            ((HashMap)checkInMap[i]).put("approWasQty", approWasQty);
            approWasbaseQty = InvClientUtils.getBaseUnitQty(unit, material, approWasQty);
            approWasbaseQty = approWasbaseQty == null ? DtUtils.ZERO : approWasbaseQty;
            ((HashMap)checkInMap[i]).put("approWasbaseQty", approWasbaseQty);
        }
        CarryBillFacadeFactory.getRemoteInstance().checkIn(checkInMap, this.billID);
    }

    public void onLoad() throws Exception {
        this.mainTable.checkParsed();
        super.onLoad();
        this.mainTable.addKDTEditListener((KDTEditListener)this);
    }

    protected void refresh() throws EASBizException, BOSException {
        if (this.billID == null) {
            return;
        }
        this.loadVO();
        this.initFetchData();
        this.bindVOtoUI();
        this.initChinkInTable();
    }

    private void loadVO() throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("distributionType"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo(TB_ENTRYID));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.assistProperty.*"));
        sic.add(new SelectorItemInfo("entry.lot"));
        sic.add(new SelectorItemInfo("entry.unit.*"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.outQtyActual"));
        sic.add(new SelectorItemInfo("entry.qtyActual"));
        sic.add(new SelectorItemInfo("entry.qtyLoss"));
        sic.add(new SelectorItemInfo("entry.obeyQty"));
        sic.add(new SelectorItemInfo("entry.associateQty"));
        sic.add(new SelectorItemInfo("entry.checkInRemark"));
        sic.add(new SelectorItemInfo("entry.receivedQty"));
        sic.add(new SelectorItemInfo("entry.receiveAssoBaseQty"));
        sic.add(new SelectorItemInfo("entry.receivedLostQty"));
        sic.add(new SelectorItemInfo("entry.receivedArQty"));
        sic.add(new SelectorItemInfo("entry.arAssociateQty"));
        sic.add(new SelectorItemInfo("entry.carrier.*"));
        sic.add(new SelectorItemInfo("entry.carrier.name"));
        this.billInfo = CarryBillFactory.getRemoteInstance().getCarryBillInfo((IObjectPK)new ObjectUuidPK(this.billID), sic);
    }

    private void bindVOtoUI() {
        if (this.billInfo == null) {
            return;
        }
        this.mainTable.removeRows();
        int n = this.billInfo.getEntry().size();
        for (int i = 0; i < n; ++i) {
            this.mainTable.addRow();
            CarryBillEntryInfo entry = this.billInfo.getEntry().get(i);
            this.mainTable.getCell(i, TB_ENTRYID).setValue((Object)entry.getId().toString());
            this.mainTable.getCell(i, TB_SEQ).setValue((Object)new Integer(entry.getSeq()));
            this.mainTable.getCell(i, TB_MATERIAL).setValue((Object)entry.getMaterial().getNumber());
            this.mainTable.getCell(i, TB_MATERIALNAME).setValue((Object)entry.getMaterial());
            this.mainTable.getCell(i, TB_MODEL).setValue((Object)entry.getMaterial().getModel());
            this.mainTable.getCell(i, TB_ASSISTPROPERTY).setValue((Object)entry.getAssistProperty());
            this.mainTable.getCell(i, TB_LOT).setValue((Object)entry.getLot());
            this.mainTable.getCell(i, TB_UNIT).setValue((Object)entry.getUnit());
            this.mainTable.getCell(i, TB_QTY).setValue((Object)entry.getQty());
            this.mainTable.getCell(i, TB_OUTQTYACTUAL).setValue((Object)entry.getOutQtyActual());
            this.mainTable.getCell(i, TB_QTYACTUAL).setValue((Object)entry.getQtyActual());
            this.mainTable.getCell(i, TB_OBEYQTY).setValue((Object)entry.getObeyQty());
            this.mainTable.getCell(i, TB_QTYLOSS).setValue((Object)entry.getQtyLoss());
            this.mainTable.getCell(i, TB_CHECKINREMARK).setValue((Object)entry.getCheckInRemark());
            this.mainTable.getCell(i, TB_RECEIVEDQTY).setValue((Object)entry.getReceivedQty());
            this.mainTable.getCell(i, TB_RECEIVEDLOSTQTY).setValue((Object)entry.getReceivedLostQty());
            this.mainTable.getCell(i, TB_CARRIER).setValue((Object)entry.getCarrier());
            this.mainTable.getCell(i, TB_CAR).setValue((Object)entry.getCar());
            this.mainTable.getCell(i, TB_DRIVER).setValue((Object)entry.getDriverStr());
            this.mainTable.getCell(i, TB_APPROWASRATIO).setValue((Object)entry.getApproWasRatio());
            this.mainTable.getCell(i, TB_APPROWASNUM).setValue((Object)entry.getApproWasNum());
            KDDatePicker datePicker = new KDDatePicker();
            KDTDefaultCellEditor editorDate = new KDTDefaultCellEditor(datePicker);
            if (entry.getCheckInDate() != null) {
                this.mainTable.getCell(i, TB_AUDITDATE).setValue((Object)entry.getCheckInDate());
            }
            this.mainTable.getCell(i, TB_AUDITDATE).setEditor((ICellEditor)editorDate);
            this.mainTable.getCell(i, TB_AUDITDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        }
        this.setNeedRefresh(false);
    }

    private void initChinkInTable() throws EASBizException, BOSException {
        DistributionTypeEnum distributionType = this.billInfo.getDistributionType();
        this.mainTable.getColumn(TB_CARRIER).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_CAR).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_DRIVER).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_APPROWASRATIO).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_APPROWASNUM).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_AUDITDATE).getStyleAttributes().setLocked(false);
        this.mainTable.getColumn(TB_QTYLOSS).getStyleAttributes().setLocked(true);
        this.mainTable.getColumn(TB_RECEIVEDLOSTQTY).getStyleAttributes().setLocked(true);
        if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) {
            this.mainTable.getColumn(TB_RECEIVEDQTY).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        } else if (DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType)) {
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_RECEIVEDQTY).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            this.mainTable.getColumn(TB_RECEIVEDQTY).getStyleAttributes().setHided(true);
            this.mainTable.getColumn(TB_RECEIVEDLOSTQTY).getStyleAttributes().setHided(true);
        } else if (DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
            this.mainTable.getHead().getRow(0).getCell(this.mainTable.getColumnIndex(TB_OUTQTYACTUAL)).setValue((Object)CarryBillClientUtils.getResource("outQtyActualForPur"));
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setLocked(false);
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setHided(true);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setHided(true);
            this.mainTable.getColumn(TB_QTYLOSS).getStyleAttributes().setHided(true);
        } else if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType)) {
            this.mainTable.getHead().getRow(0).getCell(this.mainTable.getColumnIndex(TB_OUTQTYACTUAL)).setValue((Object)CarryBillClientUtils.getResource("outQtyActualForPur"));
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setLocked(true);
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setLocked(false);
            this.mainTable.getColumn(TB_OUTQTYACTUAL).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            this.mainTable.getColumn(TB_QTYACTUAL).getStyleAttributes().setHided(true);
            this.mainTable.getColumn(TB_OBEYQTY).getStyleAttributes().setHided(true);
            this.mainTable.getColumn(TB_QTYLOSS).getStyleAttributes().setHided(true);
        }
        for (int j = 0; j < this.mainTable.getRowCount(); ++j) {
            BigDecimal outQtyActual;
            if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) {
                outQtyActual = (BigDecimal)this.mainTable.getCell(j, TB_OUTQTYACTUAL).getValue();
                if (outQtyActual != null && outQtyActual.compareTo(DtUtils.ZERO) == 1) {
                    this.mainTable.getCell(j, TB_QTYACTUAL).getStyleAttributes().setLocked(false);
                    this.mainTable.getCell(j, TB_OBEYQTY).getStyleAttributes().setLocked(false);
                    continue;
                }
                this.mainTable.getCell(j, TB_QTYACTUAL).getStyleAttributes().setLocked(true);
                this.mainTable.getCell(j, TB_OBEYQTY).getStyleAttributes().setLocked(true);
                continue;
            }
            if (DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType)) {
                outQtyActual = (BigDecimal)this.mainTable.getCell(j, TB_OUTQTYACTUAL).getValue();
                if (outQtyActual != null && outQtyActual.compareTo(DtUtils.ZERO) == 1) {
                    this.mainTable.getCell(j, TB_QTYACTUAL).getStyleAttributes().setLocked(false);
                    this.mainTable.getCell(j, TB_OBEYQTY).getStyleAttributes().setLocked(false);
                    continue;
                }
                this.mainTable.getCell(j, TB_QTYACTUAL).getStyleAttributes().setLocked(true);
                this.mainTable.getCell(j, TB_OBEYQTY).getStyleAttributes().setLocked(true);
                continue;
            }
            if (!DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType) && !DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType)) continue;
        }
        int n = this.mainTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            String materialID = ((MaterialInfo)this.mainTable.getCell(i, TB_MATERIALNAME).getValue()).getId().toString();
            String unitID = ((MeasureUnitInfo)this.mainTable.getCell(i, TB_UNIT).getValue()).getId().toString();
            int precision = 4;
            if (this.fetchData.getUnitPrecision(materialID, unitID) == null) {
                precision = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialID, unitID).getQtyPrecision();
                this.fetchData.putUnitPrecision(materialID, unitID, precision);
            } else {
                precision = this.fetchData.getUnitPrecision(materialID, unitID);
            }
            DtUtils.changePrecision(this.mainTable, i, TBS_QTY, precision, false);
            ((KDFormattedTextField)this.mainTable.getCell(i, TB_QTYLOSS).getEditor().getComponent()).setNegatived(true);
            ((KDFormattedTextField)this.mainTable.getCell(i, TB_RECEIVEDLOSTQTY).getEditor().getComponent()).setNegatived(true);
            this.calculateApproveWasteQty(i);
        }
        this.mainTable.getColumn(TB_APPROWASRATIO).getStyleAttributes().setNumberFormat(InvClientUtils.getPrecisionFormatStr(4));
    }

    private void initFetchData() throws EASBizException, BOSException {
        SCMFetchDataCondition condition = this.buildCondition();
        if (condition != null) {
            this.fetchData = SCMFetchDataFacadeFactory.getRemoteInstance().fetchData(condition.toEntiryView());
        }
    }

    private SCMFetchDataCondition buildCondition() {
        if (this.billInfo == null) {
            return null;
        }
        int entrySize = this.billInfo.getEntry().size();
        String[] materialPKs = new String[entrySize];
        String[] unitPKs = new String[entrySize];
        int n = this.billInfo.getEntry().size();
        for (int i = 0; i < n; ++i) {
            materialPKs[i] = this.billInfo.getEntry().get(i).getMaterial().getId().toString();
            unitPKs[i] = this.billInfo.getEntry().get(i).getUnit().getId().toString();
        }
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        condition.setFetchUnitPrecision(true);
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        return condition;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        String selectColName = this.mainTable.getColumnKey(selectCol);
        if (TB_OUTQTYACTUAL.equals(selectColName) || TB_QTYACTUAL.equals(selectColName) || TB_OBEYQTY.equals(selectColName)) {
            this.calculateQtyActual(selectRow);
            this.calculateQtyLoss(selectRow);
            this.calculateReceivedLostQty(selectRow);
        }
        if (TB_OUTQTYACTUAL.equals(selectColName)) {
            this.calculateApproveWasteQty(selectRow);
        }
        this.setNeedRefresh(true);
    }

    public void editCanceled(KDTEditEvent e) {
    }

    private void calculateApproveWasteQty(int rowIndex) {
        BigDecimal outQtyActual;
        Component o;
        KDFormattedTextField text;
        int outQtyActualPrec = 4;
        if (this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getEditor() != null && this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getEditor().getComponent() != null && (text = (KDFormattedTextField)(o = this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getEditor().getComponent())) != null) {
            outQtyActualPrec = text.getPrecision();
        }
        if ((outQtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getValue()) == null) {
            outQtyActual = DtUtils.ZERO;
        }
        BigDecimal approWasRatio = DtUtils.ZERO;
        if (this.mainTable.getRow(rowIndex).getCell(TB_APPROWASRATIO).getValue() != null) {
            approWasRatio = (BigDecimal)this.mainTable.getRow(rowIndex).getCell(TB_APPROWASRATIO).getValue();
        }
        BigDecimal approWasQty = outQtyActual.multiply(approWasRatio).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, outQtyActualPrec, 4);
        this.mainTable.getCell(rowIndex, TB_APPROWASNUM).setValue((Object)approWasQty);
    }

    private void calculateQtyActual(int rowIndex) {
        DistributionTypeEnum distributionType = this.billInfo.getDistributionType();
        BigDecimal outQtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getValue();
        BigDecimal bigDecimal = outQtyActual = outQtyActual == null ? DtUtils.ZERO : outQtyActual;
        if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
            this.mainTable.getCell(rowIndex, TB_QTYACTUAL).setValue((Object)outQtyActual);
        }
    }

    private void calculateQtyLoss(int rowIndex) {
        DistributionTypeEnum distributionType = this.billInfo.getDistributionType();
        if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
            BigDecimal outQtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getValue();
            outQtyActual = outQtyActual == null ? DtUtils.ZERO : outQtyActual;
            BigDecimal qtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_QTYACTUAL).getValue();
            qtyActual = qtyActual == null ? DtUtils.ZERO : qtyActual;
            BigDecimal obeyQty = (BigDecimal)this.mainTable.getCell(rowIndex, TB_OBEYQTY).getValue();
            obeyQty = obeyQty == null ? DtUtils.ZERO : obeyQty;
            BigDecimal qtyLoss = outQtyActual.subtract(qtyActual).subtract(obeyQty);
            this.mainTable.getCell(rowIndex, TB_QTYLOSS).setValue((Object)qtyLoss);
        }
    }

    private void calculateReceivedLostQty(int rowIndex) {
        DistributionTypeEnum distributionType = this.billInfo.getDistributionType();
        BigDecimal outQtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_OUTQTYACTUAL).getValue();
        outQtyActual = outQtyActual == null ? DtUtils.ZERO : outQtyActual;
        BigDecimal qtyActual = (BigDecimal)this.mainTable.getCell(rowIndex, TB_QTYACTUAL).getValue();
        qtyActual = qtyActual == null ? DtUtils.ZERO : qtyActual;
        BigDecimal receivedQty = (BigDecimal)this.mainTable.getCell(rowIndex, TB_RECEIVEDQTY).getValue();
        BigDecimal bigDecimal = receivedQty = receivedQty == null ? DtUtils.ZERO : receivedQty;
        if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
            BigDecimal receivedLostQty = qtyActual.subtract(receivedQty);
            this.mainTable.getCell(rowIndex, TB_RECEIVEDLOSTQTY).setValue((Object)receivedLostQty);
        } else if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType)) {
            BigDecimal receivedLostQty = outQtyActual.subtract(receivedQty);
            this.mainTable.getCell(rowIndex, TB_RECEIVEDLOSTQTY).setValue((Object)receivedLostQty);
        }
    }
}

