/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.DeliveryLineEntryInfo;
import com.kingdee.eas.scm.im.dt.DeliveryLineFactory;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractDeliveryLineEditUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.DeliveryLineClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DeliveryLineEditUI
extends AbstractDeliveryLineEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DeliveryLineEditUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    public int milePrecision = 2;
    private static final String TB_LINE = "detailLine";
    private static final String TB_MILE = "detailMileage";
    private static final String TB_CARRIER = "detailCarrier";
    private static final String TB_TRANTYPE = "detailTranType";
    private static final String TB_DETAILBEGIN = "detailBegin";
    private static final String TB_DETAILEND = "detailEnd";
    KDBizPromptBox prmtDeliveryLine = new KDBizPromptBox();
    KDBizPromptBox prmtDetailCarrier = new KDBizPromptBox();
    private boolean isSubmitedAddNew = false;
    boolean bSave = false;

    public DeliveryLineEditUI() throws Exception {
        this.defaultTranType.removeItem((Object)TransportTypeEnum.isNull);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.txttotalMileage.setMinimumValue((Comparable)new BigDecimal("-1.0E12"));
        this.txttotalMileage.setMaximumValue((Comparable)new BigDecimal("1.0E12"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.updateButtonStatus();
        this.setTxtNumberStatus("NONE");
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        super.recycleNumberByOrg(editData, orgType, number);
    }

    protected void updateButtonStatus() {
        this.actionSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        if (BillStatusEnum.save.equals((Object)this.editData.getStatus())) {
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        } else if (BillStatusEnum.enable.equals((Object)this.editData.getStatus())) {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else if (BillStatusEnum.disable.equals((Object)this.editData.getStatus())) {
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if (this.getOprtState().equals("EDIT")) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if (this.getOprtState().equals("VIEW")) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
        if (BillStatusEnum.enable.equals((Object)this.editData.getStatus())) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionEdit.setEnabled(false);
        }
    }

    private void setTxtNumberStatus(String orgType) {
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)this.editData, companyID)) {
                    this.txtNumber.setEnabled(true);
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.bSave && this.editData.getStatus().equals((Object)BillStatusEnum.newbill)) {
            this.bSave = false;
            this.editData.setStatus(BillStatusEnum.save);
        }
    }

    public boolean isModify() {
        if (this.isSubmitedAddNew) {
            return false;
        }
        return super.isModify();
    }

    protected void afterSubmitAddNew() {
        this.isSubmitedAddNew = true;
        this.initOldData((IObjectValue)this.editData);
        super.afterSubmitAddNew();
    }

    protected void afterSubmitPrint() {
        this.initOldData((IObjectValue)this.editData);
        super.afterSubmitPrint();
    }

    protected void setAutoNumber(String orgType) {
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().length() == 0) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    String number = "";
                    number = iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID) ? iCodingRuleManager.readNumber((IObjectValue)this.editData, companyID) : iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID);
                    this.editData.setNumber(number);
                    this.txtNumber.setText(number);
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (this.isModify() && b) {
            this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
        }
        return b;
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            String message = null;
            message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                if (!this.isModifySave()) {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    if (this.actionSubmit.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                } else {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    if (this.actionSave.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (e == null || e.getSource() == this.btnSave || e.getSource() == this.menuItemSave) {
            return;
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(DeliveryLineClientUtils.getResource("CanNotIsNull"), this.kDLabelContainer2.getBoundLabelText()));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtbeginStation.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(DeliveryLineClientUtils.getResource("CanNotIsNull"), this.contbeginStation.getBoundLabelText()));
            this.prmtbeginStation.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtendStation.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(DeliveryLineClientUtils.getResource("CanNotIsNull"), this.contendStation.getBoundLabelText()));
            this.prmtendStation.requestFocus();
            SysUtil.abort();
        }
        if (this.defaultTranType.getSelectedItem() == null || TransportTypeEnum.isNull.equals(this.defaultTranType.getSelectedItem())) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("TransTypeIsNull"));
            this.defaultTranType.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtbeginStation.getValue() != null && this.prmtendStation.getValue() != null && this.prmtbeginStation.getValue().equals(this.prmtendStation.getValue())) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("startStationEqualsEndStation"));
            this.prmtendStation.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtbeginStation.getValue() != null && this.prmtendStation.getValue() != null && this.getDetailTable().getRowCount() > 0) {
            Object fristRowdetailBegin = this.getDetailTable().getRow(0).getCell(TB_DETAILBEGIN).getValue();
            Object laseRowdetailEnd = this.getDetailTable().getRow(this.getDetailTable().getRowCount() - 1).getCell(TB_DETAILEND).getValue();
            if (!this.prmtbeginStation.getValue().toString().equals(fristRowdetailBegin) || !this.prmtendStation.getValue().toString().equals(laseRowdetailEnd)) {
                MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("startEndStationNotMatch"));
                this.prmtendStation.requestFocus();
                SysUtil.abort();
            }
        }
        KDTable table = this.getDetailTable();
        BigDecimal entryTotalMail = DtUtils.ZERO;
        HashMap<String, Integer> lineEntryMap = new HashMap<String, Integer>();
        if (table.getRowCount() != 0) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                DeliveryLineInfo oValue;
                BigDecimal mil = (BigDecimal)table.getCell(i, TB_MILE).getValue();
                if (mil == null) {
                    mil = DtUtils.ZERO;
                }
                entryTotalMail = entryTotalMail.add(mil);
                if (table.getCell(i, TB_TRANTYPE).getValue() == null || TransportTypeEnum.isNull.equals(table.getCell(i, TB_TRANTYPE).getValue())) {
                    MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("entryTransportTypeNull"));
                    table.getEditManager().editCellAt(i, table.getColumnIndex(TB_TRANTYPE));
                    SysUtil.abort();
                }
                if (!(this.kdtEntry.getCell(i, TB_LINE).getValue() instanceof DeliveryLineInfo) || (oValue = (DeliveryLineInfo)this.kdtEntry.getCell(i, TB_LINE).getValue()) == null || oValue.getNumber() == null || oValue.getNumber().toString().length() <= 0) continue;
                if (lineEntryMap.containsKey(oValue.getNumber().toString())) {
                    MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(DeliveryLineClientUtils.getResource("submit_REPEAT_ENTRY"), lineEntryMap.get(oValue.getNumber().toString()).toString(), new Integer(i + 1).toString()));
                    SysUtil.abort();
                    continue;
                }
                lineEntryMap.put(oValue.getNumber().toString(), i + 1);
            }
            BigDecimal totalMail = this.txttotalMileage.getBigDecimalValue();
            if (totalMail == null) {
                totalMail = DtUtils.ZERO;
            }
            if (entryTotalMail.compareTo(totalMail) != 0) {
                MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("DetailMileageNotSame"));
                SysUtil.abort();
            }
        }
        super.beforeStoreFields(e);
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "deliveryLine_addnew";
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DeliveryLineFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DeliveryLineInfo objectValue = new DeliveryLineInfo();
        objectValue.setId(BOSUuid.create((BOSObjectType)objectValue.getBOSType()));
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date now = SCMClientUtils.getServerDate2();
        objectValue.setCreateTime(new Timestamp(now.getTime()));
        objectValue.setStatus(BillStatusEnum.newbill);
        objectValue.setTotalMileage(ZERO);
        objectValue.setDefaultTranType(TransportTypeEnum.CAR);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        DeliveryLineEntryInfo entryInfo = new DeliveryLineEntryInfo();
        return entryInfo;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initHeadControl();
        this.initKDTEntry();
        this.prmtDetailCarrier.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
        this.prmtdefaultCarrier.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setVisible(true);
        this.btnPre.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnLast.setVisible(true);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    private void initKDTEntry() {
        this.getDetailTable().checkParsed();
        if (this.getDetailTable().getActionMap() != null) {
            this.getDetailTable().getActionMap().remove("Paste");
        }
        KDFormattedTextField txtMile = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorMile = new KDTDefaultCellEditor((JTextField)txtMile);
        txtMile.setHorizontalAlignment(4);
        txtMile.setPrecision(4);
        txtMile.setSupportedEmpty(true);
        txtMile.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtMile, editorMile, this.kdtEntry, TB_MILE);
        String formatString = PrecisionUtil.getFormatString((int)2);
        this.kdtEntry.getColumn(TB_MILE).getStyleAttributes().setNumberFormat(formatString);
        DtUtils.setDefaultF7Editor(this.prmtDeliveryLine, "com.kingdee.eas.scm.im.dt.app.F7DeliveryLineQuery", this.kdtEntry, TB_LINE);
        DtUtils.setDefaultF7Editor(this.prmtDetailCarrier, "com.kingdee.eas.basedata.master.cssp.app.F7CarrierQueryWithDefaultStandard", this.kdtEntry, TB_CARRIER);
        this.kdtEntry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DeliveryLineEditUI.this.kdtEntry_Changed(e);
                }
                catch (Exception exc) {
                    DeliveryLineEditUI.this.handUIException(exc);
                }
            }
        });
        KDTSortManager sortManager = new KDTSortManager(this.kdtEntry);
        sortManager.setSortAuto(true);
        for (int i = 0; i < this.kdtEntry.getColumnCount(); ++i) {
            this.kdtEntry.getColumn(i).setSortable(true);
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        DeliveryLineInfo info = (DeliveryLineInfo)arg0;
        info.setName(null);
        info.setStatus(BillStatusEnum.newbill);
    }

    public void kdtEntry_Changed(KDTEditEvent e) throws Exception {
        if (e.getOldValue() == null && e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtEntry.getColumnIndex(TB_LINE) == colIndex) {
            IObjectValue oValue = (IObjectValue)this.kdtEntry.getCell(rowIndex, TB_LINE).getValue();
            String detailBeg = null;
            String detailEnd = null;
            BigDecimal detailMil = null;
            SupplierInfo detailCar = null;
            Object detailTra = null;
            if (oValue != null) {
                detailBeg = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)oValue, (String)"beginStation.name"));
                detailEnd = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)oValue, (String)"endStation.name"));
                detailMil = UIRuleUtil.getBigDecimal((Object)UIRuleUtil.getProperty((IObjectValue)oValue, (String)"totalMileage"));
                if (UIRuleUtil.getProperty((IObjectValue)oValue, (String)"defaultCarrier.id") != null) {
                    String Id = UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)oValue, (String)"defaultCarrier.id"));
                    detailCar = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)Id)));
                }
                detailTra = UIRuleUtil.getProperty((IObjectValue)oValue, (String)"defaultTranType");
            }
            this.kdtEntry.getCell(rowIndex, TB_DETAILBEGIN).setValue((Object)detailBeg);
            this.kdtEntry.getCell(rowIndex, TB_DETAILEND).setValue((Object)detailEnd);
            this.kdtEntry.getCell(rowIndex, TB_MILE).setValue((Object)detailMil);
            this.kdtEntry.getCell(rowIndex, TB_CARRIER).setValue(detailCar);
            this.kdtEntry.getCell(rowIndex, TB_TRANTYPE).setValue(detailTra);
            if (detailMil != null) {
                BigDecimal totalMile = ZERO;
                int sz = this.kdtEntry.getRowCount();
                for (int i = 0; i < sz; ++i) {
                    if (this.kdtEntry.getCell(i, TB_MILE).getValue() == null) continue;
                    totalMile = totalMile.add((BigDecimal)this.kdtEntry.getCell(i, TB_MILE).getValue());
                }
                this.txttotalMileage.setValue((Object)totalMile);
            }
        } else if (this.kdtEntry.getColumnIndex(TB_MILE) == colIndex) {
            BigDecimal totalMile = ZERO;
            int sz = this.kdtEntry.getRowCount();
            for (int i = 0; i < sz; ++i) {
                if (this.kdtEntry.getCell(i, TB_MILE).getValue() == null) continue;
                totalMile = totalMile.add((BigDecimal)this.kdtEntry.getCell(i, TB_MILE).getValue());
            }
            this.txttotalMileage.setValue((Object)totalMile);
        }
    }

    private void initHeadControl() {
        this.txtName.setMaxLength(255);
        this.txttotalMileage.setRemoveingZeroInDispaly(false);
        this.txttotalMileage.setPrecision(2);
        this.txttotalMileage.setHorizontalAlignment(4);
        this.prmtbeginStation.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
        this.prmtendStation.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtdefaultCarrier.setEntityViewInfo(viewInfo);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.detailLine.id"));
        sic.add(new SelectorItemInfo("entry.detailLine.name"));
        sic.add(new SelectorItemInfo("entry.detailLine.number"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.updateButtonStatus();
        this.setTxtNumberStatus("ControlUnit");
    }

    public void actionSubmit_actionPerformed(ActionEvent arg0) throws Exception {
        for (int i = this.kdtEntry.getRowCount() - 1; i >= 0; --i) {
            if (this.kdtEntry.getCell(i, TB_LINE).getValue() != null) continue;
            this.kdtEntry.getSelectManager().select(i, 0, i, 0, 2);
            IObjectValue detailData = (IObjectValue)this.kdtEntry.getRow(i).getUserObject();
            this.kdtEntry.removeRow(i);
            IObjectCollection collection = (IObjectCollection)this.kdtEntry.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
                continue;
            }
            if (detailData == null) continue;
            collection.removeObject(detailData);
        }
        this.bSave = true;
        if (!this.txtNumber.isEnabled() && (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals(""))) {
            this.setAutoNumber("ControlUnit");
        }
        super.actionSubmit_actionPerformed(arg0);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
    }

    protected void showSubmitSuccess() {
        this.setMessageText(MessageFormat.format(DeliveryLineClientUtils.getResource("Msg_Save_OK"), this.editData.getNumber()));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IObjectValue entry = this.createNewDetailData(this.kdtEntry);
        IRow row = this.kdtEntry.addRow();
        this.loadLineFields(this.kdtEntry, row, entry);
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        IObjectValue entry = this.createNewDetailData(this.kdtEntry);
        IRow row = null;
        if (this.kdtEntry.getSelectManager().size() > 0) {
            int top = this.kdtEntry.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.kdtEntry) ? this.kdtEntry.addRow() : this.kdtEntry.addRow(top);
        } else {
            row = this.kdtEntry.addRow();
        }
        this.loadLineFields(this.kdtEntry, row, entry);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        BigDecimal totalMile = ZERO;
        int sz = this.kdtEntry.getRowCount();
        for (int i = 0; i < sz; ++i) {
            if (this.kdtEntry.getCell(i, TB_MILE).getValue() == null) continue;
            totalMile = totalMile.add((BigDecimal)this.kdtEntry.getCell(i, TB_MILE).getValue());
        }
        this.txttotalMileage.setValue((Object)totalMile);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.kdtEntry.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtEntry)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.kdtEntry.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.kdtEntry.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)this.kdtEntry.getRow(rowIndex).getUserObject();
                this.kdtEntry.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)this.kdtEntry.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(this.kdtEntry, detailData);
            }
            if (this.kdtEntry.getRow(0) != null) {
                this.kdtEntry.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.actionEdit.setEnabled(true);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.actionEdit.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }
}

