/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.FeeLimitFactory;
import com.kingdee.eas.scm.im.dt.FeeLimitInfo;
import com.kingdee.eas.scm.im.dt.IFeeLimit;
import com.kingdee.eas.scm.im.dt.client.AbstractFeeLimitListUI;
import com.kingdee.eas.scm.im.dt.client.DeliveryLineCommonQueryProcess;
import com.kingdee.eas.scm.im.dt.client.FeeLimitFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.DeliveryLineClientUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FeeLimitListUI
extends AbstractFeeLimitListUI {
    private static final Logger logger = CoreUIObject.getLogger(FeeLimitListUI.class);
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_TRANSPORTORG = "transportOrg";
    private static final String TB_STATUS = "status";
    private static final String TB_PRICEDQTY = "entry.pricedQty";
    private static final String TB_PRICE = "entry.price";
    private static final String TB_BEGINDATE = "beginDate";
    private static final String TB_ENDDATE = "endDate";
    private static final String TB_CREATOR_NAME = "creator.name";
    private static final String TB_CREATETIME = "createTime";
    private static final String TB_MODIFIER_NAME = "lastUpdateUser.name";
    private static final String TB_MODIFICATIONTIME = "lastUpdateTime";
    private static final String TB_AUDITOR_NAME = "effector.name";
    private static final String TB_AUDITTIME = "effectDate";
    private static final String[] mergeCols = new String[]{"number", "name", "transportOrg", "status", "beginDate", "endDate", "creator.name", "createTime", "lastUpdateUser.name", "lastUpdateTime", "effector.name", "effectDate"};
    private static final String DTResource = "com.kingdee.eas.scm.im.dt.DTDataImportResource";
    private int qtyPrecision = 0;
    private int pricePrecision = 6;
    private OrgUnitCollection authorizedMainOrgs = null;
    private CommonQueryDialog dialog = null;
    private FeeLimitFilterUI filterUI = null;

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FeeLimitFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setHeight(424);
            this.dialog.setWidth(500);
            DeliveryLineCommonQueryProcess processor = new DeliveryLineCommonQueryProcess();
            this.dialog.setProcessor((IProcessor)processor);
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.dialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = mergeCols;
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            if (this.authorizedMainOrgs == null) {
                IFeeLimit iFeeLimit = FeeLimitFactory.getRemoteInstance();
                this.authorizedMainOrgs = iFeeLimit.getAuthOrgsByType(this.getMainBizOrgType(), this.mainQueryPK);
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (this.authorizedMainOrgs != null && this.authorizedMainOrgs.size() > 0) {
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    keys.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
            } else {
                keys.add(" ");
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("transportOrg.id", keys, CompareType.INCLUDE));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FeeLimitFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        FeeLimitInfo objectValue = new FeeLimitInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.menuItemImportData.setVisible(true);
        super.onLoad();
        KDFormattedTextField txtQty = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorQty = new KDTDefaultCellEditor((JTextField)txtQty);
        txtQty.setHorizontalAlignment(4);
        txtQty.setPrecision(4);
        txtQty.setSupportedEmpty(true);
        txtQty.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtQty, editorQty, this.tblMain, TB_PRICEDQTY);
        String formatString = PrecisionUtil.getFormatString((int)this.qtyPrecision);
        this.tblMain.getColumn(TB_PRICEDQTY).getStyleAttributes().setNumberFormat(formatString);
        KDFormattedTextField txtPrice = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorPrice = new KDTDefaultCellEditor((JTextField)txtPrice);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object target = null;
            Object targetValue = null;
            BigDecimal temp = (BigDecimal)this.tblMain.getRow(i).getCell(TB_PRICE).getValue();
            String temp1 = temp.toString();
            String[] t = temp1.split("\\.");
            this.pricePrecision = t.length == 2 ? t[1].length() : 0;
            txtPrice.setHorizontalAlignment(4);
            txtPrice.setPrecision(this.pricePrecision);
            txtPrice.setSupportedEmpty(true);
            txtPrice.setNegatived(false);
            formatString = PrecisionUtil.getFormatString((int)this.pricePrecision);
            this.tblMain.getRow(i).getCell(TB_PRICE).setEditor((ICellEditor)editorPrice);
            this.tblMain.getRow(i).getCell(TB_PRICE).getStyleAttributes().setNumberFormat(formatString);
        }
        this.tblMain.getColumn(TB_PRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_BEGINDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_ENDDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_CREATETIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_MODIFICATIONTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_AUDITTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (DeliveryLineClientUtils.isSameStatus(this.tblMain, BillStatusEnum.enable, TB_STATUS)) {
            MsgBox.showInfo((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("UnEditLimitFeeForStart"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (DeliveryLineClientUtils.isSameStatus(this.tblMain, BillStatusEnum.enable, TB_STATUS)) {
            MsgBox.showInfo((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("UnRemoveEnableFee"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.cancelCancel();
        this.refreshList();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("B55AEC9C"), null, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"4_FeeLimitListUI"), (String)"feeLimit_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("B55AEC9C"), null, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"4_FeeLimitListUI"), (String)"feeLimit_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.im.FeeLimitInitBill";
        param.alias = FeeLimitListUI.getDTResource("FeeLimitInitBill");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("B55AEC9C"), null, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"4_FeeLimitListUI"), (String)"feeLimit_import");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private static String getDTResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)DTResource, (String)strKey);
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        if (solution != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam("transportOrg.id");
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return null;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.43supplyManage.439dtManage.FeeLimitInitBill";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        param.alias = FeeLimitListUI.getDTResource("FeeLimitInitBill");
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter() == null ? new FilterInfo() : this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

