/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.dt.client.AbstractLogisticsFeeFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.LogisticsFeeClientUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class LogisticsFeeFilterUI
extends AbstractLogisticsFeeFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(LogisticsFeeFilterUI.class);

    public LogisticsFeeFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo));
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        SingleFilterElement mainOrgElement = new SingleFilterElement("transportOrgUnit.number", (Component)this.prmtTransportOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, LogisticsFeeClientUtils.getResource("TransportOrgUnitCantNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("companyOrgUnit.number", (Component)this.prmtCompany));
        elements.add((FilterElement)new RangeFilterElement("sourceBillType.number", (Component)this.prmtSourceBillTypeFrom, (Component)this.prmtSourceBillTypeTo));
        elements.add((FilterElement)new RangeFilterElement("balancer1.number", (Component)this.prmtBalancerFrom, (Component)this.prmtBalancerTo));
        elements.add((FilterElement)new RangeFilterElement("entry.sourceBillNumber", (Component)this.txtSourceNumberFrom, (Component)this.txtSourceNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("feeItem.number", (Component)this.prmtFeeItem));
        elements.add((FilterElement)new SingleFilterElement("detailLine.number", (Component)this.prmtDetailLine));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cbxBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "transportOrgUnit.id");
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtTransportOrgUnit;
    }

    protected String getViewPermission() {
        return "logisticsFee_view";
    }

    private void setF7Filter() throws Exception {
        EntityViewInfo viewNumber = DtUtils.getBizTransportFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewNumber);
        this.prmtNumberTo.setEntityViewInfo(viewNumber);
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtCompany.setEnabledMultiSelection(true);
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.pkBizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.pkBizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.cbxBaseStatus);
        this.cbxBaseStatus.removeItem((Object)BillBaseStatusEnum.CLOSED);
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.prmtFeeItem.setValue(null);
        TransportOrgUnitInfo tou = new TransportOrgUnitInfo();
        try {
            ITransportOrgUnit tof = TransportOrgUnitFactory.getRemoteInstance();
            BOSUuid uuid = BOSUuid.read((String)ids);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            tou = tof.getTransportOrgUnitInfo((IObjectPK)pk);
            CompanyOrgUnitInfo touTOcou = DtUtils.getCompanyInfo(null, tou);
            DtUtils.setExpenseTypeFilter(this.prmtFeeItem, (CoreUIObject)this, true, "LogisticsFee", touTOcou, false);
            this.prmtFeeItem.setDisplayFormat("$name$");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

