/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.dt.RoadCostBillEntryFactory;
import com.kingdee.eas.scm.im.dt.RoadCostBillFactory;
import com.kingdee.eas.scm.im.dt.RoadCostBillInfo;
import com.kingdee.eas.scm.im.dt.client.AbstractRoadCostBillListUI;
import com.kingdee.eas.scm.im.dt.client.RoadCostBillFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import org.apache.log4j.Logger;

public class RoadCostBillListUI
extends AbstractRoadCostBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(RoadCostBillListUI.class);
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_BASESTATUS = "baseStatus";
    private static final String TB_BIZTYPE = "bizType.name";
    private static final String TB_BILLTYPE = "billType.name";
    private static final String TB_BIZDATE = "bizDate";
    private static final String TB_SOURCEBILLTYPE_NAME = "sourceBillType.name";
    private static final String TB_DISTRIBUTIONTYPE = "distributionType";
    private static final String TB_TRANSPORTORGUNIT_NAME = "transportOrgUnit.name";
    private static final String TB_MAINCARRIER_NAME = "mainCarrier.name";
    private static final String TB_SENELINE_NAME = "sendLine.name";
    private static final String TB_TRANSPORTTYPE = "carryBill.transportType";
    private static final String TB_ENTRY_ID = "entry.id";
    private static final String TB_ENTRY_SEQ = "entry.seq";
    private static final String TB_ROADCOST_QTY = "entry.roadCostQty";
    private static final String TB_HANDLE_PRICE = "entry.handlePrice";
    private static final String TB_HANDLE_AMOUNT = "entry.handleAmount";
    private static final String TB_TOTAL_ARQTY = "entry.totalArQty";
    private static final String TB_TOTAL_ARAMOUNT = "entry.totalArAmount";
    private static final String TB_ASSOCIATEQTY = "associateQty";
    private static final String TB_CREATOR_NAME = "creator.name";
    private static final String TB_CREATETIME = "createTime";
    private static final String TB_MODIFIER_NAME = "modifier.name";
    private static final String TB_MODIFICATIONTIME = "modificationTime";
    private static final String TB_AUDITOR_NAME = "auditor.name";
    private static final String TB_AUDITTIME = "auditTime";
    private static final String[] TBS_QTY = new String[]{"entry.roadCostQty", "entry.totalArQty", "associateQty"};
    private static final String[] TBS_PRICE = new String[]{"entry.handlePrice"};
    private static final String[] TBS_AMOUNT = new String[]{"entry.handleAmount", "entry.totalArAmount"};
    private RoadCostBillFilterUI conditionPanel = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(TB_CREATETIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_MODIFICATIONTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_AUDITTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.tblMain.getColumn("description").getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("entry.remark").getStyleAttributes().setWrapText(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.dt.client.RoadCostBillEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RoadCostBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.carryBillEntry.id"));
        return sic;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Transport;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new RoadCostBillFilterUI();
        }
        return this.conditionPanel;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{TB_ID, TB_NUMBER, TB_BASESTATUS, TB_BIZDATE, TB_BIZTYPE, TB_BILLTYPE, TB_SOURCEBILLTYPE_NAME, TB_DISTRIBUTIONTYPE, TB_TRANSPORTORGUNIT_NAME, TB_MAINCARRIER_NAME, TB_SENELINE_NAME, TB_TRANSPORTTYPE, TB_CREATOR_NAME, TB_CREATETIME, TB_MODIFIER_NAME, TB_MODIFICATIONTIME, TB_AUDITOR_NAME, TB_AUDITTIME, "description", "companyOrgUnit.name", "processNode"};
    }

    protected String[] getQtyColumns() throws Exception {
        return TBS_QTY;
    }

    protected String[] getPriceColumns() throws Exception {
        return TBS_PRICE;
    }

    protected String[] getAmountColumns() {
        return TBS_AMOUNT;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add("*");
        sic.add("transportOrgUnit.number");
        sic.add(TB_TRANSPORTORGUNIT_NAME);
        sic.add("bizType.number");
        sic.add(TB_BIZTYPE);
        sic.add("entry.*");
        sic.add("entry.material.number");
        sic.add("entry.material.name");
        sic.add("entry.material.pricePrecision");
        sic.add("entry.assistProperty.number");
        sic.add("entry.assistProperty.name");
        sic.add("entry.unit.number");
        sic.add("entry.unit.name");
        sic.add("entry.baseUnit.number");
        sic.add("entry.baseUnit.name");
        sic.add("entry.assistUnit.number");
        sic.add("entry.assistUnit.name");
        sic.add("entry.compensateDutyor.number");
        sic.add("entry.compensateDutyor.name");
        sic.add("entry.coreBillType.number");
        sic.add("entry.coreBillType.name");
        sic.add("entry.sourceBillType.number");
        sic.add("entry.sourceBillType.name");
        return sic;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"A4D04D23".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, RoadCostBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, RoadCostBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, TB_ID, TB_ENTRY_ID, TB_NUMBER, TB_ENTRY_SEQ, "transportOrgUnit.id");
        super.initBatchActions();
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected void logPrint() {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.im.dt.client.JhResource", (String)"RoadCostBillPrint");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new RoadCostBillInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.dt.RoadCostBillPrintQuery");
    }

    protected String getTDFileName() {
        return "SCM/DT/RoadCostBill";
    }
}

