/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.etl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IIndustry;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IndustryCollection;
import com.kingdee.eas.basedata.assistant.IndustryFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.etl.ETL_IndustryInvVelocityDataFactory;
import com.kingdee.eas.scm.im.etl.ETL_IndustryInvVelocityDataInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportInvVelocity
extends AbstractDataTransmission {
    private IMaterial iMaterial = null;
    private IMaterialGroup iMaterialGroup = null;
    private MaterialCollection materialCollection = null;
    private MaterialGroupCollection materialGroupCollecton = null;
    private IIndustry iIndustry = null;
    private IndustryCollection industryCollection = null;
    private IPeriod iPeriod = null;
    private PeriodCollection periodCollection = null;
    public static final String resClassName = "com.kingdee.eas.scm.im.inv.InvAddResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ETL_IndustryInvVelocityDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).submit(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ETL_IndustryInvVelocityDataInfo info = new ETL_IndustryInvVelocityDataInfo();
        String str = null;
        if (this.iMaterial == null) {
            try {
                this.iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialNumNotExist", (Locale)ctx.getLocale()));
            }
        }
        if (this.iMaterialGroup == null) {
            try {
                this.iMaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialGroupNumNotExist", (Locale)ctx.getLocale()));
            }
        }
        if (this.iIndustry == null) {
            try {
                this.iIndustry = IndustryFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"InventoryNumNotExist", (Locale)ctx.getLocale()));
            }
        }
        if (this.iPeriod == null) {
            try {
                this.iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"PeriodNumNotExist", (Locale)ctx.getLocale()));
            }
        }
        if ((str = this.getDataString(hsData, "FMaterialNum")) != null && !"".equals(str)) {
            try {
                this.materialCollection = this.iMaterial.getMaterialCollection(this.getMaterialViewInfo(str));
            }
            catch (BOSException e) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialNumNotExist", (Locale)ctx.getLocale()));
            }
            if (this.materialCollection == null || this.materialCollection.size() <= 0 || this.materialCollection.get(0) == null || this.materialCollection.get(0).getId() == null) {
                throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialNumNotExist", (Locale)ctx.getLocale()));
            }
            info.setMaterialID(this.materialCollection.get(0).getId().toString());
            if (this.materialCollection.get(0).getMaterialGroup() != null && this.materialCollection.get(0).getMaterialGroup().getId() != null) {
                info.setMaterialGroupID(this.materialCollection.get(0).getMaterialGroup().getId().toString());
            }
        } else {
            str = this.getDataString(hsData, "FMaterialGroupNum");
            if (str != null && !"".equals(str)) {
                try {
                    this.materialGroupCollecton = this.iMaterialGroup.getMaterialGroupCollection(this.getViewInfo(str));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialGroupNumNotExist", (Locale)ctx.getLocale()));
                }
                if (this.materialGroupCollecton == null || this.materialGroupCollecton.size() <= 0 || this.materialGroupCollecton.get(0) == null || this.materialGroupCollecton.get(0).getId() == null) {
                    throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"MaterialGroupNumNotExist", (Locale)ctx.getLocale()));
                }
                info.setMaterialGroupID(this.materialGroupCollecton.get(0).getId().toString());
            }
        }
        if ((str = this.getDataString(hsData, "FIndusteryNum")) == null || "".equals(str)) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"IndustryNumCannotBeNull", (Locale)ctx.getLocale()));
        }
        try {
            this.industryCollection = this.iIndustry.getIndustryCollection(this.getMaterialViewInfo(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"InventoryNumNotExist", (Locale)ctx.getLocale()));
        }
        if (this.industryCollection == null || this.industryCollection.size() <= 0 || this.industryCollection.get(0) == null || this.industryCollection.get(0).getId() == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"InventoryNumNotExist", (Locale)ctx.getLocale()));
        }
        info.setIndustreryID(this.industryCollection.get(0).getId().toString());
        str = this.getDataString(hsData, "FPeriodNum");
        if (str == null || "".equals(str)) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"PeriodCannotBeNull", (Locale)ctx.getLocale()));
        }
        try {
            this.periodCollection = this.iPeriod.getPeriodCollection(this.getViewInfo(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"PeriodNumNotExist", (Locale)ctx.getLocale()));
        }
        if (this.periodCollection == null || this.periodCollection.size() <= 0 || this.periodCollection.get(0) == null || this.periodCollection.get(0).getId() == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"PeriodNumNotExist", (Locale)ctx.getLocale()));
        }
        info.setPeriodID(this.periodCollection.get(0).getId().toString());
        BigDecimal Zero = new BigDecimal("0.00");
        info.setPeriodBeginAmount(Zero);
        info.setPeriodEndAmount(Zero);
        info.setIssueAmount(Zero);
        info.setTurnOverRate(Zero);
        if (this.getDataBigDecimal(hsData, "FTurnOverRate") == null) {
            throw new TaskExternalException(DataImportTools.getResString((String)resClassName, (String)"InvTurnOverRateCannotBeNull", (Locale)ctx.getLocale()));
        }
        info.setTurnOverRate(this.getDataBigDecimal(hsData, "FTurnOverRate"));
        String id = null;
        id = this.getExistID(info, ctx);
        if (id != null) {
            info.setId(BOSUuid.read((String)id));
        }
        return info;
    }

    private String getExistID(ETL_IndustryInvVelocityDataInfo info, Context ctx) {
        String id = null;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("select fid from T_ETL_IndustryInData where 1 = 1\r\n");
        if (info.getMaterialID() != null) {
            strBuffer.append("and FMATERIALID = '" + info.getMaterialID() + "'\r\n");
        } else {
            strBuffer.append("and FMATERIALID is null \r\n");
        }
        if (info.getMaterialGroupID() != null) {
            strBuffer.append("and FMATERIALGROUPID = '" + info.getMaterialGroupID() + "'\r\n");
        } else {
            strBuffer.append("and FMATERIALGROUPID is null \r\n");
        }
        if (info.getIndustreryID() != null) {
            strBuffer.append("and FINDUSTERYID = '" + info.getIndustreryID() + "'\r\n");
        } else {
            strBuffer.append("and FINDUSTERYID is null \r\n");
        }
        if (info.getPeriodID() != null) {
            strBuffer.append("and FPERIODID = '" + info.getPeriodID() + "'\r\n");
        } else {
            strBuffer.append(" and FPERIODID is null \r\n");
        }
        IRowSet rs = null;
        try {
            String sqlStr = strBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException ex) {
            Logger.error((Throwable)ex);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return id;
    }

    private EntityViewInfo getViewInfo(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        return viewInfo;
    }

    private EntityViewInfo getMaterialViewInfo(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("materialGroup.id"));
        return viewInfo;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }
}

