/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractDecompShortQtyListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class DecompShortQtyListUI
extends AbstractDecompShortQtyListUI {
    private static final String MATERIALNUM = "materialNum";
    private static final String MATERIALNAME = "materialName";
    private static final String MODEL = "model";
    private static final String ASSISTPROPERTY = "assistProperty";
    private static final String LOT = "lot";
    private static final String WAREHOUSE = "warehouse";
    private static final String LOCATION = "location";
    private static final String UNIT = "unit";
    private static final String EXP = "exp";
    private static final String NEEDQTY = "needQty";
    private static final String DETAILQTY = "detailQty";
    private static final String SHORTQTY = "shortQty";
    private static final String STORETYPE = "storeType";
    private static final String STORESTATUS = "storeStatus";
    private static final String CUSTOMER = "customer";
    private static final String SUPPLIER = "supplier";
    private static final String ID = "inventoryID";
    private static final int COLLENGTH = 17;
    private ArrayList alObject;
    private HashMap hm = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap uiContext = (HashMap)this.getUIContext();
        this.hm = (HashMap)uiContext.get("DecomposeBillEditUI_hmKey");
        this.alObject = (ArrayList)uiContext.get("DecomposeBillEditUI_alKey");
        this.kdTable.checkParsed();
        this.initTable();
        if (this.alObject != null) {
            this.fillData();
        }
    }

    public String getUITitle() {
        String strList = InvClientUtils.getResource("DECOMPNEEDQTYLIST");
        return strList;
    }

    private void initTable() {
        for (int i = 0; i < 17; ++i) {
            this.kdTable.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.kdTable.getColumn(EXP).getStyleAttributes().setNumberFormat(DateTimeUtil.strDateFormat);
        this.kdTable.getColumn(NEEDQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdTable.getColumn(DETAILQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdTable.getColumn(SHORTQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected void btnCommit_actionPerformed(ActionEvent e) throws Exception {
        super.btnCommit_actionPerformed(e);
    }

    private void fillData() {
        BigDecimal needlQty = InvClientUtils.ZERO;
        BigDecimal detailQty = InvClientUtils.ZERO;
        BigDecimal shortQty = InvClientUtils.ZERO;
        String id = "";
        int recs = this.hm.size();
        for (int i = 0; i < recs; ++i) {
            InventoryInfo inventoryInfo = (InventoryInfo)this.alObject.get(i);
            this.kdTable.addRow();
            IRow iRow = this.kdTable.getRow(i);
            id = inventoryInfo.getId().toString();
            iRow.getCell(ID).setValue((Object)id);
            iRow.getCell(MATERIALNUM).setValue((Object)inventoryInfo.getMaterial().getNumber());
            iRow.getCell(MATERIALNAME).setValue((Object)inventoryInfo.getMaterial().getName());
            iRow.getCell(MODEL).setValue((Object)inventoryInfo.getMaterial().getModel());
            if (inventoryInfo.getAssistProperty() != null) {
                iRow.getCell(ASSISTPROPERTY).setValue((Object)inventoryInfo.getAssistProperty().getName());
            }
            iRow.getCell(LOT).setValue((Object)inventoryInfo.getLot());
            if (inventoryInfo.getWarehouse() != null) {
                iRow.getCell(WAREHOUSE).setValue((Object)inventoryInfo.getWarehouse().getName());
            }
            if (inventoryInfo.getLocation() != null) {
                iRow.getCell(LOCATION).setValue((Object)inventoryInfo.getLocation().getName());
            }
            iRow.getCell(UNIT).setValue((Object)inventoryInfo.getUnit().getName());
            iRow.getCell(EXP).setValue((Object)inventoryInfo.getExp());
            needlQty = inventoryInfo.getCurStoreQty();
            iRow.getCell(NEEDQTY).setValue((Object)needlQty);
            iRow.getCell(STORETYPE).setValue((Object)inventoryInfo.getStoretype().getName());
            iRow.getCell(STORESTATUS).setValue((Object)inventoryInfo.getStorestatus().getName());
            if (inventoryInfo.getCustomer() != null) {
                iRow.getCell(CUSTOMER).setValue((Object)inventoryInfo.getCustomer().getName());
            }
            if (inventoryInfo.getSupplier() != null) {
                iRow.getCell(SUPPLIER).setValue((Object)inventoryInfo.getSupplier().getName());
            }
            detailQty = (BigDecimal)this.hm.get(id);
            shortQty = needlQty.subtract(detailQty);
            iRow.getCell(DETAILQTY).setValue((Object)detailQty);
            iRow.getCell(SHORTQTY).setValue((Object)shortQty);
        }
    }
}

