/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.im.inv.client.AbstractFileImportUI;
import com.kingdee.eas.scm.im.inv.client.ExcelFileFilter;
import com.kingdee.eas.scm.im.inv.client.TxtFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileImportUI
extends AbstractFileImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(FileImportUI.class);
    private static final String SN_RESOURCE = "com.kingdee.eas.scm.im.inv.SerialNumberResource";
    private KDFileChooser fileChooser;
    private boolean iscancel = false;
    private File file = null;
    private String fileType = null;
    private CoreUI resUI = null;

    private String getSNResource(String field) {
        return EASResource.getString((String)SN_RESOURCE, (String)field);
    }

    public FileImportUI() throws Exception {
        this.btnTemplateExport.setEnabled(true);
        this.btnSelectFile.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnImport.setEnabled(true);
    }

    public void init(String name, String fileType) {
        this.setUITitle(name);
        if ("TXT".equals(fileType)) {
            this.fileType = "TXT";
        } else if ("XLS".equals(fileType)) {
            this.fileType = "XLS";
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        this.setIscancel(true);
    }

    @Override
    public void actionTemplateExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.resUI == null) {
            return;
        }
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        int result = fileChooser.showSaveDialog((Component)((Object)this));
        if (result == 0) {
            File destFlie = this.getSelectedFile(fileChooser);
            if (destFlie == null) {
                String error = this.getSNResource("FILE_NOT_EXIST");
                MsgBox.showInfo((String)error);
                return;
            }
            super.actionTemplateExport_actionPerformed(e);
            logger.debug((Object)this.resUI.getClass().getName());
            Class<?> clazz = this.resUI.getClass();
            Method method = clazz.getMethod("exportTempFile", File.class);
            method.invoke((Object)this.resUI, destFlie);
        }
    }

    @Override
    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        this.fileChooser = this.getFileChooser();
        if (this.fileChooser.showOpenDialog((Component)((Object)this)) != 1) {
            File aFile = this.fileChooser.getSelectedFile();
            if (aFile == null) {
                String error = this.getSNResource("nofile");
                MsgBox.showInfo((String)error);
                return;
            }
            if (!aFile.isFile()) {
                String error = this.getSNResource("notfile");
                MsgBox.showInfo((String)error);
                return;
            }
            if (aFile.isDirectory()) {
                String error = this.getSNResource("isdirectory");
                MsgBox.showInfo((String)error);
                return;
            }
            if (!aFile.canRead()) {
                String error = this.getSNResource("notread");
                MsgBox.showInfo((String)error);
                return;
            }
            this.txtFile.setText(aFile.getAbsolutePath());
        }
    }

    public KDFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileSelectionMode(0);
            if ("TXT".equals(this.fileType)) {
                this.fileChooser.setFileFilter((FileFilter)new TxtFileFilter());
            } else if ("XLS".equals(this.fileType)) {
                this.fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
            } else if (this.fileType == null) {
                this.fileChooser.setFileFilter((FileFilter)new TxtFileFilter());
            }
        }
        return this.fileChooser;
    }

    public File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                } else if (ext instanceof TxtFileFilter) {
                    path = path + ".txt";
                }
                file = new File(path);
            }
        }
        return file;
    }

    protected File getImportFile() throws Exception {
        String strFile = this.txtFile.getText();
        if (strFile == null || strFile.length() == 0) {
            return null;
        }
        File aFile = new File(strFile);
        if (!aFile.isFile()) {
            return null;
        }
        if (aFile.isDirectory()) {
            return null;
        }
        if (!aFile.canRead()) {
            return null;
        }
        return aFile;
    }

    @Override
    public void actionConfim_actionPerformed(ActionEvent e) throws Exception {
        File aFile = this.getImportFile();
        if (aFile == null) {
            String error = this.getSNResource("noSelectFile");
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
        this.file = aFile;
        this.actionExitCurrent_actionPerformed(null);
        this.setIscancel(false);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isIscancel() {
        return this.iscancel;
    }

    public void setIscancel(boolean iscancel) {
        this.iscancel = iscancel;
    }

    public CoreUI getResUI() {
        return this.resUI;
    }

    public void setResUI(CoreUI resUI) {
        this.resUI = resUI;
    }
}

