/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.InvCkAccountFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInvCkAccountFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InvCkAccountFilterUI
extends AbstractInvCkAccountFilterUI
implements KDTEditListener,
DataChangeListener {
    private static final long serialVersionUID = -7702139796043484034L;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private boolean isSetCustomCondition = false;
    private CompanyOrgUnitInfo curCompany = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.bizCompnayOrg.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
            SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.bizCompnayOrg, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
            this.bizCompnayOrg.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        InvCkAccountFilterUI.this.bizCompnayOrg_stateChanged(e);
                    }
                    catch (Exception exc) {
                        InvCkAccountFilterUI.this.handUIException(exc);
                    }
                }
            });
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        this.spnAccountFrom.setValue(null);
        this.spnAccountTo.setValue(null);
        this.ckShowNoCalculate.setSelected(false);
        this.noSelectStorageMoveBill.setSelected(false);
        this.noSelectWarehouseMoveBill.setSelected(false);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.bizCompnayOrg.setValue((Object)this.curCompany);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams rptParam = new RptParams();
        rptParam.setObject("bizCompnayOrg", this.bizCompnayOrg.getValue());
        rptParam.setInt("spnYearFrom", this.spnYearFrom.getIntegerVlaue().intValue());
        rptParam.setInt("spnPeriodFrom", this.spnPeriodFrom.getIntegerVlaue().intValue());
        rptParam.setInt("spnYearTo", this.spnYearTo.getIntegerVlaue().intValue());
        rptParam.setInt("spnPeriodTo", this.spnPeriodTo.getIntegerVlaue().intValue());
        rptParam.setObject("spnAccountFrom", this.spnAccountFrom.getValue());
        rptParam.setObject("spnAccountTo", this.spnAccountTo.getValue());
        rptParam.setObject("ckShowNoCalculate", (Object)this.ckShowNoCalculate.isSelected());
        rptParam.setObject("noSelectStorageMoveBill", (Object)this.noSelectStorageMoveBill.isSelected());
        rptParam.setObject("noSelectWarehouseMoveBill", (Object)this.noSelectWarehouseMoveBill.isSelected());
        return rptParam;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            return;
        }
        this.isSetCustomCondition = true;
        this.bizCompnayOrg.setValue(params.getObject("bizCompnayOrg"));
        this.spnYearFrom.setValue((Object)new Integer(params.getInt("spnYearFrom")));
        this.spnPeriodFrom.setValue((Object)new Integer(params.getInt("spnPeriodFrom")));
        this.spnYearTo.setValue((Object)new Integer(params.getInt("spnYearTo")));
        this.spnPeriodTo.setValue((Object)new Integer(params.getInt("spnPeriodTo")));
        this.spnAccountFrom.setValue(params.getObject("spnAccountFrom"));
        this.spnAccountTo.setValue(params.getObject("spnAccountTo"));
        this.ckShowNoCalculate.setSelected(((Boolean)params.getObject("ckShowNoCalculate")).booleanValue());
        this.noSelectStorageMoveBill.setSelected(params.getObject("noSelectStorageMoveBill") == null ? false : (Boolean)params.getObject("noSelectStorageMoveBill"));
        this.noSelectWarehouseMoveBill.setSelected(params.getObject("noSelectWarehouseMoveBill") == null ? false : (Boolean)params.getObject("noSelectWarehouseMoveBill"));
        this.isSetCustomCondition = false;
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (companyInfo != null) {
            Map map = InvCkAccountFacadeFactory.getRemoteInstance().getPeriodRange(companyInfo);
            PeriodInfo currPeriodInfo = (PeriodInfo)map.get("currPeriod");
            PeriodInfo startPeriodInfo = (PeriodInfo)map.get("startPeriod");
            if (currPeriodInfo == null) {
                this.bizCompnayOrg.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
            if (startPeriodInfo == null) {
                this.bizCompnayOrg.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)map.get("actPeriod");
            CalculateUtil.appliesPeriodControl((KDSpinner)this.spnYearFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnPeriodTo, (CalculateUtil.AccountPeriodInfo)actPeriodInfo, (boolean)true, (boolean)false);
        }
    }

    public AccountTableInfo getAccountTable(String tableId) {
        AccountTableInfo currentTable = null;
        try {
            IAccountTable iAccTable = AccountTableFactory.getRemoteInstance();
            currentTable = iAccTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(tableId));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return currentTable;
    }

    public String checkAccountTable(KDBizPromptBox bizPromptBox) {
        this.curCompany = (CompanyOrgUnitInfo)this.bizCompnayOrg.getValue();
        if (this.curCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            if ("spnAccountFrom".equals(bizPromptBox.getName())) {
                this.spnAccountFrom.setValue(null);
            } else if ("spnAccountTo".equals(bizPromptBox.getName())) {
                this.spnAccountTo.setValue(null);
            }
            SysUtil.abort();
        }
        AccountTableInfo table = this.curCompany.getAccountTable();
        int yearFrom = this.spnYearFrom.getIntegerVlaue();
        int yearTo = this.spnYearTo.getIntegerVlaue();
        int periodFrom = this.spnPeriodFrom.getIntegerVlaue();
        int periodTo = this.spnPeriodTo.getIntegerVlaue();
        String companyID = this.curCompany.getId().toString();
        String tableFromId = "";
        String tableToId = "";
        String tableId = "";
        try {
            tableFromId = AccountTools.getCurrentAcctTable((String)companyID, (String)table.getId().toString(), (int)yearFrom, (int)periodFrom);
            tableToId = AccountTools.getCurrentAcctTable((String)companyID, (String)table.getId().toString(), (int)yearTo, (int)periodTo);
            if (!tableFromId.equals(tableToId)) {
                MsgBox.showError((String)EASResource.getString((String)resClassName, (String)"newOldAccountTalbeCanNotView"));
                SysUtil.abort();
            } else {
                tableId = tableFromId;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return tableId;
    }

    protected void bizCompnayOrg_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isSetCustomCondition) {
            if (this.bizCompnayOrg.getData() != null) {
                this.loadAccountPeriod((CompanyOrgUnitInfo)this.bizCompnayOrg.getData());
            }
            this.curCompany = (CompanyOrgUnitInfo)this.bizCompnayOrg.getData();
        }
        if (this.curCompany != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("longName"));
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            if (this.curCompany.getAccountTable() == null) {
                fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
            } else {
                fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
                fic.add(new FilterItemInfo("accountTableID.id", (Object)this.curCompany.getAccountTable().getId().toString()));
            }
            fic.add(new FilterItemInfo("isleaf", (Object)1));
            this.spnAccountFrom.setEditable(true);
            this.spnAccountFrom.setEditFormat("$number$");
            this.spnAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
            this.spnAccountFrom.setDisplayFormat("$number$ - $name$");
            this.spnAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            this.spnAccountFrom.setSelectorCollection(sic);
            this.spnAccountTo.setEditFormat("$number$");
            this.spnAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
            this.spnAccountTo.setDisplayFormat("$number$ - $name$");
            this.spnAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            this.spnAccountTo.setSelectorCollection(sic);
            view.setFilter(filter);
            this.spnAccountFrom.setEntityViewInfo(view);
            this.spnAccountTo.setEntityViewInfo(view);
        }
    }

    public boolean verify() {
        int periodTo;
        int yearTo;
        int periodfrom;
        if (this.bizCompnayOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.spnYearFrom.getIntegerVlaue();
        if (100 * yearFrom + (periodfrom = this.spnPeriodFrom.getIntegerVlaue().intValue()) > 100 * (yearTo = this.spnYearTo.getIntegerVlaue().intValue()) + (periodTo = this.spnPeriodTo.getIntegerVlaue().intValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg != null && currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
            FullOrgUnitCollection orgCol = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
            if (orgCol != null && orgCol.size() > 0) {
                OrgUnitInfo[] orgs = OrgRelationUtils.getOrgUnitInfosByType((FullOrgUnitCollection)orgCol, (OrgType)this.getMainBizOrgType());
                return orgs[0];
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizCompnayOrg;
    }

    protected String getViewPermission() {
        return "checkaccount";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void dataChanged(DataChangeEvent eventObj) {
    }
}

