/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InvFetchDataUtils {
    public static FetchSupplyInfo getFetchSupplyInfo(Map supplyInfoMap, String supplierId, String pouId, String matId) throws EASBizException, BOSException {
        if (supplierId == null || pouId == null || matId == null) {
            return null;
        }
        String key = supplierId + pouId + matId;
        if (supplyInfoMap.containsKey(key)) {
            return (FetchSupplyInfo)supplyInfoMap.get(key);
        }
        FetchSupplyInfo info = null;
        HashMap<String, Object> materialMap = new HashMap<String, Object>(1);
        materialMap.put(matId, null);
        info = (FetchSupplyInfo)BatchFetchDataUtils.getFetchSupplyInfoMap(materialMap, (String)pouId, (String)supplierId, null, (boolean)false).get(matId);
        supplyInfoMap.put(key, info);
        return info;
    }

    public static void batchPutFetchSupplyMap(Map supplyInfoMap, SupplierInfo supplierInfo, PurchaseOrgUnitInfo aPurchaseOrgUnitInfo, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        if (materialInfos == null || materialInfos.length == 0) {
            return;
        }
        if (supplierInfo == null || aPurchaseOrgUnitInfo == null) {
            return;
        }
        HashMap<String, Object> materialMap = new HashMap<String, Object>();
        for (int i = 0; i < materialInfos.length; ++i) {
            materialMap.put(materialInfos[i].getId().toString(), null);
        }
        String supplierId = supplierInfo.getId().toString();
        String pouId = aPurchaseOrgUnitInfo.getId().toString();
        Map fetMap = BatchFetchDataUtils.getFetchSupplyInfoMap(materialMap, (String)pouId, (String)supplierId, null, (boolean)false);
        for (Object key : fetMap.keySet()) {
            String matId = (String)key;
            supplyInfoMap.put(supplierId + pouId + matId, fetMap.get(key));
        }
    }

    public static void batchPutFetchSupplyMap(Map supplyInfoMap, SupplierInfo supplierInfo, PurchaseOrgUnitInfo aPurchaseOrgUnitInfo, KDTable detailTable, String materialColumn, int beginRow, int length) throws EASBizException, BOSException {
        if (supplierInfo == null || aPurchaseOrgUnitInfo == null) {
            return;
        }
        HashMap<String, Object> materialMap = new HashMap<String, Object>();
        MaterialInfo materilInfo = null;
        for (int i = 0; i < length; ++i) {
            materilInfo = (MaterialInfo)detailTable.getCell(beginRow + i, materialColumn).getValue();
            if (materilInfo == null) continue;
            materialMap.put(materilInfo.getId().toString(), null);
        }
        String supplierId = supplierInfo.getId().toString();
        String pouId = aPurchaseOrgUnitInfo.getId().toString();
        Map fetMap = BatchFetchDataUtils.getFetchSupplyInfoMap(materialMap, (String)pouId, (String)supplierId, null, (boolean)false);
        for (Object key : fetMap.keySet()) {
            String matId = (String)key;
            supplyInfoMap.put(supplierId + pouId + matId, fetMap.get(key));
        }
    }

    public static void initFetchDataWhenBatchMaterial(StorageOrgUnitInfo sou, CompanyOrgUnitInfo ficompanyOrgInfo, PurchaseOrgUnitInfo pou, MaterialInfo[] minfos, SCMFetchData fetchData) throws EASBizException, BOSException {
        if (fetchData == null || minfos == null || minfos.length == 0) {
            return;
        }
        MaterialInfo[] materialInfos = new MaterialInfo[minfos.length];
        System.arraycopy(minfos, 0, materialInfos, 0, minfos.length);
        for (int i = 0; i < materialInfos.length; ++i) {
            if (materialInfos[i] == null || !fetchData.getMapMaterial().containsKey(materialInfos[i].getId().toString())) continue;
            materialInfos[i] = null;
        }
        SCMFetchDataCondition condition = InvFetchDataUtils.getConditionForBatchMaterial(ficompanyOrgInfo, pou);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < materialInfos.length; ++i) {
            if (materialInfos[i] == null) continue;
            set.add(materialInfos[i].getId().toString());
        }
        if (set.isEmpty()) {
            return;
        }
        String[] materialIds = set.toArray(new String[set.size()]);
        condition.setMaterialPKs(materialIds);
        condition.setSou(sou);
        SCMFetchData sCMFetchData = SCMFetchDataFacadeFactory.getRemoteInstance().fetchData(condition.toEntiryView());
        fetchData.addMapMaterial(sCMFetchData.getMapMaterial());
        fetchData.addMapMaterialCompany(sCMFetchData.getMapMaterialCompany());
        fetchData.addMapMaterialInventory(sCMFetchData.getMapMaterialInventory());
        fetchData.addMapMaterialPurchasing(sCMFetchData.getMapMaterialPurchasing());
    }

    public static void setCacheDefautWarehouse(StorageOrgUnitInfo sou, SCMFetchData fetchData) throws EASBizException, BOSException {
        Map materialInvtoryMap = fetchData.getMapMaterialInventory();
        Map mapStoker = fetchData.getMapStocker();
        Map warehousMap = fetchData.getMapWarehouse();
        MaterialInventoryInfo matInvInfo = null;
        WarehouseInfo warhousInfo = null;
        if (materialInvtoryMap != null && !materialInvtoryMap.isEmpty()) {
            for (Object key : materialInvtoryMap.keySet()) {
                matInvInfo = (MaterialInventoryInfo)materialInvtoryMap.get(key);
                if (matInvInfo == null) continue;
                warehousMap.put(matInvInfo.getMaterial().getId().toString(), matInvInfo.getDefaultWarehouse());
                warhousInfo = matInvInfo.getDefaultWarehouse();
                if (warhousInfo == null) continue;
                mapStoker.put(warhousInfo.getId().toString(), warhousInfo.getWhman());
            }
        }
        InvFetchDataUtils.setCacheDefaultLocation(sou, fetchData);
    }

    public static void setCacheDefaultLocation(StorageOrgUnitInfo sou, SCMFetchData fetchData) throws EASBizException, BOSException {
        Map materialInvtoryMap = fetchData.getMapMaterialInventory();
        Map locationMap = fetchData.getMapDefaultLocation();
        if (sou == null || materialInvtoryMap == null || materialInvtoryMap.isEmpty()) {
            return;
        }
        HashMap<String, String> mat2Warehous = new HashMap<String, String>();
        MaterialInventoryInfo matInvInfo = null;
        WarehouseInfo wareInfo = null;
        if (materialInvtoryMap != null && !materialInvtoryMap.isEmpty()) {
            for (Object key : materialInvtoryMap.keySet()) {
                matInvInfo = (MaterialInventoryInfo)materialInvtoryMap.get(key);
                if (matInvInfo == null || (wareInfo = matInvInfo.getDefaultWarehouse()) == null) continue;
                mat2Warehous.put(matInvInfo.getMaterial().getId().toString(), wareInfo.getId().toString());
                locationMap.put(matInvInfo.getMaterial().getId().toString() + wareInfo.getId().toString() + sou.getId().toString(), null);
            }
        }
        locationMap.putAll(InvFetchDataUtils.batchGetDefaultLocation(sou, mat2Warehous));
    }

    public static Map batchGetDefaultLocation(StorageOrgUnitInfo sou, Map mat2Warehous) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        if (sou == null || mat2Warehous == null || mat2Warehous.isEmpty()) {
            return map;
        }
        String matId = null;
        String wareId = null;
        for (Object key : mat2Warehous.keySet()) {
            matId = (String)key;
            wareId = (String)mat2Warehous.get(key);
            map.put(matId + wareId + sou.getId().toString(), null);
        }
        IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
        map.putAll(imsa.batchGetDefaultLocation(sou.getId().toString(), mat2Warehous));
        return map;
    }

    public static SCMFetchDataCondition getConditionForBatchMaterial(CompanyOrgUnitInfo ficompanyOrgInfo, PurchaseOrgUnitInfo pou) {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        condition.setFetchMaterial(true);
        condition.setFetchID(true);
        condition.setFetchNumber(true);
        condition.setFetchName(true);
        condition.setFetchAsstAttrType(true);
        condition.setFetchModel(true);
        condition.setFetchIsLotNumber(true);
        condition.setFetchUnitPrecision(true);
        condition.setFetchBaseUnit(true);
        condition.setFetchBaseUnitPrecision(true);
        condition.setFetchAssistUnit(true);
        condition.setFetchAsstUnitPrecision(true);
        condition.setFetchPricePrecision(true);
        condition.setFetchSou(true);
        condition.setFetchMaterialInventory(true);
        condition.setFetchDefaultWarehouse(true);
        condition.setFetchDefaultLocation(true);
        condition.setFetchIsLotNumber(true);
        condition.setFetchIsBatchNo(true);
        condition.setFetchIsSequenceNo(true);
        condition.setFetchIsPeriodValid(true);
        condition.setFetchIsNegative(true);
        condition.setFetchIssuePriorityMode(true);
        condition.setFetchInventoryUnit(true);
        condition.setFetchLotFrame(true);
        condition.setFetchDurability(true);
        condition.setPou(pou);
        condition.setFetchMaterialPurchasing(true);
        condition.setFetchQualityOrg(true);
        condition.setFetchMaterialCompany(true);
        condition.setFetchCompany(true);
        condition.setFetchAccountType(true);
        condition.setFetchStandardCost(true);
        condition.setFetchCompanyStatus(true);
        condition.setCou(ficompanyOrgInfo);
        return condition;
    }

    public static void setCacheData(StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou, MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException, EASBizException {
        LowTimer timer = new LowTimer();
        InvFetchDataUtils.setMatCache(matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u57fa\u672c\u4fe1\u606f\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
        InvFetchDataUtils.setMatComCache(cou, matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u8d22\u52a1\u4fe1\u606f\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
        InvFetchDataUtils.setMatPlanyCache(sou, matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
        InvFetchDataUtils.setMatInvCache(sou, matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
        InvFetchDataUtils.setMatUnitPrecisionCache(matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u7cbe\u5ea6\u4fe1\u606f\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
        InvFetchDataUtils.setMatUnitbaseConvsRate(matInfos, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u7684\u8f6c\u6362\u7387\u8017\u65f6\uff1a" + timer.msValue());
        InvFetchDataUtils.setCacheDefautWarehouse(sou, fetchData);
        System.out.println("\u83b7\u53d6\u7269\u6599\u9ed8\u8ba4\u4ed3\u5e93\u7684\u9ed8\u8ba4\u5e93\u4f4d\u8017\u65f6\uff1a" + timer.msValue());
        timer.reset();
    }

    public static void setMatCache(MaterialInfo[] matInfos, SCMFetchData fetchData) {
        Map materialsMap = fetchData.getMapMaterial();
        for (int i = 0; i < matInfos.length; ++i) {
            MaterialInfo matInfo = matInfos[i];
            if (matInfo == null || materialsMap.containsKey(matInfo.getId().toString())) continue;
            materialsMap.put(matInfo.getId().toString(), matInfo);
        }
    }

    public static void setMatComCache(CompanyOrgUnitInfo cou, MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException {
        if (cou == null || matInfos == null || matInfos.length == 0) {
            return;
        }
        Map materialsComMap = fetchData.getMapMaterialCompany();
        HashSet<String> queryMatIDs = new HashSet<String>();
        for (int i = 0; i < matInfos.length; ++i) {
            MaterialInfo matInfo = matInfos[i];
            if (matInfo == null || materialsComMap.containsKey(matInfo.getId().toString() + cou.getId().toString())) continue;
            queryMatIDs.add(matInfo.getId().toString());
        }
        if (queryMatIDs.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", queryMatIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cou.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("KAClass.id"));
        sic.add(new SelectorItemInfo("KAClass.name"));
        sic.add(new SelectorItemInfo("KAClass.number"));
        sic.add(new SelectorItemInfo("standardCost"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("calculateType"));
        sic.add(new SelectorItemInfo("materialId"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("mateial.longNumber"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.shortName"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        MaterialCompanyInfoCollection con = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialCompanyInfoInfo info = con.get(i);
                materialsComMap.put(info.getMateial().getId().toString() + cou.getId().toString(), info);
            }
        }
    }

    public static void setMatPlanyCache(StorageOrgUnitInfo sou, MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException {
        if (sou == null || matInfos == null || matInfos.length == 0) {
            return;
        }
        Map materialsPlany = fetchData.getMapMaterialPlan();
        HashSet<String> queryMatIDs = new HashSet<String>();
        for (int i = 0; i < matInfos.length; ++i) {
            MaterialInfo matInfo = matInfos[i];
            if (matInfo == null || materialsPlany.containsKey(matInfo.getId().toString() + sou.getId().toString())) continue;
            queryMatIDs.add(matInfo.getId().toString());
            materialsPlany.put(matInfo.getId().toString() + sou.getId().toString(), null);
        }
        if (queryMatIDs.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", queryMatIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("productUnit.number"));
        sic.add(new SelectorItemInfo("productUnit.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("manufactureStrategy.name"));
        sic.add(new SelectorItemInfo("manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("isolatedRule"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        MaterialPlanCollection con = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialPlanInfo info = con.get(i);
                materialsPlany.put(info.getMaterial().getId().toString() + sou.getId().toString(), info);
            }
        }
    }

    public static void setMatInvCache(StorageOrgUnitInfo sou, MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException {
        if (sou == null || matInfos == null || matInfos.length == 0) {
            return;
        }
        Map materialsInv = fetchData.getMapMaterialInventory();
        HashSet<String> queryMatIDs = new HashSet<String>();
        for (int i = 0; i < matInfos.length; ++i) {
            MaterialInfo matInfo = matInfos[i];
            if (matInfo == null || materialsInv.containsKey(matInfo.getId().toString() + sou.getId().toString())) continue;
            queryMatIDs.add(matInfo.getId().toString());
        }
        if (queryMatIDs.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", queryMatIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)sou.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("defaultWarehouse.name"));
        sic.add(new SelectorItemInfo("defaultWarehouse.number"));
        sic.add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        sic.add(new SelectorItemInfo("defaultWarehouse.whState"));
        sic.add(new SelectorItemInfo("defaultWarehouse.whman.id"));
        sic.add(new SelectorItemInfo("defaultWarehouse.whman.number"));
        sic.add(new SelectorItemInfo("defaultWarehouse.whman.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isControl"));
        sic.add(new SelectorItemInfo("qtySafety"));
        sic.add(new SelectorItemInfo("qtyMin"));
        sic.add(new SelectorItemInfo("qtyMax"));
        sic.add(new SelectorItemInfo("daysBottom"));
        sic.add(new SelectorItemInfo("daysTop"));
        sic.add(new SelectorItemInfo("daysTurnover"));
        sic.add(new SelectorItemInfo("isNegative"));
        sic.add(new SelectorItemInfo("isBatchNo"));
        sic.add(new SelectorItemInfo("isSequenceNo"));
        sic.add(new SelectorItemInfo("isLotNumber"));
        sic.add(new SelectorItemInfo("isBarcode"));
        sic.add(new SelectorItemInfo("qtyMinPackage"));
        sic.add(new SelectorItemInfo("abcType"));
        sic.add(new SelectorItemInfo("isCompages"));
        sic.add(new SelectorItemInfo("issuePriorityMode"));
        sic.add(new SelectorItemInfo("isPeriodValid"));
        sic.add(new SelectorItemInfo("periodValid"));
        sic.add(new SelectorItemInfo("periodValidUnit"));
        sic.add(new SelectorItemInfo("inWarehsAhead"));
        sic.add(new SelectorItemInfo("outWarehsAhead"));
        sic.add(new SelectorItemInfo("prepWarnAhead"));
        sic.add(new SelectorItemInfo("aheadUnit"));
        sic.add(new SelectorItemInfo("closeDateCalMode"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        MaterialInventoryCollection con = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialInventoryInfo info = con.get(i);
                materialsInv.put(info.getMaterial().getId().toString() + sou.getId().toString(), info);
            }
        }
    }

    public static void setMatUnitbaseConvsRate(MaterialInfo[] materialInfoArray, SCMFetchData fetchData) throws BOSException, EASBizException {
        if (materialInfoArray == null || materialInfoArray.length == 0) {
            return;
        }
        Map mapConvertRate = fetchData.getMapUnitbaseConvsRate();
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (MaterialInfo materialInfo : materialInfoArray) {
            String unitIdStr;
            if (materialInfo == null || materialInfo.getId() == null) continue;
            String materialIdStr = materialInfo.getId().toString();
            MeasureUnitInfo unit = materialInfo.getBaseUnit();
            if (unit != null && !mapConvertRate.containsKey(materialIdStr + unit.getId().toString())) {
                unitIdStr = unit.getId().toString();
                materialIdSet.add(materialIdStr);
                unitIdSet.add(unitIdStr);
                mapConvertRate.put(materialIdStr + unitIdStr, null);
            }
            if ((unit = materialInfo.getAssistUnit()) == null || mapConvertRate.containsKey(materialIdStr + unit.getId().toString())) continue;
            unitIdStr = unit.getId().toString();
            materialIdSet.add(materialIdStr);
            unitIdSet.add(unitIdStr);
            mapConvertRate.put(materialIdStr + unitIdStr, null);
        }
        if (materialIdSet.isEmpty() && unitIdSet.isEmpty()) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" select material.id,measureUnit.id,baseConvsRate where ");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdSet, CompareType.INCLUDE));
        oql.append(filter.toSql());
        MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(oql.toString());
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            MultiMeasureUnitInfo multiMeasureUnitInfo = collection.get(i);
            String keyString = multiMeasureUnitInfo.getMaterial().getId().toString() + multiMeasureUnitInfo.getMeasureUnit().getId().toString();
            if (!mapConvertRate.containsKey(keyString)) continue;
            BigDecimal rate = multiMeasureUnitInfo.getBaseConvsRate();
            mapConvertRate.put(keyString, rate);
        }
    }

    public static void setMatUnitPrecisionCache(MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException {
        if (matInfos == null || matInfos.length == 0) {
            return;
        }
        Map materialsUnitPrecision = fetchData.getMapUnitPrecision();
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int index = 0; index < matInfos.length; ++index) {
            MaterialInfo matInfo = matInfos[index];
            if (matInfo != null && matInfo.getId() != null && !materialIdSet.contains(matInfo.getId().toString())) {
                materialIdSet.add(matInfo.getId().toString());
            }
            if (matInfo != null && matInfo.getId() != null && matInfo.getBaseUnit() != null && matInfo.getBaseUnit().getId() != null && !unitIdSet.contains(matInfo.getBaseUnit().getId().toString())) {
                unitIdSet.add(matInfo.getBaseUnit().getId().toString());
            }
            if (matInfo == null || matInfo.getId() == null || matInfo.getAssistUnit() == null || matInfo.getAssistUnit().getId() == null || unitIdSet.contains(matInfo.getAssistUnit().getId().toString())) continue;
            unitIdSet.add(matInfo.getAssistUnit().getId().toString());
        }
        if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
            EntityViewInfo entityViewInfo = SCMUtils.getMultiMeasureUnitEntityViewInfo(materialIdSet, unitIdSet);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    MultiMeasureUnitInfo mmuInfo = collection.get(i);
                    if (materialsUnitPrecision.containsKey(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString())) continue;
                    materialsUnitPrecision.put(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString(), mmuInfo.getQtyPrecision());
                }
            }
        }
    }

    public static void setMaterialPurchaseCache(PurchaseOrgUnitInfo pou, MaterialInfo[] matInfos, SCMFetchData fetchData) throws BOSException {
        if (pou == null || matInfos == null || matInfos.length == 0) {
            return;
        }
        Map mapMaterialPurchase = fetchData.getMapMaterialPurchasing();
        HashSet<String> queryMatIDs = new HashSet<String>();
        for (int i = 0; i < matInfos.length; ++i) {
            MaterialInfo matInfo = matInfos[i];
            if (mapMaterialPurchase.containsKey(matInfo.getId().toString() + pou.getId().toString())) continue;
            queryMatIDs.add(matInfo.getId().toString());
        }
        if (queryMatIDs.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", queryMatIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)pou.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("purchaseCheck"));
        sic.add(new SelectorItemInfo("isPurchaseCheck"));
        sic.add(new SelectorItemInfo("quotaPolicy.id"));
        sic.add(new SelectorItemInfo("quotaPolicy.name"));
        sic.add(new SelectorItemInfo("quotaPolicy.number"));
        sic.add(new SelectorItemInfo("qualityOrg.id"));
        sic.add(new SelectorItemInfo("qualityOrg.number"));
        sic.add(new SelectorItemInfo("qualityOrg.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        MaterialPurchasingCollection coll = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(viewInfo);
        MaterialPurchasingInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            mapMaterialPurchase.put(info.getMaterial().getId() + info.getOrgUnit().getId().toString(), info);
        }
    }
}

