/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventoryInitBill;
import com.kingdee.eas.scm.im.inv.InventoryInitBillFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryInitBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.InventoryInitFilterUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class InventoryInitBillListUI
extends AbstractInventoryInitBillListUI {
    private static final long serialVersionUID = 1L;
    InventoryInitFilterUI filterUI = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.im.inventoryInitBill";
        param.alias = InvClientUtils.getResource("InventoryInitBill");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "baseStatus", "number", "bizDate", "isPBCalculate", "storageOrgUnit.name", "creator", "createdate", "modifier", "modifydate", "auditor", "auditdate"};
        return strMergeColKeys;
    }

    public String getEntriesPKName() {
        return "entry.id";
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.separator3.setVisible(false);
        super.onLoad();
        InvClientUtils.setFreezeCol(this.tblMain, "material.name");
        this.tblMain.getColumn("createdate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createdate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifydate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifydate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditdate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditdate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.menuItemExportData.setVisible(true);
        this.btnMultiPrint.setVisible(false);
        this.btnMultiPrintPreview.setVisible(false);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.InventoryInitBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InventoryInitBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditBill() throws Exception {
        Uuid mutexUuid = null;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
            IInventoryInitBill iInventoryInitBill = InventoryInitBillFactory.getRemoteInstance();
            String mutextStorageID = iInventoryInitBill.getInventoryInitBillInfo((IObjectPK)pk).getStorageOrgUnit().getId().toString();
            mutexUuid = Uuid.create();
            String actionName = "FinishInitAction";
            MutexParameter tempMutext = SCMClientUtils.setMutexParameter((Uuid)mutexUuid, (String)mutextStorageID, (String)actionName, (MutexLockType)MutexLockType.EXCLUSIVE_LOCK);
            SCMUtils.requestMutex((MutexParameter)tempMutext);
            iInventoryInitBill.audit((IObjectPK)pk);
            this.tblMain.repaint();
        }
        catch (Throwable throwable) {
            SCMUtils.releaseMutex(mutexUuid);
            throw throwable;
        }
        SCMUtils.releaseMutex((Uuid)mutexUuid);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionAudit_actionPerformed(e);
        }
        catch (BOSException e2) {
            String errorTitle = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.MaterialSNResource", (String)"AUDIT_ERROR_TITLE");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorTitle, (String)e2.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        String temp = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.IsUnAduit");
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)temp))) {
            return;
        }
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        if (!this.getBizInterface().exists((IObjectPK)pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("baseStatus"));
        CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)o;
        if (aSCMBillBaseInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.CantUnAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        this.unAuditBill(pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unAuditBill(ObjectUuidPK pk) throws Exception {
        Uuid mutexUuid = null;
        try {
            IInventoryInitBill iInventoryInitBill = InventoryInitBillFactory.getRemoteInstance();
            String mutextStorageID = iInventoryInitBill.getInventoryInitBillInfo((IObjectPK)pk).getStorageOrgUnit().getId().toString();
            mutexUuid = Uuid.create();
            String actionName = "FinishInitAction";
            MutexParameter tempMutext = SCMClientUtils.setMutexParameter((Uuid)mutexUuid, (String)mutextStorageID, (String)actionName, (MutexLockType)MutexLockType.EXCLUSIVE_LOCK);
            SCMUtils.requestMutex((MutexParameter)tempMutext);
            iInventoryInitBill.unpassAudit((IObjectPK)pk, null);
            this.execQuery();
        }
        catch (Throwable throwable) {
            SCMUtils.releaseMutex(mutexUuid);
            throw throwable;
        }
        SCMUtils.releaseMutex((Uuid)mutexUuid);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"entry.qty", "entry.yearReceiptQty", "entry.yearIssueQty", "entry.assitQty", "entry.yearReceiptAssitQty", "entry.yearIssueAssitQty", "entry.baseQty", "entry.yearReceiptBaseQty", "entry.yearIssueBaseQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"entry.costPrice"};
    }

    public String[] getAmountColumns() {
        return new String[]{"entry.amount", "entry.diffAmount", "entry.yearReceiptAmount", "entry.yearReceiptCostDiff", "entry.yearIssueAmount", "entry.yearIssueCostDiff"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        try {
            String[] priceCols = new String[]{"entry.costPrice"};
            String[] currencyCols = new String[]{"entry.amount", "entry.diffAmount", "entry.yearReceiptAmount", "entry.yearReceiptCostDiff", "entry.yearIssueAmount", "entry.yearIssueCostDiff"};
            String[] qtyCols = new String[]{"ENTRY.QTY", "ENTRY.YEARRECEIPTQTY", "ENTRY.YEARISSUEQTY"};
            String[] BaseQtyCols = new String[]{"ENTRY.BASEQTY", "ENTRY.YEARRECEIPTBASEQTY", "ENTRY.YEARISSUEBASEQTY"};
            String[] AssistQtyCols = new String[]{"ENTRY.ASSISTQTY", "ENTRY.YEARRECEIPTASSISTQTY", "ENTRY.YEARISSUEASSISTQTY"};
            rowSet.beforeFirst();
            while (rowSet.next()) {
                int currencyPrec = rowSet.getInt("CURRENCY.PRECISION");
                int pricePrec = rowSet.getInt("material.pricePrecision");
                SCMClientUtils.iniColumnsPrecision((int)pricePrec, (String[])priceCols, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)currencyPrec, (String[])currencyCols, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])qtyCols, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BaseQtyCols, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])AssistQtyCols, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        return sic;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InventoryInitFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, InventoryInitBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, InventoryInitEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.im.inventoryInitBill";
        param.alias = InvClientUtils.getResource("InventoryInitBill");
        param.varList = new ArrayList();
        param.datataskMode = 1;
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.scm.im.inv.InventoryInitExportQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrint_actionPerformed(e);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(e);
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.InventoryInitPrintQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/SCM/IM/InventoryInit/InventoryInitBill";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isLazyMode() {
        return true;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    protected void setDefaultQuickFilterInfo() {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add(this.getPropertyOfBizOrg(this.getMainBizOrgType()), CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG);
        }
    }
}

