/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryInitFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class InventoryInitFilterUI
extends AbstractInventoryInitFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(InventoryInitFilterUI.class);
    private CompanyOrgUnitInfo cou = null;

    public InventoryInitFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.bizPromptBillNumFrom, (Component)this.bizPromptBillNumTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.bizPromptMaterialNumFrom, (Component)this.bizPromptMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("warehouse.number", (Component)this.bizPromptWarehouseFrom, (Component)this.bizPromptWarehouseTo));
        elements.add((FilterElement)new RangeFilterElement("customer.number", (Component)this.bizPromptCustomerFrom, (Component)this.bizPromptCustomerTo));
        elements.add((FilterElement)new RangeFilterElement("supplier.number", (Component)this.bizPromptSupplierFrom, (Component)this.bizPromptSupplierTo));
        elements.add((FilterElement)new RangeFilterElement("storeType.number", (Component)this.bizPromptStoreTypeFrom, (Component)this.bizPromptStoreTypeTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("storageOrgUnit.id", (Component)this.bizPromptStOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboxBillStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizPromptMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.bizPromptMaterialNumTo, false, null);
        this.setBizCustomerF7(this.bizPromptCustomerFrom, null);
        this.setBizCustomerF7(this.bizPromptCustomerTo, null);
        this.setBizSupplierF7(this.bizPromptSupplierFrom, null);
        this.setBizSupplierF7(this.bizPromptSupplierTo, null);
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseTo, this.getPropertyOfMainBizOrg());
        this.bizPromptBillNumFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.bizPromptBillNumTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.f7Manager.registerContextChangeF7(this.bizPromptBillNumFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizPromptBillNumTo, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPromptMaterialNumFrom, this.bizPromptMaterialNumTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.bizPromptBillNumFrom, this.bizPromptBillNumTo});
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboxBillStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.DELETED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStOrgUnitFrom;
    }

    protected String getViewPermission() {
        return "inventoryinit_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void afterMainOrgChanged(String ids) {
        if (this.bizPromptStOrgUnitFrom.getValue() != null) {
            if (this.bizPromptStOrgUnitFrom.getValue() instanceof FullOrgUnitInfo) {
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                FullOrgUnitInfo fou = (FullOrgUnitInfo)this.bizPromptStOrgUnitFrom.getValue();
                sou.setId(fou.getId());
                this.cou = InvClientUtils.getCompanyInfo(sou);
            } else if (this.bizPromptStOrgUnitFrom.getValue() instanceof Object[]) {
                Object[] sous = (Object[])this.bizPromptStOrgUnitFrom.getValue();
                if (sous[0] instanceof FullOrgUnitInfo) {
                    StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                    FullOrgUnitInfo fou = (FullOrgUnitInfo)sous[0];
                    sou.setId(fou.getId());
                    this.cou = InvClientUtils.getCompanyInfo(sou);
                } else {
                    this.cou = InvClientUtils.getCompanyInfo((StorageOrgUnitInfo)sous[0]);
                }
            } else {
                this.cou = InvClientUtils.getCompanyInfo((StorageOrgUnitInfo)this.bizPromptStOrgUnitFrom.getValue());
            }
            if (this.cou != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.cou.getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
                this.bizPromptCustomerFrom.setEntityViewInfo(evi);
                this.bizPromptCustomerTo.setEntityViewInfo(evi);
                this.bizPromptSupplierFrom.setEntityViewInfo(evi);
                this.bizPromptSupplierTo.setEntityViewInfo(evi);
            }
        }
    }
}

