/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryRefreshUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InventoryRefreshUI
extends AbstractInventoryRefreshUI
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final String INVREFRESH_RESOURCE = "com.kingdee.eas.scm.im.inv.client.InventoryRefreshResource";
    private boolean isProcessing = false;

    public InventoryRefreshUI() throws Exception {
        this.setStorageF7(this.prmtStorage);
        this.setMaterialF7(this.prmtMaterial);
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtMaterial.setEnabledMultiSelection(true);
        this.prmtStorage.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                InventoryRefreshUI.this.storageDataChanged(eventObj);
            }
        });
        this.progressBar.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void storageDataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.prmtWarehouse.setValue(null);
            this.prmtWarehouse.setEnabled(false);
            this.prmtMaterial.setValue(null);
            this.prmtMaterial.setEnabled(false);
            return;
        }
        if (eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)eventObj.getNewValue();
        this.prmtWarehouse.setEnabled(true);
        this.prmtWarehouse.setValue(null);
        try {
            this.prmtWarehouse.setEntityViewInfo(SCMBaseCommonUtil.getWarehouseFilter((String)sou.getId().toString(), (int)1));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.prmtMaterial.setEnabled(true);
        this.prmtMaterial.setValue(null);
        this.prmtMaterial.setCurrentMainBizOrgUnit((OrgUnitInfo)sou, OrgType.Storage);
    }

    private void setStorageF7(KDBizPromptBox box) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        if (this.getPermissionItem() != null) {
            iProducer.getModel().setPermissionItem(this.getPermissionItem());
        }
        iProducer.getModel().setIsCUFilter(false);
        box.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    private void setMaterialF7(KDBizPromptBox kDBizPromptBoxMaterial) {
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), (Object)this, "C79FC042", QueryInfoConstants.getMaterialQueryInfo((OrgType)OrgType.Storage), "materialGroup.id", QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Storage), false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        selectorLisenterMaterial.setIsMultiSelect(true);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector(selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
    }

    protected String getPermissionItem() {
        return "refreshInventory";
    }

    private Map buildRefreshParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorage.getValue();
        params.put("StorageID", sou.getId().toString());
        WarehouseInfo warehsInfo = null;
        Object[] warehouse = (Object[])this.prmtWarehouse.getValue();
        if (warehouse != null && warehouse.length > 0) {
            HashSet<String> warehsSet = new HashSet<String>();
            for (int i = 0; i < warehouse.length; ++i) {
                warehsInfo = (WarehouseInfo)warehouse[i];
                warehsSet.add(warehsInfo.getId().toString());
            }
            params.put("WarehouseIDs", warehsSet);
        }
        MaterialInfo materialInfo = null;
        Object[] material = (Object[])this.prmtMaterial.getValue();
        if (material != null && material.length > 0) {
            HashSet<String> materialSet = new HashSet<String>();
            for (int i = 0; i < material.length; ++i) {
                materialInfo = (MaterialInfo)material[i];
                materialSet.add(materialInfo.getId().toString());
            }
            params.put("MaterialIDs", materialSet);
        }
        return params;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorage.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)INVREFRESH_RESOURCE, (String)"STORAGE_NOTNULL"));
            this.prmtStorage.requestFocus();
            SysUtil.abort();
        }
        Thread t = new Thread(this);
        t.setName("Thread for StartSCMGuideUI");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            ComponentUtil.setWindowsCursorOfWair((Window)window);
            this.btnOK.setEnabled(false);
            this.btnCancel.setEnabled(false);
            String complete = "";
            try {
                LowTimer timer = new LowTimer();
                Map params = this.buildRefreshParams();
                int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)INVREFRESH_RESOURCE, (String)"IS_CONTINUE"));
                if (confirm != 0) break block8;
                this.progressBar.setVisible(true);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString(EASResource.getString((String)INVREFRESH_RESOURCE, (String)"CALCULATING"));
                this.progressBar.setIndeterminate(true);
                timer.reset();
                SCMBillCommonFacadeFactory.getRemoteInstance().setRefreshing(params, true);
                try {
                    InventoryUpdateFactory.getRemoteInstance().refreshInventory(params);
                }
                finally {
                    SCMBillCommonFacadeFactory.getRemoteInstance().setRefreshing(params, false);
                }
                complete = EASResource.getString((String)INVREFRESH_RESOURCE, (String)"CALCULATE_COMPLETE") + timer.msValue() + "ms\uff01";
            }
            catch (Exception e) {
                this.isProcessing = false;
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setVisible(false);
                this.handUIException(e);
                complete = EASResource.getString((String)INVREFRESH_RESOURCE, (String)"HAS_EXCEPTION");
            }
            finally {
                ComponentUtil.setWindowCursorOfDefault((Window)window);
                this.btnOK.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setString(complete);
                this.isProcessing = false;
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public boolean destroyWindow() {
        if (this.isProcessing) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)INVREFRESH_RESOURCE, (String)"PLEASE_WAIT"));
            return false;
        }
        return super.destroyWindow();
    }
}

