/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractMatDisassembleBillFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MatDisassembleBillFilterUI
extends AbstractMatDisassembleBillFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(MatDisassembleBillFilterUI.class);
    private DataChangeListener AdminOrgUnitListener = null;

    public MatDisassembleBillFilterUI() throws Exception {
        this.getElementsInfo();
        this.bizPromptStOrgUnitFrom.setValue((Object)this.getDefaultMainBizOrg());
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.bizPrmtBizTypeFrom, (Component)this.bizPrmtBizTypeTo));
        elements.add((FilterElement)new RangeFilterElement("adminOrgUnit.number", (Component)this.prmtAdminOrgFrom, (Component)this.prmtAdminOrgTo));
        elements.add((FilterElement)new RangeFilterElement("entries.material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        CompositeFilterElement DateElements = new CompositeFilterElement(0);
        DateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo));
        DateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)DateElements);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.bizPromptStOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.combxBillStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new RangeFilterElement("entries.warehouse.number", (Component)this.prmtWarehouseFrom, (Component)this.prmtWarehouseTo));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        EntityViewInfo viewInfo = InvClientUtils.getBizStorageFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewInfo);
        this.prmtNumberTo.setEntityViewInfo(viewInfo);
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtWarehouseFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtWarehouseTo, this.getPropertyOfMainBizOrg());
        this.filterMaterialChange();
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        this.setShowAllSealOrg(new KDBizPromptBox[]{this.prmtAdminOrgFrom, this.prmtAdminOrgTo}, new OrgType[]{OrgType.Admin, OrgType.Admin});
    }

    public void filterMaterialChange() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"132", CompareType.EQUALS));
        ev.setFilter(filter);
        this.bizPrmtBizTypeFrom.setEntityViewInfo(ev);
        this.bizPrmtBizTypeTo.setEntityViewInfo(ev);
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.combxBillStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED};
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStOrgUnitFrom;
    }

    protected String getViewPermission() {
        return "MatDisassemble_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void afterMainOrgChanged(String ids) {
        String[] str = null;
        if (null != ids) {
            str = ids.length() > 1 ? ids.split(",") : new String[]{ids};
            StorageOrgUnitInfo info = new StorageOrgUnitInfo();
            HashSet<String> adminorgids = new HashSet<String>();
            for (int i = 0; i < str.length; ++i) {
                info.setId(BOSUuid.read((String)str[i]));
                CompanyOrgUnitInfo companyInfo = null;
                try {
                    companyInfo = OrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)info, (boolean)false);
                    if (companyInfo == null) {
                        continue;
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                OrgUnitCollection coll = null;
                try {
                    coll = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(companyInfo.getId().toString(), 1, 0);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                for (int j = 0; j < coll.size(); ++j) {
                    adminorgids.add(coll.get(j).getId().toString());
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", adminorgids, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtAdminOrgFrom.setEntityViewInfo(view);
            this.prmtAdminOrgTo.setEntityViewInfo(view);
        } else {
            this.prmtAdminOrgFrom.setEntityViewInfo(new EntityViewInfo());
            this.prmtAdminOrgTo.setEntityViewInfo(new EntityViewInfo());
        }
    }
}

