/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.im.inv.MaterNumberEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSNSaleSplitUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.TxtFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MaterialSNSaleSplitUI
extends AbstractMaterialSNSaleSplitUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialSNSaleSplitUI.class);
    private KDFileChooser fileChooser;
    private Hashtable ht = new Hashtable(0);
    private boolean iscancel = false;
    private String sBillSign = "";
    private String SBillVSNSign = "";
    private String sSNSign = "";
    private int materialNumEnum = 0;
    private int iMaterLength = 0;
    private int iLotLength = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        this.setIscancel(true);
    }

    @Override
    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        this.fileChooser = this.getFileChooser();
        if (this.fileChooser.showOpenDialog((Component)((Object)this)) != 1) {
            File aFile = this.fileChooser.getSelectedFile();
            if (aFile == null) {
                String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nofile");
                MsgBox.showInfo((String)error);
                return;
            }
            if (!aFile.isFile()) {
                String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"notfile");
                MsgBox.showInfo((String)error);
                return;
            }
            if (aFile.isDirectory()) {
                String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"isdirectory");
                MsgBox.showInfo((String)error);
                return;
            }
            if (!aFile.canRead()) {
                String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"notread");
                MsgBox.showInfo((String)error);
                return;
            }
            this.txtFile.setText(aFile.getAbsolutePath());
        }
    }

    @Override
    public void actionConfim_actionPerformed(ActionEvent e) throws Exception {
        int billSize;
        String lastChar;
        File aFile = this.getFile();
        if (aFile == null) {
            String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"noSelectFile");
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
        this.checkOtherImput();
        this.sBillSign = this.billSign.getText().trim();
        this.SBillVSNSign = this.billVSNSign.getText().trim();
        this.sSNSign = this.SNSign.getText().trim();
        this.materialNumEnum = ((MaterNumberEnum)((Object)this.cobMaterilNum.getSelectedItem())).getValue();
        this.iMaterLength = this.kDFormattedTxtMaterLength.getBigDecimalValue().intValue();
        this.iLotLength = this.kDFormattedTxtLotLength.getIntegerValue();
        String strLine = this.getDataFromFile(aFile);
        if (strLine != null && strLine.trim().length() > 0 && (lastChar = strLine.substring(strLine.length() - 1)).equals(this.sBillSign)) {
            strLine = strLine.substring(0, strLine.length() - 1);
        }
        Vector<String> vecBill = new Vector<String>(0);
        int point = strLine.indexOf(this.sBillSign);
        while (point != -1) {
            String strOneBill = strLine.substring(0, point);
            strLine = strLine.substring(point + this.sBillSign.length());
            if (strOneBill != null && strOneBill.length() > 0) {
                vecBill.add(strOneBill);
            }
            point = strLine.indexOf(this.sBillSign);
        }
        if (strLine != null && strLine.trim().length() > 0) {
            vecBill.add(strLine);
        }
        if ((billSize = vecBill.size()) == 0) {
            String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nodata");
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
        Hashtable hmBill = new Hashtable(0);
        String errorMate = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"errormeta");
        String errorlot = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"errorlot");
        String errorlast = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"errorlast");
        String errorbill = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"errorbill");
        String errorbox = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"errorbox");
        Vector<String> vecAllSN = new Vector<String>(0);
        Vector<String> vecHasSN = new Vector<String>(0);
        int snPoint = -1;
        for (int i = 0; i < billSize; ++i) {
            Vector<String> vsn;
            String key;
            String strOneBill = (String)vecBill.get(i);
            point = strOneBill.indexOf(this.SBillVSNSign);
            if (point == -1) {
                MsgBox.showInfo((String)errorbill);
                SysUtil.abort();
            }
            String billNum = strOneBill.substring(0, point);
            String strSN = strOneBill.substring(point + this.SBillVSNSign.length());
            Hashtable hmEnty = new Hashtable(0);
            if (hmBill.containsKey(billNum)) {
                hmEnty = (Hashtable)hmBill.get(billNum);
            } else {
                hmEnty = new Hashtable(0);
                hmBill.put(billNum, hmEnty);
            }
            snPoint = strSN.indexOf(this.sSNSign);
            String oneSN = "";
            while (snPoint != -1) {
                oneSN = strSN.substring(0, snPoint);
                strSN = strSN.substring(snPoint + this.sSNSign.length());
                snPoint = strSN.indexOf(this.sSNSign);
                if (this.iMaterLength + this.iLotLength >= oneSN.length()) {
                    MsgBox.showInfo((String)(errorMate + "[" + (this.iMaterLength + this.iLotLength) + "]" + errorlot + "[" + oneSN + "]" + errorlast));
                    SysUtil.abort();
                }
                key = oneSN.substring(0, this.iMaterLength + this.iLotLength);
                oneSN = oneSN.substring(this.iMaterLength + this.iLotLength);
                vsn = new Vector(0);
                if (hmEnty.containsKey(key)) {
                    vsn = (Vector<String>)hmEnty.get(key);
                } else {
                    vsn = new Vector<String>(0);
                    hmEnty.put(key, vsn);
                }
                vsn.add(oneSN);
                if (!vecAllSN.contains(oneSN)) {
                    vecAllSN.add(oneSN);
                    continue;
                }
                if (vecHasSN.contains(oneSN)) continue;
                vecHasSN.add(oneSN);
            }
            if (strSN == null || strSN.trim().length() <= 0) continue;
            oneSN = strSN;
            if (this.iMaterLength + this.iLotLength >= oneSN.length()) {
                MsgBox.showInfo((String)(errorMate + "[" + this.iMaterLength + this.iLotLength + "]" + errorlot + "[" + oneSN + "]" + errorlast));
                SysUtil.abort();
            }
            key = oneSN.substring(0, this.iMaterLength + this.iLotLength);
            oneSN = oneSN.substring(this.iMaterLength + this.iLotLength);
            vsn = new Vector<String>(0);
            if (hmEnty.containsKey(key)) {
                vsn = (Vector<String>)hmEnty.get(key);
            } else {
                vsn = new Vector<String>(0);
                hmEnty.put(key, vsn);
            }
            vsn.add(oneSN);
            if (!vecAllSN.contains(oneSN)) {
                vecAllSN.add(oneSN);
                continue;
            }
            if (vecHasSN.contains(oneSN)) continue;
            vecHasSN.add(oneSN);
        }
        if (vecHasSN.size() > 0) {
            StringBuffer sbHasSn = new StringBuffer();
            String hasSN = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"hasSN");
            sbHasSn.append(":[");
            sbHasSn.append(vecHasSN.get(0));
            sbHasSn.append("]");
            for (int i = 1; i < vecHasSN.size(); ++i) {
                sbHasSn.append(",[");
                sbHasSn.append(vecHasSN.get(i));
                sbHasSn.append("]");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)hasSN, (String)sbHasSn.toString(), (int)0);
        }
        this.ht = hmBill;
        this.actionExitCurrent_actionPerformed(null);
        this.setIscancel(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
    }

    public void checkSNQty(BigDecimal snQty) throws Exception {
        if (snQty == null) {
            snQty = InvClientUtils.ZERO;
        }
        BigDecimal temp = snQty.setScale(0, 2);
        if ((temp = snQty.subtract(temp)).compareTo(InvClientUtils.ZERO) != 0) {
            String SNIsNotInt = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"SNIsNotInt");
            MsgBox.showInfo((Component)((Object)this), (String)(SNIsNotInt + "[" + snQty + "]"));
            SysUtil.abort();
            this.disposeUIWindow();
        }
    }

    public void initControl() throws Exception {
        this.btnConfim.setEnabled(true);
        this.btnSelectFile.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kDFormattedTxtMaterLength.setNegatived(false);
        this.kDFormattedTxtMaterLength.setDataType(0);
        this.kDFormattedTxtMaterLength.setHorizontalAlignment(4);
        this.kDFormattedTxtLotLength.setNegatived(false);
        this.kDFormattedTxtLotLength.setDataType(0);
        this.kDFormattedTxtLotLength.setHorizontalAlignment(4);
        this.kDFormattedTxtMaterLength.setValue((Object)new Integer(4));
        this.kDFormattedTxtLotLength.setValue((Object)new Integer(6));
        this.billSign.setText(";");
        this.billVSNSign.setText(":");
        this.SNSign.setText(",");
        this.cobMaterilNum.setSelectedItem((Object)MaterNumberEnum.code);
    }

    public KDFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            String title = LanguageManager.getLangMessage((String)"FileChooserTitle", KDTMenuManager.class, (String)"Files select...");
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setFileFilter((FileFilter)new TxtFileFilter());
        }
        return this.fileChooser;
    }

    protected File getFile() throws Exception {
        String strFile = this.txtFile.getText();
        if (strFile == null || strFile.length() == 0) {
            return null;
        }
        File aFile = new File(strFile);
        if (!aFile.isFile()) {
            return null;
        }
        if (aFile.isDirectory()) {
            return null;
        }
        if (!aFile.canRead()) {
            return null;
        }
        return aFile;
    }

    protected void checkOtherImput() throws Exception {
        int iLotLength;
        int iMaterLength;
        String err1 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nofe");
        String err2 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nolot");
        String err3 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"nofelot");
        String err4 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"islong");
        String err5 = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"lotislong");
        if (this.billSign.getText() == null || this.billSign.getText().trim().length() == 0) {
            MsgBox.showInfo((String)err1);
            SysUtil.abort();
        }
        if (this.billVSNSign.getText() == null || this.billVSNSign.getText().trim().length() == 0) {
            MsgBox.showInfo((String)err2);
            SysUtil.abort();
        }
        if (this.SNSign.getText() == null || this.SNSign.getText().trim().length() == 0) {
            MsgBox.showInfo((String)err3);
            SysUtil.abort();
        }
        if ((iMaterLength = this.kDFormattedTxtMaterLength.getBigDecimalValue().intValue()) > 20) {
            MsgBox.showError((Component)((Object)this), (String)err4);
            SysUtil.abort();
        }
        if ((iLotLength = this.kDFormattedTxtLotLength.getIntegerValue().intValue()) > 20) {
            MsgBox.showError((Component)((Object)this), (String)err5);
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataFromFile(File aFile) throws FileNotFoundException, IOException {
        try (BufferedReader br = null;){
            FileInputStream fis = new FileInputStream(aFile);
            br = new BufferedReader(new InputStreamReader(fis));
            String filenodata = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"filenodata");
            StringBuffer sb = new StringBuffer();
            String strLine = br.readLine();
            if (strLine == null) {
                MsgBox.showInfo((String)filenodata);
                SysUtil.abort();
            }
            while (strLine != null) {
                if (strLine.equals("\n") || strLine.equals("\r") || strLine.trim().length() == 0) {
                    strLine = br.readLine();
                    if (strLine == null) continue;
                    sb.append(strLine);
                    continue;
                }
                sb.append(strLine);
                strLine = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public Hashtable getHt() {
        return this.ht;
    }

    public int getILotLength() {
        return this.iLotLength;
    }

    public int getIMaterLength() {
        return this.iMaterLength;
    }

    public int getMaterialNumEnum() {
        return this.materialNumEnum;
    }

    public String getSBillSign() {
        return this.sBillSign;
    }

    public String getSBillVSNSign() {
        return this.SBillVSNSign;
    }

    public String getSSNSign() {
        return this.sSNSign;
    }

    public boolean isIscancel() {
        return this.iscancel;
    }

    public void setIscancel(boolean iscancel) {
        this.iscancel = iscancel;
    }
}

