/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSerialNumberUI;
import com.kingdee.eas.scm.im.inv.client.BatchCreateSNUI;
import com.kingdee.eas.scm.im.inv.client.ExcelFileFilter;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class MaterialSerialNumberUI
extends AbstractMaterialSerialNumberUI {
    private static final long serialVersionUID = 1L;
    protected IUIWindow batchCreatSNWindow = null;
    protected MaterialSerialNumberInfo snInfo = null;
    private boolean isView = false;
    private BigDecimal billEntryQty = InvClientUtils.ZERO;
    private KDFileChooser fileChooser;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.snInfo.setSnQty(this.getSnQty(this.snInfo));
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
        IObjectPK pk = iMaterialSerialNumber.saveSerialNumber(this.snInfo);
        if (this.snInfo.getEntry() != null && this.snInfo.getEntry().size() == 0 && this.snInfo.getId() != null) {
            iMaterialSerialNumber.delete((IObjectPK)new ObjectUuidPK(this.snInfo.getId()));
        }
        this.snInfo.setId(BOSUuid.read((String)pk.toString()));
        this.setDataObject((IObjectValue)this.snInfo);
        this.showSaveSuccess();
    }

    protected void verifyInput() throws Exception {
        int rowCount = this.kdtEntry.getRowCount();
        if (rowCount > 0) {
            IRow iRow = null;
            Vector<String> v = new Vector<String>(0);
            StringBuffer msg = new StringBuffer();
            String strNo = InvClientUtils.getResource("No");
            String strRow = InvClientUtils.getResource("Row");
            String serialNumber = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"SERIALNUMBER");
            String repeat = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"REPEAT");
            for (int i = 0; i < rowCount; ++i) {
                iRow = this.kdtEntry.getRow(i);
                MaterialSerialNumberEntryInfo entryInfo = (MaterialSerialNumberEntryInfo)iRow.getUserObject();
                if (iRow.getCell("serialNumber").getValue() != null) {
                    String o = iRow.getCell("serialNumber").getValue().toString().trim();
                    if (entryInfo == null || o == null || o.toString().length() == 0) {
                        if (i >= this.snInfo.getEntry().size()) continue;
                        this.snInfo.getEntry().removeObject(i);
                        this.snInfo.setSnQty(this.snInfo.getSnQty().subtract(new BigDecimal(1)));
                        --i;
                        continue;
                    }
                    entryInfo.setSeq(i);
                    if (iRow.getCell("remark").getValue() != null) {
                        entryInfo.setRemark(iRow.getCell("remark").getValue().toString());
                    } else {
                        entryInfo.setRemark(null);
                    }
                    if (v.contains(o)) {
                        msg.append(strNo);
                        msg.append(i + 1);
                        msg.append(strRow);
                        msg.append(serialNumber);
                        msg.append(" [ ");
                        msg.append(o.toString());
                        msg.append(" ] ");
                        msg.append(repeat);
                        msg.append("\n");
                    } else {
                        v.add(o);
                    }
                    entryInfo.setSerialNumber(o.toString().trim());
                    continue;
                }
                this.snInfo.getEntry().remove(entryInfo);
            }
            if (msg.length() > 0) {
                String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"ERROR");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)msg.toString(), (int)8188);
                SysUtil.abort();
            }
        }
    }

    private BigDecimal getSnQty(MaterialSerialNumberInfo snInfo) {
        MaterialSerialNumberEntryCollection entryColl = snInfo.getEntry();
        int size = entryColl.size();
        int qtySize = 0;
        MaterialSerialNumberEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null || entryInfo.getSerialNumber() == null || entryInfo.getSerialNumber().length() <= 0) continue;
            ++qtySize;
        }
        return new BigDecimal(qtySize);
    }

    @Override
    public void actionBatchCreat_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"MAXNumber", (Object)Integer.valueOf("10"));
        if (this.batchCreatSNWindow == null) {
            this.batchCreatSNWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.BatchCreateSNUI", (Map)uiContext, null, OprtState.EDIT);
        }
        BatchCreateSNUI aBatchCreateSNUI = (BatchCreateSNUI)this.batchCreatSNWindow.getUIObject();
        int qty = this.txtSNQuantity.getIntegerValue();
        aBatchCreateSNUI.init(qty);
        this.batchCreatSNWindow.show();
        if (!aBatchCreateSNUI.isCancel()) {
            Vector v = aBatchCreateSNUI.getVecRestor();
            int vSize = v.size();
            KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
            int startRow = 0;
            if (selectBlock != null) {
                startRow = selectBlock.getTop();
            }
            IRow iRow = null;
            ICell iCell = null;
            int i = startRow;
            for (int j = 0; i < qty && j < vSize; ++i, ++j) {
                iRow = this.kdtEntry.getRow(i);
                iCell = iRow.getCell("seq");
                iCell.setValue((Object)Integer.toString(i));
                iCell = iRow.getCell("serialNumber");
                iCell.setValue(v.get(j));
            }
        }
        this.batchCreatSNWindow.close();
    }

    @Override
    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.kdtEntry.getRowCount();
        if (rowCount > 0) {
            IRow iRow = null;
            for (int i = 0; i < rowCount; ++i) {
                iRow = this.kdtEntry.getRow(i);
                iRow.getCell("id").setValue(null);
                iRow.getCell("seq").setValue(null);
                iRow.getCell("serialNumber").setValue(null);
                iRow.getCell("remark").setValue(null);
            }
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = null;
        int size = this.kdtEntry.getSelectManager().size();
        IRow iRow = null;
        for (int i = 0; i < size; ++i) {
            selectBlock = this.kdtEntry.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                iRow = this.kdtEntry.getRow(j);
                iRow.getCell("id").setValue(null);
                iRow.getCell("seq").setValue(null);
                iRow.getCell("serialNumber").setValue(null);
                iRow.getCell("remark").setValue(null);
            }
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        this.importFromExcel();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        this.exportToExcel();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntry.checkParsed();
        this.initMenuAndTool();
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{"remark"}, (int)200);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{"serialNumber"}, (int)80);
    }

    private void initMenuAndTool() {
        this.btnAddLine.setVisible(false);
        this.menuItemAddLine.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.menuItemInsterLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.separator1.setVisible(false);
        this.separator4.setVisible(false);
        this.txtMateialNumber.setText(null);
        this.txtMateialName.setText(null);
        this.txtMateialNumber.setEnabled(false);
        this.txtMateialName.setEnabled(false);
        this.prmtSnUnit.setEnabled(false);
        this.txtSNQuantity.setEnabled(false);
        this.btnImport.setVisible(false);
        this.btnExport.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnBatchCreat);
        this.btnBatchCreat.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.menuItemBatchCreat.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.setButtonDefaultStyl(this.btnDelLine);
        this.btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuItemDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.setButtonDefaultStyl(this.btnDelAll);
        this.btnDelAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemDelAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.setButtonDefaultStyl(this.btnImport);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.setButtonDefaultStyl(this.btnExport);
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPerview);
        this.btnPrintPerview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public void init(HashMap hm) throws Exception {
        BigDecimal baseQty;
        this.kdtEntry.removeRows();
        this.snInfo = null;
        if (hm.get("isView") != null) {
            this.isView = Boolean.valueOf(hm.get("isView").toString());
        }
        this.btnSave.setEnabled(!this.isView);
        this.menuItemSave.setEnabled(!this.isView);
        this.actionSave.setEnabled(!this.isView);
        this.btnBatchCreat.setEnabled(!this.isView);
        this.menuItemBatchCreat.setEnabled(!this.isView);
        this.btnImport.setEnabled(!this.isView);
        this.menuItemImport.setEnabled(!this.isView);
        this.btnDelLine.setEnabled(!this.isView);
        this.menuItemDelLine.setEnabled(!this.isView);
        this.btnDelAll.setEnabled(!this.isView);
        this.menuItemDelAll.setEnabled(!this.isView);
        this.kdtEntry.getStyleAttributes().setLocked(this.isView);
        MaterialInfo material = (MaterialInfo)hm.get("MATERIAL");
        MeasureUnitInfo abaseUnitInfo = (MeasureUnitInfo)hm.get("BASEUNIT");
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("seqUnit.number"));
        sic.add(new SelectorItemInfo("seqUnit.name"));
        material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), sic);
        MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
        if (sNUnitInfo == null) {
            String unitIsNull = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"UNITISNULL");
            MsgBox.showInfo((Component)((Object)this), (String)unitIsNull);
            SysUtil.abort();
            this.disposeUIWindow();
        }
        this.billEntryQty = baseQty = (BigDecimal)hm.get("BASEQTY");
        if (!abaseUnitInfo.equals((Object)sNUnitInfo.getId().toString())) {
            this.billEntryQty = InvClientUtils.getAssUnitQty(sNUnitInfo, material, baseQty);
        }
        this.billEntryQty = this.billEntryQty.abs();
        this.checkSNQty(this.billEntryQty);
        int snSize = this.billEntryQty.intValue();
        SCMBillBaseInfo bill = (SCMBillBaseInfo)hm.get("BILL");
        String billID = bill.getId().toString();
        String billEntryID = (String)hm.get("BILLENTRYID");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)billEntryID));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("snUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("snUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("material.number"));
        ev.getSelector().add(new SelectorItemInfo("material.name"));
        ev.getSelector().add(new SelectorItemInfo("entry.*"));
        ev.getSorter().add(new SorterItemInfo("entry.seq"));
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
        MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
        if (snColl != null && snColl.size() > 0) {
            this.snInfo = snColl.get(0);
            SerialNumberStatusEnum status = (SerialNumberStatusEnum)((Object)hm.get("snStatus"));
            if (status != null) {
                this.snInfo.setSnStatus(status);
            }
            this.txtMateialNumber.setText(this.snInfo.getMaterial().getNumber());
            this.txtMateialName.setText(this.snInfo.getMaterial().getName());
            this.prmtSnUnit.setData((Object)this.snInfo.getSnUnit());
            this.txtSNQuantity.setValue((Object)this.billEntryQty);
            MaterialSerialNumberEntryCollection entryColl = this.snInfo.getEntry();
            MaterialSerialNumberEntryInfo entryInfo = null;
            if (entryColl != null) {
                IRow iRow = null;
                ICell cell = null;
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = entryColl.get(i);
                    if (entryInfo != null) {
                        iRow = this.kdtEntry.addRow();
                        cell = iRow.getCell("id");
                        cell.setValue((Object)entryInfo.getId());
                        cell = iRow.getCell("seq");
                        cell.setValue((Object)Integer.toString(entryInfo.getSeq()));
                        cell = iRow.getCell("serialNumber");
                        cell.setValue((Object)entryInfo.getSerialNumber());
                        cell = iRow.getCell("remark");
                        cell.setValue((Object)entryInfo.getRemark());
                        if (i + 1 > snSize) {
                            iRow.getStyleAttributes().setFontColor(Color.RED);
                        }
                        iRow.setUserObject((Object)entryInfo);
                        continue;
                    }
                    entryInfo = new MaterialSerialNumberEntryInfo();
                    entryInfo.setSeq(i);
                    entryColl.add(entryInfo);
                    iRow = this.kdtEntry.addRow();
                    iRow.setUserObject((Object)entryInfo);
                    this.addLineBindData(entryInfo, iRow, i);
                }
                if (snSize > size) {
                    for (int j = size; j < snSize; ++j) {
                        entryInfo = new MaterialSerialNumberEntryInfo();
                        entryInfo.setSeq(j);
                        iRow = this.kdtEntry.addRow();
                        iRow.setUserObject((Object)entryInfo);
                        entryColl.add(entryInfo);
                        this.addLineBindData(entryInfo, iRow, j);
                    }
                }
            }
        } else {
            String entrySeq;
            String locationID;
            this.snInfo = new MaterialSerialNumberInfo();
            this.snInfo.setBillID(billID);
            this.snInfo.setBillEntryID(billEntryID);
            Boolean isReversed = (Boolean)hm.get("isReversed");
            this.snInfo.setIsReversed(isReversed);
            String sourceBillID = (String)hm.get("SOUREBILLID");
            this.snInfo.setSoureBillID(sourceBillID);
            String sourceBillEntryID = (String)hm.get("SOURCEBILLENTRYID");
            this.snInfo.setSoureBillEntryID(sourceBillEntryID);
            SerialNumberStatusEnum status = (SerialNumberStatusEnum)((Object)hm.get("snStatus"));
            if (status != null) {
                this.snInfo.setSnStatus(status);
            }
            String billTypeid = (String)hm.get("BILLTYPE");
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)billTypeid));
            this.snInfo.setBillType(aBillTypeInfo);
            this.snInfo.setBillNumber(bill.getNumber());
            this.snInfo.setBillBizDate(bill.getBizDate());
            this.snInfo.setTransactionType((TransactionTypeInfo)hm.get("TRANSACTIONTYPE"));
            this.snInfo.setBillBaseStatus(bill.getBaseStatus());
            String warehouseID = (String)hm.get("WAREHOUSE");
            if (warehouseID != null) {
                this.snInfo.setWarehouse(WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseID)));
            }
            if ((locationID = (String)hm.get("LOCATION")) != null) {
                this.snInfo.setLocation(LocationFactory.getRemoteInstance().getLocationInfo((IObjectPK)new ObjectUuidPK(locationID)));
            }
            if (!StringUtil.isEmpty((String)(entrySeq = (String)hm.get("BILLENTRYSEQ")))) {
                this.snInfo.setBillEntrySeq(Integer.valueOf(entrySeq));
            } else {
                this.snInfo.setBillEntrySeq(0);
            }
            StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
            this.snInfo.setStorageOrgUnit(aStorageOrgUnitInfo);
            this.snInfo.setMaterial(material);
            this.snInfo.setSnUnit(sNUnitInfo);
            this.snInfo.setSnQty(this.billEntryQty);
            this.txtMateialNumber.setText(this.snInfo.getMaterial().getNumber());
            this.txtMateialName.setText(this.snInfo.getMaterial().getName());
            this.prmtSnUnit.setData((Object)this.snInfo.getSnUnit());
            this.txtSNQuantity.setValue((Object)this.snInfo.getSnQty());
            IRow iRow = null;
            MaterialSerialNumberEntryCollection entryColl = this.snInfo.getEntry();
            for (int j = 0; j < this.billEntryQty.intValue(); ++j) {
                MaterialSerialNumberEntryInfo entryInfo = new MaterialSerialNumberEntryInfo();
                entryInfo.setSeq(j);
                entryColl.add(entryInfo);
                iRow = this.kdtEntry.addRow();
                iRow.setUserObject((Object)entryInfo);
                this.addLineBindData(entryInfo, iRow, j);
            }
        }
        hm = null;
    }

    private void checkSNQty(BigDecimal snQty) throws Exception {
        BigDecimal temp = snQty.setScale(0, 2);
        if ((temp = snQty.subtract(temp)).compareTo(InvClientUtils.ZERO) != 0) {
            String SNIsNotInt = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"SNIsNotInt");
            MsgBox.showInfo((Component)((Object)this), (String)(SNIsNotInt + "[" + snQty + "]"));
            SysUtil.abort();
            this.disposeUIWindow();
        }
    }

    private void addLineBindData(MaterialSerialNumberEntryInfo entryInfo, IRow iRow, int row) {
        ICell cell = iRow.getCell("id");
        cell.setValue((Object)entryInfo.getId());
        cell = iRow.getCell("seq");
        cell.setValue((Object)Integer.toString(row));
        cell = iRow.getCell("serialNumber");
        cell.setValue((Object)entryInfo.getSerialNumber());
        cell = iRow.getCell("remark");
        cell.setValue((Object)entryInfo.getRemark());
    }

    protected void importFromExcel() {
        this.fileChooser = this.getFileChooser();
        if (this.fileChooser.showOpenDialog((Component)((Object)this)) != 1) {
            int rowAll;
            Workbook workBook;
            File afile = this.fileChooser.getSelectedFile();
            if (afile == null) {
                return;
            }
            if (!afile.isFile()) {
                return;
            }
            if (afile.isDirectory()) {
                return;
            }
            if (!afile.canRead()) {
                return;
            }
            try {
                workBook = Workbook.getWorkbook((File)afile);
            }
            catch (Exception e) {
                String msg = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"OpenFileFailed");
                MsgBox.showError((Component)((Object)this), (String)msg);
                return;
            }
            Sheet sheet = workBook.getSheet(0);
            if (sheet == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"NotFindSheet");
                MsgBox.showError((Component)((Object)this), (String)(msg + ":sheetName"));
                return;
            }
            int rowCount = sheet.getRows();
            int startCol = -1;
            for (int i = 0; i < rowCount; ++i) {
                Cell[] cells = sheet.getRow(i);
                if (cells == null || cells.length <= 0) continue;
                if (startCol == -1) {
                    for (int m = 0; m < cells.length; ++m) {
                        if (cells[m].getContents() == null || cells[m].getContents().toString().trim().length() <= 0) continue;
                        startCol = m;
                        break;
                    }
                }
                if (startCol > -1) break;
            }
            IRow iRow = null;
            ICell cell = null;
            MaterialSerialNumberEntryCollection entryColl = this.snInfo.getEntry();
            MaterialSerialNumberEntryInfo entryInfo = null;
            this.kdtEntry.removeRows();
            this.snInfo.getEntry().clear();
            if (startCol > -1) {
                int j = 0;
                for (int i = 0; i < rowCount; ++i) {
                    Cell[] cells = sheet.getRow(i);
                    if (cells == null || cells.length <= 0 || cells[startCol].getContents() == null || cells[startCol].getContents().toString().trim().length() <= 0 || EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InventoryResource", (String)"serialNumber").equals(cells[startCol].getContents()) && EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InventoryResource", (String)"mark").equals(cells[startCol + 1].getContents())) continue;
                    iRow = this.kdtEntry.getRow(j);
                    if (iRow != null) {
                        cell = iRow.getCell("serialNumber");
                        cell.setValue((Object)cells[startCol].getContents());
                        try {
                            if (cells[startCol + 1].getContents() != null && cells[startCol].getContents().toString().trim().length() > 0) {
                                cell = iRow.getCell("remark");
                                cell.setValue((Object)cells[startCol + 1].getContents());
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    } else {
                        iRow = this.kdtEntry.addRow();
                        entryInfo = new MaterialSerialNumberEntryInfo();
                        entryInfo.setSeq(j);
                        iRow.setUserObject((Object)entryInfo);
                        entryColl.add(entryInfo);
                        entryInfo.setSerialNumber(cells[startCol].getContents());
                        try {
                            if (cells[startCol + 1].getContents() != null && cells[startCol].getContents().toString().trim().length() > 0) {
                                entryInfo.setRemark(cells[startCol + 1].getContents());
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.addLineBindData(entryInfo, iRow, j);
                    }
                    if (j >= this.billEntryQty.intValue()) {
                        iRow.getStyleAttributes().setFontColor(Color.RED);
                    }
                    ++j;
                }
            }
            if ((rowAll = this.kdtEntry.getRowCount()) < this.billEntryQty.intValue()) {
                for (int i = rowAll; i < this.billEntryQty.intValue(); ++i) {
                    iRow = this.kdtEntry.addRow();
                    entryInfo = new MaterialSerialNumberEntryInfo();
                    entryInfo.setSeq(i);
                    iRow.setUserObject((Object)entryInfo);
                    entryColl.add(entryInfo);
                    entryInfo.setSerialNumber(null);
                    this.addLineBindData(entryInfo, iRow, i);
                }
            }
        }
    }

    private static File createTempFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile()) {
            file = file.getParentFile();
        }
        try {
            file = File.createTempFile("tmp", ".xls", file);
        }
        catch (IOException e) {
            try {
                file = File.createTempFile("tmp", ".xls");
            }
            catch (IOException e1) {
                file = null;
            }
        }
        return file;
    }

    protected void exportToExcel() {
        block12: {
            File tempFile;
            String path = null;
            try {
                tempFile = File.createTempFile("eastemp", ".xls");
                path = tempFile.getCanonicalPath();
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            tempFile = MaterialSerialNumberUI.createTempFile(path);
            if (tempFile != null) {
                String tempFileName = tempFile.getAbsolutePath();
                KDSSheet sheet = null;
                ExportManager man = new ExportManager();
                KDSBook book = null;
                book = new KDSBook("kdtable export");
                sheet = this.getKDSSheet(book);
                try {
                    book.addSheet(null, sheet);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                    return;
                }
                try {
                    man.exportToExcel(book, tempFileName);
                }
                catch (Exception pee) {
                    this.handUIException(pee);
                }
                try {
                    this.openFileInExcel(tempFileName);
                }
                catch (IOException e2) {
                    int result = this.getFileChooser().showSaveDialog((Component)this.kdtEntry);
                    if (result != 0) break block12;
                    File dest = this.getSelectedFile(this.getFileChooser());
                    try {
                        File src = new File(tempFileName);
                        if (dest.exists()) {
                            dest.delete();
                        }
                        src.renameTo(dest);
                    }
                    catch (Exception e3) {
                        this.handUIException(e3);
                    }
                }
            }
        }
    }

    protected KDSSheet getKDSSheet(KDSBook book) {
        return this.kdtEntry.getIOManager().saveToKDSSheet(book, true, false, false, "sheet1");
    }

    void openFileInExcel(String file) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + file + "\"");
    }

    public File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(path);
            }
        }
        return file;
    }

    public KDFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        }
        return this.fileChooser;
    }

    protected void showSaveSuccess() {
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK");
        this.setMessageText(msg);
        this.setNextMessageText(null);
        this.setShowMessagePolicy(2);
        this.showMessage();
    }
}

