/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMBillListUI;
import com.kingdee.eas.scm.im.inv.IMergeSplitedBillFacade;
import com.kingdee.eas.scm.im.inv.MergeSplitedBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractMergeSplitedBillUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MergeSplitedBillUI
extends AbstractMergeSplitedBillUI {
    private static final String TEMP_TABLE = "tempTable";
    private static final String FCANTMERGERESON = "FCANTMERGERESON";
    private static final String BOS_TYPE = "BOSType";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MergeSplitedBillUI.class);
    private SCMBillListUI billListUI = null;
    private Set<String> selectedIdSet = new HashSet<String>();
    private static final String MERGESPLITEDRESOURCE = "com.kingdee.eas.scm.im.inv.MergeSplitedResource";
    public static final String MER_InvUI = "com.kingdee.eas.scm.im.inv.client.InvResource";
    private boolean firstLoadData = true;

    public MergeSplitedBillUI() throws Exception {
        this.initBtnIcon();
        this.params = new RptParams();
        this.billTable.setEditable(false);
        this.billTable.getDataRequestManager().setDataRequestMode(0);
        this.billTable.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void debugInit() {
        Map ctx = this.getUIContext();
        ctx.put("ListUIName", "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillListUI");
        ctx.put(BOS_TYPE, "783061E3");
    }

    private void addBillPanel(String listUIName) throws UIException {
        KDPanel panel = new KDPanel(false);
        panel.setBounds(new Rectangle(41, 366, 780, 570));
        panel.setBackground(Color.RED);
        BOSUIContext uiCtx = new BOSUIContext();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"XXXXXXXXXXX"));
        view.setFilter(filter);
        uiCtx.put("BOTPFilter", view);
        uiCtx.put("BOTPViewStatus", 1);
        uiCtx.put("IDList", null);
        this.billListUI = (SCMBillListUI)UIFactoryHelper.initUIObject((String)listUIName, (Map)uiCtx, null, (String)"FINDVIEW");
        String billTitle = this.getBillUITitle();
        this.billPanel.addTab(billTitle, (Component)panel);
        panel.setLayout((LayoutManager)new BorderLayout());
        this.billListUI.getUIContentPane().setSize(new Dimension(790, 580));
        this.billListUI.setVisible(true);
        panel.add((Component)this.billListUI, (Object)"Center");
        panel.validate();
    }

    private String getBillUITitle() {
        Map uiContext = this.getUIContext();
        String bosType = (String)uiContext.get(BOS_TYPE);
        IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntity = metadataLoader.getEntity(BOSObjectType.create((String)bosType));
        return srcEntity.getAlias();
    }

    private void initBtnIcon() {
        this.btnAddBill.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnRemoveBill.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnExpandAll.setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
        this.btnRefresh.setVisible(false);
    }

    public void onLoad() throws Exception {
        Map ctx = this.getUIContext();
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", true);
        ctx.put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", this.params);
        super.onLoad();
        String billTitle = this.getBillUITitle();
        this.kDTabbedPane1.setTitleAt(0, billTitle);
        String listUIName = (String)ctx.get("ListUIName");
        this.addBillPanel(listUIName);
    }

    public void getData(KDTDataRequestEvent e) {
        if (!this.firstLoadData) {
            return;
        }
        this.firstLoadData = false;
        RptParams para = new RptParams();
        try {
            Map uiContext = this.getUIContext();
            String bosType = (String)uiContext.get(BOS_TYPE);
            String rootBillId = (String)uiContext.get("RootBillId");
            para.setString(BOS_TYPE, bosType);
            para.setString("rootBillId", rootBillId);
            RptParams rpt = this.getRemoteInstance().createTempTable(para);
            this.billTable.setRowCount(rpt.getInt("totalCount"));
            this.setTempTable(rpt.getString(TEMP_TABLE));
            this.billTable.setRowCount(rpt.getInt("totalCount"));
            RptTableHeader header = (RptTableHeader)rpt.getObject("header");
            KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.billTable);
            this.billTable.checkParsed();
            para.setString(TEMP_TABLE, this.getTempTable());
            rpt = this.getRemoteInstance().query(para);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.insertRows(rs, 0, this.billTable, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        super.tableDataRequest(e);
        try {
            this.actionExpandAll_actionPerformed(null);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            this.handUIExceptionAndAbort(e1);
        }
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        IRow row = null;
        ICell cell = null;
        int rowIndex = insertRowIndex + insertRowCount;
        SimpleCompanyUserObject companyUserObject = null;
        int treeColIndex = table.getColumnIndex(this.getTreeCol());
        int inTaxColIndex = table.getColumnIndex("FINTAX");
        int isArColIndex = table.getColumnIndex("FISGENBIZAR");
        int isApColIndex = table.getColumnIndex("FISGENBIZAP");
        int statusColIndex = table.getColumnIndex("FSTATUS");
        int resonIndex = table.getColumnIndex(FCANTMERGERESON);
        for (int i = 0; i < rs.getRowCount(); ++i) {
            if (i != 0) {
                rs.moveTo(i - 1);
                rs.moveTo(i);
            } else {
                rs.moveTo(i);
            }
            row = this.isExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            companyUserObject = new SimpleCompanyUserObject();
            companyUserObject.setCompanyId(rs.getString("FID"));
            companyUserObject.setName(rs.getString("FNUMBER"));
            companyUserObject.setBlockId("XX");
            companyUserObject.setExpanded(false);
            int isleaf = rs.getInt("FISLEAF");
            companyUserObject.setLeaf(isleaf == 1);
            companyUserObject.setLevel(rs.getInt("FLEVEL"));
            handler.setTableRowData(row, rs.toRowArray());
            if (null != row.getCell(resonIndex) && null != row.getCell(resonIndex).getValue() && !StringUtils.isEmpty((String)row.getCell(resonIndex).getValue().toString())) {
                row.getStyleAttributes().setBackground(Color.lightGray);
            }
            cell = row.getCell(treeColIndex);
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
            cell = row.getCell(inTaxColIndex);
            cell.setValue((Object)(rs.getObject("FINTAX") != null && 1 == rs.getInt("FINTAX") ? 1 : 0));
            if (isArColIndex > 0) {
                cell = row.getCell(isArColIndex);
                cell.setValue((Object)(rs.getObject("FISGENBIZAR") != null && 1 == rs.getInt("FISGENBIZAR") ? 1 : 0));
            }
            if (isApColIndex > 0) {
                cell = row.getCell(isApColIndex);
                cell.setValue((Object)(rs.getObject("FISGENBIZAP") != null && 1 == rs.getInt("FISGENBIZAP") ? 1 : 0));
            }
            int status = -1;
            if (rs.getObject("FSTATUS") != null) {
                status = rs.getInt("FSTATUS");
            }
            cell = row.getCell(statusColIndex);
            cell.setValue((Object)BillBaseStatusEnum.getEnum((int)status));
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    protected void initListener() {
        super.initListener();
        super.initVirtualCompanyListener();
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
        int numColIndex = this.getTable().getColumnIndex(this.getTreeCol());
        if (numColIndex != column) {
            String selectId = (String)this.getTable().getRow(row).getCell("FID").getValue();
            Object reson = this.getTable().getRow(row).getCell(FCANTMERGERESON).getValue();
            if (null == reson || StringUtils.isEmpty((String)reson.toString())) {
                this.selectedIdSet.add(selectId);
                this.queryBySelectIds();
            }
        }
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams pp = new RptParams();
        pp.setString("fparentid", companyUserObject.getCompanyId());
        pp.setString("flevel", Integer.toString(companyUserObject.getLevel()));
        pp.setString(TEMP_TABLE, this.getTempTable());
        Map uiContext = this.getUIContext();
        String bosType = (String)uiContext.get(BOS_TYPE);
        pp.setString(BOS_TYPE, bosType);
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(pp, -1, -1, this.getTempTable(), (Object)companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return MergeSplitedBillFacadeFactory.getRemoteInstance();
    }

    public boolean isAsynchronism() {
        return false;
    }

    public String getTreeCol() {
        return "FNUMBER";
    }

    protected KDTable getTable() {
        return this.billTable;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return MergeSplitedBillFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionAddBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable().getRowCount() == 0 || this.getTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        List selectedIds = this.getSelectedIdList(this.getTable());
        this.selectedIdSet.addAll(selectedIds);
        this.queryBySelectIds();
    }

    private void queryBySelectIds() {
        FilterInfo filter = new FilterInfo();
        if (this.selectedIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", this.selectedIdSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"XXXXXXXXXXX"));
        }
        this.billListUI.getMainQuery().setFilter(filter);
        this.billListUI.getMainTable().removeRows();
    }

    @Override
    public void actionRemoveBill_actionPerformed(ActionEvent e) throws Exception {
        this.billListUI.checkSelected();
        ArrayList selectedIds = this.billListUI.getSelectedIdValuesArrayList();
        this.selectedIdSet.removeAll(selectedIds);
        this.queryBySelectIds();
    }

    private List getSelectedIdList(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        int idIndex = table.getColumnIndex("FID");
        int resonIndex = table.getColumnIndex(FCANTMERGERESON);
        ICell cell = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            cell = table.getCell(selectRows[i], resonIndex);
            if (null != cell && null != cell.getValue() && !StringUtils.isEmpty((String)cell.getValue().toString())) continue;
            idSet.add(table.getCell(selectRows[i], idIndex).getValue().toString());
        }
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.addAll(idSet);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionExpandAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.getTable().getRowCount();
        if (rowCount <= 0) {
            return;
        }
        int treeColIndex = this.getTable().getColumnIndex(this.getTreeCol());
        try {
            this.setCursorOfWair();
            for (int row = 0; row < rowCount; ++row) {
                SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(row).getCell(treeColIndex).getValue();
                if (companyUserObject == null || companyUserObject.isExpanded()) continue;
                this.doExpand(companyUserObject, row);
                rowCount = this.getTable().getRowCount();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.getTable().removeColumns();
        this.getTable().removeRows();
        super.actionRefresh_actionPerformed(e);
        this.selectedIdSet = new HashSet<String>();
        this.queryBySelectIds();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.mergeSubsingleData();
        this.disposeUIWindow();
    }

    public void mergeSubsingleData() throws BOSException, EASBizException {
        Map result;
        String deitalMsg;
        CharSequence info;
        IMergeSplitedBillFacade iMergeSplitedBillFacade;
        HashMap map;
        KDTable table = this.billListUI.getMainTable();
        if (table.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        Map ctx = this.getUIContext();
        String rootBillId = (String)ctx.get("RootBillId");
        String bosType = (String)ctx.get(BOS_TYPE);
        HashSet<String> idSet = new HashSet<String>();
        for (int j = 0; j < table.getRowCount(); ++j) {
            String id = (String)table.getCell(j, "id").getValue();
            idSet.add(id);
        }
        if (idSet.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)MER_InvUI, (String)"NoMergeChild"));
        }
        if ((map = (iMergeSplitedBillFacade = MergeSplitedBillFacadeFactory.getRemoteInstance()).judgeUnitPriceAndAccountIsConsist(rootBillId, idSet, bosType)).get("same") != null && map.get("same").equals("no")) {
            int show;
            String priceDifferInfo = (String)map.get("priceDifferInfo");
            String accountViewDifferInfo = (String)map.get("accountViewDifferInfo");
            info = new StringBuffer();
            StringBuffer detailInfo = new StringBuffer();
            if (priceDifferInfo != null) {
                String price = EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"recylingDocuments");
                ((StringBuffer)info).append(price);
                detailInfo.append(EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"priceInfo"));
                detailInfo.append("\n");
                detailInfo.append(priceDifferInfo);
                detailInfo.append("\n");
            }
            if (accountViewDifferInfo != null) {
                String account = EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"accountViewDiffer");
                ((StringBuffer)info).append(account);
                detailInfo.append(EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"accountInfo"));
                detailInfo.append("\n");
                detailInfo.append(accountViewDifferInfo);
                detailInfo.append("\n");
            }
            if (2 == (show = MsgBox.showConfirm3a((Component)((Object)this), (String)((StringBuffer)info).toString(), (String)detailInfo.toString()))) {
                return;
            }
        }
        if (!StringUtils.isEmpty((String)(deitalMsg = (String)(result = iMergeSplitedBillFacade.mergeSubsingleData(rootBillId, idSet, bosType)).get("checkMsg")))) {
            String mergeWithMsg = EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"mergeWithMsg");
            MsgBox.showDetailAndOK(null, (String)mergeWithMsg, (String)deitalMsg, (int)1);
        } else {
            info = EASResource.getString((String)MERGESPLITEDRESOURCE, (String)"succcess");
            MsgBox.showInfo((String)info);
        }
    }

    protected void disposeUIWindow() {
        if (this.params != null && this.getTempTable() != null) {
            try {
                this.getRemoteInstance().dropPoolTempTable(this.getTempTable());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        super.disposeUIWindow();
    }
}

