/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.scm.util.SCMF7ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillAgent;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryAgent;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractMoveInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvFetchDataUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MoveInWarehsBillEditUI
extends AbstractMoveInWarehsBillEditUI
implements DataChangeListener,
ChangeListener {
    private static final long serialVersionUID = 6546157896680113006L;
    private static final Logger logger = CoreUIObject.getLogger(MoveInWarehsBillEditUI.class);
    private boolean inwardSetOff = false;
    private boolean inwardBOTP = false;
    boolean isReverse = false;
    private boolean isBOTP = false;
    private int SRowIndex;
    private static final String TB_ASSISTQTY = "assistantQty";
    private static final String TB_MATERIAL = "materialNum";
    private static final String TB_BATCH = "lot";
    private static final String TB_LOCATION = "location";
    private static final String TB_STOCKER = "stocker";
    private static final String TB_BASEUNITQTY = "baseUnitQty";
    private static final String TB_ASSISTANTUNIT = "assistantUnit";
    private static final String TB_QTY = "qty";
    private static final String TB_COUNTERVAILQTY = "countervailQty";
    private static final String TB_UNIT = "unit";
    private static final String TB_WAREHS = "warehouse";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_UNITSTANCOST = "unitStandardCost";
    private static final String TB_STANDARDCOST = "standardCost";
    private static final String TB_UNITFACTCOST = "unitFactCost";
    private static final String TB_FACTCOST = "factCost";
    private static final String TB_ASSISPROPERTY = "assistantAttr";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_ASSIATTR = "assistantAttr";
    private static final String TB_MATERIALMODEL = "model";
    private static final String TB_MFG = "mfg";
    private static final String TB_EXP = "exp";
    private static final String TB_STOCKTRANSFERBILLNUM = "stockTransferNum";
    private static final String TB_STOCKTRANSFERBILLSEQ = "stockTransferEntrySeq";
    private static final String TB_ISPRESENT = "isPresent";
    private static final String TB_PROJECTNUM = "projectNumCol";
    private static final String TB_TRACKNUM = "trackNumCol";
    private static final String TB_PRICE = "price";
    private static final String TB_AMOUNT = "amount";
    MyEventListener myEnent = null;
    private KDBizPromptBox prmtSupplier = null;
    private KDBizPromptBox prmtCustomer = null;
    private static final String[] CURRENCYPRECISIONTAB = new String[]{"standardCost", "factCost"};
    KDBizPromptBox kDBizWarehouse = null;
    KDBizPromptBox kDBizPromptBoxMaterial = null;
    private int indexRow = -1;
    private int indexCol = -1;
    private static final String[] LOCKCOLS = new String[]{"qty", "unit"};
    private static final String[] QTYPRECISIONTAB = new String[]{"qty", "countervailQty"};
    private static final String[] PRICE_PRECISION_TAB = new String[]{"unitStandardCost", "unitFactCost", "price"};
    private static final String[] ASSQTY_PRECISION_TAB = new String[]{"assistantQty"};
    private static final String[] ENTRYCOLUMNS = new String[]{"materialNum", "unit", "qty"};
    private static final String[] BASEQTY_PRECISION_TAB = new String[]{"baseUnitQty"};
    private static final String FREEPROP_RESOURCE = "com.kingdee.eas.scm.im.inv.freeprop.MoveInWarehsFreePropResource";

    public String getUITitle() {
        return InvClientUtils.getResource("MoveInWarehsBill");
    }

    public MoveInWarehsBillEditUI() throws Exception {
        if (this.myEnent == null) {
            this.myEnent = new MyEventListener();
        }
        this.initConfigMap();
    }

    @Override
    protected void initBOTPData() throws Exception {
        this.initBOTPOrReverseData(this.editData);
    }

    @Override
    public void loadFields() {
        this.isReverse = this.editData.isIsReversed();
        this.syncOldData((IObjectValue)this.editData);
        this.isBOTP = !this.isReverse && this.editData.getSourceBillType() != null;
        try {
            this.removeListeners();
            this.initFetchData();
            this.loadFieldsBefore();
            this.setNegativeBill();
            super.loadFields();
            this.sou = this.editData.getStorageOrgUnit();
            this.setCouBySou();
            if (this.sou != null && this.cou == null) {
                MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                SysUtil.abort();
            }
            if (this.cou != null && this.cou.getBaseCurrency() != null) {
                this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.cou.getBaseCurrency(), (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
            }
            this.loadFieldsAfter();
            this.setControl();
            this.setDefaultMainOrgUnit();
            IRow curRow = null;
            int rows = this.detailTable.getRowCount();
            for (int i = 0; i < rows; ++i) {
                curRow = this.detailTable.getRow(i);
                MaterialInfo mi = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
                if (mi != null) continue;
                String[] precisionFileds = new String[]{TB_BASEUNITQTY};
                SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.detailTable, (String[])precisionFileds, (int)i, (boolean)true);
            }
            if (this.isBillQuery()) {
                this.setOnlyActualCostEditable();
            }
            this.addListeners();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.detailTable.getColumn(TB_EXP).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.detailTable.getColumn(TB_MFG).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        InvClientUtils.setColumnsFontColor(this.getDetailTable(), this.getNumberColumns(), this.getTransactionType(), this.editData.isIsReversed());
    }

    protected void initBOTPOrReverseData(MoveInWarehsBillInfo editData) throws Exception {
        if (editData != null && editData.getBoolean("autoTransfer")) {
            this.setOprtState(OprtState.EDIT);
            this.setDataObject((IObjectValue)editData);
            this.initFetchData();
        }
        this.isReverse = editData.isIsReversed();
        this.isBOTP = !this.isReverse && editData.getSourceBillType() != null;
        int entrySize = editData.getEntry().size();
        String materialId = "";
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = editData.getReceiptCompanyOrgUnit();
        try {
            if ((this.isReverse || this.isBOTP && editData.getBillType() == null) && entrySize > 0) {
                if (this.isReverse) {
                    editData.setTotalStandardCost(editData.getTotalStandardCost() == null ? null : editData.getTotalStandardCost().abs());
                    editData.setTotalActualCost(editData.getTotalActualCost() == null ? null : editData.getTotalActualCost().abs());
                }
                if (this.isBOTP) {
                    editData.setIsInitBill(false);
                    this.sou = editData.getStorageOrgUnit();
                    this.setCouBySou();
                    if (this.sou != null && this.cou == null) {
                        MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                        SysUtil.abort();
                    }
                    editData.setIssueCompanyOrgUnit(this.cou);
                    editData.setReceiptCompanyOrgUnit(this.cou);
                    if (this.cou != null && this.cou.getBaseCurrency() != null) {
                        this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                    }
                    BillTypeInfo billType = new BillTypeInfo();
                    billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0172c0a812fd463ED552"));
                    billType.setNumber("107");
                    editData.setBillType(billType);
                }
                MaterialInventoryInfo materialInvInfo = null;
                for (int i = 0; i < entrySize; ++i) {
                    MoveInWarehsBillEntryInfo entry = editData.getEntry().get(i);
                    if (this.isReverse) {
                        entry.setQty(this.getAbsOrZero(entry.getQty()));
                        entry.setBaseQty(this.getAbsOrZero(entry.getBaseQty()));
                        entry.setAssistQty(this.getAbsOrZero(entry.getAssistQty()));
                        entry.setActualCost(entry.getActualCost() == null ? null : entry.getActualCost().abs());
                        entry.setStandardCost(entry.getStandardCost() == null ? null : entry.getStandardCost().abs());
                        continue;
                    }
                    if (!this.isBOTP) continue;
                    entry.setStorageOrgUnit(this.sou);
                    MaterialInfo material = entry.getMaterial();
                    if (material != null) {
                        materialId = material.getId().toString();
                        if (this.sou != null) {
                            materialInvInfo = this.fetchData.getMaterialInventory(materialId, this.sou.getId().toString());
                            if (materialInvInfo == null || !materialInvInfo.isIsLotNumber()) {
                                entry.setLot(null);
                            }
                            if (materialInvInfo == null || !materialInvInfo.isIsPeriodValid()) {
                                entry.setExp(null);
                                entry.setMfg(null);
                            }
                        }
                        if (entry.getWarehouse() == null && this.sou != null) {
                            entry.setWarehouse(this.fetchData.getDefaultWarehouse(materialId, this.sou.getId().toString()));
                        }
                        if (entry.getWarehouse() != null) {
                            if (entry.getStocker() == null) {
                                entry.setStocker(entry.getWarehouse().getWhman());
                            }
                            if (entry.getLocation() == null && this.cou != null) {
                                entry.setLocation(this.fetchData.getDefaultLocation(materialId, entry.getWarehouse().getId().toString(), this.cou.getId().toString()));
                            }
                        }
                    }
                    this.initEntryCost4Botp(entry, this.localAmtPrecision);
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private BigDecimal getAbsOrZero(BigDecimal value) {
        return value == null ? InvClientUtils.ZERO : value.abs();
    }

    private void initEntrys() throws Exception {
        SCMClientUtils.changeTableColPrecision((int)this.localAmtPrecision, (KDTable)this.detailTable, (String[])new String[]{TB_AMOUNT, TB_FACTCOST});
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.detailTable.getColumn(TB_WAREHS).getStyleAttributes().setLocked(false);
        if (storage != null) {
            int count = this.getDetailTable().getRowCount();
            this.lotFrameList = new LinkedList();
            for (int i = 0; i < count; ++i) {
                this.initEntry(i, storage);
            }
        } else {
            this.detailTable.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
        }
    }

    private int getPrecision(String materialId, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        Integer precision = this.fetchData.getUnitPrecision(materialId, unitInfo.getId().toString());
        return precision == null ? 2 : precision;
    }

    private void initEntry(int i, StorageOrgUnitInfo storage) throws Exception {
        MaterialInfo material = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo assUnit = null;
        MeasureUnitInfo baseUnit = null;
        WarehouseInfo warehs = null;
        String materialId = null;
        MaterialInventoryInfo materialInvInfo = null;
        IRow curRow = this.detailTable.getRow(i);
        material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        assUnit = (MeasureUnitInfo)curRow.getCell(TB_ASSISTANTUNIT).getValue();
        baseUnit = (MeasureUnitInfo)curRow.getCell(TB_BASEUNIT).getValue();
        warehs = (WarehouseInfo)curRow.getCell(TB_WAREHS).getValue();
        if (material != null) {
            this.setActualCostColor(curRow);
            InvClientUtils.setColLock(this.detailTable, new String[]{TB_QTY}, i, false);
            materialId = material.getId().toString();
            materialInvInfo = this.fetchData.getMaterialInventory(materialId, storage.getId().toString());
            SCMClientUtils.changeTableColPrecision((int)material.getPricePrecision(), (KDTable)this.detailTable, (String[])PRICE_PRECISION_TAB, (int)i);
            this.changeQtyPrecision(curRow);
            InvClientUtils.setExpAndMfgEnabled(materialInvInfo, this.detailTable, i, true);
            if (materialInvInfo != null && materialInvInfo.isIsLotNumber()) {
                StorageOrgUnitInfo sou;
                boolean isLoad;
                curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                LotFrame lotFrame = new LotFrame();
                lotFrame.setSeq(i);
                lotFrame.setMainBizOrg(this.sou.getId().toString());
                lotFrame.setMaterial(material.getId().toString());
                this.lotFrameList.add(lotFrame);
                StorageOrgUnitInfo issueSou = (StorageOrgUnitInfo)this.prmtMoveOutStorageOrgUnit.getValue();
                if (issueSou != null && !issueSou.getId().toString().equals(storage.getId().toString())) {
                    curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                }
                SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_BATCH, (int)i, (boolean)true);
                boolean bl = isLoad = !this.getOprtState().equals("ADDNEW");
                if (this.isBOTP && ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState()))) {
                    if (curRow.getCell(TB_BATCH).getValue() == null) {
                        this.fillLotFrame();
                    }
                    if (curRow.getCell(TB_BATCH).getValue() != null) {
                        sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                        InvClientUtils.setLotInfo(this.detailTable, i, sou, material, this.detailTable.getCell(i, TB_BATCH).getValue().toString(), this.editData);
                    }
                }
                if (!isLoad && this.isBOTP && curRow.getCell(TB_BATCH).getValue() != null) {
                    sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                    InvClientUtils.setLotInfo(this.detailTable, i, sou, material, this.detailTable.getCell(i, TB_BATCH).getValue().toString(), this.editData);
                }
                if (curRow.getCell(TB_BATCH).getValue() == null) {
                    curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                }
            } else {
                curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(true);
                curRow.getCell(TB_BATCH).setValue(null);
            }
            if (materialInvInfo != null && materialInvInfo.isIsSequenceNo()) {
                curRow.getCell(this.detailTable.getColumnIndex("isSerialNumber")).setValue((Object)new Boolean(true));
            } else {
                curRow.getCell(this.detailTable.getColumnIndex("isSerialNumber")).setValue((Object)new Boolean(false));
            }
            this.initEntryUnitCell(i, material);
            boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
            if (isUseWarehsRelation) {
                InvClientUtils.setWarehouseFitlerByMSRelation(this.sou, material, this.getDetailTable(), i, TB_WAREHS, -1);
            }
            if (warehs != null && warehs.isHasLocation()) {
                if (this.isBOTP) {
                    curRow.getCell(TB_LOCATION).getStyleAttributes().setLocked(false);
                }
                SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_LOCATION, (int)i, (boolean)true);
                if (isUseWarehsRelation) {
                    InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehs, material, this.getDetailTable(), i, false, this.fetchData);
                } else {
                    curRow.getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)InvClientUtils.getLocationF7((CoreUIObject)this, warehs)));
                }
            } else {
                curRow.getCell(TB_LOCATION).getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_LOCATION, (int)i, (boolean)false);
            }
            if (warehs == null || !this.isBOTP && !this.isReverse) {
                curRow.getCell(TB_WAREHS).getStyleAttributes().setLocked(false);
            }
            this.setEntryAssistProperty(i, material);
        }
    }

    private void changeQtyPrecision(IRow curRow) throws BOSException, EASBizException {
        MaterialInfo material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        String materialId = material.getId().toString();
        MeasureUnitInfo unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        MeasureUnitInfo assUnit = (MeasureUnitInfo)curRow.getCell(TB_ASSISTANTUNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)curRow.getCell(TB_BASEUNIT).getValue();
        if (unit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])QTYPRECISIONTAB, (int)this.getPrecision(materialId, unit), (boolean)this.isNegativeBill, (boolean)true);
        }
        if (assUnit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])ASSQTY_PRECISION_TAB, (int)this.getPrecision(materialId, assUnit), (boolean)this.isNegativeBill, (boolean)true);
            curRow.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(false);
        } else {
            curRow.getCell(TB_ASSISTQTY).setValue(null);
            curRow.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(true);
        }
        if (baseUnit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])BASEQTY_PRECISION_TAB, (int)this.getPrecision(materialId, baseUnit), (boolean)this.isNegativeBill, (boolean)true);
        }
    }

    private void initBOTPControls() {
        if (this.isBOTP ^ this.inwardBOTP) {
            this.detailTable.getColumn(TB_QTY).getStyleAttributes().setLocked(this.inwardBOTP);
            this.detailTable.getColumn(TB_UNIT).getStyleAttributes().setLocked(this.inwardBOTP);
            this.detailTable.getColumn(TB_STOCKER).getStyleAttributes().setLocked(this.inwardBOTP);
            this.inwardBOTP = this.isBOTP;
        }
        if (this.isBOTP) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.prmtStorageOrgUnit.setEnabled(false);
            this.prmtMoveOutStorageOrgUnit.setEnabled(false);
        }
    }

    private void initSetOffControls() {
        if (this.isReverse ^ this.inwardSetOff) {
            if (this.isReverse) {
                this.prmtTransactionType.setEnabled(false);
                this.prmtStorageOrgUnit.setEnabled(false);
                this.prmtMoveOutStorageOrgUnit.setEnabled(false);
                this.prmtAdminOrg.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
                this.actionAddLine.setEnabled(false);
                InvClientUtils.setTableLock(this.detailTable, new String[]{TB_ASSISTQTY}, true);
                this.detailTable.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
                this.detailTable.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.RED);
                this.detailTable.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
                this.detailTable.getColumn(TB_QTY).getStyleAttributes().setLocked(false);
                InvClientUtils.setCellLock(this.detailTable, "remark", false);
            } else {
                this.detailTable.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
                this.detailTable.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.BLACK);
                this.detailTable.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
            }
            this.inwardSetOff = this.isReverse;
        }
    }

    private void initEntryUnitCell(int rowIndex, MaterialInfo materialInfo) {
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialInfo.getId().toString());
        this.detailTable.getRow(rowIndex).getCell(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        bizUnitBox.addDataChangeListener((DataChangeListener)this);
    }

    private void setLocationColProperty(WarehouseInfo warehouseInfo, int rowIndex, boolean isClearLocation) {
        if (isClearLocation) {
            this.detailTable.getRow(rowIndex).getCell(this.detailTable.getColumnIndex(TB_LOCATION)).setValue(null);
        }
        if (warehouseInfo == null) {
            this.detailTable.getCell(rowIndex, TB_LOCATION).setValue(null);
            this.detailTable.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_LOCATION, (int)rowIndex, (boolean)false);
            this.detailTable.getCell(rowIndex, TB_STOCKER).setValue(null);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            this.detailTable.getRow(rowIndex).getCell(this.detailTable.getColumnIndex(TB_LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            kDBizPromptBoxLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
            kDBizPromptBoxLocation.setDisplayFormat("$name$");
            kDBizPromptBoxLocation.setEditFormat("$number$");
            kDBizPromptBoxLocation.setCommitFormat("$number$");
            kDBizPromptBoxLocation.setEntityViewInfo(viewInfo);
            this.detailTable.getRow(rowIndex).getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
            MaterialInfo material = (MaterialInfo)this.detailTable.getCell(rowIndex, TB_MATERIAL).getValue();
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (material != null && storage != null) {
                this.detailTable.getCell(rowIndex, TB_LOCATION).setValue((Object)InvClientUtils.getDefaultLocation(storage, material, warehouseInfo));
            }
        } else {
            this.detailTable.getRow(rowIndex).getCell(this.detailTable.getColumnIndex(TB_LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    @Override
    public void storeFields() {
        this.detailTable.getEditManager().stopEditing();
        try {
            this.storeFieldsBefore();
            super.storeFields();
            if (BillBaseStatusEnum.SUBMITED.equals((Object)this.editData.getBaseStatus())) {
                this.initOldData((IObjectValue)this.editData);
            }
            this.editData.setSyncOldValue(true);
            this.storeFieldsAfter();
            MoveInWarehsBillEntryInfo entry = null;
            BigDecimal facost = null;
            BigDecimal standardCost = null;
            StorageOrgUnitInfo headStorage = this.editData.getStorageOrgUnit();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.editData.getReceiptCompanyOrgUnit();
            if (aCompanyOrgUnitInfo == null) {
                aCompanyOrgUnitInfo = InvClientUtils.getCompanyInfo(headStorage);
            }
            BigDecimal assQty = null;
            if (this.inwardSetOff) {
                if (this.editData.getTotalStandardCost() != null) {
                    this.editData.setTotalStandardCost(this.editData.getTotalStandardCost().negate());
                }
                if (this.editData.getTotalActualCost() != null) {
                    this.editData.setTotalActualCost(this.editData.getTotalActualCost().negate());
                }
            }
            MoveInWarehsBillEntryCollection entrys = this.editData.getEntry();
            int entryCount = entrys.size();
            for (int i = 0; i < entryCount; ++i) {
                entry = entrys.get(i);
                entry.setStorageOrgUnit(headStorage);
                if (aCompanyOrgUnitInfo != null) {
                    entry.setCompanyOrgUnit(aCompanyOrgUnitInfo);
                }
                if ((assQty = entry.getAssistQty()) == null) {
                    assQty = InvClientUtils.ZERO;
                    entry.setAssistQty(assQty);
                }
                if (!this.inwardSetOff) continue;
                if (entry.getQty() == null) {
                    entry.setQty(InvClientUtils.ZERO);
                } else {
                    entry.setQty(entry.getQty().negate());
                }
                if (entry.getAmount() == null) {
                    entry.setAmount(InvClientUtils.ZERO);
                } else {
                    entry.setAmount(entry.getAmount().negate());
                }
                if (entry.getBaseQty() == null) {
                    entry.setBaseQty(InvClientUtils.ZERO);
                } else {
                    entry.setBaseQty(entry.getBaseQty().negate());
                }
                if (assQty != null) {
                    entry.setAssistQty(assQty.negate());
                }
                if ((standardCost = entry.getStandardCost()) != null) {
                    entry.setStandardCost(standardCost.negate());
                }
                if ((facost = entry.getActualCost()) == null) continue;
                entry.setActualCost(facost.negate());
            }
            this.editData.setSyncOldValue(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.pkBizDate.requestFocus();
        }
    }

    @Override
    public void onLoad() throws Exception {
        String oprState = this.getOprtState();
        if (oprState == null) {
            this.setOprtState("ADDNEW");
            oprState = "ADDNEW";
        }
        this.bizInventory.setEnabledMultiSelection(true);
        super.onLoad();
        this.initControl();
        this.initTableControl();
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnSplitOption.setVisible(false);
        this.detailTable.getColumn(TB_PROJECTNUM).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveOutStorageOrgUnit, (KDTable)this.detailTable, (String)TB_PROJECTNUM);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveOutStorageOrgUnit, (KDTable)this.detailTable, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        if (this.getSCMBizDataVO() != null) {
            this.setInvBillOptinStatus();
        }
    }

    @Override
    protected KDTable getDetailTable() {
        return this.detailTable;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDDatePicker getBizDateField() {
        return this.pkBizDate;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MoveInWarehsBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        MoveInWarehsBillAgent billInfo = null;
        try {
            billInfo = MoveInWarehsBillAgent.create();
            billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            billInfo.setBillType(SCMClientUtils.getBillType((String)"50957179-0105-1000-e000-0172c0a812fd463ED552"));
            billInfo.setTotalStandardCost(InvClientUtils.ZERO);
            billInfo.setTotalActualCost(InvClientUtils.ZERO);
            billInfo.setTotalAmount(InvClientUtils.ZERO);
            billInfo.setFiVouchered(false);
            Date date = this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getCurrentTime() : SCMClientUtils.getServerDate2();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            billInfo.setBizDate(cal.getTime());
            UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            billInfo.setCreator(aUserInfo);
            this.sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
            this.setCouBySou();
            if (this.cou != null) {
                billInfo.setStorageOrgUnit(this.sou);
                billInfo.setIssueCompanyOrgUnit(this.cou);
                billInfo.setReceiptCompanyOrgUnit(this.cou);
            }
            MoveInWarehsBillEntryInfo entryInfo = (MoveInWarehsBillEntryInfo)this.createNewDetailData(this.detailTable);
            if (this.cou != null) {
                entryInfo.setStorageOrgUnit(this.sou);
                entryInfo.setCompanyOrgUnit(this.cou);
            }
            billInfo.getEntry().add(entryInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return billInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        MoveInWarehsBillEntryAgent entryInfo = null;
        try {
            entryInfo = MoveInWarehsBillEntryAgent.create();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        entryInfo.setReverseQty(InvClientUtils.ZERO);
        entryInfo.setAssociateQty(InvClientUtils.ZERO);
        entryInfo.setUnitActualCost(InvClientUtils.ZERO);
        entryInfo.setUnitStandardCost(InvClientUtils.ZERO);
        entryInfo.setActualCost(InvClientUtils.ZERO);
        entryInfo.setStandardCost(InvClientUtils.ZERO);
        if (entryInfo.getBaseQty() == null) {
            entryInfo.setBaseQty(InvClientUtils.ZERO);
        }
        if (entryInfo.getQty() == null) {
            entryInfo.setQty(InvClientUtils.ZERO);
        }
        if (entryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(InvClientUtils.ZERO);
        }
        if (this.getDetailTable().getRowCount() > 0 && this.batchCarryWarehouseLocation && !this.isUseWarehsRelation(this.sou)) {
            IRow curRow = this.getDetailTable().getRow(0);
            WarehouseInfo wi = (WarehouseInfo)curRow.getCell(TB_WAREHS).getValue();
            entryInfo.setWarehouse(wi);
            PersonInfo personInfo = (PersonInfo)curRow.getCell(TB_STOCKER).getValue();
            entryInfo.setStocker(personInfo);
        }
        entryInfo.setStorageOrgUnit(this.sou);
        entryInfo.setCompanyOrgUnit(this.cou);
        this.fillCurEntryByFirsrRow(entryInfo, new String[]{this.getCustomerColName(), this.getSupplierColName(), this.TB_STORETYPE});
        return entryInfo;
    }

    public void initControl() throws Exception {
        this.btnQuickAddLine.setEnabled(false);
        this.btnQuickAddLine.setVisible(false);
        this.menuItemQuickAddLine.setEnabled(false);
        this.menuItemQuickAddLine.setVisible(false);
        this.actionQuickAddLine.setEnabled(false);
        this.comboBaseStatus.setEnabled(false);
        this.txtAddStandardCost.setEditable(false);
        this.txtAddFactCost.setEditable(false);
        this.bizPromptCreator.setEnabled(false);
        this.bizPromptLastUpdateUser.setEnabled(false);
        this.bizPromptAuditor.setEnabled(false);
        this.dateCreateTime.setEnabled(false);
        this.dateLastUpdateTime.setEnabled(false);
        this.dateAuditTime.setEnabled(false);
        this.txtNumber.setRequired(true);
        this.prmtTransactionType.setRequired(true);
        this.pkBizDate.setRequired(true);
        this.prmtStorageOrgUnit.setRequired(true);
        this.prmtMoveOutStorageOrgUnit.setRequired(true);
        this.txtAddFactCost.setPrecision(this.localAmtPrecision);
        this.txtAddFactCost.setNegatived(false);
        this.txtAddFactCost.setRemoveingZeroInDispaly(false);
        this.txtAddFactCost.setHorizontalAlignment(4);
        this.txtAddStandardCost.setPrecision(this.localAmtPrecision);
        this.txtAddStandardCost.setNegatived(false);
        this.txtAddStandardCost.setRemoveingZeroInDispaly(false);
        this.txtAddStandardCost.setHorizontalAlignment(4);
        this.txtDescription.setMaxLength(255);
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            if (4 != this.editData.getBaseStatus().getValue()) {
                this.setHeadBizTypeStatus(!this.isBotpBill());
                this.setHeadTransactionTypeStatus();
            } else {
                this.setHeadBizTypeStatus(false);
                this.setHeadTransactionTypeStatus(false);
            }
        } else {
            this.setHeadBizTypeStatus(false);
            this.setHeadTransactionTypeStatus(false);
        }
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtMoveOutStorageOrgUnit);
        this.detailTable.getActionMap().remove("Paste");
        this.btnOffset.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.btnQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.prmtMoveOutStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                MoveInWarehsBillEditUI.this.moveOutStoragePreChange(e);
            }
        });
        this.prmtStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                MoveInWarehsBillEditUI.this.storageOrgPreChange(e);
            }
        });
        if (this.isReverse) {
            this.prmtTransactionType.setEnabled(false);
        }
    }

    @Override
    protected void bizInventoryPreChanged(PreChangeEvent e) {
        if (e.getData() == null) {
            return;
        }
        InventoryInfo[] Inventory0 = null;
        if (e.getData() instanceof InventoryInfo[]) {
            Inventory0 = (InventoryInfo[])e.getData();
        } else if (e.getData() instanceof InventoryInfo) {
            Inventory0 = new InventoryInfo[]{(InventoryInfo)e.getData()};
        }
        if (Inventory0 == null) {
            return;
        }
        try {
            IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
            MaterialInfo material = null;
            ObjectUuidPK pk = null;
            for (int i = 0; i < Inventory0.length; ++i) {
                if (this.SRowIndex == 1 && this.detailTable.getCell(0, TB_MATERIAL).getValue() == null) {
                    this.SRowIndex = 0;
                } else {
                    IObjectValue detailData = this.createNewDetailData(this.detailTable);
                    IRow row = this.detailTable.addRow(this.SRowIndex);
                    this.loadLineFields(this.detailTable, row, detailData);
                }
                InventoryInfo sInventory = Inventory0[i];
                if (this.SRowIndex == -1) continue;
                if (sInventory.getMaterial() != null) {
                    pk = new ObjectUuidPK(sInventory.getMaterial().getId());
                    material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)pk);
                    this.detailTable.getRow(this.SRowIndex).getCell(TB_MATERIAL).setValue((Object)material);
                    this.materialChanged(material, this.SRowIndex);
                }
                if (sInventory.getWarehouse() != null) {
                    pk = new ObjectUuidPK(sInventory.getWarehouse().getId());
                    WarehouseInfo aWarehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk);
                    this.detailTable.getRow(this.SRowIndex).getCell(TB_WAREHS).setValue((Object)aWarehouseInfo);
                }
                if (sInventory.getLocation() != null) {
                    ILocation iLocation = LocationFactory.getRemoteInstance();
                    pk = new ObjectUuidPK(sInventory.getLocation().getId());
                    this.detailTable.getRow(this.SRowIndex).getCell(TB_LOCATION).setValue((Object)iLocation.getLocationInfo((IObjectPK)pk));
                }
                if (sInventory.getLot() != null) {
                    this.detailTable.getRow(this.SRowIndex).getCell(TB_BATCH).setValue((Object)sInventory.getLot());
                }
                if (this.detailTable.getCell(this.SRowIndex, TB_EXP).getValue() != null) {
                    if (this.pkBizDate.getValue() != null) {
                        this.editData.setBizDate((Date)this.pkBizDate.getValue());
                    }
                    InvClientUtils.checkEXP(this.detailTable, this.SRowIndex, this.editData.getTransactionType(), this.editData.isIsReversed(), this.sou, material, this.editData);
                }
                if (sInventory.getCurStoreQty() != null) {
                    this.detailTable.getRow(this.SRowIndex).getCell(TB_QTY).setValue((Object)sInventory.getCurStoreQty());
                    this.qtyChanged(this.SRowIndex);
                }
                this.setInvUpdateByInventory(sInventory, this.SRowIndex);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected Vector getCheckDupFileds() {
        Vector<String> vct = new Vector<String>();
        vct.add(TB_MATERIAL);
        vct.add(TB_UNIT);
        vct.add("assistantAttr");
        vct.add(TB_BATCH);
        vct.add(TB_WAREHS);
        vct.add(TB_LOCATION);
        vct.add(TB_STOCKTRANSFERBILLNUM);
        vct.add(TB_STOCKTRANSFERBILLSEQ);
        return vct;
    }

    @Override
    public void actionQuickAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.SRowIndex = this.detailTable.getRowCount();
        this.inventoryAdaptor();
    }

    protected void moveOutStoragePreChange(PreChangeEvent e) {
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)e.getData();
        StorageOrgUnitInfo oldStorage = (StorageOrgUnitInfo)e.getOldData();
        if (storage == null && oldStorage == null || storage != null && storage.equals((Object)oldStorage)) {
            return;
        }
        CompanyOrgUnitInfo newCompany = null;
        if (storage != null && (newCompany = InvClientUtils.getCompanyInfo(storage)) == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
            e.setResult(0);
        }
        this.editData.setIssueCompanyOrgUnit(newCompany);
    }

    public void initTableControl() throws Exception {
        this.detailTable.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
        ObjectValueRender materialAvr = new ObjectValueRender();
        materialAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.detailTable.getColumn(TB_MATERIAL).setRenderer((IBasicRender)materialAvr);
        KDFormattedTextField txtField = new KDFormattedTextField(0);
        this.detailTable.getColumn(TB_STOCKTRANSFERBILLSEQ).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField));
        this.detailTable.getColumn(TB_STOCKTRANSFERBILLSEQ).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.detailTable.getColumn(TB_STOCKTRANSFERBILLSEQ).getStyleAttributes().setNumberFormat("%r{#,##0}f");
        ObjectValueRender avrAssPro = new ObjectValueRender();
        avrAssPro.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.detailTable.getColumn("assistantAttr").setRenderer((IBasicRender)avrAssPro);
        this.detailTable.getColumn(TB_WAREHS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getKDBizWarehouse()));
        StorageOrgUnitInfo storage = this.editData.getStorageOrgUnit();
        if (storage != null) {
            try {
                this.getKDBizWarehouse().setEntityViewInfo(InvClientUtils.getWarehouseFilter(storage));
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        KDBizPromptBox kDBizPromptBoxStocker = new KDBizPromptBox();
        kDBizPromptBoxStocker = SCMF7ContextUtils.setStockerF7ByStorageOrg((KDBizPromptBox)kDBizPromptBoxStocker, (StorageOrgUnitInfo)this.sou, (CoreUI)this);
        this.detailTable.getColumn(TB_STOCKER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxStocker));
        KDBizPromptBox bizAssistantUnitBox = new KDBizPromptBox();
        bizAssistantUnitBox.setEditFormat("$number$");
        bizAssistantUnitBox.setDisplayFormat("$name$");
        bizAssistantUnitBox.setCommitFormat("$number$");
        this.detailTable.getColumn(TB_ASSISTANTUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistantUnitBox));
        KDBizPromptBox bizBaseUnitBox = new KDBizPromptBox();
        bizAssistantUnitBox.setEditFormat("$number$");
        bizAssistantUnitBox.setDisplayFormat("$name$");
        bizAssistantUnitBox.setCommitFormat("$number$");
        this.detailTable.getColumn(TB_BASEUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBaseUnitBox));
        KDDatePicker KDDateMFG = new KDDatePicker();
        this.detailTable.getColumn(TB_MFG).setEditor((ICellEditor)new KDTDefaultCellEditor(KDDateMFG));
        KDDatePicker KDDateEXP = new KDDatePicker();
        this.detailTable.getColumn(TB_EXP).setEditor((ICellEditor)new KDTDefaultCellEditor(KDDateEXP));
        this.detailTable.getColumn(TB_STANDARDCOST).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)InvClientUtils.getNewFormatTxtField(this.localAmtPrecision, false)));
        this.detailTable.getColumn(TB_STANDARDCOST).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        InvClientUtils.fmtTableAmt(this.detailTable, TB_STANDARDCOST, this.localAmtPrecision);
        this.detailTable.getColumn(TB_UNITFACTCOST).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)InvClientUtils.getNewFormatTxtField(this.localAmtPrecision, false)));
        this.detailTable.getColumn(TB_UNITFACTCOST).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.detailTable.getColumn(TB_FACTCOST).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)InvClientUtils.getNewFormatTxtField(this.localAmtPrecision, false)));
        this.detailTable.getColumn(TB_FACTCOST).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        InvClientUtils.fmtTableAmt(this.detailTable, TB_FACTCOST, this.localAmtPrecision);
        SCMClientUtils.setNecessColorInTable((KDTable)this.detailTable, (String[])new String[]{TB_MATERIAL, TB_WAREHS, TB_UNIT, TB_QTY});
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.detailTable, (String[])new String[]{"remark"}, (int)255);
    }

    private Map getSrcEntry() throws EASBizException, BOSException {
        MoveInWarehsBillEntryInfo entry = null;
        HashSet<String> pkSet = new HashSet<String>(this.detailTable.getRowCount());
        int rowCount = this.detailTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            entry = (MoveInWarehsBillEntryInfo)this.detailTable.getRow(i).getUserObject();
            if (entry == null || entry.getSourceBillEntryId() == null) continue;
            pkSet.add(entry.getSourceBillEntryId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo(TB_QTY));
        view.getSelector().add(new SelectorItemInfo("reverseQty"));
        view.setFilter(filter);
        MoveInWarehsBillEntryCollection entryCol = MoveInWarehsBillEntryFactory.getRemoteInstance().getMoveInWarehsBillEntryCollection(view);
        HashMap<String, MoveInWarehsBillEntryInfo> result = new HashMap<String, MoveInWarehsBillEntryInfo>(entryCol.size());
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            result.put(entryCol.get(i).getId().toString(), entryCol.get(i));
        }
        return result;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.detailTable.getEditManager().stopEditing();
        String strTemp = "";
        int errorCount = 0;
        StringBuffer error = new StringBuffer();
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            int rowCount = this.getDetailTable().getRowCount();
            String[] checkCols = new String[]{TB_MATERIAL};
            for (int i = 0; i < rowCount; ++i) {
                if (!InvClientUtils.isRowBlankOnTable(this.getDetailTable(), i, checkCols)) continue;
                this.removeLine(this.getDetailTable(), i);
                --i;
                --rowCount;
            }
            if (rowCount == 0) {
                this.addLine(this.getDetailTable());
            }
            return;
        }
        StringBuffer sbSN = new StringBuffer();
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
        if (storage == null) {
            strTemp = InvClientUtils.getResource("moveInStorageOrgNotNull");
            this.showError(strTemp, (JComponent)this.prmtStorageOrgUnit);
        } else if (this.cou == null) {
            strTemp = InvClientUtils.getResource("StorageOrgNotHasCompanyOrg");
            this.showError(strTemp, (JComponent)this.prmtStorageOrgUnit);
        }
        StorageOrgUnitInfo storageOut = (StorageOrgUnitInfo)this.prmtMoveOutStorageOrgUnit.getData();
        if (storageOut == null) {
            strTemp = InvClientUtils.getResource("moveIssueStorageOrgNotNull");
            this.showError(strTemp, (JComponent)this.prmtMoveOutStorageOrgUnit);
        } else if (this.cou == null) {
            strTemp = InvClientUtils.getResource("StorageOrgNotHasCompanyOrg");
            this.showError(strTemp, (JComponent)this.prmtMoveOutStorageOrgUnit);
        }
        if (this.pkBizDate.getValue() == null) {
            strTemp = InvClientUtils.getResource("bizDateIsNull");
            this.showError(strTemp, (JComponent)this.pkBizDate);
        }
        if (this.inwardSetOff) {
            int rowCount = this.detailTable.getRowCount();
            if (rowCount == 0) {
                strTemp = InvClientUtils.getResource("EntryIsNull");
                MsgBox.showInfo((Component)((Object)this), (String)strTemp);
                SysUtil.abort();
            }
            MoveInWarehsBillEntryInfo entry = null;
            MoveInWarehsBillEntryInfo sourceEntry = null;
            Map entryMap = this.getSrcEntry();
            BigDecimal realCountervail = null;
            BigDecimal qty = null;
            BigDecimal sourceQty = null;
            BigDecimal sourceCountervail = null;
            KDFormattedTextField ktf = null;
            for (int i = 0; i < rowCount; ++i) {
                qty = (BigDecimal)this.detailTable.getCell(i, TB_QTY).getValue();
                if (qty == null || qty.compareTo(InvClientUtils.ZERO) == 0) {
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"QtyGreaterZero", (String[])new String[]{String.valueOf(i + 1)});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_QTY);
                } else {
                    entry = (MoveInWarehsBillEntryInfo)this.detailTable.getRow(i).getUserObject();
                    if (entry == null || entry.getSourceBillEntryId() == null) {
                        this.removeLine(this.detailTable, i);
                        --i;
                        --rowCount;
                        continue;
                    }
                    sourceEntry = (MoveInWarehsBillEntryInfo)entryMap.get(entry.getSourceBillEntryId().toString());
                    sourceQty = sourceEntry.getQty();
                    sourceCountervail = sourceEntry.getReverseQty();
                    realCountervail = sourceCountervail == null ? sourceQty : sourceQty.subtract(sourceCountervail);
                    ktf = (KDFormattedTextField)this.detailTable.getCell(i, TB_QTY).getEditor().getComponent();
                    if (qty.compareTo(realCountervail = realCountervail.setScale(ktf.getPrecision(), 4)) > 0) {
                        StringBuffer sb = new StringBuffer();
                        String realCountervailStr = NumericUtil.getDecimalFormatString((BigDecimal)realCountervail, (int)qty.scale());
                        sb.append(ResourceUtil.getMessage((String)this.invAddResource, (String)"OffSetQtyGreaterThanOld", (String[])new String[]{String.valueOf(i + 1), realCountervailStr}));
                        errorCount = this.buildErrorString(error, sb.toString(), i, errorCount, TB_QTY);
                    }
                }
                MaterialInfo materialNum = (MaterialInfo)this.detailTable.getRow(i).getCell(TB_MATERIAL).getValue();
                MeasureUnitInfo unit = (MeasureUnitInfo)this.detailTable.getRow(i).getCell(TB_UNIT).getValue();
                Object isSerialNumber = this.getDetailTable().getRow(i).getCell("isSerialNumber").getValue();
                if (!this.isNeedCheckSN(i) || isSerialNumber == null || !new Boolean(isSerialNumber.toString()).booleanValue() || materialNum == null || materialNum.getSeqUnit() == null || unit == null || !unit.getId().equals((Object)materialNum.getSeqUnit().getId())) continue;
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                boolean isSaveSN = false;
                if (materialNum == null || materialNum.getId() == null) continue;
                MoveInWarehsBillEntryInfo entryInfo = (MoveInWarehsBillEntryInfo)this.getDetailTable().getRow(i).getUserObject();
                if (this.editData.getId() != null && entryInfo.getId() != null) {
                    String billID = this.editData.getId().toString();
                    filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
                    filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getId().toString().trim()));
                    filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialNum.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)entryInfo.getQty(), CompareType.GREATER_EQUALS));
                    ev.setFilter(filter);
                    ev.getSelector().add(new SelectorItemInfo("*"));
                    ev.getSelector().add(new SelectorItemInfo("entry.*"));
                    ev.getSorter().add(new SorterItemInfo("entry.seq"));
                    IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
                    MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
                    isSaveSN = snColl != null && snColl.size() != 0;
                }
                if (this.editData.get("ImportSN") != null) {
                    Hashtable htSN = (Hashtable)this.editData.get("ImportSN");
                    String lot = (String)this.detailTable.getCell(i, TB_BATCH).getValue();
                    if (lot != null && lot.length() > 0) {
                        String key = lot.trim() + materialNum.getId();
                        isSaveSN = htSN.get(key) != null;
                    }
                }
                if (isSaveSN) continue;
                strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"SerialNumberNotInput", (String[])new String[]{String.valueOf(i + 1)});
                sbSN.append(strTemp + '\n');
                this.detailTable.requestFocus();
                this.detailTable.getEditManager().editCellAt(i, 0);
            }
            if (sbSN.toString().length() > 0) {
                if (InvCommonUtils.isSerialRequired(this.sou.getId().toString(), null).booleanValue()) {
                    MsgBox.showInfo((Component)((Object)this), (String)sbSN.toString());
                    SysUtil.abort();
                } else {
                    sbSN.append('\n' + InvClientUtils.getResource("SN_CONFIRM_NOT_INPUT"));
                    int answer = MsgBox.showConfirm2((Component)((Object)this), (String)sbSN.toString());
                    if (answer != 0) {
                        SysUtil.abort();
                    }
                }
            }
            this.showError(error.toString());
            return;
        }
        int rowCount = this.detailTable.getRowCount();
        boolean notHasRow = true;
        if (rowCount > 0) {
            for (int index = rowCount - 1; !(index < 0 || notHasRow && index == 0); --index) {
                if (this.isEntryCurrentRowEmpty(this.detailTable, index)) {
                    this.detailTable.getEditManager().stopEditing();
                    this.removeLine(this.detailTable, index);
                    continue;
                }
                notHasRow = false;
            }
        } else {
            strTemp = InvClientUtils.getResource("EntryIsNull");
            this.showError(strTemp);
        }
        rowCount = this.detailTable.getRowCount();
        if (rowCount > 0) {
            MaterialInfo materialNum = null;
            MeasureUnitInfo unit = null;
            WarehouseInfo warehouse = null;
            LocationInfo location = null;
            BigDecimal qty = null;
            Object o = null;
            AsstAttrValueInfo asst = null;
            for (int i = 0; i < rowCount; ++i) {
                materialNum = (MaterialInfo)this.detailTable.getRow(i).getCell(TB_MATERIAL).getValue();
                if (materialNum == null || materialNum.getId() == null) {
                    strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_MATERIAL).getValue().toString();
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_MATERIAL);
                } else {
                    asst = (AsstAttrValueInfo)this.detailTable.getCell(i, "assistantAttr").getValue();
                    if (asst == null && materialNum.getAssistAttr() != null) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell("assistantAttr").getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, "assistantAttr");
                    }
                }
                unit = (MeasureUnitInfo)this.detailTable.getRow(i).getCell(TB_UNIT).getValue();
                if (unit == null || unit.getId() == null) {
                    strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_UNIT).getValue().toString();
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_UNIT);
                }
                if ((warehouse = (WarehouseInfo)this.detailTable.getRow(i).getCell(TB_WAREHS).getValue()) == null || warehouse.getId() == null) {
                    strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_WAREHS).getValue().toString();
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_WAREHS);
                }
                location = (LocationInfo)this.detailTable.getCell(i, TB_LOCATION).getValue();
                if (warehouse != null && warehouse.isHasLocation() && location == null) {
                    strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_LOCATION).getValue().toString();
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_LOCATION);
                }
                if ((o = this.detailTable.getRow(i).getCell(TB_QTY).getValue()) != null && StringUtil.isNumber((String)o.toString())) {
                    qty = new BigDecimal(o.toString());
                }
                if (qty == null || qty.compareTo(InvClientUtils.ZERO) == 0) {
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"QtyGreaterZero", (String[])new String[]{String.valueOf(i + 1)});
                    errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_QTY);
                }
                if (materialNum != null) {
                    boolean isPeriodVaild;
                    Object batch;
                    MaterialInventoryInfo materialInvInfo = this.fetchData.getMaterialInventory(materialNum.getId().toString(), storage.getId().toString());
                    if (materialInvInfo == null) {
                        materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialNum.getId().toString(), storage.getId().toString());
                    }
                    if (materialInvInfo != null && materialInvInfo.isIsLotNumber() && ((batch = this.detailTable.getCell(i, TB_BATCH).getValue()) == null || batch.toString().length() <= 0)) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_BATCH).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_BATCH);
                    }
                    boolean bl = isPeriodVaild = this.detailTable.getRow(i).getCell(this.detailTable.getColumnIndex("periodValidUnit")).getValue() != null;
                    if (isPeriodVaild && (this.detailTable.getRow(i).getCell(TB_MFG).getValue() == null || this.detailTable.getRow(i).getCell(TB_EXP).getValue() == null)) {
                        strTemp = InvClientUtils.getResource("EXPMFGISNULL");
                        errorCount = this.detailTable.getRow(i).getCell(TB_MFG).getValue() == null ? this.buildErrorString(error, strTemp, i, errorCount, TB_MFG) : this.buildErrorString(error, strTemp, i, errorCount, TB_EXP);
                    }
                }
                Object isSerialNumber = this.getDetailTable().getRow(i).getCell("isSerialNumber").getValue();
                if (this.isNeedCheckSN(i) && isSerialNumber != null && new Boolean(isSerialNumber.toString()).booleanValue() && materialNum != null && materialNum.getSeqUnit() != null && unit != null && unit.getId().equals((Object)materialNum.getSeqUnit().getId())) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    boolean isSaveSN = false;
                    if (materialNum != null && materialNum.getId() != null) {
                        MoveInWarehsBillEntryInfo entryInfo = (MoveInWarehsBillEntryInfo)this.getDetailTable().getRow(i).getUserObject();
                        if (this.editData.getId() != null && entryInfo.getId() != null) {
                            String billID = this.editData.getId().toString();
                            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
                            filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getId().toString().trim()));
                            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialNum.getId().toString()));
                            filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)entryInfo.getQty(), CompareType.GREATER_EQUALS));
                            ev.setFilter(filter);
                            ev.getSelector().add(new SelectorItemInfo("entry.*"));
                            ev.getSorter().add(new SorterItemInfo("entry.seq"));
                            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
                            MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
                            isSaveSN = snColl != null && snColl.size() != 0;
                        }
                        if (this.editData.get("ImportSN") != null) {
                            Hashtable htSN = (Hashtable)this.editData.get("ImportSN");
                            String lot = (String)this.detailTable.getCell(i, TB_BATCH).getValue();
                            if (lot != null && lot.length() > 0) {
                                String key = lot.trim() + materialNum.getId();
                                isSaveSN = htSN.get(key) != null;
                            }
                        }
                        if (!isSaveSN) {
                            strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"SerialNumberNotInput", (String[])new String[]{String.valueOf(i + 1)});
                            sbSN.append(strTemp + '\n');
                            this.detailTable.requestFocus();
                            this.detailTable.getEditManager().editCellAt(i, 0);
                        }
                    }
                }
                this.detailTable.getEditManager().stopEditing();
            }
            if (sbSN.toString().length() > 0) {
                if (InvCommonUtils.isSerialRequired(this.sou.getId().toString(), null).booleanValue()) {
                    MsgBox.showInfo((Component)((Object)this), (String)sbSN.toString());
                    SysUtil.abort();
                } else {
                    sbSN.append('\n' + InvClientUtils.getResource("SN_CONFIRM_NOT_INPUT"));
                    int answer = MsgBox.showConfirm2((Component)((Object)this), (String)sbSN.toString());
                    if (answer != 0) {
                        SysUtil.abort();
                    }
                }
            }
            this.showError(error.toString());
            InvClientUtils.checkDuplicateLot(this.detailTable, TB_MATERIAL);
        }
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSubmit || e.getSource() == this.menuItemSubmit)) {
            InvClientUtils.checkForOffSet(this.editData);
        }
    }

    private boolean isEntryCurrentRowEmpty(KDTable kdTable, int currentRow) {
        boolean empty = true;
        int totalRows = ENTRYCOLUMNS.length;
        for (int i = 0; i < totalRows; ++i) {
            if (kdTable.getRow(currentRow).getCell(ENTRYCOLUMNS[i]).getValue() == null) continue;
            return false;
        }
        return empty;
    }

    public void tableValueChanged(KDTEditEvent e) throws Exception {
        int colIsPresent;
        WarehouseInfo tempWI;
        IRow iRow;
        WarehouseInfo wi;
        TransactionTypeInfo tti;
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        IRow curRow = kDTable.getRow(selectRow);
        String colName = kDTable.getColumnKey(e.getColIndex());
        if (TB_PROJECTNUM.equals(colName) && e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            this.detailTable.getCell(selectRow, this.detailTable.getColumnIndex(TB_TRACKNUM)).setValue(null);
            UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveOutStorageOrgUnit, (KDTable)this.detailTable, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        }
        int colFactCost = kDTable.getColumnIndex(TB_FACTCOST);
        int colUnitFactCost = kDTable.getColumnIndex(TB_UNITFACTCOST);
        int colMaterialNum = kDTable.getColumnIndex(TB_MATERIAL);
        int colQty = kDTable.getColumnIndex(TB_QTY);
        int colWarehouse = kDTable.getColumnIndex(TB_WAREHS);
        int colStocker = kDTable.getColumnIndex(TB_STOCKER);
        int colLocation = this.getDetailTable().getColumnIndex(TB_LOCATION);
        int colUnit = kDTable.getColumnIndex(TB_UNIT);
        int colLot = kDTable.getColumnIndex(TB_BATCH);
        int colMfg = kDTable.getColumnIndex(TB_MFG);
        int colExp = kDTable.getColumnIndex(TB_EXP);
        int col_customer = kDTable.getColumnIndex("customer");
        int col_supplier = kDTable.getColumnIndex("supplier");
        int colUnitPrice = kDTable.getColumnIndex(TB_PRICE);
        int colAmount = kDTable.getColumnIndex(TB_AMOUNT);
        this.fillAllEntriesByFirstRow(e.getValue(), this.getDetailTable().getColumnKey(e.getColIndex()), e.getRowIndex());
        if (selectCol == colQty) {
            this.qtyChanged(selectRow);
        }
        if (selectCol == colFactCost) {
            this.calEntryUnitActualCostByTotal(selectRow);
        }
        if (selectCol == colUnitFactCost) {
            this.calEntryActualCostByUnitCost(selectRow, this.localAmtPrecision);
        }
        MaterialInfo mi = null;
        Object temp = kDTable.getCell(selectRow, colMaterialNum).getValue();
        if (!(temp instanceof MaterialInfo)) {
            if (temp == null) {
                InvClientUtils.setCellValueNull(this.detailTable, null, selectRow, true);
                InvClientUtils.setColLock(this.detailTable, LOCKCOLS, selectRow, true);
            }
            return;
        }
        mi = (MaterialInfo)temp;
        if (selectCol == colMaterialNum && (mi == null || mi instanceof MaterialInfo)) {
            InvClientUtils.setCellValueNull(this.detailTable, null, selectRow, true);
            if (mi == null) {
                InvClientUtils.setColLock(this.detailTable, LOCKCOLS, selectRow, true);
                return;
            }
            InvClientUtils.setColLock(this.detailTable, LOCKCOLS, selectRow, false);
            this.materialChanged(mi, selectRow);
        }
        if (this.pkBizDate.getValue() != null) {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
        }
        if (colAmount == selectCol) {
            BigDecimal amount = (BigDecimal)kDTable.getCell(selectRow, TB_AMOUNT).getValue();
            BigDecimal qty = (BigDecimal)kDTable.getRow(selectRow).getCell(TB_QTY).getValue();
            if (qty == null || amount == null || qty.compareTo(InvClientUtils.ZERO) == 0) {
                kDTable.getCell(selectRow, TB_PRICE).setValue((Object)InvClientUtils.ZERO);
            } else {
                MaterialInfo materialInfo = (MaterialInfo)kDTable.getCell(selectRow, TB_MATERIAL).getValue();
                if (materialInfo != null) {
                    BigDecimal price = amount.divide(qty, materialInfo.getPricePrecision(), 4);
                    kDTable.getCell(selectRow, TB_PRICE).setValue((Object)price);
                }
            }
        }
        if (selectCol == colUnitPrice || selectCol == colQty) {
            BigDecimal qty = InvClientUtils.ZERO;
            BigDecimal price = InvClientUtils.ZERO;
            String str = null;
            Object o = kDTable.getRow(selectRow).getCell(TB_QTY).getValue();
            if (o != null && (str = o.toString()) != null && StringUtil.isNumber((String)str)) {
                qty = new BigDecimal(str);
            }
            if ((o = kDTable.getRow(selectRow).getCell(TB_PRICE).getValue()) != null && (str = o.toString()) != null && StringUtil.isNumber((String)str)) {
                price = new BigDecimal(str);
            }
            BigDecimal amount = qty.multiply(price);
            amount = amount.setScale(this.localAmtPrecision, 4);
            kDTable.getRow(selectRow).getCell(TB_AMOUNT).setValue((Object)amount);
        }
        if ((tti = this.editData.getTransactionType()) == null) {
            this.editData.setTransactionType(this.prmtTransactionType.getValue() == null ? null : (TransactionTypeInfo)this.prmtTransactionType.getValue());
        }
        boolean isReversed = this.editData.isIsReversed();
        if (selectCol == colMfg) {
            InvClientUtils.setEXP(kDTable, selectRow, tti, isReversed, this.isExpMinusOne(), this.sou, mi, this.fetchData, this.editData);
        }
        if (selectCol == colExp) {
            this.expChanged(selectRow, isReversed);
            InvClientUtils.setMFG(kDTable, selectRow, tti, isReversed, this.isExpMinusOne(), this.sou, mi, this.editData, this.fetchData);
        }
        if (selectCol == colLot) {
            if (curRow.getCell(colLot).getValue() != null) {
                StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                String lot = curRow.getCell(colLot).getValue().toString();
                InvClientUtils.setLotInfo(kDTable, selectRow, this.editData.getStorageOrgUnit(), mi, lot, this.editData, this.fetchData);
                InvClientUtils.checkEXP(kDTable, selectRow, tti, isReversed, sou, mi, this.editData);
            } else {
                InvClientUtils.setLotInfo(kDTable, selectRow, this.editData.getStorageOrgUnit(), mi, "", this.editData, this.fetchData);
                curRow.getCell(TB_MFG).setValue(null);
                curRow.getCell(TB_EXP).setValue(null);
            }
        }
        if (selectCol == colWarehouse) {
            this.sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            WarehouseInfo warehouse = (WarehouseInfo)kDTable.getCell(selectRow, TB_WAREHS).getValue();
            boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
            if (isUseWarehsRelation) {
                InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehouse, mi, this.fetchData, this.getDetailTable(), selectRow, false);
            } else {
                this.setLocationColProperty(warehouse, selectRow, true);
            }
            if (warehouse != null && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()))) {
                PersonInfo stocker;
                if (warehouse.getWhman() == null || warehouse.getWhman().getName() == null) {
                    if (this.fetchData.getDefaultStocker(warehouse.getId().toString()) == null) {
                        ObjectUuidPK pk = new ObjectUuidPK(warehouse.getId());
                        IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                        SelectorItemCollection sc = new SelectorItemCollection();
                        sc.add(new SelectorItemInfo("*"));
                        sc.add(new SelectorItemInfo("number"));
                        sc.add(new SelectorItemInfo("name"));
                        sc.add(new SelectorItemInfo("hasLocation"));
                        sc.add(new SelectorItemInfo("whman.id"));
                        sc.add(new SelectorItemInfo("whman.number"));
                        sc.add(new SelectorItemInfo("whman.name"));
                        warehouse = iWarehouse.getWarehouseInfo((IObjectPK)pk, sc);
                        stocker = warehouse.getWhman();
                        this.fetchData.putDefaultStocker(warehouse.getId().toString(), stocker);
                    } else {
                        stocker = this.fetchData.getDefaultStocker(warehouse.getId().toString());
                    }
                } else {
                    stocker = warehouse.getWhman();
                }
                if (this.isActionF12 && curRow.getCell(TB_STOCKER).getValue() == null || !this.isActionF12) {
                    curRow.getCell(this.getDetailTable().getColumnIndex(TB_STOCKER)).setValue((Object)stocker);
                }
                if (this.batchCarryWarehouseLocation && selectRow == 0) {
                    int rowCount = this.getDetailTable().getRowCount();
                    IRow iRow2 = null;
                    WarehouseInfo tempWI2 = null;
                    MaterialInfo tempMi = null;
                    boolean isCopy = false;
                    for (int i = 1; i < rowCount; ++i) {
                        iRow2 = this.getDetailTable().getRow(i);
                        tempWI2 = (WarehouseInfo)iRow2.getCell(TB_WAREHS).getValue();
                        tempMi = (MaterialInfo)iRow2.getCell(TB_MATERIAL).getValue();
                        isCopy = false;
                        if (tempWI2 == null && tempMi != null) {
                            isCopy = true;
                            if (isUseWarehsRelation && !tempMi.getId().equals((Object)mi.getId())) {
                                isCopy = false;
                            }
                        }
                        if (!isCopy) continue;
                        iRow2.getCell(TB_WAREHS).setValue((Object)warehouse);
                        iRow2.getCell(TB_STOCKER).setValue((Object)stocker);
                        if (tempMi != null && tempMi.getId() != null && this.sou != null && this.sou.getId() != null) {
                            MaterialInventoryInfo materialInvInfo = this.fetchData.getMaterialInventory(tempMi.getId().toString(), this.sou.getId().toString());
                            if (materialInvInfo == null) {
                                materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(tempMi.getId().toString(), this.sou.getId().toString());
                            }
                            if (materialInvInfo != null && materialInvInfo.isIsLotNumber()) {
                                this.setLotAttribute(colName);
                                this.fillLotNumber(i);
                            }
                        }
                        if (isUseWarehsRelation) {
                            InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehouse, tempMi, this.fetchData, this.getDetailTable(), i, false);
                            continue;
                        }
                        InvClientUtils.setLocationFilter((CoreUIObject)this, this.sou, warehouse, tempMi, this.fetchData, this.getDetailTable(), i, false);
                    }
                }
            }
        }
        if (selectCol == colStocker && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()))) {
            wi = (WarehouseInfo)curRow.getCell(colWarehouse).getValue();
            PersonInfo aPersonInfo = (PersonInfo)curRow.getCell(colStocker).getValue();
            if (wi != null && aPersonInfo != null && selectRow == 0) {
                int rowCount = this.getDetailTable().getRowCount();
                iRow = null;
                tempWI = null;
                PersonInfo tempPs = null;
                for (int i = 1; i < rowCount; ++i) {
                    iRow = this.getDetailTable().getRow(i);
                    tempWI = (WarehouseInfo)iRow.getCell(colWarehouse).getValue();
                    tempPs = (PersonInfo)iRow.getCell(colStocker).getValue();
                    if (tempWI == null || tempPs != null || !tempWI.getId().toString().equals(wi.getId().toString())) continue;
                    iRow.getCell(colStocker).setValue((Object)aPersonInfo);
                }
            }
        }
        if (selectCol == colLocation) {
            wi = (WarehouseInfo)curRow.getCell(TB_WAREHS).getValue();
            LocationInfo aLocationInfo = (LocationInfo)curRow.getCell(TB_LOCATION).getValue();
            if (this.batchCarryWarehouseLocation && selectRow == 0 && wi != null) {
                int rowCount = this.getDetailTable().getRowCount();
                iRow = null;
                tempWI = null;
                MaterialInfo tempMi = null;
                boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
                for (int i = 1; i < rowCount; ++i) {
                    iRow = this.getDetailTable().getRow(i);
                    tempWI = (WarehouseInfo)iRow.getCell(TB_WAREHS).getValue();
                    tempMi = (MaterialInfo)iRow.getCell(TB_MATERIAL).getValue();
                    if (isUseWarehsRelation) {
                        if (tempWI == null || !tempWI.getId().equals((Object)wi.getId()) || tempMi == null || !tempMi.getId().equals((Object)mi.getId()) || iRow.getCell(TB_LOCATION).getValue() != null) continue;
                        iRow.getCell(TB_LOCATION).setValue((Object)aLocationInfo);
                        continue;
                    }
                    if (tempWI == null || !tempWI.getId().equals((Object)wi.getId()) || iRow.getCell(TB_LOCATION).getValue() != null) continue;
                    iRow.getCell(TB_LOCATION).setValue((Object)aLocationInfo);
                }
            }
        }
        if (selectCol == colUnit) {
            this.unitChanged(selectRow);
            MeasureUnitInfo muOld = (MeasureUnitInfo)e.getOldValue();
            MeasureUnitInfo mu = (MeasureUnitInfo)kDTable.getRow(selectRow).getCell(TB_UNIT).getValue();
            BigDecimal price = (BigDecimal)kDTable.getCell(selectRow, TB_PRICE).getValue();
            price = InvClientUtils.getUnitPrice(mu, muOld, mi, price);
            kDTable.getCell(selectRow, TB_PRICE).setValue((Object)price);
        }
        if (selectCol == (colIsPresent = kDTable.getColumnIndex(TB_ISPRESENT))) {
            super.calEntryCost4IsPresentChanged(selectRow, this.localAmtPrecision);
        }
        if (selectCol == colExp || selectCol == colMfg || selectCol == colWarehouse || selectCol == col_customer || selectCol == col_supplier) {
            this.sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (mi != null && mi.getId() != null && this.sou != null && this.sou.getId() != null) {
                MaterialInventoryInfo materialInvInfo = this.fetchData.getMaterialInventory(mi.getId().toString(), this.sou.getId().toString());
                if (materialInvInfo == null) {
                    materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(mi.getId().toString(), this.sou.getId().toString());
                }
                if (materialInvInfo != null && materialInvInfo.isIsLotNumber()) {
                    this.setLotAttribute(colName);
                    this.fillLotNumber(selectRow);
                    this.setLotAttribute(null);
                }
            }
        }
        if (selectCol == kDTable.getColumnIndex(TB_MATERIAL) || selectCol == kDTable.getColumnIndex(TB_UNIT) || selectCol == kDTable.getColumnIndex("assistantAttr") || selectCol == kDTable.getColumnIndex(TB_BATCH) || selectCol == kDTable.getColumnIndex(TB_WAREHS) || selectCol == kDTable.getColumnIndex(TB_LOCATION)) {
            this.checkDupRecord(selectRow, selectCol);
        }
        this.setQtyBaseQtyAssisQty(this.getDetailTable(), selectRow, selectCol);
    }

    private void unitChanged(int rowIndex) throws EASBizException, BOSException {
        IRow curRow = this.detailTable.getRow(rowIndex);
        MeasureUnitInfo mulitInfo = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        this.detailTable.removeKDTEditListener((KDTEditListener)this.myEnent);
        if (mulitInfo == null || materialInfo == null) {
            curRow.getCell(TB_QTY).setValue(null);
            curRow.getCell(TB_QTY).getStyleAttributes().setLocked(true);
        } else {
            this.changeSerialNumberEnable(curRow, mulitInfo, materialInfo);
            curRow.getCell(TB_QTY).getStyleAttributes().setLocked(false);
            SCMClientUtils.changeCellPrecisionByMaterial((SCMFetchData)this.fetchData, (String[])QTYPRECISIONTAB, (IRow)curRow, (boolean)this.isNegativeBill);
        }
        this.calEntryQty4UnitChanged(rowIndex);
        this.calEntryCost4UnitChanged(rowIndex, this.localAmtPrecision);
        this.detailTable.addKDTEditListener((KDTEditListener)this.myEnent);
    }

    private void qtyChanged(int rowIndex) throws EASBizException, BOSException {
        IRow curRow = this.detailTable.getRow(rowIndex);
        MaterialInfo materialNum = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        if (this.editData != null && this.editData.getSourceBillType() != null && materialNum == null) {
            return;
        }
        BigDecimal qty = SCMConstant.BIGDECIMAL_ZERO;
        if (curRow.getCell(TB_QTY).getValue() instanceof BigDecimal) {
            qty = (BigDecimal)curRow.getCell(TB_QTY).getValue();
        }
        MaterialInfo material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        ICell baseCell = curRow.getCell(TB_BASEUNITQTY);
        BigDecimal baseQty = null;
        if (material != null && unit != null) {
            baseQty = InvClientUtils.getBaseUnitQty(unit, material, qty);
            baseCell.setValue((Object)baseQty);
        }
        this.calEntryCost4QtyChanged(rowIndex, this.localAmtPrecision);
    }

    private int buildErrorString(StringBuffer error, String strTemp, int rowIndex, int errorCount, String col) {
        ++errorCount;
        if (error.toString().length() != 0) {
            error.append("\r\n");
        }
        if (errorCount == 1) {
            this.indexRow = rowIndex;
            this.indexCol = this.detailTable.getColumnIndex(col);
        }
        error.append(strTemp);
        if (errorCount > 4) {
            this.showError(error.toString());
        }
        return errorCount;
    }

    private void showError(String error) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            if (this.indexRow != -1) {
                this.detailTable.getEditManager().editCellAt(this.indexRow, this.indexCol);
                this.indexRow = -1;
                this.indexCol = -1;
            }
            SysUtil.abort();
        }
    }

    private void showError(String error, JComponent component) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            component.requestFocus();
            SysUtil.abort();
        }
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        Object source = e.getSource();
        if (source.equals(this.prmtAdminOrg)) {
            this.adminOrgChanged(e);
        } else if (source.equals(this.pkBizDate)) {
            this.bizDateChanged(e);
        } else if (e.getSource().equals(this.prmtStorageOrgUnit)) {
            this.txtPurOrgChange(e);
        } else if (source.equals(this.getTransacationTypeF7())) {
            try {
                this.transactionTypeChanged(e);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    protected void txtPurOrgChange(DataChangeEvent e) {
        try {
            if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
                for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
                    this.detailTable.getCell(i, this.detailTable.getColumnIndex(TB_PROJECTNUM)).setValue(null);
                    this.detailTable.getCell(i, this.detailTable.getColumnIndex(TB_TRACKNUM)).setValue(null);
                }
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    private void adminOrgChanged(DataChangeEvent e) {
        this.setLotAttribute("department");
        this.fillLotNumber(-1);
        this.setLotAttribute(null);
    }

    private void bizDateChanged(DataChangeEvent e) {
        int bizDirection;
        if (e.getNewValue() != null) {
            String oldValue;
            Date date = (Date)e.getNewValue();
            Date date2 = (Date)e.getOldValue();
            String newValue = DateTimeUtil.getFmtDate((Date)date);
            if (newValue.equals(oldValue = DateTimeUtil.getFmtDate((Date)date2))) {
                return;
            }
        }
        KDTable table = this.getDetailTable();
        TransactionTypeInfo tti = this.editData.getTransactionType();
        int n = bizDirection = tti == null ? 1 : tti.getRiType().getBizDirection().getValue();
        if (bizDirection == -1) {
            return;
        }
        if (this.pkBizDate.getValue() != null) {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            ICell cellLotFrame = table.getCell(i, "lotFrame");
            if (cellLotFrame == null) {
                return;
            }
            LotFrame lotFrame = (LotFrame)cellLotFrame.getValue();
            if (lotFrame == null) {
                return;
            }
            LotRuleInfo lotRult = lotFrame.getLotRule();
            if (LotRuleInfo.containsBizDate((LotRuleInfo)lotRult)) {
                this.setLotAttribute("bizDate");
                this.fillLotNumber(i);
                this.setLotAttribute(null);
            }
            MaterialInfo material = (MaterialInfo)table.getCell(i, this.getMaterialName()).getValue();
            IRow curRow = this.detailTable.getRow(i);
            Date mfg = (Date)curRow.getCell(this.getMfgName()).getValue();
            Date exp = (Date)curRow.getCell(this.getExpName()).getValue();
            if (mfg == null || exp == null) continue;
            if (exp.before(mfg) && !exp.equals(mfg)) {
                this.detailTable.getEditManager().editCellAt(this.detailTable.getColumnIndex(this.getExpName()), i);
                MsgBox.showInfo((String)InvClientUtils.getResource("EXPBEFOREMFG"));
                continue;
            }
            Calendar c = Calendar.getInstance();
            c.setTime(exp);
            try {
                String msg;
                int ret;
                MaterialInventoryInfo materialInventory = this.fetchData.getMaterialInventory(material.getId().toString(), this.sou.getId().toString());
                if (materialInventory == null) {
                    materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), this.sou.getId().toString());
                }
                if (materialInventory == null || materialInventory.getPeriodValid() != 1) continue;
                int InWarehsAhead = materialInventory.getInWarehsAhead();
                if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                    c.add(1, -InWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                    c.add(2, -InWarehsAhead);
                } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                    c.add(5, -InWarehsAhead);
                }
                if (!c.getTime().before(this.editData.getBizDate()) || (ret = MsgBox.showConfirm3((Component)((Object)this), (String)(msg = InvClientUtils.getResource("EXPVALID")))) == 0) continue;
                curRow.getCell(this.getExpName()).setValue(null);
                curRow.getCell(this.getMfgName()).setValue(null);
                this.detailTable.getEditManager().editCellAt(this.detailTable.getColumnIndex(this.getExpName()), i);
                continue;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex);
                continue;
            }
            catch (BOSException ex) {
                logger.error((Object)ex);
            }
        }
    }

    private void storageOrgPreChange(PreChangeEvent e) {
        try {
            if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
                return;
            }
            if (e.getData() != null && e.getData().equals(e.getOldData())) {
                return;
            }
            if (e.getData() != null && e.getOldData() != null) {
                StorageOrgUnitInfo soNew = (StorageOrgUnitInfo)e.getData();
                StorageOrgUnitInfo soOld = (StorageOrgUnitInfo)e.getOldData();
                if (soNew.getId().equals((Object)soOld.getId())) {
                    return;
                }
            }
            this.sou = InvClientUtils.getStorageOrgUnitInfo(e);
            if (this.sou != null) {
                CompanyOrgUnitInfo couNew = null;
                if (this.sou != null) {
                    couNew = this.getCouBySou(this.sou);
                }
                if (couNew == null) {
                    MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                    e.setResult(0);
                } else {
                    if (!this.checkEntryIsBlank()) {
                        String strTemp = InvClientUtils.getResource("CLEARENTRYAFTERORGCHANGED");
                        int ret = MsgBox.showConfirm2((String)strTemp);
                        if (ret == 2) {
                            e.setResult(0);
                            return;
                        }
                        this.cleanEntry();
                        this.addLine(this.detailTable);
                        this.getDetailTable().getSelectManager().select(0, 0);
                    }
                    this.editData.setReceiptCompanyOrgUnit(couNew);
                    this.cou = couNew;
                    if (this.cou.getBaseCurrency() != null && this.cou.getBaseCurrency().getName() == null) {
                        this.cou.setBaseCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId())));
                        this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                    }
                    if (this.cou != null) {
                        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.cou.getBaseCurrency(), (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
                    }
                    try {
                        this.getKDBizWarehouse().setEntityViewInfo(InvClientUtils.getWarehouseFilter(this.sou));
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                    this.detailTable.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
                }
                this.prmtAdminOrg.setData(null);
                KDBizPromptBox kDBizPromptBoxStocker = new KDBizPromptBox();
                kDBizPromptBoxStocker = SCMF7ContextUtils.setStockerF7ByStorageOrg((KDBizPromptBox)kDBizPromptBoxStocker, (StorageOrgUnitInfo)this.sou, (CoreUI)this);
                this.detailTable.getColumn(TB_STOCKER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxStocker));
            } else {
                if (!this.checkEntryIsBlank()) {
                    String strTemp = InvClientUtils.getResource("CLEARENTRYAFTERORGCHANGED");
                    int ret = MsgBox.showConfirm2((String)strTemp);
                    if (ret == 2) {
                        e.setResult(0);
                        return;
                    }
                    this.cleanEntry();
                    this.addLine(this.detailTable);
                    this.getDetailTable().getSelectManager().select(0, 0);
                }
                this.detailTable.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
            }
            this.getCostCenter().setValue(null);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private boolean checkEntryIsBlank() {
        int rows = this.detailTable.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (this.detailTable.getCell(i, TB_MATERIAL).getValue() == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void actionOffset_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getSourceBillType() != null && "18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(this.editData.getSourceBillType().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("NOTSUPPORT_OFFSET"));
            SysUtil.abort();
        }
        if (this.editData.getId() == null || !InvClientUtils.isOffSetable(this.editData)) {
            return;
        }
        if (this.isSysBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("SYSBILL_CANT_OFFSET"));
            SysUtil.abort();
        }
        MoveInWarehsBillInfo billInfo = this.editData;
        billInfo.setIsReversed(true);
        String sourebillNumber = billInfo.getNumber();
        billInfo.setNumber(null);
        MoveInWarehsBillEntryCollection entrys = billInfo.getEntry();
        MoveInWarehsBillEntryInfo entry = null;
        BigDecimal reverseQty = InvClientUtils.ZERO;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo assistUnit = null;
        MaterialInfo material = null;
        int entrySize = entrys.size();
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal qty;
            entry = entrys.get(i);
            if (entry.getId() == null) {
                entrys.removeObject((IObjectValue)entry);
                --i;
                --entrySize;
                continue;
            }
            entry.setParent(billInfo);
            entry.setSourceBillId(billInfo.getId().toString());
            entry.setSourceBillNumber(sourebillNumber);
            entry.setSourceBillEntryId(entry.getId().toString());
            entry.setSourceBillEntrySeq(entry.getSeq());
            BigDecimal oldQty = entry.getQty();
            if (oldQty == null) {
                oldQty = InvClientUtils.ZERO;
            }
            if ((reverseQty = entry.getReverseQty()) != null) {
                entry.setQty(entry.getQty().subtract(reverseQty));
            }
            entry.setReverseQty(InvClientUtils.ZERO);
            entry.setReverseBaseQty(InvClientUtils.ZERO);
            unit = entry.getUnit();
            material = entry.getMaterial();
            assistUnit = entry.getAssistUnit();
            entry.setBaseQty(InvClientUtils.getBaseUnitQty(unit, material, entry.getQty(), this.fetchData));
            if (assistUnit != null) {
                entry.setAssistQty(InvClientUtils.getAssUnitQty(assistUnit, material, entry.getBaseQty(), this.fetchData));
            }
            if ((qty = entry.getQty()) == null) {
                qty = InvClientUtils.ZERO;
            }
            if (oldQty.compareTo(qty) != 0) {
                this.initEntryCost4Reversed(entry, this.localAmtPrecision);
            }
            entry.setId(null);
        }
        billInfo.setSourceBillId(billInfo.getId().toString());
        billInfo.setId(null);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setVoucher(null);
        billInfo.setFiVouchered(false);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setLastUpdateUser(null);
        billInfo.setLastUpdateTime(null);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setModifier(null);
        billInfo.setModificationTime(null);
        billInfo.setFiVouchered(false);
        billInfo.setVoucher(null);
        billInfo.setSourceBillType(billInfo.getBillType());
        StorageOrgUnitInfo storage = this.editData.getStorageOrgUnit();
        this.setOprtState("ADDNEW");
        this.setNumEditableWhenUnitChange(storage.getId().toString());
        if (this.isAutoNumber) {
            this.isAddView = this.isAddView(storage.getId().toString());
            if (this.isAddView) {
                this.getNumTextField().setText(null);
                String newNum = this.getNewNumberByUnit(storage.getId().toString());
                this.getNumTextField().setText(newNum);
                billInfo.setNumber(newNum);
            }
        }
        this.setDataObject((IObjectValue)billInfo);
        this.setMakeRelations(null);
        this.unLockUI();
        this.loadFields();
        this.setDefaultFocused();
        this.bizPrmtBizType.setEnabled(false);
        this.prmtStorageOrgUnit.setEditable(false);
        this.prmtStorageOrgUnit.setAccessAuthority(1);
        this.getNumTextField().setEditable(this.getIsEditable());
        if (this.getIsEditable()) {
            this.getNumTextField().setAccessAuthority(0);
        } else {
            this.getNumTextField().setAccessAuthority(1);
        }
    }

    private void initSetOffBtn() {
        if (this.editData.isIsReversed() || this.editData.getId() == null || this.editData.getBaseStatus().getValue() != EntryBaseStatusEnum.AUDITED.getValue()) {
            this.actionOffset.setEnabled(false);
            this.btnOffset.setVisible(this.isCanOffSet);
        } else {
            this.actionOffset.setEnabled(true);
            this.btnOffset.setVisible(this.isCanOffSet);
        }
    }

    protected String getEntryMaterialFieldName() {
        return TB_MATERIAL;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.checkCanEdit();
        int entrySize = this.editData.getEntry().size();
        BigDecimal facost = InvClientUtils.ZERO;
        BigDecimal standardCost = InvClientUtils.ZERO;
        this.isReverse = this.editData.isIsReversed();
        if (this.isReverse && entrySize > 0) {
            this.editData.setTotalStandardCost(this.editData.getTotalStandardCost().negate());
            this.editData.setTotalActualCost(this.editData.getTotalActualCost().negate());
            for (int i = 0; i < entrySize; ++i) {
                MoveInWarehsBillEntryInfo entry = this.editData.getEntry().get(i);
                entry.setQty(entry.getQty().negate());
                entry.setBaseQty(entry.getBaseQty().negate());
                BigDecimal assQty = entry.getAssistQty();
                if (assQty != null) {
                    entry.setAssistQty(assQty.negate());
                }
                if ((facost = entry.getActualCost()) != null) {
                    entry.setActualCost(facost.negate());
                }
                if ((standardCost = entry.getStandardCost()) == null) continue;
                entry.setStandardCost(standardCost.negate());
            }
        }
        super.actionEdit_actionPerformed(e);
        this.initSetOffBtn();
        this.setOnlyActualCostEditable();
        this.syncOldData((IObjectValue)this.editData);
    }

    @Override
    protected void initDataStatus() {
        String viewStatus;
        super.initDataStatus();
        if (this.editData != null) {
            this.initSetOffBtn();
        }
        if ("ADDNEW".equals(this.getOprtState()) && this.editData.getId() == null && !this.isBotpBill()) {
            this.prmtStorageOrgUnit.setEnabled(true);
        }
        if (((viewStatus = this.getOprtState()).equalsIgnoreCase("EDIT") || viewStatus.equalsIgnoreCase("ADDNEW")) && (this.isReverse || this.isBOTP)) {
            this.detailTable.setEnabled(true);
            this.getNumTextField().setEnabled(true);
            if (this.isBOTP) {
                this.pkBizDate.setEnabled(true);
            }
        }
        if (this.editData != null && this.editData.getBaseStatus().getValue() == 4 && this.getUIContext().get("BillQuery") == null) {
            this.btnSave.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.menuItemSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.setOprtState("VIEW");
        }
        this.setControl();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = this.kDBizPromptBoxMaterial.getValue();
        if (o == null) {
            return;
        }
        if (!(o instanceof MaterialInfo[]) && !(o instanceof Object[])) {
            return;
        }
        KDTSelectBlock ksb = this.detailTable.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        MaterialInfo[] materialInfos = null;
        if (o instanceof MaterialInfo[]) {
            materialInfos = (MaterialInfo[])o;
        } else if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            if (objects.length == 0) {
                return;
            }
            materialInfos = new MaterialInfo[objects.length];
            System.arraycopy(objects, 0, materialInfos, 0, objects.length);
        } else {
            return;
        }
        int length = materialInfos.length;
        if (length > 0) {
            this.kDBizPromptBoxMaterial.removeChangeListener((ChangeListener)this);
            for (int i = 0; i < length; ++i) {
                if (materialInfos[i] == null) {
                    InvClientUtils.setCellValueNull(this.detailTable, null, beginRow + i, true);
                    InvClientUtils.setColLock(this.detailTable, LOCKCOLS, beginRow + i, true);
                    return;
                }
                IRow curRow2 = this.detailTable.getRow(beginRow + i);
                curRow2.getCell(TB_MATERIAL).setValue(null);
                curRow2.getCell(TB_MATERIAL).setValue((Object)materialInfos[i]);
                InvClientUtils.setCellValueNull(this.detailTable, null, beginRow + i, true);
                try {
                    this.fetchData.setMapMaterialInventory(new HashMap());
                    InvFetchDataUtils.setCacheData(this.sou, this.cou, materialInfos, this.fetchData);
                    this.materialChanged(materialInfos[i], beginRow + i);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
                if (i >= length - 1) continue;
                this.insertLine(beginRow + i + 1);
            }
            this.kDBizPromptBoxMaterial.addChangeListener((ChangeListener)this);
        }
    }

    private void materialChanged(MaterialInfo material, int selectRow) throws Exception {
        InvClientUtils.setColLock(this.detailTable, LOCKCOLS, selectRow, false);
        String materialName = "";
        String materialModel = "";
        if (material != null) {
            MeasureUnitInfo assUnit;
            materialName = material.getName();
            materialModel = material.getModel();
            this.initEntryUnitCell(selectRow, material);
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (storage != null) {
                MaterialInventoryInfo materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), storage.getId().toString());
                if (materialInvInfo != null) {
                    this.detailTable.getCell(selectRow, TB_UNIT).setValue((Object)materialInvInfo.getUnit());
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)material, (MeasureUnitInfo)materialInvInfo.getUnit(), (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int[])new int[]{selectRow});
                    if (materialInvInfo.isIsLotNumber()) {
                        SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_BATCH, (int)selectRow, (boolean)true);
                        LotFrame lotFrame = new LotFrame();
                        lotFrame.setSeq(selectRow);
                        lotFrame.setMainBizOrg(this.sou.getId().toString());
                        lotFrame.setMaterial(material.getId().toString());
                        this.lotFrameList.add(lotFrame);
                    } else {
                        SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)TB_BATCH, (int)selectRow, (boolean)false);
                        this.detailTable.getCell(selectRow, TB_BATCH).getStyleAttributes().setLocked(true);
                    }
                } else {
                    SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int[])new int[]{selectRow});
                    this.detailTable.getCell(selectRow, TB_UNIT).setValue(null);
                }
                WarehouseInfo wi = (WarehouseInfo)this.detailTable.getCell(selectRow, TB_WAREHS).getValue();
                InvClientUtils.setLocationFilter((CoreUIObject)this, storage, wi, material, this.fetchData, this.detailTable, selectRow, true);
                if (wi != null) {
                    this.detailTable.getCell(selectRow, TB_WAREHS).setValue((Object)wi);
                    PersonInfo stocker = wi.getWhman();
                    if (stocker != null) {
                        this.detailTable.getCell(selectRow, TB_STOCKER).setValue((Object)stocker);
                    }
                }
            }
            this.detailTable.getCell(selectRow, "assistantAttr").setValue(null);
            this.setEntryAssistProperty(selectRow, material);
            MeasureUnitInfo baseUnit = material.getBaseUnit();
            if (baseUnit != null) {
                String baseId = baseUnit.getId().toString();
                ObjectUuidPK pk = new ObjectUuidPK(baseId);
                baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                this.detailTable.getCell(selectRow, TB_BASEUNIT).setValue((Object)baseUnit);
                int scale = InvClientUtils.getMeasueUnitScale(material.getId().toString(), baseId);
                SCMClientUtils.changeTableColPrecision((int)scale, (KDTable)this.detailTable, (String[])BASEQTY_PRECISION_TAB, (int)selectRow);
            }
            if ((assUnit = material.getAssistUnit()) != null) {
                String assId = assUnit.getId().toString();
                ObjectUuidPK pk = new ObjectUuidPK(assId);
                assUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                this.detailTable.getCell(selectRow, TB_ASSISTQTY).getStyleAttributes().setLocked(false);
                int scale = InvClientUtils.getMeasueUnitScale(material.getId().toString(), assId);
                SCMClientUtils.changeTableColPrecision((int)scale, (KDTable)this.detailTable, (String[])ASSQTY_PRECISION_TAB, (int)selectRow);
            } else {
                this.detailTable.getCell(selectRow, TB_ASSISTQTY).getStyleAttributes().setLocked(true);
                this.detailTable.getCell(selectRow, TB_ASSISTQTY).setValue(null);
            }
            this.detailTable.getCell(selectRow, TB_ASSISTANTUNIT).setValue((Object)assUnit);
            int pricePrecision = material.getPricePrecision();
            SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.detailTable, (String[])PRICE_PRECISION_TAB, (int)selectRow);
        }
        this.detailTable.getRow(selectRow).getCell(TB_MATERIALNAME).setValue((Object)materialName);
        this.detailTable.getRow(selectRow).getCell(TB_MATERIALMODEL).setValue((Object)materialModel);
        this.calEntryCost4MaterialChanged(selectRow, this.localAmtPrecision);
    }

    protected void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo) {
        if (materialInfo != null) {
            AsstAttrTypeInfo asst = materialInfo.getAssistAttr();
            if (asst != null && !this.editData.isIsReversed()) {
                KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
                SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)bizAssistPropertyBox, (MaterialInfo)materialInfo, (IUIObject)this);
                bizAssistPropertyBox.setDisplayFormat("$number$");
                this.detailTable.getRow(rowIndex).getCell("assistantAttr").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
                this.detailTable.getRow(rowIndex).getCell("assistantAttr").getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)"assistantAttr", (int)rowIndex, (boolean)true);
            } else {
                this.detailTable.getRow(rowIndex).getCell("assistantAttr").getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.detailTable, (String)"assistantAttr", (int)rowIndex, (boolean)false);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("entry.companyOrgUnit"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.number"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.name"));
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("billType.number"));
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("bizType"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("isSysBill"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvBillBaseSelector((boolean)true));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntryName()));
        selector.add(new SelectorItemInfo("entry.reservationId"));
        selector.add(new SelectorItemInfo("entry.reservationBillObjectId"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.name"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.number"));
        return selector;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.detailTable.removeKDTEditListener((KDTEditListener)this.myEnent);
        this.detailTable.addKDTEditListener((KDTEditListener)this.myEnent);
        this.prmtAdminOrg.addDataChangeListener((DataChangeListener)this);
        this.pkBizDate.addDataChangeListener((DataChangeListener)this);
        this.prmtStorageOrgUnit.addDataChangeListener((DataChangeListener)this);
        this.prmtTransactionType.addDataChangeListener((DataChangeListener)this);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        if (this.detailTable != null) {
            this.detailTable.removeKDTEditListener((KDTEditListener)this.myEnent);
        }
        this.prmtAdminOrg.removeDataChangeListener((DataChangeListener)this);
        this.pkBizDate.removeDataChangeListener((DataChangeListener)this);
        this.prmtStorageOrgUnit.removeDataChangeListener((DataChangeListener)this);
        this.prmtTransactionType.removeDataChangeListener((DataChangeListener)this);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        this.invokePrintFunction(noPreview);
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MoveInWarehsPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/InWarehs/MoveInWarehsBill";
    }

    protected void setColumnProperty(MaterialInfo materialInfo, int row, int col, boolean isOnload) throws Exception {
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.initEntry(row, storage);
    }

    protected boolean isSplitLine() {
        return true;
    }

    protected List getSplitLineData(SCMBillEntryBaseInfo entryInfo, int splitNum, int splitType) {
        if (splitType == 1) {
            return this._getCopyLineData(entryInfo, splitNum, false);
        }
        ArrayList<MoveInWarehsBillEntryAgent> entryList = new ArrayList<MoveInWarehsBillEntryAgent>();
        MoveInWarehsBillEntryAgent aEntryInfo = null;
        for (int i = 1; i < splitNum; ++i) {
            aEntryInfo = MoveInWarehsBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            aEntryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    private List _getCopyLineData(SCMBillEntryBaseInfo entryInfo, int splitNum, boolean needCleanQty) {
        ArrayList<MoveInWarehsBillEntryAgent> entryList = new ArrayList<MoveInWarehsBillEntryAgent>();
        MoveInWarehsBillEntryAgent aEntryInfo = null;
        if (this.detailTable.getSelectManager().size() == 0) {
            return null;
        }
        int beginRow = this.detailTable.getSelectManager().get().getBeginRow();
        int endRow = this.detailTable.getSelectManager().get().getEndRow();
        if (beginRow < 0 && endRow >= 0) {
            beginRow = 0;
        }
        for (int i = 0; i < splitNum - 1; ++i) {
            aEntryInfo = MoveInWarehsBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            aEntryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
            if (this.detailTable.getRow(beginRow).getCell("lotFrame") != null && this.detailTable.getRow(beginRow).getCell("lotFrame").getValue() != null && !this.isNegativeBill) {
                LotFrame lotFrame = (LotFrame)this.detailTable.getRow(beginRow).getCell("lotFrame").getValue();
                long currentSerial = this.getSerialNumber(lotFrame, entryInfo.getMaterial().getId().toString());
                lotFrame.setCurrentSerial(currentSerial);
                aEntryInfo.setLot(lotFrame.getLotNumber());
            }
            if (needCleanQty) {
                aEntryInfo.setQty(InvClientUtils.ZERO);
                aEntryInfo.setBaseQty(InvClientUtils.ZERO);
                aEntryInfo.setAssistQty(InvClientUtils.ZERO);
                aEntryInfo.setReverseQty(InvClientUtils.ZERO);
                aEntryInfo.setStandardCost(InvClientUtils.ZERO);
                aEntryInfo.setActualCost(InvClientUtils.ZERO);
                aEntryInfo.setAmount(InvClientUtils.ZERO);
            }
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    public void actionSplitLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionSplitLine_actionPerformed(e);
        if (this.detailTable.getSelectManager().size() == 0) {
            return;
        }
        int beginRow = this.detailTable.getSelectManager().get().getBeginRow();
        int endRow = this.detailTable.getSelectManager().get().getEndRow();
        if (beginRow < 0 && endRow >= 0) {
            beginRow = 0;
        }
        for (int i = beginRow; i < this.splitOptConf.getSplitNum() + beginRow; ++i) {
            InvClientUtils.setLotInfo(null, this.detailTable, i, this.sou, (MaterialInfo)this.detailTable.getRow(i).getCell(TB_MATERIAL).getValue(), (String)this.detailTable.getRow(i).getCell(TB_BATCH).getValue(), this.editData);
        }
    }

    protected void unLockUI() {
        super.unLockUI();
        this.prmtMoveOutStorageOrgUnit.setEnabled(false);
    }

    @Override
    public void setBtnHaidForCalQuery() throws Exception {
        super.setBtnHaidForCalQuery();
        this.actionOffset.setVisible(false);
        this.btnOffset.setVisible(false);
        this.menuItemOffset.setVisible(false);
        this.actionQuickAddLine.setVisible(false);
        this.btnQuickAddLine.setVisible(false);
        this.menuItemQuickAddLine.setVisible(false);
    }

    @Override
    public void setOnlyActualCostEditable() {
        if (this.isBillQuery()) {
            super.setOnlyActualCostEditable();
            this.prmtTransactionType.setEnabled(false);
            this.prmtStorageOrgUnit.setEnabled(false);
            this.prmtAdminOrg.setEnabled(false);
            this.prmtMoveOutStorageOrgUnit.setEnabled(false);
            this.pkBizDate.setEditable(false);
            IRow curRow = null;
            for (int i = 0; i < this.getDetailTable().getRowCount3(); ++i) {
                curRow = this.getDetailTable().getRow(i);
                if (this.isBillEdit(curRow)) continue;
                InvClientUtils.setRowLock(this.getDetailTable(), i, new String[]{this.getFactCostName(), this.getUnitFactCostName(), this.getRemarkName()}, true);
            }
        }
    }

    protected void transactionTypeChanged(DataChangeEvent e) throws Exception {
        this.transactionTypeChanged(e, this.localAmtPrecision);
        TransactionTypeInfo tti = (TransactionTypeInfo)this.prmtTransactionType.getValue();
        this.fillLotNumber(-1);
        this.isNegativeBill = InvClientUtils.isReturnRIType((TransactionTypeInfo)e.getNewValue());
        ArrayList qtyCol = new ArrayList();
        Collections.addAll(qtyCol, QTYPRECISIONTAB);
        Collections.addAll(qtyCol, ASSQTY_PRECISION_TAB);
        Collections.addAll(qtyCol, BASEQTY_PRECISION_TAB);
        int count = this.getDetailTable().getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.getDetailTable().getRow(i);
            MaterialInfo material = null;
            if (curRow != null) {
                material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
            }
            if (material != null && curRow.getCell(TB_BATCH).getValue() != null) {
                StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                InvClientUtils.setLotInfo(tti, this.detailTable, i, sou, material, this.detailTable.getCell(i, TB_BATCH).getValue().toString(), this.editData);
            }
            this.changeQtyPrecision(curRow);
            if (!this.isNegativeBill) continue;
            for (int j = 0; j < qtyCol.size(); ++j) {
                Object qty = curRow.getCell((String)qtyCol.get(j)).getValue();
                if (qty == null) continue;
                curRow.getCell((String)qtyCol.get(j)).setValue((Object)((BigDecimal)qty).abs().negate());
            }
        }
    }

    @Override
    protected KDBizPromptBox getTransacationTypeF7() {
        return this.prmtTransactionType;
    }

    @Override
    protected String getFactCostName() {
        return TB_FACTCOST;
    }

    @Override
    protected String getOffSetQtyName() {
        return TB_COUNTERVAILQTY;
    }

    @Override
    protected String getUnitFactCostName() {
        return TB_UNITFACTCOST;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemOffset.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuItemQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    @Override
    protected void setSeparatorVisable(boolean isVisable) {
        super.setSeparatorVisable(isVisable);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected void initNeedMainOrgF7s() {
        super.initNeedMainOrgF7s();
        this.kDBizPromptBoxMaterial = this.getBizMaterialF7(this.detailTable.getColumn(TB_MATERIAL), null);
        this.kDBizPromptBoxMaterial.addChangeListener((ChangeListener)this);
        this.setDepartmentF7(this.prmtAdminOrg);
        this.addNeedMainOrgF7s(new KDBizPromptBox[]{this.kDBizPromptBoxMaterial, this.prmtAdminOrg});
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "moveinwarehs_new";
        }
        return null;
    }

    @Override
    protected String[] getColumnKeysForExtraUnvisible() {
        return new String[]{"lotFrame"};
    }

    @Override
    protected String getMaterialName() {
        return TB_MATERIAL;
    }

    @Override
    protected KDPromptBox getPrmtAdminOrg() {
        return this.prmtAdminOrg;
    }

    @Override
    protected String getWarehouseName() {
        return TB_WAREHS;
    }

    @Override
    protected String getBatchName() {
        return TB_BATCH;
    }

    @Override
    protected void initEditData(IObjectValue objectValue) {
        super.initEditData(objectValue);
        this.editData = (MoveInWarehsBillInfo)objectValue;
    }

    @Override
    protected void changeMainOrgUnit(PreChangeEvent pce) {
        this.storageOrgPreChange(pce);
    }

    public KDBizPromptBox getKDBizWarehouse() {
        if (this.kDBizWarehouse == null) {
            this.kDBizWarehouse = new KDBizPromptBox();
            this.kDBizWarehouse.setEditable(true);
            this.kDBizWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            this.kDBizWarehouse.setDisplayFormat("$name$");
            this.kDBizWarehouse.setEditFormat("$number$");
            this.kDBizWarehouse.setCommitFormat("$number$");
        }
        return this.kDBizWarehouse;
    }

    @Override
    protected void loadFieldsAfter() throws Exception {
        super.loadFieldsAfter();
        this.prmtTransactionType.setAccessAuthority(0);
        this.prmtMoveOutStorageOrgUnit.setAccessAuthority(0);
        this.prmtSourceBillType.setAccessAuthority(0);
        this.prmtSourceBillType.setEnabled(false);
        this.prmtSourceBillType.setEditable(false);
        this.initEntrys();
        this.initBOTPControls();
        this.initSetOffControls();
    }

    @Override
    protected void loadFieldsBefore() throws Exception {
        super.loadFieldsBefore();
        this.initBOTPData();
        this.initReverseData();
    }

    @Override
    protected void storeFieldsAfter() throws Exception {
        super.storeFieldsAfter();
    }

    @Override
    protected void storeFieldsBefore() throws Exception {
        super.storeFieldsBefore();
    }

    private void setControl() {
        MoveInWarehsBillInfo info = null;
        info = this.editData != null ? this.editData : (MoveInWarehsBillInfo)this.dataBinder.getValueObject();
        if (info == null) {
            return;
        }
        boolean setoff = info.isIsReversed();
        if (info.getBaseStatus().getValue() == 4 || "VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()) || setoff) {
            this.prmtTransactionType.setEnabled(false);
            this.prmtStorageOrgUnit.setEditable(false);
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.pkBizDate.setEnabled(false);
        } else {
            this.pkBizDate.setEnabled(true);
        }
        if (info.getBaseStatus().getValue() != 4 && setoff) {
            this.pkBizDate.setEnabled(true);
        }
        this.setSerialNumberEnable(false);
        if (setoff) {
            this.getDetailTable().getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
            InvClientUtils.setTableLock(this.getDetailTable(), new String[]{TB_QTY, TB_ASSISTQTY}, true);
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
            InvClientUtils.setCellLock(this.getDetailTable(), TB_QTY, false);
            InvClientUtils.setCellLock(this.getDetailTable(), "remark", false);
        } else {
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
        }
        try {
            super.lockOrUnLockCostCell4Init(setoff);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected KDDatePicker getPkBizDate() {
        return this.pkBizDate;
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        String[] str = new String[]{TB_QTY, TB_BASEUNITQTY, TB_ASSISTQTY, TB_STANDARDCOST, TB_FACTCOST, TB_COUNTERVAILQTY, TB_AMOUNT};
        StringBuffer temp = new StringBuffer(str[3]);
        temp.append("@#.");
        for (int i = 0; i < this.localAmtPrecision; ++i) {
            temp.append("#");
        }
        str[3] = temp.toString();
        return str;
    }

    @Override
    protected void tableSelectChanged(IRow curRow) throws Exception {
        MeasureUnitInfo unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        MaterialInfo material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        this.changeSerialNumberEnable(curRow, unit, material);
    }

    @Override
    protected InvBillBaseEntryInfo getCopyOvEntryAgent(InvBillBaseEntryInfo aInvBillBaseEntryInfo) {
        MoveInWarehsBillEntryInfo entryInfo = (MoveInWarehsBillEntryInfo)aInvBillBaseEntryInfo;
        MoveInWarehsBillEntryAgent aMoveInWarehsBillEntryAgent = MoveInWarehsBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
        aMoveInWarehsBillEntryAgent.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        return aMoveInWarehsBillEntryAgent;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected EntityViewInfo buildTransactionTypeEntityView() {
        return super.buildTransactionTypeEntityView();
    }

    @Override
    protected KDPromptBox getPrmtCustomer() {
        if (this.prmtCustomer == null) {
            this.prmtCustomer = SCMClientUtils.createSimpleEntryF7(null);
        }
        return this.prmtCustomer;
    }

    @Override
    protected KDPromptBox getPrmtSupplier() {
        if (this.prmtSupplier == null) {
            this.prmtSupplier = SCMClientUtils.createSimpleEntryF7(null);
        }
        return this.prmtSupplier;
    }

    @Override
    protected Set getAutoFilledColNames() {
        Set colSet = super.getAutoFilledColNames();
        return colSet;
    }

    @Override
    protected String getQtyName() {
        return TB_QTY;
    }

    @Override
    protected String getBaseQtyName() {
        return TB_BASEUNITQTY;
    }

    @Override
    protected String getAssistQtyName() {
        return TB_ASSISTQTY;
    }

    @Override
    protected String getAssistPropertyColName() {
        return "assistantAttr";
    }

    @Override
    protected String getUnitName() {
        return TB_UNIT;
    }

    @Override
    protected void initSCMBizDataVO(SCMBizDataVO vo) {
        if (this.isFirstLoading()) {
            vo.setOptionConfigNames(new String[]{"AssistForNumber", "NumberForAssist"});
            vo.setUiClassName(this.getMetaDataPK().getFullName());
        }
        super.initSCMBizDataVO(vo);
    }

    protected TransactionTypeInfo getTransactionType() {
        return (TransactionTypeInfo)this.getTransacationTypeF7().getValue();
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-0172c0a812fd463ED552";
    }

    @Override
    protected boolean isSysBill() {
        return this.editData.isIsSysBill();
    }

    protected boolean isNeedSepcialParam() {
        return true;
    }

    @Override
    protected boolean isSupportVoucher() {
        return true;
    }

    @Override
    protected String getGeneralVoucherPermissionName() {
        return "moveinwarehs_generalVoucher";
    }

    @Override
    protected String getGeneralPCVoucherPermissionName() {
        return "moveinwarehs_generalPcVoucher";
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.setLotAttribute("bizDate");
        this.initCopyEntrys();
        this.setLotAttribute(null);
    }

    @Override
    protected KDBizPromptBox getCostCenter() {
        return this.prmtCostCenter;
    }

    @Override
    protected KDBizPromptBox getDepartment() {
        return this.prmtAdminOrg;
    }

    protected KDBizPromptBox getHeadTransactionTypeF7() {
        return this.prmtTransactionType;
    }

    protected KDBizPromptBox getHeadBizTypeF7() {
        return this.bizPrmtBizType;
    }

    @Override
    protected KDBizPromptBox getBizInventory() {
        return this.bizInventory;
    }

    protected void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, MoveInWarehsBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, MoveInWarehsBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.getDetailTable(), "id", this.txtNumber, null);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    protected String getFreeProp1Name() {
        String retRes = EASResource.getString((String)FREEPROP_RESOURCE, (String)"freeProp1.editui");
        if (StringUtils.isEmpty((String)retRes) || "value_new".equalsIgnoreCase(retRes)) {
            return super.getFreeProp1Name();
        }
        return retRes;
    }

    @Override
    protected String getFreeProp2Name() {
        String retRes = EASResource.getString((String)FREEPROP_RESOURCE, (String)"freeProp2.editui");
        if (StringUtils.isEmpty((String)retRes) || "value_new".equalsIgnoreCase(retRes)) {
            return super.getFreeProp2Name();
        }
        return retRes;
    }

    @Override
    protected String getFreeProp3Name() {
        String retRes = EASResource.getString((String)FREEPROP_RESOURCE, (String)"freeProp3.editui");
        if (StringUtils.isEmpty((String)retRes) || "value_new".equalsIgnoreCase(retRes)) {
            return super.getFreeProp3Name();
        }
        return retRes;
    }

    @Override
    protected String getFreeProp4Name() {
        String retRes = EASResource.getString((String)FREEPROP_RESOURCE, (String)"freeProp4.editui");
        if (StringUtils.isEmpty((String)retRes) || "value_new".equalsIgnoreCase(retRes)) {
            return super.getFreeProp4Name();
        }
        return retRes;
    }

    @Override
    protected String getFreeProp5Name() {
        String retRes = EASResource.getString((String)FREEPROP_RESOURCE, (String)"freeProp5.editui");
        if (StringUtils.isEmpty((String)retRes) || "value_new".equalsIgnoreCase(retRes)) {
            return super.getFreeProp5Name();
        }
        return retRes;
    }

    @Override
    protected String[] getNumberColumns() {
        return new String[]{TB_QTY, TB_BASEUNITQTY, TB_ASSISTQTY, TB_UNITSTANCOST, TB_STANDARDCOST, TB_UNITFACTCOST, TB_FACTCOST, TB_COUNTERVAILQTY};
    }

    @Override
    protected boolean isSupportPCVoucher() {
        return true;
    }

    private class MyEventListener
    implements KDTEditListener {
        private MyEventListener() {
        }

        public void editStarting(KDTEditEvent e) {
            KDTable table = MoveInWarehsBillEditUI.this.getDetailTable();
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = table.getColumnKey(colIndex);
            IRow row = table.getRow(rowIndex);
            if (MoveInWarehsBillEditUI.this.getDetailTable().getColumnIndex(MoveInWarehsBillEditUI.this.getEntryInvUpdateTypeColumnName()) == e.getColIndex()) {
                try {
                    MoveInWarehsBillEditUI.this.filterEntryInvUpdateType(e.getRowIndex());
                }
                catch (Exception e1) {
                    MoveInWarehsBillEditUI.this.handUIException(e1);
                }
            }
            if (MoveInWarehsBillEditUI.TB_PRICE.equals(fieldName) || MoveInWarehsBillEditUI.TB_AMOUNT.equals(fieldName)) {
                if (row.getCell("id").getValue() == null) {
                    return;
                }
                String id = row.getCell("id").getValue().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("sourceBillEntryId"));
                sic.add(new SelectorItemInfo("sourceBillType"));
                sic.add(new SelectorItemInfo("id"));
                try {
                    if (!MoveInWarehsBillEntryFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(id))) {
                        return;
                    }
                    MoveInWarehsBillEntryInfo entry = MoveInWarehsBillEntryFactory.getRemoteInstance().getMoveInWarehsBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                    String transferBillEntryId = null;
                    if (entry.getSourceBillEntryId() != null && "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(entry.getSourceBillType().getId().toString())) {
                        transferBillEntryId = entry.getSourceBillEntryId();
                    }
                    if (entry.getSourceBillEntryId() != null && "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(entry.getSourceBillType().getId().toString())) {
                        sic.clear();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("sourceBillEntryId"));
                        MoveIssueBillEntryInfo issueBillEntryInfo = MoveIssueBillEntryFactory.getRemoteInstance().getMoveIssueBillEntryInfo((IObjectPK)new ObjectUuidPK(entry.getSourceBillEntryId()), sic);
                        transferBillEntryId = issueBillEntryInfo.getSourceBillEntryId();
                    }
                    sic.clear();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("isSalePrice"));
                    StockTransferBillEntryInfo transferBillEntryInfo = StockTransferBillEntryFactory.getRemoteInstance().getStockTransferBillEntryInfo((IObjectPK)new ObjectUuidPK(transferBillEntryId), sic);
                    if (transferBillEntryInfo.isIsSalePrice()) {
                        row.getCell(colIndex).getStyleAttributes().setLocked(true);
                        e.setCancel(true);
                    } else {
                        row.getCell(colIndex).getStyleAttributes().setLocked(false);
                    }
                }
                catch (Exception e1) {
                    MoveInWarehsBillEditUI.this.handleException(e1);
                }
            }
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editCanceled(KDTEditEvent e) {
        }

        public void editStopped(KDTEditEvent e) {
            try {
                MoveInWarehsBillEditUI.this.tableValueChanged(e);
            }
            catch (Exception ex) {
                MoveInWarehsBillEditUI.this.handUIException(ex);
            }
        }
    }
}

