/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.IMoveIssueBill;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractMoveIssueBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillFilter;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MoveIssueBillListUI
extends AbstractMoveIssueBillListUI {
    static final String[] MERGE_COLUMNS = new String[]{"id", "number", "baseStatus", "bizType", "transactionType.name", "bizDate", "adminOrgUnit", "sourceBillType", "storageOrgUnit.name", "moveInStorageOrgUnit.name", "isOffset", "fiVouchered", "voucher", "creator", "creatTime", "modifier", "modifyTime", "auditor", "auditTime", "pcVouchered", "pcVoucherNumber", "description", "processNode"};
    MoveIssueBillFilter filterUI = null;
    private OrgUnitInfo ouInfo = null;
    private IMoveIssueBill imi = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    protected String getEditUIName() {
        return MoveIssueBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        if (this.imi == null) {
            this.imi = MoveIssueBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        }
        return this.imi;
    }

    public String[] getMergeColumnKeys() {
        return MERGE_COLUMNS;
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        InvClientUtils.setFreezeCol(this.tblMain, "baseStatus");
        this.tblMain.getColumn("creatTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("creatTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        if (this.getUIContext().get("BillMainQuery") != null) {
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
    }

    public OrgUnitInfo getMainOrgInfo() {
        if (this.ouInfo == null) {
            this.ouInfo = super.getMainOrgInfo();
        }
        return this.ouInfo;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"entry.qty", "baseQty", "assistQty", "reverseQty", "totalInWarehsQty", "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"unitStardartCost", "unitActualCost"};
    }

    public String[] getAmountColumns() {
        return new String[]{"stardardCost", "actualCost"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        String[] QTY_COLUMNS = new String[]{"entry.qty", "entry.reverseQty", "entry.totalInWarehsQty", "entry.baseQty", "entry.assistQty", "entry.unVmiSettleBaseQty", "entry.totalVmiSettleBaseQty"};
        String[] PRICE_COLUMNS = new String[]{"entry.unitStandardCost", "entry.unitActualCost"};
        String[] amount_COLUMNS = new String[]{"totalAmount", "totalStandardCost", "totalActualCost", "entry.standardCost", "entry.actualCost"};
        try {
            rowSet.beforeFirst();
            Map colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
            while (rowSet.next()) {
                amoutPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])amount_COLUMNS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entry.amount"));
        sic.add(new SelectorItemInfo("entry.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entry.sourceBillType.number"));
        sic.add(new SelectorItemInfo("entry.sourceBillType.name"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntriesName()));
        return sic;
    }

    @Override
    public IUIActionPostman prepareInit() {
        CurrencyInfo baseCurrInfo;
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        if (SysContext.getSysContext().getCurrentFIUnit() != null && (baseCurrInfo = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency()) != null) {
            request.put("baseCurrInfoID", (Object)baseCurrInfo.getId().toString());
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        String id = this.getSelectedKeyValue();
        CompanyOrgUnitInfo com = null;
        if (id != null) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            com = MoveIssueBillFactory.getRemoteInstance().getCompanyOrgUnit((IObjectPK)pk);
        }
        return com;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    boolean isVouchered = (Boolean)this.tblMain.getCell(j, "fiVouchered").getValue();
                    boolean isReversed = (Boolean)this.tblMain.getCell(j, "isOffset").getValue();
                    if (isVouchered) {
                        MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_VOUCHERED"));
                        SysUtil.abort();
                    }
                    if (!isReversed) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_ISREVERSED"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new MoveIssueBillFilter();
        }
        return this.filterUI;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.id"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.number"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.name"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.whman.id"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.stockTransBillEntry.receiptWarehouse.hasLocation"));
        return sic;
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, MoveIssueBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, MoveIssueBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        String[] orgIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"storageOrgUnit.id");
        if (!InvClientUtils.checkStorageConsignSameCompany(orgIDs)) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        int size = orgIDs.length;
        for (int i = 0; i < size; ++i) {
            set.add(orgIDs[i]);
        }
        Object[] orgIDs2 = set.toArray();
        try {
            IPermission iPer = PermissionFactory.getRemoteInstance();
            for (int index = 0; index < orgIDs2.length; ++index) {
                iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgIDs2[index].toString())), "moveissue_generalVoucher");
            }
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
            return;
        }
        catch (BOSException ex) {
            this.handUIException(ex);
            return;
        }
        catch (UuidException ex) {
            this.handUIException(ex);
            return;
        }
        OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)orgIDs[0]));
        this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfo);
        super.actionVoucher_actionPerformed(e);
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        FilterInfo filter = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeId = botpMap.get("DESTBILLTYPE.ID").toString())) {
            filter = new FilterInfo();
            StorageOrgUnitInfo destSou = (StorageOrgUnitInfo)botpMap.get("MAINBIZORG");
            filter.getFilterItems().add(new FilterItemInfo("receiptStorageOrgUnit.id", (Object)destSou.getId().toString()));
        }
        return filter;
    }

    public void actionMultiPrint_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrint_actionPerformed(arg0);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(arg0);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.MoveIssuePrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/Issue/MoveIssueBilll";
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizDate", "storageOrgUnit.name", "moveInStorageOrgUnit.name", "material.number", "material.name", "material.model", "transactionType.name", "storeType", "unit.name", "entry.qty", "warehouse.name", "location.name"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected String[] getQueryHideField() {
        return new String[]{"fiVouchered", "isOffset", "storageOrgUnit.id"};
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("BillQuery") != null) {
            return super.getQuickFilteringSupport();
        }
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    @Override
    protected String getGeneralPCVoucherPermission() {
        return "moveissue_generalPcVoucher";
    }

    @Override
    protected String getStorageColName() {
        return "storageOrgUnit.id";
    }
}

