/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractMoveLocationFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class MoveLocationFilterUI
extends AbstractMoveLocationFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(MoveLocationFilterUI.class);
    private DataChangeListener warehouseListener = null;

    public MoveLocationFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.txtNumberFrom, (Component)this.txtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.bizPromptMaterialNumFrom, (Component)this.bizPromptMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("warehouse.number", (Component)this.bizPromptWarehouseFrom, (Component)this.bizPromptWarehouseTo));
        elements.add((FilterElement)new RangeFilterElement("department.number", (Component)this.bizPromptDepartmentFrom, (Component)this.bizPromptDepartmentTo));
        elements.add((FilterElement)new RangeFilterElement("location.number", (Component)this.bizPromptOutLocationFrom, (Component)this.bizPromptOutLocationTo));
        elements.add((FilterElement)new RangeFilterElement("receiptLocation.number", (Component)this.bizPromptInLocationFrom, (Component)this.bizPromptInLocationTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        CompositeFilterElement DateElements = new CompositeFilterElement(0);
        DateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo));
        DateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)DateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("storageOrgUnit1.id", (Component)this.bizPromptStOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboxBillStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizPromptMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.bizPromptMaterialNumTo, false, null);
        this.f7Manager.registerContextChangeF7(this.txtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.txtNumberTo, this.getPropertyOfMainBizOrg());
        this.txtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.txtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setBizOrgF7ByType(this.bizPromptDepartmentFrom, OrgType.Admin, OrgType.Storage, true);
        this.setBizOrgF7ByType(this.bizPromptDepartmentTo, OrgType.Admin, OrgType.Storage, true);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPromptDepartmentFrom, this.bizPromptDepartmentTo, this.bizPromptMaterialNumFrom, this.bizPromptMaterialNumTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.txtNumberFrom, this.txtNumberTo});
        this.setShowAllSealOrg(new KDBizPromptBox[]{this.bizPromptDepartmentFrom, this.bizPromptDepartmentTo}, new OrgType[]{OrgType.Admin, OrgType.Admin});
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseTo, this.getPropertyOfMainBizOrg());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        if (this.warehouseListener == null) {
            this.warehouseListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        MoveLocationFilterUI.this.wareHouse_dataChanged(eventObj);
                    }
                    catch (Exception exc) {
                        MoveLocationFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.bizPromptWarehouseFrom.addDataChangeListener(this.warehouseListener);
        this.bizPromptWarehouseTo.addDataChangeListener(this.warehouseListener);
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboxBillStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.DELETED};
    }

    private void wareHouse_dataChanged(DataChangeEvent e) {
        KDBizPromptBox prmtWarehouse = (KDBizPromptBox)e.getSource();
        String value = prmtWarehouse.getText();
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.number", (Object)value));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        if ("bizPromptWarehouseFrom".equals(prmtWarehouse.getName())) {
            this.bizPromptOutLocationFrom.setEntityViewInfo(viewInfo);
            this.bizPromptInLocationFrom.setEntityViewInfo(viewInfo);
        } else {
            this.bizPromptOutLocationTo.setEntityViewInfo(viewInfo);
            this.bizPromptInLocationTo.setEntityViewInfo(viewInfo);
        }
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStOrgUnitFrom;
    }

    protected String getViewPermission() {
        return "movelocation_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }
}

