/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IPurReceivalEntry;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalException;
import com.kingdee.eas.scm.im.inv.client.AbstractPurReceivalBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.PurRecBillFilterUI;
import com.kingdee.eas.scm.im.inv.client.PurReceivalBillEditUI;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;

public class PurReceivalBillListUI
extends AbstractPurReceivalBillListUI {
    PurRecBillFilterUI filterUI = null;
    private static final String TB_productTaskNumber = "entry.productTaskNumber";
    private static final String TB_PURORDERNUM = "purOrder";
    private static final String TB_PURORDERENTRYSEQ = "purOrderEntrySeq";
    private static final String Resource_subContract = "com.kingdee.eas.scm.sm.sc.SubContractResource";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.isInternalCompany"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entry.purOrder.id"));
        sic.add(new SelectorItemInfo("entry.purOrder.name"));
        sic.add(new SelectorItemInfo("entry.purOrder.number"));
        sic.add(new SelectorItemInfo("entry.purOrder.currency.id"));
        sic.add(new SelectorItemInfo("entry.purOrder.currency.name"));
        sic.add(new SelectorItemInfo("entry.purOrder.currency.number"));
        sic.add(new SelectorItemInfo("entry.purOrder.currency.precision"));
        sic.add(new SelectorItemInfo("entry.purOrder.exchangeRate"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.id"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.name"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.number"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.actualPrice"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.actualTaxPrice"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry.taxRate"));
        sic.add(new SelectorItemInfo("entry.purOrderNum"));
        sic.add(new SelectorItemInfo("entry.purOrderEntrySeq"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.warehouse.id"));
        sic.add(new SelectorItemInfo("entry.warehouse.name"));
        sic.add(new SelectorItemInfo("entry.warehouse.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.stocker.id"));
        sic.add(new SelectorItemInfo("entry.stocker.name"));
        sic.add(new SelectorItemInfo("entry.stocker.number"));
        sic.add(new SelectorItemInfo("entry.batch"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.receiptQty"));
        sic.add(new SelectorItemInfo("entry.associateQty"));
        sic.add(new SelectorItemInfo("entry.reverseQty"));
        sic.add(new SelectorItemInfo("entry.assistQty"));
        sic.add(new SelectorItemInfo("entry.isPresent"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.mfg"));
        sic.add(new SelectorItemInfo("entry.exp"));
        return sic;
    }

    @Override
    protected String getEditUIName() {
        return PurReceivalBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurReceivalBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        this.initButtons();
        super.onLoad();
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.tblMain.getColumn("bizDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("creatTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("creatTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        if (this.isSubContractBill()) {
            this.initSubContractReceivalUI();
        } else {
            this.initPurReceivalBillUI();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    private void initButtons() {
        this.btnCopyTo.setVisible(false);
        this.btnCopyTo.setEnabled(false);
        this.menuItemCopyTo.setVisible(false);
        this.menuItemCopyTo.setEnabled(false);
        this.menuItemImportData.setVisible(false);
        this.menuItemImportData.setEnabled(false);
        this.separator3.setVisible(false);
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "baseStatus", "bizType.name", "transactionType.name", "bizDate", "storageOrgUnit.name", "supplier.name", "department.name", "soureBillType", "isOffset", "isInit", "creator", "creatTime", "modifier", "modifyTime", "auditor", "auditTime", "processNode"};
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"entry.qty", "baseUnitQty", "assistQty", "receiptQty", "reverseQty", "toFixAssetQty", "checkQty", "checkReturnedQty", "unCheckQty", "qualifiedQty", "unqualifiedQty", "entry.concessiveRecQty", "entry.concessiveRecBaseQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return null;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        String[] QTY_COLUMNS = new String[]{"entry.qty", "entry.receiptQty", "entry.reverseQty", "entry.checkQty", "entry.checkReturnedQty", "entry.unCheckQty", "entry.qualifiedQty", "entry.unqualifiedQty", "entry.baseQty", "entry.assistQty"};
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.actualCost"));
        sic.add(new SelectorItemInfo("entry.standardCost"));
        sic.add(new SelectorItemInfo("entry.unitStandardCost"));
        sic.add(new SelectorItemInfo("entry.unitActualCost"));
        sic.add(new SelectorItemInfo("entry.amount"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntriesName()));
        return sic;
    }

    public String getUITitle() {
        if (this.isSubContractBill()) {
            return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractReceivalBill");
        }
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"PurReceivalBill");
    }

    public String getBOTPBillUITitleByID(String id) {
        String title = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("purchaseType");
        if (null == id) {
            return null;
        }
        try {
            int type = PurReceivalBillFactory.getRemoteInstance().getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(id), sic).getPurchaseType().getValue();
            title = type == 1 ? EASResource.getString((String)Resource_subContract, (String)"SubContractReceivalBill") : InvClientUtils.getResource("purReceivalBill");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return title;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = this.isSubContractBill() ? new PurRecBillFilterUI(true) : new PurRecBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurReceivalBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurReceivalEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", "storageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"handClose");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnClose, (String)"handleUnclose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnclose");
        actionProxy.bindTo((AbstractButton)this.btnUnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemUnClose);
        super.initBatchActions();
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.PurReceivalPrintQuery");
    }

    protected String getTDFileName() {
        if (this.isSubContractBill()) {
            return "/SCM/SM/SubContract/SubContractReceival";
        }
        return "/SCM/IM/InWarehs/PurReceivalBill";
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedFieldValues(this.getKeyFieldName());
        String[] idArray = new String[idList.size()];
        idList.toArray(idArray);
        try {
            PurReceivalBillFactory.getRemoteInstance().updateCheckUnReturnQty(idArray);
            super.actionCreateTo_actionPerformed(e);
        }
        catch (Exception err) {
            this.handleException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        String[] selIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)new OrderException(PurReceivalException.PUR_MUSTSELECT_ONERECORD, (Object[])new String[]{this.getResource("OPERATOR_CLOSE")}));
            return;
        }
        super.actionClose_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getRemoteInstance();
        try {
            iPurReceivalEntry.canHandleClose(pks);
            this.setOprtState("CLOSE");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num2;
                if (reasonCodeInfo instanceof IObjectValue) {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iPurReceivalEntry.handClose(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    String[] reasonCodeInfos = new String[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iPurReceivalEntry.handClose(pks, reasonCodeInfos);
                }
            }
            this.showSuccessMsg("PUR_CLOSE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionUnClose_actionPerformed(e);
            String[] entryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
            if (entryIDs == null) {
                this.handleException((Exception)new PurOrderException(PurReceivalException.PUR_MUSTSELECT_ONEENTRY, (Object[])new String[]{this.getResource("OPERATOR_UNCLOSE")}));
                return;
            }
            IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getRemoteInstance();
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])entryIDs);
            iPurReceivalEntry.handleUnclose(pks);
            this.showSuccessMsg("PUR_UNCLOSE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(this.getResource(msgResource));
        this.showMessage();
    }

    protected String getResource(String msgResource) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)msgResource);
    }

    private void changeHeaderTitle(String columnNumber, String destColumnTitle) {
        KDTCell cell = this.tblMain.getHead().getRow(0).getCell(this.tblMain.getColumnIndex(columnNumber));
        if (cell != null) {
            cell.setValue((Object)destColumnTitle);
        }
    }

    private void initPurReceivalBillUI() {
        this.tblMain.getColumn(TB_productTaskNumber).setWidth(0);
        this.tblMain.getColumn(TB_productTaskNumber).setResizeable(false);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        boolean isCreateTo = Integer.valueOf("0").equals(this.getUIContext().get("BTPCreateMode"));
        if (!isCreateTo && this.getBOTPViewStatus() == 1) {
            return filterInfo;
        }
        if (filterInfo != null) {
            if (this.isSubContractBill()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(1)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(0)));
            }
        }
        return filterInfo;
    }

    private void initSubContractReceivalUI() {
        this.changeHeaderTitle(TB_PURORDERNUM, EASResource.getString((String)Resource_subContract, (String)"SubContractOrderBill_Number"));
        this.changeHeaderTitle(TB_PURORDERENTRYSEQ, EASResource.getString((String)Resource_subContract, (String)"SubContractOrderBill_RowNumber"));
        this.tblMain.getColumn("contractNumber").setWidth(0);
        this.tblMain.getColumn("contractNumber").setResizeable(false);
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (destBosTypeList != null && destBosTypeList.size() != 0 && this.isSubContractBill()) {
            destBosTypeList.remove("42AC39EC");
            destBosTypeList.remove("4A1078C5");
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    public List getDestBosTypeForBotpByID(String[] srcIdList, String[] entryNames, List entriesIDList, List destBosTypeList) {
        if (destBosTypeList != null && destBosTypeList.size() != 0 && this.isSubContractBill()) {
            destBosTypeList.remove("42AC39EC");
            destBosTypeList.remove("4A1078C5");
        }
        return super.getDestBosTypeForBotpByID(srcIdList, entryNames, entriesIDList, destBosTypeList);
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public OrgType getMainBizOrgType() {
        return super.getMainBizOrgType();
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.im.inv.app.PurReceivalBillListUIHandler");
        IUIActionPostman handler = super.prepareInit();
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizDate", "supplier.name", "storageOrgUnit.name", "material.number", "material.name", "material.model", "transactionType.name", "unit.name", "entry.qty", "warehouse.name", "location"};
    }

    protected String[] getQueryHideField() {
        return new String[]{"entry.seq", "storageOrgUnit.id"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    public boolean isPrepareActionView() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    protected BOSObjectType getBOSType() {
        return new PurReceivalBillInfo().getBOSType();
    }

    public void onShow() throws Exception {
        if (this.getParent().getParent() instanceof KDTabbedPane) {
            KDTabbedPane tabbPane = (KDTabbedPane)this.getParent().getParent();
            if (this.isSubContractBill()) {
                for (int i = 0; i < tabbPane.getTabCount(); ++i) {
                    tabbPane.setTitleAt(i, this.transmitSubTitle(tabbPane.getTitleAt(i)));
                }
            }
        }
        super.onShow();
    }

    private String transmitSubTitle(String title) {
        String resultTitle = title;
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"PurInWarehsBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractInWarehsBill");
        }
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"MaterialReqBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractMatReqBill");
        }
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"PurReceivalBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractReceivalBill");
        }
        return resultTitle;
    }
}

