/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.ROPException;
import com.kingdee.eas.scm.im.inv.ROPFacadeFactory;
import com.kingdee.eas.scm.im.inv.ROPParam;
import com.kingdee.eas.scm.im.inv.client.AbstractROPConditionUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ROPConditionUI
extends AbstractROPConditionUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(ROPConditionUI.class);

    public ROPConditionUI() throws Exception {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        this.prmtStorageOrgUnit.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtStorageOrgUnit.setCommitFormat("$number$;$code$");
    }

    @Override
    public void actionRun_actionPerformed(ActionEvent e) throws Exception {
        Object planner;
        Object materialTo;
        super.actionRun_actionPerformed(e);
        ROPParam ropParam = new ROPParam();
        String[] souIDs = null;
        Object o = this.prmtStorageOrgUnit.getValue();
        if (o == null) {
            this.prmtStorageOrgUnit.requestFocus();
            throw new ROPException(ROPException.STORAGEISNULL);
        }
        if (o instanceof StorageOrgUnitInfo) {
            souIDs = new String[]{((StorageOrgUnitInfo)o).getId().toString()};
        } else if (o instanceof Object[]) {
            Object[] sous = (Object[])o;
            if (sous.length > 0 && sous[0] == null) {
                this.prmtStorageOrgUnit.requestFocus();
                throw new ROPException(ROPException.STORAGEISNULL);
            }
            souIDs = new String[sous.length];
            for (int i = 0; i < souIDs.length; ++i) {
                souIDs[i] = ((StorageOrgUnitInfo)sous[i]).getId().toString();
            }
        }
        ropParam.setSouIDs(souIDs);
        Object materialFrom = this.prmtMaterialFrom.getValue();
        if (materialFrom != null && materialFrom instanceof MaterialInfo) {
            ropParam.setMaterialNumberFrom(((MaterialInfo)materialFrom).getNumber());
        }
        if ((materialTo = this.prmtMaterialTo.getValue()) != null && materialTo instanceof MaterialInfo) {
            ropParam.setMaterialNumberTo(((MaterialInfo)materialTo).getNumber());
        }
        if ((planner = this.prmtPlanner.getValue()) != null && planner instanceof PersonInfo) {
            ropParam.setPlanner(((PersonInfo)planner).getId().toString());
        }
        List planOrderNOs = ROPFacadeFactory.getRemoteInstance().runROPForManual(ropParam);
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.ROPResource", (String)"RunROPSuccess", (String[])new String[]{BigDecimal.valueOf(planOrderNOs.size()).toString()}));
        if (planOrderNOs.size() > 0) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.ROPResource", (String)"WhoseNumbersAre"));
            Iterator iter = planOrderNOs.iterator();
            while (iter.hasNext()) {
                msg.append(iter.next());
                if (!iter.hasNext()) continue;
                msg.append(", ");
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMainOrg();
        this.prmtStorageOrgUnit.addDataChangeListener((DataChangeListener)this);
        SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)this.prmtPlanner, null, (CoreUI)this);
    }

    private void initMainOrg() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        String permissionItem = "rop";
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        this.prmtStorageOrgUnit.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.prmtStorageOrgUnit.setCommitFormat("$number$;$code$");
        this.prmtStorageOrgUnit.setEnabledMultiSelection(true);
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (this.prmtStorageOrgUnit.equals(source)) {
            this.storageOrgUnitChanged(e);
        }
    }

    private void storageOrgUnitChanged(DataChangeEvent e) {
        try {
            Object o = e.getNewValue();
            if (o instanceof StorageOrgUnitInfo) {
                this.setControlEnable(true, (StorageOrgUnitInfo)o);
                this.setMaterialF7ByStorage((StorageOrgUnitInfo)o);
                SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)this.prmtPlanner, (StorageOrgUnitInfo)((StorageOrgUnitInfo)o), (CoreUI)this);
            } else if (o instanceof Object[]) {
                Object[] sous = (Object[])o;
                if (sous.length == 1) {
                    this.setControlEnable(true, (StorageOrgUnitInfo)sous[0]);
                    this.setMaterialF7ByStorage((StorageOrgUnitInfo)sous[0]);
                    SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)this.prmtPlanner, (StorageOrgUnitInfo)((StorageOrgUnitInfo)sous[0]), (CoreUI)this);
                } else {
                    this.setControlEnable(false, null);
                    SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)this.prmtPlanner, null, (CoreUI)this);
                }
            } else {
                this.setControlEnable(false, null);
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void setControlEnable(boolean isEnable, StorageOrgUnitInfo sou) {
        if (isEnable) {
            this.prmtMaterialFrom.setEnabled(true);
            this.prmtMaterialTo.setEnabled(true);
            this.prmtPlanner.setEnabled(true);
            if (sou == null) {
                this.prmtMaterialFrom.setEntityViewInfo(SCMClientUtils.getNullView());
                this.prmtMaterialTo.setEntityViewInfo(SCMClientUtils.getNullView());
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)sou.getId().toString()));
                view.setFilter(filter);
                this.prmtMaterialFrom.setEntityViewInfo(view);
                this.prmtMaterialTo.setEntityViewInfo(view);
            }
        } else {
            this.prmtMaterialFrom.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
            this.prmtPlanner.setEnabled(false);
            this.prmtMaterialFrom.setValue(null);
            this.prmtMaterialTo.setValue(null);
            this.prmtPlanner.setValue(null);
        }
    }

    private void setMaterialF7ByStorage(StorageOrgUnitInfo storage) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(1)));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.planningMode", (Object)String.valueOf(1)));
        if (storage == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTS"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storage.getId().toString()));
        }
        view.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(view);
        this.prmtMaterialTo.setEntityViewInfo(view);
    }
}

