/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.calculate.PropertyCalculator;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.SaleIssueAlgorithm;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import java.math.BigDecimal;
import javax.swing.JTextField;

class SaleIssueAlgorithmForUI
extends SaleIssueAlgorithm {
    private SaleIssueBillEditUI editUI;
    private SaleIssueBillInfo info;
    private int paramDiscountRate = 2;
    protected BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;

    public SaleIssueAlgorithmForUI(SaleIssueBillEditUI editUI, SaleIssueBillInfo info, Context ctx) {
        this.editUI = editUI;
        this.info = info;
        this.ctx = ctx;
    }

    public void calByCurrency(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        BigDecimal discountRate = this.getDiscountRate(i);
        if (null == discountRate || discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
            discountRate = new BigDecimal("0.0");
        }
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("taxAmount=localTaxAmount/" + this.getExchangeRate(), this.getAmountPrecision());
            } else {
                siCalculator.evalForEntry("taxAmount=localTaxAmount*" + this.getExchangeRate(), this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("taxPrice=0", this.getPricePrecision(i));
                } else if (this.getQty(i) != null) {
                    siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax() && !this.editUI.isRowDiscount100(i)) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("amount=localAmount/" + this.getExchangeRate(), this.getAmountPrecision());
            } else {
                siCalculator.evalForEntry("amount=localAmount*" + this.getExchangeRate(), this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("price=0", this.getPricePrecision(i));
                } else if (this.getQty(i) != null && this.getQty(i).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
                    siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax() && !this.editUI.isRowDiscount100(i)) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
            }
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (this.getQty(i) != null && this.getQty(i).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (this.getQty(i) != null && this.getQty(i).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    public void calByExchangeRate(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
    }

    public void calByTableChange(KDTEditEvent e) throws Exception {
        int i = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.editUI.getDetailTable() == null) {
            return;
        }
        if (i < 0 || colIndex < 0) {
            return;
        }
        if (this.editUI.getDetailTable().getRow(i) == null) {
            return;
        }
        String fieldName = this.editUI.getDetailTable().getColumnKey(colIndex);
        if ("price".equalsIgnoreCase(fieldName)) {
            this.calByPrice(i);
        } else if ("taxRate".equalsIgnoreCase(fieldName)) {
            this.calByEntryTaxRate(i);
        } else if ("taxPrice".equalsIgnoreCase(fieldName)) {
            this.calByTaxPrice(i);
        } else if ("discount".equalsIgnoreCase(fieldName)) {
            this.calByEntryDiscount(i);
        } else if ("amount".equalsIgnoreCase(fieldName)) {
            this.calByAmount(i);
        } else if ("tax".equalsIgnoreCase(fieldName)) {
            this.calByTax(i);
        } else if ("qty".equalsIgnoreCase(fieldName)) {
            this.calByQty(i);
        } else if ("unit".equalsIgnoreCase(fieldName)) {
            this.calByUnit(i);
        } else if ("discountType".equalsIgnoreCase(fieldName)) {
            this.calByDiscountType(i);
        } else if ("discountAmount".equalsIgnoreCase(fieldName)) {
            ICell cell = this.editUI.getDetailTable().getCell(i, "discountAmount");
            if (this.isNegativeBill() && cell.getValue() != null) {
                cell.setValue((Object)((BigDecimal)cell.getValue()).negate());
            }
            this.calByDiscountAmount(i);
        } else if ("taxAmount".equalsIgnoreCase(fieldName)) {
            this.calByTaxAmount(i);
        } else if ("standardCost".equalsIgnoreCase(fieldName)) {
            this.calTotalStandardCost();
        } else if ("actualCost".equalsIgnoreCase(fieldName)) {
            this.calUnitActualCost(i);
            this.calWrittenOffAmount(i);
            this.calUnWriteOffAmount(i);
            this.calTotalActualCost();
        } else if ("isPresent".equalsIgnoreCase(fieldName)) {
            this.calByTaxPrice(i);
            this.calTotalActualCost();
            this.calTotalAmount();
            this.calTotalLocalTaxAmount();
            this.calTotalStandardCost();
        } else if ("unitActualCost".equalsIgnoreCase(fieldName)) {
            this.calActualCost(i);
            this.calWrittenOffAmount(i);
            this.calUnWriteOffAmount(i);
            this.calTotalActualCost();
        } else if ("actualTaxPrice".equalsIgnoreCase(fieldName)) {
            this.calByActualTaxPrice(i);
        } else if ("actualPrice".equalsIgnoreCase(fieldName)) {
            this.calByActualPrice(i);
        }
    }

    public void setDiscountAmountMaxValue(int rowIndex) throws EASBizException, BOSException {
        IRow row = this.editUI.getDetailTable().getRow(rowIndex);
        ICell cell = row.getCell("discountAmount");
        KDTDefaultCellEditor defaultEditor = null;
        if (row != null) {
            BigDecimal qty = this.getQty(rowIndex);
            BigDecimal taxPrice = this.getTaxPrice(rowIndex);
            ICellEditor editor = this.editUI.getDetailTable().getColumn("amount").getEditor();
            int precision = editor == null ? 2 : ((KDFormattedTextField)editor.getComponent()).getPrecision();
            String colPrecision = "";
            colPrecision = PrecisionUtil.getFormatString((int)precision);
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(precision);
            colTxtField.setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
            colTxtField.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            colTxtField.setHorizontalAlignment(4);
            colTxtField.setSupportedEmpty(true);
            colTxtField.setRemoveingZeroInDispaly(false);
            colTxtField.setNegatived(true);
            if (this.isNegativeBill()) {
                colTxtField.setMaximumValue((Comparable)taxPrice.multiply(qty).abs());
            } else {
                if (qty != null && taxPrice != null && taxPrice.compareTo(SysConstant.BIGZERO) > 0 && qty.compareTo(SysConstant.BIGZERO) > 0) {
                    colTxtField.setMaximumValue((Comparable)taxPrice.multiply(qty).setScale(precision, 4));
                } else {
                    colTxtField.setMaximumValue((Comparable)SysConstant.BIGZERO.setScale(precision));
                }
                BigDecimal discountAmount = (BigDecimal)row.getCell("discountAmount").getValue();
                if (discountAmount != null && discountAmount.compareTo((BigDecimal)colTxtField.getMaximumValue()) > 0) {
                    cell.setValue((Object)SysConstant.BIGZERO.setScale(precision));
                }
            }
            defaultEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
            cell.setEditor((ICellEditor)defaultEditor);
            cell.getStyleAttributes().setNumberFormat(colPrecision);
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void setDiscountPrecision(int rowIndex) {
        IRow row = this.editUI.getDetailTable().getRow(rowIndex);
        ICell discountCell = row.getCell("discount");
        DiscountModeEnum discounMode = (DiscountModeEnum)row.getCell("discountType").getValue();
        if (discounMode == null || discounMode.getValue() == -1 || discounMode.getValue() == 0) {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(this.getDiscountRatePrecision(rowIndex));
            BigDecimal discount = (BigDecimal)discountCell.getValue();
            if (discount == null || discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                discountCell.setValue((Object)SysConstant.BIGZERO);
            }
            colTxtField.setRemoveingZeroInDispaly(false);
            colTxtField.setSupportedEmpty(true);
            discountCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
            discountCell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.getDiscountRatePrecision(rowIndex)));
            discountCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        } else {
            KDFormattedTextField colTxtField = new KDFormattedTextField();
            colTxtField.setDataType(1);
            colTxtField.setPrecision(this.getDiscountRatePrecision(rowIndex));
            colTxtField.setRemoveingZeroInDispaly(false);
            colTxtField.setSupportedEmpty(true);
            colTxtField.setMaximumValue((Comparable)(this.isInTax() ? this.getTaxPrice(rowIndex) : this.getPrice(rowIndex)));
            discountCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
            discountCell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.getDiscountRatePrecision(rowIndex)));
            discountCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void setParamDiscountRate(int paramDiscountRate) {
        this.paramDiscountRate = paramDiscountRate;
    }

    @Override
    protected void calAmount(int i) {
        super.calAmount(i);
    }

    @Override
    protected void calByAmount(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByAmount(i, siCalculator);
    }

    @Override
    protected void calByPrice(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByPrice(i, siCalculator);
    }

    @Override
    protected void calByTaxAmount(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByTaxAmount(i, siCalculator);
    }

    @Override
    protected void calByTaxPrice(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByTaxPrice(i, siCalculator);
    }

    protected void calByActualTaxPrice(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByActualTaxPrice(i, siCalculator);
    }

    protected void calByActualPrice(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        this.calByActualPrice(i, siCalculator);
    }

    @Override
    protected BigDecimal getActualCost(int i) {
        return this.getBigDecimal("actualCost", i);
    }

    protected BigDecimal getActualPrice(int i) {
        return this.getBigDecimal("actualPrice", i);
    }

    protected BigDecimal getActualTaxPrice(int i) {
        return this.getBigDecimal("actualTaxPrice", i);
    }

    @Override
    protected BigDecimal getAmount(int i) {
        return this.getBigDecimal("amount", i);
    }

    @Override
    protected int getAmountPrecision() {
        return this.editUI.amtPrecision;
    }

    @Override
    protected MeasureUnitInfo getAssistUnit(int i) {
        return (MeasureUnitInfo)this.editUI.getDetailTable().getRow(i).getCell("assistUnit").getValue();
    }

    @Override
    protected BigDecimal getBaseQty(int i) {
        return this.getBigDecimal("baseQty", i);
    }

    @Override
    protected ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    protected BigDecimal getDiscountAmount(int i) {
        return this.getBigDecimal("discountAmount", i);
    }

    @Override
    protected BigDecimal getDiscountRate(int i) {
        return this.getBigDecimal("discount", i);
    }

    @Override
    protected DiscountModeEnum getDiscountType(int i) {
        return (DiscountModeEnum)this.editUI.getDetailTable().getRow(i).getCell("discountType").getValue();
    }

    @Override
    protected int getEntrySize() {
        return this.editUI.getDetailTable().getRowCount();
    }

    @Override
    protected BigDecimal getExchangeRate() {
        BigDecimal exchangeRate = SCMConstant.BIGDECIMAL_ONE;
        try {
            exchangeRate = InvClientUtils.obj2BigDecimal(this.editUI.txtExchangeRate.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exchangeRate;
    }

    @Override
    protected BigDecimal getLocalAmount(int i) {
        return this.getBigDecimal("localAmount", i);
    }

    @Override
    protected int getLocalAmountPrecision() {
        return this.editUI.localAmtPrecision;
    }

    protected BigDecimal getLocalPrice(int i) {
        return this.getBigDecimal("localPrice", i);
    }

    protected BigDecimal getLocalTax(int i) {
        return this.getBigDecimal("localTax", i);
    }

    @Override
    protected BigDecimal getLocalTaxAmount(int i) {
        return this.getBigDecimal("localTaxAmount", i);
    }

    @Override
    protected MaterialInfo getMaterial(int i) {
        return (MaterialInfo)this.editUI.getDetailTable().getRow(i).getCell("materialNum").getValue();
    }

    @Override
    protected WarehouseInfo getWarehouse(int i) {
        return (WarehouseInfo)this.editUI.getDetailTable().getRow(i).getCell("warehouse").getValue();
    }

    @Override
    protected BigDecimal getPrice(int i) {
        return this.getBigDecimal("price", i);
    }

    @Override
    protected int getPricePrecision(int i) {
        return this.getMaterial(i) == null ? 2 : this.getMaterial(i).getPricePrecision();
    }

    @Override
    protected BigDecimal getQty(int i) {
        return this.getBigDecimal("qty", i);
    }

    protected BigDecimal getReturnBaseQty(int i) {
        return this.getBigDecimal("returnBaseQty", i);
    }

    @Override
    protected BigDecimal getStandardCost(int i) {
        return this.getBigDecimal("standardCost", i);
    }

    @Override
    protected BigDecimal getTax(int i) {
        return this.getBigDecimal("tax", i);
    }

    @Override
    protected BigDecimal getTaxAmount(int i) {
        return this.getBigDecimal("taxAmount", i);
    }

    @Override
    protected BigDecimal getTaxPrice(int i) {
        return this.getBigDecimal("taxPrice", i);
    }

    @Override
    protected BigDecimal getTaxRate(int i) {
        return this.getBigDecimal("taxRate", i);
    }

    @Override
    protected TransactionTypeInfo getTransactionType() {
        return (TransactionTypeInfo)this.editUI.prmtTransactionType.getValue();
    }

    @Override
    protected MeasureUnitInfo getUnit(int i) {
        return (MeasureUnitInfo)this.editUI.getDetailTable().getRow(i).getCell("unit").getValue();
    }

    @Override
    protected BigDecimal getUnitStandardCost(int i) {
        return this.getBigDecimal("unitStandardCost", i);
    }

    @Override
    protected boolean isInTax() {
        return this.editUI.cboxIsInTax.isSelected();
    }

    protected boolean isIsPresent(int i) {
        return new Boolean(this.editUI.getDetailTable().getRow(i).getCell("isPresent").getValue().toString());
    }

    @Override
    protected boolean isIsReversed() {
        return this.editUI.cboxIsReversed.isSelected();
    }

    @Override
    protected void setMaterial(MaterialInfo materialInfo, int i) {
        this.setValue("materialNum", materialInfo, i);
    }

    @Override
    protected void setActualCost(BigDecimal actualCost, int i) {
        this.setValue("actualCost", actualCost, i);
    }

    @Override
    protected void setActualPrice(BigDecimal actualPrice, int i) {
        this.setValue("actualPrice", actualPrice, i);
    }

    @Override
    protected void setActualTaxPrice(BigDecimal actualTaxPrice, int i) {
        this.setValue("actualTaxPrice", actualTaxPrice, i);
    }

    @Override
    protected void setAmount(BigDecimal amount, int i) {
        this.setValue("amount", amount, i);
    }

    @Override
    protected void setAssistQty(BigDecimal assistQty, int i) {
    }

    protected void setAssociateQty(BigDecimal associateQty, int i) {
        this.setValue("associateQty", associateQty, i);
    }

    @Override
    protected void setBaseQty(BigDecimal baseQty, int i) {
        this.setValue("baseQty", baseQty, i);
    }

    protected void setCompanyOrgUnit(CompanyOrgUnitInfo companyOrgUnit, int i) {
        this.setValue("companyOrgUnit", companyOrgUnit, i);
    }

    @Override
    protected void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.setValue("discountAmount", discountAmount, i);
    }

    @Override
    protected void setLocalAmount(BigDecimal localAmount, int i) {
        this.setValue("localAmount", localAmount, i);
    }

    protected void setLocalPrice(BigDecimal localPrice, int i) {
        this.setValue("localPrice", localPrice, i);
    }

    @Override
    protected void setLocalTax(BigDecimal localTax, int i) {
        this.setValue("localTax", localTax, i);
    }

    @Override
    protected void setLocalTaxAmount(BigDecimal localTaxAmount, int i) {
        this.setValue("localTaxAmount", localTaxAmount, i);
    }

    @Override
    protected void setPrice(BigDecimal price, int i) {
        this.setValue("price", price, i);
    }

    @Override
    protected void setQty(BigDecimal qty, int i) {
        this.setValue("qty", qty, i);
    }

    protected void setReturnBaseQty(BigDecimal returnBaseQty, int i) {
        this.setValue("returnBaseQty", returnBaseQty, i);
    }

    @Override
    protected void setStandardCost(BigDecimal standardCost, int i) {
        this.setValue("standardCost", standardCost, i);
    }

    @Override
    protected void setTax(BigDecimal tax, int i) {
        this.setValue("tax", tax, i);
    }

    @Override
    protected void setTaxAmount(BigDecimal taxAmount, int i) {
        this.setValue("taxAmount", taxAmount, i);
    }

    @Override
    protected void setTaxPrice(BigDecimal taxPrice, int i) {
        this.setValue("taxPrice", taxPrice, i);
    }

    @Override
    protected void setTotalActualCost(BigDecimal totalActualCost) {
        this.info.setTotalActualCost(totalActualCost);
    }

    @Override
    protected void setTotalAmount(BigDecimal totalAmount) {
        this.info.setTotalAmount(totalAmount);
    }

    @Override
    protected void setTotalLocalAmount(BigDecimal totalLocalAmount) {
        this.info.setTotalLocalAmount(totalLocalAmount);
    }

    @Override
    protected void setTotalStandardCost(BigDecimal totalStandardCost) {
        this.info.setTotalStandardCost(totalStandardCost);
    }

    @Override
    protected void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setTotalAmount(totalTaxAmount);
    }

    @Override
    protected void setUnitActualCost(BigDecimal unitActualCost, int i) {
        this.setValue("unitActualCost", unitActualCost, i);
    }

    @Override
    protected void setUnitStandardCost(BigDecimal unitStandardCost, int i) {
        this.setValue("unitStandardCost", unitStandardCost, i);
    }

    protected void setUnReturnedBaseQty(BigDecimal unReturnedBaseQty, int i) {
        this.setValue("unReturnedBaseQty", unReturnedBaseQty, i);
    }

    protected void setUnWriteOffAmount(BigDecimal unWriteOffAmount, int i) {
        this.setValue("unWriteOffAmount", unWriteOffAmount, i);
    }

    protected void setUnWriteOffBaseQty(BigDecimal unWriteOffBaseQty, int i) {
        this.setValue("unWriteOffBaseQty", unWriteOffBaseQty, i);
    }

    protected void setUnWriteOffQty(BigDecimal unWriteOffQty, int i) {
        this.setValue("unWriteOffQty", unWriteOffQty, i);
    }

    protected void setWrittenOffAmount(BigDecimal writtenOffAmount, int i) {
        this.setValue("writtenOffAmount", writtenOffAmount, i);
    }

    protected void setWrittenOffBaseQty(BigDecimal writtenOffBaseQty, int i) {
        this.setValue("writtenOffBaseQty", writtenOffBaseQty, i);
    }

    protected void setWrittenOffQty(BigDecimal writtenOffQty, int i) {
        this.setValue("writtenOffQty", writtenOffQty, i);
    }

    private void calActualCost(int i) {
        BigDecimal actualCost = this.getUnitActualCost(i).multiply(this.getQty(i)).setScale(this.getLocalAmountPrecision(), 4);
        this.setActualCost(actualCost, i);
    }

    private void calByDiscountAmount(int i) throws Exception {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(taxPrice*qty)*100", this.getDiscountRatePrecision(i));
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/qty", this.getPricePrecision(i));
            }
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(taxPrice*qty)*100", this.getDiscountRatePrecision(i));
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(qty*(1+taxRate/100))", this.getPricePrecision(i));
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    private void calByDiscountType(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    private void calByEntryDiscount(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        BigDecimal discountValue = this.formatBigDecimal((BigDecimal)row.getCell("discount").getValue());
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i)) && discountValue.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0 || DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i)) && discountValue.compareTo(this.getTaxPrice(i)) > 0) {
            row.getCell("discount").setValue((Object)SysConstant.BIGZERO);
        }
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("actualPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("actualTaxPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i)) && this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("localTaxAmount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("localAmount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("amount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("taxAmount=0", this.getPricePrecision(i));
        }
    }

    private void calByEntryTaxRate(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
                siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
            }
        } else {
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
            if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
                siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
            }
        }
    }

    public void calByQty(int i) {
        try {
            this.calBaseQtyByQty(i);
            if (this.editUI.isAssistForNumber()) {
                this.calAssistQtyByBaseQty(i);
            }
        }
        catch (Exception e) {
            this.editUI.handUIException(e);
        }
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
            }
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("actualPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("actualTaxPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("localTaxAmount=0", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("localAmount=0", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("amount=0", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0 && DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("taxAmount=0", this.getPricePrecision(i));
        }
    }

    private void calByTax(int i) {
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getAmountPrecision());
        }
    }

    private void calByUnit(int i) {
        try {
            this.calQty(i);
            if (this.editUI.isAssistForNumber()) {
                this.calAssistQtyByBaseQty(i);
            }
        }
        catch (Exception e) {
            this.editUI.handUIException(e);
        }
        IRow row = this.editUI.getDetailTable().getRow(i);
        PropertyCalculator siCalculator = new PropertyCalculator(row);
        BigDecimal discountRate = this.getDiscountRate(i);
        if (null == discountRate || discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
            discountRate = new BigDecimal("0.0");
        }
        if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=discountAmount/qty", this.getPricePrecision(i));
        }
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("taxPrice=discountAmount/qty/(discount/100)", this.getPricePrecision(i));
                } else {
                    siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
            }
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("price=discountAmount/qty/(1+taxRate/100)", this.getPricePrecision(i));
                } else {
                    siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
            }
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    private void calUnWriteOffAmount(int i) {
        this.setUnWriteOffAmount(this.getActualCost(i).subtract(this.getWrittenOffAmount(i)), i);
    }

    private void calWrittenOffAmount(int i) {
        this.setWrittenOffAmount(SysConstant.BIGZERO.setScale(this.getLocalAmountPrecision()), i);
        if (!this.isIsPresent(i) && SysConstant.BIGZERO.compareTo(this.getWrittenOffQty(i)) != 0 && this.getWrittenOffQty(i).compareTo(this.getQty(i)) == 0) {
            this.setWrittenOffAmount(this.getActualCost(i), i);
        } else if (!this.isIsPresent(i) && SysConstant.BIGZERO.compareTo(this.getWrittenOffQty(i)) != 0) {
            BigDecimal writtenOffAmount = this.getUnitActualCost(i).multiply(this.getWrittenOffQty(i)).setScale(this.getLocalAmountPrecision(), 4);
            this.setWrittenOffAmount(writtenOffAmount, i);
        }
    }

    private BigDecimal getBigDecimal(String fieldName, int i) {
        ICell cell = this.editUI.getDetailTable().getRow(i).getCell(fieldName);
        if (cell != null) {
            Object value = cell.getValue();
            if (value != null) {
                if (value instanceof BigDecimal) {
                    return this.nullToZero((BigDecimal)value);
                }
                BigDecimal value_BD = new BigDecimal(value.toString());
                return this.nullToZero(value_BD);
            }
            return this.nullToZero(null);
        }
        return this.nullToZero(null);
    }

    @Override
    protected int getDiscountRatePrecision(int i) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            return this.paramDiscountRate;
        }
        if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            return this.getPricePrecision(i);
        }
        return 2;
    }

    private BigDecimal getUnitActualCost(int i) {
        return this.getBigDecimal("unitActualCost", i);
    }

    private BigDecimal getWrittenOffAmount(int i) {
        return this.nullToZero((BigDecimal)this.editUI.getDetailTable().getRow(i).getCell("writtenOffAmount").getValue());
    }

    private BigDecimal getWrittenOffQty(int i) {
        return this.nullToZero((BigDecimal)this.editUI.getDetailTable().getRow(i).getCell("writtenOffQty").getValue());
    }

    private void setValue(String fieldName, Object value, int i) {
        this.editUI.getDetailTable().getRow(i).getCell(fieldName).setValue(value);
    }

    public BigDecimal formatBigDecimal(BigDecimal value) {
        return value == null ? this.ZERO : value;
    }
}

