/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.client.CCRelationBillListImpl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.CommonOperatorEnum;
import com.kingdee.eas.scm.im.inv.IRelationOfChildAndParentFacade;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBillSplitFacade;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.ITransferOrderBillEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.RelationOfChildAndParentFacadeFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillSplitFacadeFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractSaleIssueBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.MergeSplitedBillUIHelper;
import com.kingdee.eas.scm.im.inv.client.SaleIssueFilterUI;
import com.kingdee.eas.scm.im.inv.client.SplitBillDateUI;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class SaleIssueBillListUI
extends AbstractSaleIssueBillListUI {
    private static final long serialVersionUID = 933724280096818518L;
    public static final String RES_InvUI = "com.kingdee.eas.basedata.scm.im.inv.client.InvResource";
    public static final String MER_InvUI = "com.kingdee.eas.scm.im.inv.client.InvResource";
    public int amtPrecision = 2;
    SaleIssueFilterUI filterUI = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String entryID = this.getEntriesPKName();
            if (entryID != null && (keyValue = (cell = row.getCell(entryID)).getValue()) != null) {
                ISaleIssueEntry ise = SaleIssueEntryFactory.getRemoteInstance();
                SaleIssueEntryInfo pie = ise.getSaleIssueEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue.toString())));
                return pie.getCompanyOrgUnit();
            }
        }
        return null;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleIssueBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "number", "baseStatus", "sourceBillType", "sourceBillNumber", "transactionType", "bizDate", "customer", "customerNumber", "adminOrgUnit", "storageOrgUnitID", "isInitBill", "isReversed", "fiVouchered", "voucherNumber", "currency", "exchangeRate", "creator", "createTime", "modifier", "modifyTime", "auditor", "auditTime", "isGenBizAR", "bizType", "pcVouchered", "pcVoucherNumber", "description", "processNode"};
        return strMergeColKeys;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFormatTable();
        this.btnSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnWOffSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnWOffSplitBill.setEnabled(true);
        this.btnUniteBill.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.btnUniteBill.setEnabled(true);
        this.menuItemSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemWOffSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemWOffSplitBill.setEnabled(true);
        this.btnChangePrice.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemChangePrice.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.menuItemViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.actionUnAudit.setVisible(true);
        this.tblMain.getColumn("returnsQty").getStyleAttributes().setHided(true);
        if (null != this.filterUI && this.filterUI.isShowShortName()) {
            this.tblMain.getColumn("materialShortName").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("materialShortName").getStyleAttributes().setHided(true);
        }
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        int freezeCol = this.tblMain.getColumnIndex("number");
        this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
        this.menuItemExportData.setVisible(true);
        this.menuItemImportData.setVisible(true);
        if (this.getUIContext().get("BillMainQuery") != null) {
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    public void initFormatTable() throws Exception {
        String[] fields = new String[]{"standardCost", "actualCost", "writtenOffAmount", "unWriteOffAmount", "taxRate", "tax", "localTax", "amount", "taxAmount", "localTaxAmount"};
        for (int i = 0; i < fields.length; ++i) {
            this.tblMain.getColumn(fields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("entry.id"));
        return sic;
    }

    public String getEntriesPKName() {
        return "entry.id";
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "baseQty", "assistQty", "reverseQty", "returnsQty", "writtenOffQty", "drewQty", "unSettleQty", "unSettleBaseQty", "totalQty", "unWriteOffQty", "totalInWarehsQty", "confirmQty", "unVmiSettleBaseQty", "totalVmiSettleBaseQty", "totalIncomeConfirmQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"price", "localPrice", "unitStandardCost", "unitActualCost", "taxPrice", "actualPrice", "actualTaxPrice", "discount"};
    }

    public String[] getAmountColumns() {
        return new String[]{"localAmount", "tax", "localTax", "standardCost", "actualCost", "totalStandardCost", "totalActualCost", "writtenOffAmount", "unWriteOffAmount", "amount", "totalAmount", "totalLocalAmount", "taxAmount", "localTaxAmount", "totalSaleFee"};
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int exchangeRateprec = 2;
        int localAmountprc = 2;
        String[] UNIT_COLUMNS = new String[]{"entry.qty", "entry.reverseQty", "entry.unSettleQty", "entry.returnsQty", "totalQty", "entry.drewQty", "entry.writtenOffQty", "entry.unWriteOffQty", "entry.totalInWarehsQty"};
        String[] BASEUNIT_COLUMNS = new String[]{"entry.baseQty", "entry.unSettleBaseQty", "entry.unVmiSettleBaseQty", "entry.totalVmiSettleBaseQty"};
        String[] ASSISTUNIT_COLUMNS = new String[]{"entry.assistQty"};
        String[] PIRCE_COLUMNS = new String[]{"entry.price", "entry.localPrice", "entry.unitActualCost", "entry.unitStandardCost", "discount"};
        String[] TAX_COLUMNS = new String[]{"entry.tax", "totalAmount", "entry.amount", "entry.taxAmount", "entry.nonTaxAmount"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{"entry.localTax", "entry.localTaxAmount", "entry.localAmount", "totalLocalAmount", "entry.standardCost", "entry.actualCost", "totalStandardCost", "totalActualCost", "entry.writtenOffAmount", "entry.unWriteOffAmount", "entry.localNonTaxAmount"};
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                if (rowSet.getInt("currency.precision") > 0) {
                    exchangeRateprec = rowSet.getInt("currency.precision");
                }
                if (rowSet.getInt("currency2.precision") > 0) {
                    localAmountprc = rowSet.getInt("currency2.precision");
                }
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])UNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BASEUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISTUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PIRCE_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)exchangeRateprec, (String[])TAX_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)localAmountprc, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected String[] getTaxRateColumns() {
        return new String[]{"taxRate"};
    }

    public boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency2.precision"));
        sic.add(new SelectorItemInfo("entry.assistQty"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntriesName()));
        return sic;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    boolean isVouchered = (Boolean)this.tblMain.getCell(j, "fiVouchered").getValue();
                    boolean isReversed = (Boolean)this.tblMain.getCell(j, "isReversed").getValue();
                    if (isVouchered) {
                        MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_VOUCHERED"));
                        SysUtil.abort();
                    }
                    if (!isReversed) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_ISREVERSED"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.tblMain.getColumn("id").setWidth(-1);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.commonQueryDialog != null) {
            this.commonQueryDialog.setHeight(460);
        }
        if (this.filterUI == null) {
            this.filterUI = new SaleIssueFilterUI();
        }
        return this.filterUI;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        HashMap botpMap;
        FilterInfo filter = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID")) {
            String billTypeId = botpMap.get("DESTBILLTYPE.ID").toString();
            Object botpId = this.getUIContext().get("BOTMappingInfo_ID");
            Object o = botpMap.get("MAINBIZORG");
            StorageOrgUnitInfo destSou = null;
            if (o instanceof StorageOrgUnitInfo) {
                destSou = (StorageOrgUnitInfo)o;
            }
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId)) {
                String destMainOrgId;
                filter = new FilterInfo();
                String string = destMainOrgId = destSou == null ? null : destSou.getId().toString();
                if (botpId != null && !botpId.toString().equals("0UMBIgEPEADgAACXwKgSOwRRIsQ=")) {
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filtInfo = new FilterInfo();
                    filtInfo.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit.ID", (Object)destMainOrgId, CompareType.EQUALS));
                    filtInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
                    filtInfo.getFilterItems().add(new FilterItemInfo("associateQty", (Object)new Integer(0), CompareType.GREATER));
                    evi.setFilter(filtInfo);
                    evi.getSelector().add(new SelectorItemInfo("ID"));
                    evi.getSelector().add(new SelectorItemInfo("parent.ID"));
                    evi.getSelector().add(new SelectorItemInfo("issueStorageOrgUnit.ID"));
                    TransferOrderBillEntryCollection entryCol = null;
                    try {
                        ITransferOrderBillEntry iTranEntry = TransferOrderBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainContext());
                        entryCol = iTranEntry.getTransferOrderBillEntryCollection(evi);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                    TransferOrderBillEntryInfo entry = null;
                    int size = entryCol.size();
                    if (size > 0) {
                        HashSet<String> coreEntryIdSet = new HashSet<String>();
                        for (int i = 0; i < size; ++i) {
                            entry = entryCol.get(i);
                            coreEntryIdSet.add(entry.getId().toString());
                        }
                        filter.getFilterItems().add(new FilterItemInfo("entry.saleOrderEntry", coreEntryIdSet, CompareType.INCLUDE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("entry.saleOrder", (Object)"NonExistedCoreBillID_TransferOrder", CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("entry.saleOrderEntry", (Object)"NonExistedCoreBillEntryID_TransferOrder", CompareType.EQUALS));
                    }
                } else {
                    CompanyOrgUnitInfo destCou = InvClientUtils.getCompanyInfo(destSou);
                    if (destCou != null) {
                        try {
                            CustomerCollection innerCustomerCollection = CustomerFactory.getRemoteInstance().getCustomerCollectionByInter(destCou.getId().toString());
                            if (innerCustomerCollection != null) {
                                HashSet<String> set = new HashSet<String>();
                                for (int i = 0; i < innerCustomerCollection.size(); ++i) {
                                    set.add(innerCustomerCollection.get(i).getId().toString());
                                }
                                if (set.size() == 0) {
                                    filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)"NoCustomer", CompareType.EQUALS));
                                } else {
                                    filter.getFilterItems().add(new FilterItemInfo("customer.id", set, CompareType.INCLUDE));
                                }
                            }
                        }
                        catch (Exception e) {
                            this.handUIException(e);
                        }
                    }
                }
            }
        }
        return filter;
    }

    protected void multiPrint(boolean isPrint) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        SCMCommonDataProvider data = new SCMCommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected String getTDFileName() {
        return "/SCM/IM/Issue/SaleIssueBill";
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.SaleIssuePrintQuery");
    }

    public void actionMultiPrint_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrint_actionPerformed(arg0);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(arg0);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("TransferOrderBillType", "transferOrderBill");
        super.actionTraceUp_actionPerformed(e);
    }

    @Override
    public void actionUniteBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)MER_InvUI, (String)"onlyOne"));
            return;
        }
        String id = ids.get(0).toString();
        IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getRemoteInstance();
        iRelationOfChildAndParentFacade.judgeCanMerge(id, "CC3E933B");
        Map UIContext2 = this.getUIContext();
        String bosType = this.getBOSType().toString();
        MergeSplitedBillUIHelper.showMergeSplitBillUI(UIContext2, "com.kingdee.eas.scm.im.inv.client.SaleIssueBillListUI", bosType, id);
        super.actionRefresh_actionPerformed(e);
    }

    public void addMutexServiceNotRelease(String id) throws Exception {
        boolean hasResource = false;
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        hasResource = mutexService.requestObjIDForUpdate(id);
        if (!hasResource) {
            throw new InvBizException(InvBizException.MSG_NET_LOCK);
        }
    }

    @Override
    public void actionWOffSplitBill_actionPerformed(ActionEvent e) throws Exception {
        ISaleIssueBillSplitFacade splitFacade;
        HashMap hm;
        boolean isBillSplitChangeDate;
        this.checkSelected();
        String storageUnitID = this.getOrgPK(null).toString();
        ArrayList bizDateList = this.getSelectedFieldValues("bizDate");
        Date billBizDate = new Date();
        if (bizDateList != null && bizDateList.size() > 0) {
            SimpleDateFormat myFormDate = new SimpleDateFormat("yyyy-MM-dd");
            billBizDate = myFormDate.parse((String)bizDateList.get(0));
        }
        String[] orgIDs = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"storageOrgUnit.id");
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        this.checkAllBillHasSamePeriod(ids);
        this.checkAllSouHasSamePeriod(orgIDs);
        CompanyOrgUnitInfo companyInfo = InvClientUtils.getCompanyInfo(storageUnitID);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo(null, (Date)billBizDate, (CompanyOrgUnitInfo)InvClientUtils.getCompanyInfo(storageUnitID));
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)InvClientUtils.getCompanyInfo(storageUnitID));
        IObjectPK[] pks = this.changetToPKs(ids);
        Date bizDate = null;
        if (!billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate()) && (isBillSplitChangeDate = this.getAllSouParamForSplitChangeDate(orgIDs))) {
            bizDate = this.confirmSplitBill("50957179-0105-1000-e000-015bc0a812fd463ED552", storageUnitID);
        }
        if ((hm = (splitFacade = SaleIssueBillSplitFacadeFactory.getRemoteInstance()).split(pks, bizDate)).size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"batchSplit_Sucess"));
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"batchSplit_DisSucess"), (String)this.getReturnMsg(hm), (int)1);
        }
        this.refreshList();
    }

    private boolean getAllSouParamForSplitChangeDate(String[] orgIDs) throws Exception {
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("INM100");
        for (int i = 0; i < orgIDs.length; ++i) {
            String orgId = orgIDs[i];
            if (orgIdStrList.contains(orgId)) continue;
            orgIdStrList.add(orgId);
        }
        ArrayList paramList = ParamControlFactory.getRemoteInstance().getParamHashMapBatch(paramNumberList, orgIdStrList);
        ParamSimpleInfo paramInfo = null;
        HashSet<String> paramSet = new HashSet<String>();
        for (int i = 0; i < paramList.size(); ++i) {
            paramInfo = (ParamSimpleInfo)paramList.get(i);
            paramSet.add(paramInfo.getParamValue());
        }
        if (paramSet.size() > 1) {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"not_same_paramForSplitChangeDate");
            MsgBox.showInfo((String)errHeadStr);
            SysUtil.abort();
        }
        return paramInfo == null ? false : paramInfo.getParamValue().equals(Boolean.TRUE.toString());
    }

    private void checkAllSouHasSamePeriod(String[] orgIDs) throws Exception {
        if (orgIDs != null && orgIDs.length > 1) {
            int size = orgIDs.length;
            BOSUuid[] bosIDs = new BOSUuid[size];
            for (int index = 0; index < size; ++index) {
                if (orgIDs[index] == null) continue;
                bosIDs[index] = BOSUuid.read((String)orgIDs[index]);
            }
            ISCMBillCommonFacade iScmBillCommon = SCMBillCommonFacadeFactory.getRemoteInstance();
            Map map = iScmBillCommon.getCompanyInfos(bosIDs);
            HashMap compareMap = new HashMap();
            HashSet<String> couSet = new HashSet<String>();
            if (map != null) {
                Set set = map.keySet();
                for (String id : set) {
                    CompanyOrgUnitInfo company;
                    if (map.get(id) == null || (company = (CompanyOrgUnitInfo)map.get(id)) == null) continue;
                    couSet.add(company.getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", couSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)SystemEnum.INVENTORYMANAGEMENT));
                view.setFilter(filter);
                SystemStatusCtrolCollection coll = SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(view);
                HashSet<String> periodIdSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    periodIdSet.add(coll.get(i).getCurrentPeriod() == null ? null : coll.get(i).getCurrentPeriod().getId().toString());
                }
                if (periodIdSet.size() > 1) {
                    String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"allCouHasNotSamePeriod");
                    MsgBox.showInfo((String)errHeadStr);
                    SysUtil.abort();
                }
            }
        }
    }

    private void checkAllBillHasSamePeriod(String[] ids) throws Exception {
        if (ids.length <= 1) {
            return;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("year"));
        view.setSelector(selector);
        SaleIssueBillCollection collection = ((ISaleIssueBill)this.getBizInterface()).getSaleIssueBillCollection(view);
        if (collection != null && collection.size() <= 1) {
            return;
        }
        HashSet<Integer> yearSet = new HashSet<Integer>();
        HashSet<Integer> periodSet = new HashSet<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            yearSet.add(collection.get(i).getYear());
            periodSet.add(collection.get(i).getPeriod());
        }
        if (yearSet.size() > 1 || periodSet.size() > 1) {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"allBillHasNotSamePeriod");
            MsgBox.showInfo((String)errHeadStr);
            SysUtil.abort();
        }
    }

    @Override
    public void actionSplitBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(id);
        ISaleIssueBillSplitFacade splitFacade = SaleIssueBillSplitFacadeFactory.getRemoteInstance();
        splitFacade.check((IObjectPK)pk);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.writtenOffQty"));
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)this.getBizInterface().getValue((IObjectPK)pk, selector);
        if (this.isNoneWriteOff(saleIssueBillInfo)) {
            this.addMutexServiceNotRelease(id);
            this.actionView_actionPerformed(e);
        } else {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"CanNotSplitByHand");
            MsgBox.showInfo((String)errHeadStr);
            SysUtil.abort();
        }
    }

    @Override
    public void actionChangePrice_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(id);
        String errorMsg = SaleIssueBillFactory.getRemoteInstance().checkChangePrice((IObjectPK)pk);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            String errHeadStr = InvClientUtils.getResource("CHANGEPRICE_ERRORHEAD") + "\n";
            MsgBox.showWarning((Component)((Object)this), (String)(errHeadStr + errorMsg));
            SysUtil.abort();
        }
        this.addMutexServiceNotRelease(id);
        this.actionView_actionPerformed(e);
    }

    protected String getReturnMsg(HashMap hm) {
        if (hm == null) {
            return "";
        }
        StringBuffer ReturnMsg = new StringBuffer();
        if (hm.size() > 0) {
            ReturnMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"billNO")).append("\r\n");
        }
        for (Map.Entry entry : hm.entrySet()) {
            ReturnMsg.append(entry.getKey());
            ReturnMsg.append(entry.getValue());
            ReturnMsg.append("\r\n");
        }
        return ReturnMsg.toString();
    }

    protected IObjectPK[] changetToPKs(String[] ids) {
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            pkSet.add(ids[i]);
        }
        Object[] pks = pkSet.toArray();
        IObjectPK[] pkIDs = new IObjectPK[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            pkIDs[i] = new ObjectStringPK((String)pks[i]);
        }
        return pkIDs;
    }

    @Override
    protected Date confirmSplitBill(String billType, String storageUnitID) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BILL_TYPE_ID", (Object)billType);
        uiContext.put((Object)"STORAGE_ORGUNIT_ID", (Object)storageUnitID);
        ArrayList bizDateList = this.getSelectedFieldValues("bizDate");
        Date billBizDate = new Date();
        if (bizDateList != null && bizDateList.size() > 0) {
            SimpleDateFormat myFormDate = new SimpleDateFormat("yyyy-MM-dd");
            billBizDate = myFormDate.parse((String)bizDateList.get(0));
        }
        PeriodInfo pInfo = PeriodUtils.getPeriodInfo(null, (Date)billBizDate, (CompanyOrgUnitInfo)InvClientUtils.getCompanyInfo(storageUnitID));
        uiContext.put((Object)"period", (Object)pInfo);
        uiContext.put((Object)"bizDate", (Object)billBizDate);
        IUIWindow splitBillDateUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.SplitBillDateUI", (Map)uiContext, null, OprtState.EDIT);
        SplitBillDateUI aSplitBillDateUI = (SplitBillDateUI)splitBillDateUIWindow.getUIObject();
        aSplitBillDateUI.initData(billType, storageUnitID);
        splitBillDateUIWindow.show();
        if (aSplitBillDateUI.isCancel()) {
            SysUtil.abort();
        }
        return aSplitBillDateUI.getChildBillDate();
    }

    private boolean isNoneWriteOff(SaleIssueBillInfo saleIssueBillInfo) {
        if (null == saleIssueBillInfo || saleIssueBillInfo.getEntry() == null || saleIssueBillInfo.getEntry().size() == 0) {
            return false;
        }
        SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entry = entryCol.get(i);
            if (entry.getWrittenOffQty() == null || entry.getWrittenOffQty().abs().compareTo(SysConstant.BIGZERO) <= 0) continue;
            return false;
        }
        return true;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.btnSplitBill.equals(e.getSource()) || this.menuItemSplitBill.equals(e.getSource())) {
            uiContext.put((Object)"SPLIT_FROM_LIST", (Object)Boolean.TRUE);
        } else {
            uiContext.remove((Object)"SPLIT_FROM_LIST");
        }
        if (this.btnChangePrice == e.getSource() || this.menuItemChangePrice == e.getSource()) {
            uiContext.put((Object)"CHANGEPRICE", (Object)Boolean.TRUE);
        } else {
            uiContext.remove((Object)"CHANGEPRICE");
        }
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, SaleIssueBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, SaleIssueEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        int i;
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("isInitBill"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        SaleIssueBillCollection coll = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(view);
        String[] orgIDs = new String[coll.size()];
        String[] isCreateVoucher = new String[coll.size()];
        for (i = 0; i < coll.size(); ++i) {
            orgIDs[i] = coll.get(i).getStorageOrgUnit().getId().toString();
            isCreateVoucher[i] = Boolean.toString(coll.get(i).isIsInitBill());
        }
        if (!InvClientUtils.checkStorageConsignSameCompany(orgIDs)) {
            return;
        }
        for (i = 0; i < isCreateVoucher.length; ++i) {
            if (!isCreateVoucher[i].equals("true")) continue;
            String isSelectInitBill = EASResource.getString((String)this.invAddResource, (String)"isInitBill");
            MsgBox.showInfo((String)isSelectInitBill);
            this.abort();
        }
        HashSet<String> set = new HashSet<String>();
        int size = orgIDs.length;
        for (int i2 = 0; i2 < size; ++i2) {
            set.add(orgIDs[i2]);
        }
        Object[] orgIDs2 = set.toArray();
        try {
            IPermission iPer = PermissionFactory.getRemoteInstance();
            for (int index = 0; index < orgIDs2.length; ++index) {
                iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgIDs2[index].toString())), "saleissue_generalVoucher");
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return;
        }
        OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)orgIDs[0]));
        this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfo);
        super.actionVoucher_actionPerformed(e);
    }

    @Override
    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        return super.prepareActionAddNew(itemAction);
    }

    @Override
    public RequestContext prepareActionSplitBill(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSplitBill(itemAction);
        request.setClassName("com.kingdee.eas.scm.im.inv.app.SaleIssueBillListUIHandler");
        return request;
    }

    @Override
    public RequestContext prepareActionAudit(IItemAction itemAction) throws Exception {
        return super.prepareActionAudit(itemAction);
    }

    public RequestContext prepareActionCreateTo(IItemAction itemAction) throws Exception {
        return super.prepareActionCreateTo(itemAction);
    }

    @Override
    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    public RequestContext prepareActionQuery(IItemAction itemAction) throws Exception {
        return super.prepareActionQuery(itemAction);
    }

    @Override
    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        return super.prepareActionRemove(itemAction);
    }

    public RequestContext prepareActionTraceDown(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceDown(itemAction);
    }

    public RequestContext prepareActionTraceUp(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceUp(itemAction);
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        return super.prepareActionView(itemAction);
    }

    public RequestContext prepareActionVoucher(IItemAction itemAction) throws Exception {
        return super.prepareActionVoucher(itemAction);
    }

    @Override
    public IUIActionPostman prepareInit() {
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.im.inv.app.SaleIssueBillListUIHandler");
        IUIActionPostman handler = super.prepareInit();
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return false;
    }

    @Override
    public boolean isPrepareActionAudit() {
        return false;
    }

    public boolean isPrepareActionCreateTo() {
        return false;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return false;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    @Override
    public boolean isPrepareActionRemove() {
        return false;
    }

    public boolean isPrepareActionTraceDown() {
        return false;
    }

    public boolean isPrepareActionTraceUp() {
        return false;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionVoucher() {
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionSplitBill() {
        return false;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.saleIssue";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.saleIssue";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)RES_InvUI, (String)"SALEISSUEBILL");
        param.varList = new ArrayList();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("filter", this.mainQuery.getFilter());
        EntityViewInfo viewInfo = (EntityViewInfo)this.mainQuery.clone();
        viewInfo.setSelector(null);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        viewInfo.setSorter(sorter);
        viewInfo.setRemoveEntry(false);
        hashtable.put("mainQuery", viewInfo);
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        String[] idArray;
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISCHECKCREDIT_SERVER", (Object)Boolean.TRUE);
        boolean returnValue = super.beforeAction(bizAction, selectionEntries, event);
        if (!returnValue) {
            return false;
        }
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            idArray = selectionEntries.getIdArray();
            if (idArray == null || idArray.length == 0) {
                return false;
            }
            try {
                if (this.isConsSettleCreateToSaleIssueBill(idArray)) {
                    throw new InvBizException(InvBizException.HASCONSBILLSALEISSUENOTOPERATOR, new String[]{CommonOperatorEnum.UNAUDIT.getAlias()});
                }
            }
            catch (InvBizException e) {
                this.handleException((Exception)((Object)e));
                return false;
            }
        }
        if (!this.isCreditControl(bizAction)) {
            return false;
        }
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            idArray = selectionEntries.getIdArray();
            if (idArray == null || idArray.length == 0) {
                return false;
            }
            try {
                ISaleIssueEntry iSaleIssue = SaleIssueEntryFactory.getRemoteInstance();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("saleOrderEntry");
                selector.add("id");
                List<String> idList = Arrays.asList(idArray);
                HashSet<String> idSet = new HashSet<String>(idList);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", idSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("coreBillType.id", (Object)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
                view.setFilter(filter);
                view.setSelector(selector);
                SaleIssueEntryCollection coll = iSaleIssue.getSaleIssueEntryCollection(view);
                if (coll == null || coll.size() == 0) {
                    return true;
                }
                HashSet<String> orderEntryIds = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    orderEntryIds.add(coll.get(i).getSaleOrderEntry());
                }
                try {
                    if (orderEntryIds.size() > 0) {
                        ((ISaleIssueBill)this.getBizInterface()).checkPreReceived(orderEntryIds);
                    }
                }
                catch (InvUpdateException e) {
                    if (e.getSubCode().equals(InvUpdateException.SALEORDER_UNPREPAYMENT_OVERZERO.getCode())) {
                        String detail;
                        String error = e.getMessage().substring(0, e.getMessage().indexOf(10));
                        if (MsgBox.showConfirm3a((Component)((Object)this), (String)error, (String)(detail = e.getMessage().substring(e.getMessage().indexOf(10)))) != 2) return true;
                        SysUtil.abort();
                    } else if (e.getSubCode().equals(InvUpdateException.SALEORDER_UNPREPAYMENT_OVERZERO_FORCE.getCode())) {
                        this.handUIException((Throwable)((Object)e));
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                    return false;
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                return false;
            }
        }
        if (!bizAction.equals((Object)BatchActionEnum.UNAUDIT)) return true;
        List pur = selectionEntries.getEntries();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pur.size(); ++i) {
            BatchSelectionEntry batchSelectionEntry = (BatchSelectionEntry)pur.get(i);
            String id = batchSelectionEntry.getId().toString();
            idSet.add(id);
        }
        Map resultMap = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("idSet", idSet);
        map.put("bosType", SCMConstant.BOSTYPE_SALEISSUE);
        try {
            IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getRemoteInstance();
            resultMap = iRelationOfChildAndParentFacade.queryInfoByMap(map);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        List idList = (List)resultMap.get("idList");
        if (idList.isEmpty()) {
            return true;
        }
        if (idList.isEmpty()) return true;
        String s = (String)resultMap.get("childinfo");
        StringBuffer bs = new StringBuffer();
        bs.append(EASResource.getString((String)MER_InvUI, (String)"MotherNumber"));
        bs.append("                                             ");
        bs.append(EASResource.getString((String)MER_InvUI, (String)"ChildNumber"));
        bs.append("\n");
        bs.append(s);
        int flag = MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)MER_InvUI, (String)"ConfirmWhetherToOpenTheBill"), (String)bs.toString());
        if (0 == flag) return true;
        for (int j = pur.size() - 1; j >= 0; --j) {
            BatchSelectionEntry batchSelectionEntry = (BatchSelectionEntry)pur.get(j);
            String id = batchSelectionEntry.getId().toString();
            if (!idList.contains(id)) continue;
            pur.remove(j);
        }
        return true;
    }

    private boolean isNeedHanldeCheckkCreditAtAudit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleIssueBillInfo bill = (SaleIssueBillInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtAudit(bill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCreditAtUnAudit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleIssueBillInfo bill = (SaleIssueBillInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtUnAudit(bill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCreditAtDelete(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleIssueBillInfo bill = (SaleIssueBillInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtDelete(bill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCredit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleIssueBillInfo bill = (SaleIssueBillInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtSubmit((Object)bill);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isConsSettleCreateToSaleIssueBill(String[] idArray) {
        boolean isConssettled = false;
        HashSet<String> billIdSet = new HashSet<String>();
        int len = idArray.length;
        for (int i = 0; i < len; ++i) {
            if (idArray[i] == null) continue;
            billIdSet.add(idArray[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        filterInfo.appendFilterItem("sourceBillType.id", (Object)"50957179-0105-1000-e000-015bc0a812fd463ED552");
        filterInfo.appendFilterItem("bizType.id", (Object)"d8e80652-0113-1000-e000-04c5c0a812202407435C");
        filterInfo.appendFilterItem("transactionType.riType.id", (Object)RecIssueTypeConstant.SALEOUT_RITYPEID);
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        try {
            SaleIssueBillCollection saleIssueColl = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(view);
            if (saleIssueColl != null && saleIssueColl.size() > 0) {
                isConssettled = true;
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return isConssettled;
    }

    @Override
    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
    }

    @Override
    public OrgType getMainBizOrgType() {
        return super.getMainBizOrgType();
    }

    public void beforeTransform(IObjectCollection srcObjCols, String destBillBosType) {
        if ("FC910EF3".equals(destBillBosType)) {
            if (srcObjCols instanceof CoreBillBaseCollection) {
                CoreBillBaseCollection coreBillBaseColl = (CoreBillBaseCollection)srcObjCols;
                HashSet<String> idSet = new HashSet<String>();
                int count = coreBillBaseColl.size();
                for (int i = 0; i < count; ++i) {
                    if (coreBillBaseColl.get(i) == null) continue;
                    idSet.add(coreBillBaseColl.get(i).getId().toString());
                }
                if (idSet.size() == 0) {
                    return;
                }
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("bizType.ID", (Object)"d8e80652-0113-1000-e000-04c5c0a812202407435C");
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("transactionType.isWriteOff", (Object)false, CompareType.EQUALS));
                view.setSelector(sic);
                view.setFilter(filter);
                try {
                    SaleIssueBillCollection saleIssueColl = SaleIssueBillFactory.getRemoteInstance().getSaleIssueBillCollection(view);
                    if (saleIssueColl != null && saleIssueColl.size() > 0) {
                        MsgBox.showWarning((Component)((Object)this), (String)InvClientUtils.getResource("CONSIGN_OUTORRT_SALEISSUE_NOT2ARBILL"));
                        SysUtil.abort();
                    }
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        } else if (SCMConstant.BOSTYPE_INCOMECONFIMBILL.equals(destBillBosType) && (this.getUIContext().get("BTPEDITPARAMETER") == null || ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DESTBOSTYPE.ID") == null)) {
            this.checkIncomeConfirm(srcObjCols, destBillBosType);
        }
        if (SCMConstant.BOSTYPE_INCOMECONFIMBILL.equals(destBillBosType) || "FC910EF3".equals(destBillBosType)) {
            this.checkVMITrans(srcObjCols, destBillBosType);
        }
    }

    private void checkVMITrans(IObjectCollection srcObjCols, String destBillBosType) {
        if (srcObjCols instanceof CoreBillBaseCollection) {
            CoreBillBaseCollection coreBillBaseColl = (CoreBillBaseCollection)srcObjCols;
            HashSet<String> idSet = new HashSet<String>();
            int count = coreBillBaseColl.size();
            for (int i = 0; i < count; ++i) {
                if (coreBillBaseColl.get(i) == null) continue;
                idSet.add(coreBillBaseColl.get(i).getId().toString());
            }
            if (idSet.size() == 0) {
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("invUpdateType.storeTypePre", (Object)"181875d5-0105-1000-e000-0114c0a812fd97D461A6"));
            view.setFilter(filter);
            boolean exist = false;
            try {
                exist = SaleIssueEntryFactory.getRemoteInstance().exists(filter);
                if (exist) {
                    String resourceKey = "VMICANTGENAP";
                    if (SCMConstant.BOSTYPE_INCOMECONFIMBILL.equals(destBillBosType)) {
                        resourceKey = "VMICANTGENINCOME";
                    }
                    MsgBox.showWarning((Component)((Object)this), (String)InvClientUtils.getResource(resourceKey));
                    SysUtil.abort();
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizDate", "customer", "storggeOrgUnit", "materialNumber", "materialName", "model", "transactionType", "unit", "qty", "warehouse", "location", "unitActualCost", "actualCost"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    protected String[] getQueryHideField() {
        return new String[]{"isInitBill", "fiVouchered", "isReversed", "storageOrgUnit.id"};
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    @Override
    public void actionViewWriteOffRecord_actionPerformed(ActionEvent e) throws Exception {
        CoreBillBaseCollection bills = this.getNewBillList();
        CCRelationBillListImpl billList = new CCRelationBillListImpl((CoreBillListUI)this);
        this.getUIContext().put("isSaleWriteOff", new Boolean("true"));
        billList.traceDown(bills, this.getEntriesPKName(), this.getUIContext());
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("BillQuery") != null) {
            return super.getQuickFilteringSupport();
        }
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        Object numberO = row.getCell("number").getValue();
        if (numberO != null && numberO.toString().contains("_C")) {
            this.getUIContext().put("igornEntryRelation", true);
        }
        super.actionTraceDown_actionPerformed(e);
        this.getUIContext().put("igornEntryRelation", null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
        this.menuItemSplitMerge.setEnabled(true);
        this.menuItemSplitMerge.setVisible(true);
        this.menuItemSplitMerge.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
    }

    public CustomerInfo getCustomerInfo(IObjectValue info) throws Exception {
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)info;
        return CreditUtils.readFullCustomerInfo(null, (CustomerInfo)saleIssueBillInfo.getCustomer());
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo(IObjectValue info) throws Exception {
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)info;
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)saleIssueBillInfo.getStorageOrgUnit(), (boolean)true);
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    @Override
    protected String getGeneralPCVoucherPermission() {
        return "saleissue_generalPcVoucher";
    }

    @Override
    protected String getStorageColName() {
        return "storageOrgUnit.id";
    }

    @Override
    protected void checkOtherForPCVoucher() throws Exception {
        super.checkOtherForPCVoucher();
        String[] isCreateVoucher = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"isInitBill");
        for (int i = 0; i < isCreateVoucher.length; ++i) {
            if (!isCreateVoucher[i].equals("true")) continue;
            String isSelectInitBill = EASResource.getString((String)this.invAddResource, (String)"isInitBill");
            MsgBox.showInfo((String)isSelectInitBill);
            this.abort();
        }
    }

    protected BOSObjectType getBOSType() {
        return new SaleIssueBillInfo().getBOSType();
    }

    protected void checkIncomeConfirm(IObjectCollection srcObjCols, String destBillBosType) {
        if (srcObjCols instanceof CoreBillBaseCollection) {
            CoreBillBaseCollection coreBillBaseColl = (CoreBillBaseCollection)srcObjCols;
            if (null == coreBillBaseColl || coreBillBaseColl.size() == 0) {
                return;
            }
            SaleIssueBillInfo issueBillInfo = null;
            boolean haveIncomeConfirmIsFalse = false;
            Object bizTypeID = null;
            for (int i = 0; i < coreBillBaseColl.size() && coreBillBaseColl.get(i) instanceof SaleIssueBillInfo; ++i) {
                int size;
                issueBillInfo = (SaleIssueBillInfo)coreBillBaseColl.get(i);
                if (null != issueBillInfo.getEntry() && (size = issueBillInfo.getEntry().size()) > 0) {
                    for (int j = 0; j < size; ++j) {
                        SaleIssueEntryInfo entryInfo = issueBillInfo.getEntry().get(j);
                        if (!SCMConstant.BOSTYPE_INCOMECONFIMBILL.equals(destBillBosType) || entryInfo.isIsIncomeConfirm()) continue;
                        haveIncomeConfirmIsFalse = true;
                        break;
                    }
                }
                if (haveIncomeConfirmIsFalse) break;
            }
            if (haveIncomeConfirmIsFalse) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.invAddResource, (String)"IncomeConfirmDontPushIC"));
                SysUtil.abort();
            }
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        Map btpeditparameter;
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "arOtherBill".equals((btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType")) && !((Boolean)btpeditparameter.get("ISBIZBILL")).booleanValue()) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("entry.isIncomeConfirm", (Object)0));
            try {
                this.mainQuery.getFilter().mergeFilter(fi, "AND");
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
        super.tblMain_doRequestRowSet(e);
    }
}

