/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractSaleIssueBillVirtualListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.SaleIssueVirtualFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SaleIssueBillVirtualListUI
extends AbstractSaleIssueBillVirtualListUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleIssueBillVirtualListUI.class);
    public int amtPrecision = 2;
    SaleIssueVirtualFilterUI filterUI = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String entryID = this.getEntriesPKName();
            if (entryID != null && (keyValue = (cell = row.getCell(entryID)).getValue()) != null) {
                ISaleIssueEntry ise = SaleIssueEntryFactory.getRemoteInstance();
                SaleIssueEntryInfo pie = ise.getSaleIssueEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue.toString())));
                return pie.getCompanyOrgUnit();
            }
        }
        return null;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleIssueBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "number", "baseStatus", "sourceBillType", "sourceBillNumber", "transactionType", "bizDate", "customer", "adminOrgUnit", "storageOrgUnitID", "totalQty", "isInitBill", "totalTaxAmount", "totalStandardCost", "totalActualCost", "isReversed", "fiVouchered", "voucherNumber", "currency", "exchangeRate", "creator", "createTime", "modifier", "modifyTime", "auditor", "auditTime", "customerNumber"};
        return strMergeColKeys;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemAudit.setVisible(false);
        this.btnAudit.setVisible(false);
        this.menuItemUnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.tblMain.getColumn("returnsQty").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        int freezeCol = this.tblMain.getColumnIndex("number");
        this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    public void initFormatTable() throws Exception {
        String[] fields = new String[]{"totalStandardCost", "totalActualCost", "standardCost", "actualCost", "writtenOffAmount", "unWriteOffAmount", "taxRate", "tax", "localTax", "localAmount", "nonTaxAmount", "localNonTaxAmount", "amount"};
        for (int i = 0; i < fields.length; ++i) {
            InvClientUtils.fmtTableAmt(this.tblMain, fields[i], this.amtPrecision);
        }
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.isInternalCompany"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("transactionType.id"));
        sic.add(new SelectorItemInfo("transactionType.number"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.baseQty"));
        sic.add(new SelectorItemInfo("entry.price"));
        sic.add(new SelectorItemInfo("entry.warehouse.id"));
        sic.add(new SelectorItemInfo("entry.warehouse.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.name"));
        sic.add(new SelectorItemInfo("entry.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.stocker.id"));
        sic.add(new SelectorItemInfo("entry.stocker.number"));
        sic.add(new SelectorItemInfo("entry.stocker.name"));
        sic.add(new SelectorItemInfo("entry.location.id"));
        sic.add(new SelectorItemInfo("entry.location.number"));
        sic.add(new SelectorItemInfo("entry.location.name"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.saleGroup.id"));
        sic.add(new SelectorItemInfo("entry.saleGroup.number"));
        sic.add(new SelectorItemInfo("entry.saleGroup.name"));
        sic.add(new SelectorItemInfo("entry.salePerson.id"));
        sic.add(new SelectorItemInfo("entry.salePerson.number"));
        sic.add(new SelectorItemInfo("entry.salePerson.name"));
        sic.add(new SelectorItemInfo("entry.saleOrder"));
        sic.add(new SelectorItemInfo("entry.saleOrderEntry"));
        sic.add(new SelectorItemInfo("entry.coreBillType.id"));
        sic.add(new SelectorItemInfo("entry.coreBillType.name"));
        sic.add(new SelectorItemInfo("entry.coreBillType.number"));
        return sic;
    }

    public String getEntriesPKName() {
        return "entry.id";
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "baseQty", "reverseQty", "returnsQty", "writtenOffQty", "drewQty", "totalQty", "unWriteOffQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"price", "localPrice", "unitStandardCost", "unitActualCost"};
    }

    public String[] getAmountColumns() {
        return new String[]{"exchangeRate", "localAmount", "tax", "localTax", "standardCost", "actualCost", "totalStandardCost", "totalActualCost", "writtenOffAmount", "unWriteOffAmount", "amount", "totalAmount"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int exchangeRateprec = 2;
        String[] UNIT_COLUMNS = new String[]{"entry.qty", "entry.reverseQty", "entry.returnsQty", "totalQty", "entry.drewQty", "entry.writtenOffQty", "entry.unWriteOffQty"};
        String[] BASEUNIT_COLUMNS = new String[]{"entry.baseQty"};
        String[] ASSISTUNIT_COLUMNS = new String[]{"entry.assistQty"};
        String[] PIRCE_COLUMNS = new String[]{"entry.price", "entry.localPrice", "entry.unitActualCost", "entry.unitStandardCost"};
        String[] TAX_COLUMNS = new String[]{"exchangeRate", "entry.writtenOffAmount", "entry.unWriteOffAmount", "entry.localAmount", "entry.tax", "entry.localTax", "entry.standardCost", "entry.actualCost", "totalStandardCost", "totalActualCost", "totalAmount", "entry.amount"};
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getInt("currency.precision") > 0) {
                    exchangeRateprec = rowSet.getInt("currency.precision");
                }
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])UNIT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BASEUNIT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISTUNIT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PIRCE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)exchangeRateprec, (String[])TAX_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    boolean isVouchered = (Boolean)this.tblMain.getCell(j, "fiVouchered").getValue();
                    boolean isReversed = (Boolean)this.tblMain.getCell(j, "isReversed").getValue();
                    if (isVouchered) {
                        MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_VOUCHERED"));
                        SysUtil.abort();
                    }
                    if (!isReversed) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_ISREVERSED"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SaleIssueVirtualFilterUI();
        }
        return this.filterUI;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        FilterInfo filter = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId = botpMap.get("DESTBILLTYPE.ID").toString())) {
            filter = new FilterInfo();
            StorageOrgUnitInfo destSou = (StorageOrgUnitInfo)botpMap.get("MAINBIZORG");
            CompanyOrgUnitInfo destCou = InvClientUtils.getCompanyInfo(destSou);
            if (destCou != null) {
                try {
                    CustomerCollection innerCustomerCollection = CustomerFactory.getRemoteInstance().getCustomerCollectionByInter(destCou.getId().toString());
                    if (innerCustomerCollection != null) {
                        HashSet<String> set = new HashSet<String>();
                        for (int i = 0; i < innerCustomerCollection.size(); ++i) {
                            set.add(innerCustomerCollection.get(i).getId().toString());
                        }
                        if (set.size() == 0) {
                            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)"NoCustomer", CompareType.EQUALS));
                        } else {
                            filter.getFilterItems().add(new FilterItemInfo("customer.id", set, CompareType.INCLUDE));
                        }
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return filter;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"783061E3".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    public List getDestBosTypeForBotpByID(String[] srcIdList, String[] entryNames, List entriesIDList, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"783061E3".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotpByID(srcIdList, entryNames, entriesIDList, destBosTypeList);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"HideMenuToolBar", (Object)"isHideMenuToolBar");
        super.prepareUIContext(uiContext, e);
    }

    @Override
    public boolean isSupportedBatchActions() {
        return false;
    }
}

