/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberAddEntriesFacadeFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractSerialNumberAddEntriesUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SerialNumberAddEntriesUI
extends AbstractSerialNumberAddEntriesUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SerialNumberAddEntriesUI.class);
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";
    private static final String COL_ID = "id";
    private static final String COL_MATERIALID = "materialID";
    private static final String COL_MATERIAL = "material";
    private static final String COL_SERIALNUMBER = "serialNumber";
    private static final String COL_TYPE = "type";
    private static final String COL_SELECTED = "selected";
    private int balanceQty = 0;
    private boolean firstLoadData = true;
    private RptParams params = new RptParams();

    public SerialNumberAddEntriesUI() throws Exception {
        this.getTable().checkParsed();
        this.getTable().setEnabled(true);
        this.getTable().setEditable(true);
        this.getTable().getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.getTable().getDataRequestManager().setDataRequestMode(1);
        this.getTable().getDataRequestManager().setPageRowCount(1000);
        this.getTable().getSelectManager().setSelectMode(15);
        this.getTable().getDataRequestManager().setExportMemoryCallback(true);
        this.getTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                SerialNumberAddEntriesUI.this.checkRows(SerialNumberAddEntriesUI.this.getTable());
            }
        });
        this.ckShowBalance.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SerialNumberAddEntriesUI.this.ckShowBalance_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SerialNumberAddEntriesUI.this.handUIException(exc);
                }
            }
        });
        this.ckShowExceptionData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SerialNumberAddEntriesUI.this.ckShowExceptionData_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SerialNumberAddEntriesUI.this.handUIException(exc);
                }
            }
        });
        this.ckShowHistoryData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SerialNumberAddEntriesUI.this.ckShowHistoryData_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SerialNumberAddEntriesUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.setShowDialogOnLoad(false);
        super.onLoad();
        this.initWorkControl();
    }

    private void initWorkControl() {
        this.btnQuickSearch.setEnabled(true);
        this.btnQuickSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.txtSerialNumber.setMaxLength(80);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.ckShowBalance.setSelected(true);
        this.btnQuery.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnOK.setEnabled(true);
        this.getTable().getColumn(COL_MATERIAL).getStyleAttributes().setLocked(true);
        this.getTable().getColumn(COL_TYPE).getStyleAttributes().setLocked(true);
        KDTTransferAction transAction = (KDTTransferAction)this.getTable().getActionMap().get("Paste");
        transAction.setPasteMode(2);
        this.ckShowExceptionData.setVisible(false);
        this.txtMessage.setEnabled(false);
        this.txtMessage.append(ResourceUtil.getMessage((String)resFile, (String)"Remark_1") + "\r\n");
        this.txtMessage.append(ResourceUtil.getMessage((String)resFile, (String)"Remark_2") + "\r\n");
        this.txtMessage.append(ResourceUtil.getMessage((String)resFile, (String)"Remark_3") + "\r\n");
        this.txtMessage.setCaretPosition(0);
        KDScrollPane kdsp1 = new KDScrollPane((Component)this.txtMessage);
        kdsp1.setBounds(new Rectangle(11, 625, 630, 96));
        this.add((Component)kdsp1, new KDLayout.Constraints(11, 627, 630, 60, 0));
    }

    protected void ckShowBalance_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckShowBalance.isSelected();
        if (isSelected) {
            this.getTable().getColumn(COL_SERIALNUMBER).getStyleAttributes().setLocked(false);
            this.params.setBoolean("ckShowBalance", true);
            this.params.setBoolean("ckShowHistoryData", false);
            this.params.setBoolean("ckShowExceptionData", false);
            this.ckShowExceptionData.setSelected(false);
            this.ckShowHistoryData.setSelected(false);
            this.txtSerialNumber.setText(null);
            this.txtSerialNumber.setEnabled(false);
            this.params.setString("txtSerialNumber", null);
            this.btnQuickSearch.setEnabled(false);
            this.firstLoadData = true;
            this.insertRowCount = 0;
            this.query();
        } else {
            this.getTable().removeRows(false);
        }
    }

    protected void ckShowExceptionData_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckShowExceptionData.isSelected();
        if (isSelected) {
            this.getTable().getColumn(COL_SERIALNUMBER).getStyleAttributes().setLocked(true);
            this.params.setBoolean("ckShowBalance", false);
            this.params.setBoolean("ckShowHistoryData", false);
            this.params.setBoolean("ckShowExceptionData", true);
            this.ckShowBalance.setSelected(false);
            this.ckShowHistoryData.setSelected(false);
            this.txtSerialNumber.setEnabled(true);
            this.btnQuickSearch.setEnabled(true);
            this.firstLoadData = true;
            this.insertRowCount = 0;
            this.query();
        } else {
            this.getTable().removeRows(false);
        }
    }

    protected void ckShowHistoryData_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckShowHistoryData.isSelected();
        if (isSelected) {
            this.getTable().getColumn(COL_SERIALNUMBER).getStyleAttributes().setLocked(true);
            this.params.setBoolean("ckShowBalance", false);
            this.params.setBoolean("ckShowHistoryData", true);
            this.params.setBoolean("ckShowExceptionData", false);
            this.ckShowBalance.setSelected(false);
            this.ckShowExceptionData.setSelected(false);
            this.txtSerialNumber.setEnabled(true);
            this.btnQuickSearch.setEnabled(true);
            this.firstLoadData = true;
            this.insertRowCount = 0;
            this.query();
        } else {
            this.getTable().removeRows(false);
        }
    }

    public void actionQuery4Balance(String inventoryID, BigDecimal curStoreQty, String materialID, String materialNumber) {
        this.params.setString("inventoryID", inventoryID);
        this.params.setBigDecimal("curStoreQty", curStoreQty);
        this.params.setString(COL_MATERIALID, materialID);
        this.params.setString("materialNumber", materialNumber);
        this.params.setBoolean("ckShowBalance", true);
        this.params.setBoolean("ckShowHistoryData", false);
        this.params.setBoolean("ckShowExceptionData", false);
        this.params.setString("txtSerialNumber", null);
        this.firstLoadData = true;
        this.insertRowCount = 0;
        this.query();
    }

    protected void query() {
        this.getTable().removeRows();
        super.query();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        if (StringUtils.isEmpty((String)this.params.getString("inventoryID")) && StringUtils.isEmpty((String)this.params.getString(COL_MATERIALID))) {
            return;
        }
        this.getTable().getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        try {
            if (start == 0 && this.firstLoadData) {
                try {
                    RptParams rpt = this.getRemoteInstance().createTempTable(this.params);
                    this.setTempTable(rpt.getString("tempTable"));
                    this.params.setString("tempTable", this.getTempTable());
                    if (this.tHelper != null) {
                        this.tHelper.setDefaultUserData(null);
                    }
                    this.initUserConfig();
                    if (this.params.getBoolean("ckShowBalance")) {
                        int balanceQty;
                        this.balanceQty = balanceQty = rpt.getInt("balanceQty");
                        if (balanceQty > 0) {
                            this.getTable().setRowCount(balanceQty);
                            this.insertRows4Balance(balanceQty, this.getTable());
                        }
                    }
                    if (this.params.getBoolean("ckShowHistoryData") || this.params.getBoolean("ckShowExceptionData")) {
                        rpt = this.getRemoteInstance().query(this.params, start, length);
                        RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                        int totalCount = rpt.getInt("totalCount");
                        this.getTable().setRowCount(totalCount);
                        this.insertRows(rs, start, this.getTable());
                    }
                    this.firstLoadData = false;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIExceptionAndAbort(ex);
                }
            } else {
                this.params.setString("tempTable", this.getTempTable());
                RptParams rpt = this.getRemoteInstance().query(this.params, start, length);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, start, this.getTable());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        this.getTable().getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void insertRows(RptRowSet rs, int insertRowIndex, KDTable kdTable) {
        kdTable.setRefresh(false);
        while (rs.next()) {
            IRow row = kdTable.setRow(insertRowIndex++);
            row.getCell(COL_SELECTED).setValue((Object)false);
            row.getCell(COL_ID).setValue((Object)rs.getString("fid"));
            row.getCell(COL_MATERIALID).setValue((Object)rs.getString("fmaterialid"));
            row.getCell(COL_MATERIAL).setValue((Object)rs.getString("fmaterialnumber"));
            row.getCell(COL_SERIALNUMBER).setValue((Object)rs.getString("fserialnumber"));
            row.getCell(COL_TYPE).setValue((Object)rs.getString("ftype"));
        }
        kdTable.setRefresh(true);
        if (rs.getRowCount() > 0) {
            kdTable.reLayoutAndPaint();
        } else {
            kdTable.repaint();
        }
    }

    private void insertRows4Balance(int balanceQty, KDTable kdTable) {
        for (int i = 0; i < balanceQty; ++i) {
            IRow row = kdTable.setRow(i);
            row.getCell(COL_SELECTED).setValue((Object)false);
            row.getCell(COL_ID).setValue(null);
            row.getCell(COL_MATERIALID).setValue((Object)this.params.getString(COL_MATERIALID));
            row.getCell(COL_MATERIAL).setValue((Object)this.params.getString("materialNumber"));
            row.getCell(COL_SERIALNUMBER).setValue(null);
            row.getCell(COL_TYPE).setValue((Object)ResourceUtil.getMessage((String)resFile, (String)"SERIALNUMBER_BALANCE"));
        }
    }

    private MaterialSNInventoryCollection getSelectedRowData() {
        IRow iRow = null;
        boolean isSelected = false;
        MaterialSNInventoryCollection collection = new MaterialSNInventoryCollection();
        Vector<String> vector = new Vector<String>();
        StringBuffer errorMsg = new StringBuffer();
        String strNo = InvClientUtils.getResource("No");
        String strRow = InvClientUtils.getResource("Row");
        String snTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"SERIALNUMBER");
        String repeat = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"REPEAT");
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            iRow = this.getTable().getRow(i);
            isSelected = (Boolean)iRow.getCell(COL_SELECTED).getValue();
            if (!isSelected) continue;
            Object snObject = iRow.getCell(COL_SERIALNUMBER).getValue();
            if (snObject == null) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceUtil.getMessage((String)resFile, (String)"SELECTED_ROWDATA_SERIALNUMBERNULL"));
                SysUtil.abort();
            }
            String serialNumber = snObject.toString();
            Object sniIDObject = iRow.getCell(COL_ID).getValue();
            String sniID = null;
            if (sniIDObject != null) {
                sniID = sniIDObject.toString();
            }
            String materialID = iRow.getCell(COL_MATERIALID).getValue().toString();
            MaterialSNInventoryInfo materialSNInventoryInfo = new MaterialSNInventoryInfo();
            if (sniID != null) {
                materialSNInventoryInfo.setId(BOSUuid.read((String)sniID));
            }
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)materialID));
            materialSNInventoryInfo.setMaterial(material);
            materialSNInventoryInfo.setSerialNumber(serialNumber);
            materialSNInventoryInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
            String inventoryID = this.params.getString("inventoryID");
            InventoryInfo inventory = new InventoryInfo();
            inventory.setId(BOSUuid.read((String)inventoryID));
            materialSNInventoryInfo.setInventory(inventory);
            collection.add(materialSNInventoryInfo);
            if (!this.params.getBoolean("ckShowBalance")) continue;
            String mark = materialID + serialNumber;
            if (vector.contains(mark)) {
                errorMsg.append(strNo);
                errorMsg.append(i + 1);
                errorMsg.append(strRow);
                errorMsg.append(snTitle);
                errorMsg.append(" [ ");
                errorMsg.append(serialNumber.toString());
                errorMsg.append(" ] ");
                errorMsg.append(repeat);
                errorMsg.append("\n");
                continue;
            }
            vector.add(mark);
        }
        if (errorMsg.length() > 0) {
            String error = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"ERROR");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorMsg.toString(), (int)8188);
            SysUtil.abort();
        }
        if (CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return collection;
    }

    private void checkRows(KDTable table) {
        KDTSelectBlock selectBlock = null;
        IRow iRow = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            int length = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= length; ++j) {
                iRow = table.getRow(j);
                if (iRow == null) continue;
                boolean isSelected = (Boolean)iRow.getCell(COL_SELECTED).getValue();
                int selectBeginCol = selectBlock.getBeginCol();
                int selectEndCol = selectBlock.getEndCol();
                int selectBiginRow = selectBlock.getBeginRow();
                int selectEndRow = selectBlock.getEndRow();
                int selectCol = this.getTable().getColumnIndex(COL_SELECTED);
                if (selectCol != selectBeginCol || selectBeginCol != selectEndCol || selectBeginCol == -1 || selectBiginRow == selectEndRow) continue;
                if (!isSelected) {
                    iRow.getCell(COL_SELECTED).setValue((Object)true);
                    continue;
                }
                iRow.getCell(COL_SELECTED).setValue((Object)false);
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelectedStatus(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelectedStatus(false);
    }

    private void setAllSelectedStatus(boolean isSelected) {
        IRow iRow = null;
        int rowCount = this.getTable().getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            iRow = this.getTable().getRow(i);
            if (iRow == null) continue;
            iRow.getCell(COL_SELECTED).setValue((Object)isSelected);
        }
    }

    @Override
    public void actionQuickSearch_actionPerformed(ActionEvent e) throws Exception {
        String serialNumber = this.txtSerialNumber.getText();
        if (!StringUtils.isEmpty((String)serialNumber)) {
            serialNumber = serialNumber.trim();
        }
        this.params.setString("txtSerialNumber", serialNumber);
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        MaterialSNInventoryCollection collection = this.getSelectedRowData();
        if (collection != null && collection.size() > 0) {
            if (this.params.getBoolean("ckShowBalance")) {
                MaterialSNInventoryFactory.getRemoteInstance().saveAddEntriesSerialNumberBatch(collection);
            }
            if (this.params.getBoolean("ckShowExceptionData") || this.params.getBoolean("ckShowHistoryData")) {
                if (collection.size() > this.balanceQty) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resFile, (String)"SNQTY_GREATERTHAN_BALANCEQTY"));
                    SysUtil.abort();
                }
                CoreBaseCollection coll = new CoreBaseCollection();
                coll.addObjectCollection((IObjectCollection)collection);
                MaterialSNInventoryFactory.getRemoteInstance().saveBatchData(coll);
            }
        }
        MsgBox.showInfo((Component)((Object)this), (String)ResourceUtil.getMessage((String)resFile, (String)"SAVE_SUCCESS"));
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        try {
            KDTEditHelper kdtEditHelper = new KDTEditHelper(this.getTable());
            kdtEditHelper.paste(2);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return SerialNumberAddEntriesFacadeFactory.getRemoteInstance();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return SerialNumberAddEntriesFacadeFactory.getRemoteInstance();
    }
}

