/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractSerialNumberSelectUI;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SerialNumberSelectUI
extends AbstractSerialNumberSelectUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SerialNumberSelectUI.class);
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";
    private String inventoryID = null;
    private String materialID = null;
    private int maxQty = 0;
    private String notInSelectSQL = null;
    private String tempTableName = null;
    private KDTDataRequestListener dataRequestListener = null;
    private List<String> results = new ArrayList<String>();
    private boolean isCanceld = true;

    public SerialNumberSelectUI() throws Exception {
        this.tblMain.checkParsed();
        this.finalTable.checkParsed();
        this.tblMain.setEnabled(true);
        this.finalTable.setEnabled(true);
        this.tblMain.setEditable(false);
        this.finalTable.setEditable(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().setPageRowCount(1000);
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getSelectManager().setSelectMode(10);
        this.finalTable.getSelectManager().setSelectMode(10);
        this.dataRequestListener = new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                SerialNumberSelectUI.this.tbl_DataRequest(e);
            }
        };
    }

    public void onLoad() throws Exception {
        this.initPageControl();
        super.onLoad();
    }

    private void initPageControl() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnQuickQuery.setEnabled(true);
        this.btnQuickQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.txtSerialNumber.setMaxLength(80);
    }

    private void tbl_DataRequest(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int len = e.getLastRow() - begin + 1;
        try {
            this.insertRows(this.getRowSet(begin, len), begin);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
            this.handleException(e1);
        }
    }

    public void actionQuery(String inventoryID, String materialID, int maxQty, String notInSelectSQL, int snStatus) throws Exception {
        this.inventoryID = inventoryID;
        this.materialID = materialID;
        this.maxQty = maxQty;
        this.notInSelectSQL = notInSelectSQL;
        this.comboBox_snStatuas.setSelectedIndex(2);
        this.createTempTable(null, 2);
        this.executeQuery();
    }

    private void createTempTable(String txtSn, int snStatus) throws EASBizException, BOSException {
        String createTempTableSQL = this.getCreateTempTableSQL();
        String finalSQL = this.getFinalSQL(txtSn, snStatus);
        String fieldSQL = " id, materialID, materialNumber, materialName, serialNumber, snStatus ";
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("tempTableName", this.tempTableName);
        this.tempTableName = SQLDataAccessFacadeFactory.getRemoteInstance().createTempTable(createTempTableSQL, finalSQL, fieldSQL, null);
    }

    private void executeQuery() throws Exception {
        this.tblMain.removeKDTDataRequestListener(this.dataRequestListener);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.removeRows();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.finalTable.getSelectManager().setSelectMode(10);
        this.tblMain.addKDTDataRequestListener(this.dataRequestListener);
        this.initRowCount();
        this.insertRows(this.getRowSet(0, 1000), 0);
    }

    private void initRowCount() throws BOSException, SQLException {
        if (StringUtil.isEmpty((String)this.tempTableName)) {
            return;
        }
        int count = 0;
        String sql = "select count(1) as count from " + this.tempTableName;
        IRowSet rs = new SQLExecutor(sql).executeSQL();
        if (rs.next()) {
            count = rs.getInt(1);
        }
        this.tblMain.setRowCount(count);
    }

    private IRowSet getRowSet(int start, int len) throws EASBizException, BOSException {
        StringBuilder querySQL = new StringBuilder();
        querySQL.append(" select id, materialID, materialNumber, materialName, serialNumber, snStatus from ").append(this.tempTableName);
        querySQL.append(" order by snStatus asc, materialNumber desc, serialNumber asc ");
        return SQLDataAccessFacadeFactory.getRemoteInstance().getRowSet(querySQL.toString(), start, len);
    }

    private String getFinalSQL(String txtSN, int snStatus) {
        StringBuffer finalSQL = new StringBuffer();
        finalSQL.append(" select sni.fid as id, sni.fmaterialid as materialID, mat.fnumber as materialNumber, mat.fname_l2 as materialName, sni.fserialnumber as serialNumber, ");
        finalSQL.append(" sni.fsnstatus as snStatus from T_IV_MaterialSNInventory sni ");
        finalSQL.append(" left outer join t_bd_material mat on sni.fmaterialid = mat.fid ");
        finalSQL.append(" where 1 = 1 ");
        if (!StringUtil.isEmpty((String)this.inventoryID)) {
            finalSQL.append(" and sni.finventoryid = '").append(this.inventoryID).append("' ");
        }
        if (snStatus != -1) {
            finalSQL.append(" and sni.fsnstatus = ").append(snStatus);
        }
        finalSQL.append(" and sni.fmaterialid = '").append(this.materialID).append("' ");
        if (!StringUtil.isEmpty((String)txtSN)) {
            finalSQL.append(" and sni.fserialnumber like '%").append(txtSN).append("%' ");
        }
        if (this.notInSelectSQL != null && this.notInSelectSQL.length() > 0) {
            finalSQL.append(" and sni.fserialnumber not in (" + this.notInSelectSQL + ") ");
        }
        return finalSQL.toString();
    }

    private void insertRows(IRowSet rs, int begin) throws SQLException {
        ArrayList<String> headList = new ArrayList<String>();
        headList.add("id");
        headList.add("materialID");
        headList.add("materialNumber");
        headList.add("materialName");
        headList.add("serialNumber");
        headList.add("snStatus");
        IRow row = null;
        boolean refresh = this.tblMain.isRefresh();
        this.tblMain.setRefresh(false);
        String key = null;
        this.tblMain.removeKDTDataRequestListener(this.dataRequestListener);
        while (rs.next()) {
            row = this.tblMain.addRow(begin++);
            int size = headList.size();
            for (int i = 0; i < size; ++i) {
                key = (String)headList.get(i);
                if (row.getCell(key) == null) continue;
                if ("snStatus".equals(key)) {
                    String snStatusValue = SerialNumberStatusEnum.getEnum(rs.getInt("snStatus")).getAlias();
                    row.getCell(key).setValue((Object)snStatusValue);
                    continue;
                }
                row.getCell(key).setValue(rs.getObject(key));
            }
        }
        this.tblMain.setRefresh(refresh);
        if (rs != null && rs.size() > 0) {
            this.tblMain.reLayoutAndPaint();
        } else {
            this.tblMain.repaint();
        }
        this.tblMain.reLayoutAndPaint();
        this.tblMain.addKDTDataRequestListener(this.dataRequestListener);
    }

    private String getCreateTempTableSQL() {
        StringBuffer createTempTableSQL = new StringBuffer();
        createTempTableSQL.append(" create table temp_table(id varchar(44), materialID varchar(44), materialNumber varchar(80),");
        createTempTableSQL.append(" materialName varchar(255), serialNumber nvarchar(80), snStatus int); ");
        return createTempTableSQL.toString();
    }

    @Override
    protected void ActionDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveTableRow(this.tblMain, this.finalTable);
    }

    private void moveTableRow(KDTable tableFrom, KDTable tableTo) {
        tableTo.checkParsed();
        tableFrom.checkParsed();
        int moveSize = tableFrom.getSelectManager().size();
        int colCount = tableTo.getColumnCount();
        KDTSelectBlock selectBlock = null;
        for (int p = moveSize - 1; p >= 0; --p) {
            selectBlock = tableFrom.getSelectManager().get(p);
            if (selectBlock == null) continue;
            block1: for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
                String colKey;
                int j;
                IRow row = tableFrom.getRow(i);
                String id = row.getCell("id").getValue().toString();
                if (row == null) continue;
                int toRowCount = tableTo.getRowCount3();
                for (int k = 0; k < toRowCount; ++k) {
                    if (id.equals(tableTo.getRow(k).getCell("id").getValue().toString())) continue block1;
                }
                if (tableTo.getSelectManager().getActiveRowIndex() != -1) {
                    tableTo.addRow(toRowCount, (IRow)row.clone());
                    IRow toRow = tableTo.getRow(toRowCount);
                    for (j = 0; j < colCount; ++j) {
                        colKey = tableTo.getColumnKey(j);
                        if (row.getCell(colKey) == null) continue;
                        toRow.getCell(colKey).setValue(row.getCell(colKey).getValue());
                    }
                    continue;
                }
                tableTo.addRow(0, (IRow)row.clone());
                IRow toRow = tableTo.getRow(0);
                for (j = 0; j < colCount; ++j) {
                    colKey = tableTo.getColumnKey(j);
                    if (row.getCell(colKey) == null) continue;
                    toRow.getCell(colKey).setValue(row.getCell(colKey).getValue());
                }
            }
        }
        if (tableTo.getRowCount3() > this.maxQty) {
            for (int i = this.maxQty; i < tableTo.getRowCount3(); ++i) {
                IRow toRow = tableTo.getRow(i);
                toRow.getStyleAttributes().setFontColor(Color.RED);
            }
        }
        tableFrom.getSelectManager().removeAll();
        tableTo.getSelectManager().removeAll();
        this.btnOK.requestFocus();
    }

    @Override
    protected void ActionUp_actionPerformed(ActionEvent e) throws Exception {
        this.deleteTableRow(this.finalTable);
    }

    private void deleteTableRow(KDTable table) {
        int i;
        table.checkParsed();
        int moveSize = table.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        HashSet<String> moveSet = new HashSet<String>();
        for (int p = moveSize - 1; p >= 0; --p) {
            selectBlock = table.getSelectManager().get(p);
            if (selectBlock == null) continue;
            for (int i2 = selectBlock.getEndRow(); i2 >= selectBlock.getTop(); --i2) {
                IRow row = table.getRow(i2);
                if (row == null) continue;
                moveSet.add(row.getCell("id").getValue().toString());
            }
        }
        for (i = this.finalTable.getRowCount() - 1; i >= 0; --i) {
            if (!moveSet.contains(this.finalTable.getRow(i).getCell("id").getValue().toString())) continue;
            this.finalTable.removeRow(i);
        }
        for (i = 0; i < this.maxQty; ++i) {
            IRow toRow = this.finalTable.getRow(i);
            if (toRow == null) continue;
            toRow.getStyleAttributes().setFontColor(Color.BLACK);
        }
        if (this.finalTable.getRowCount3() > this.maxQty) {
            for (i = this.maxQty; i < this.finalTable.getRowCount3(); ++i) {
                IRow toRow = this.finalTable.getRow(i);
                toRow.getStyleAttributes().setFontColor(Color.RED);
            }
        }
    }

    @Override
    protected void ActionOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        if (this.finalTable.getRowCount3() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.finalTable.getRowCount3() > this.maxQty) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceUtil.getMessage((String)resFile, (String)"SELECT_MORE", (String[])new String[]{String.valueOf(this.maxQty)}));
            SysUtil.abort();
        }
        this.getResults().clear();
        int size = this.finalTable.getRowCount3();
        for (int index = 0; index < size; ++index) {
            IRow row = this.finalTable.getRow(index);
            if (row == null || row.getCell("serialNumber") == null) continue;
            String serialNumber = (String)row.getCell("serialNumber").getValue();
            this.getResults().add(serialNumber);
        }
        this.disposeUIWindow();
    }

    public List<String> getResults() {
        return this.results;
    }

    @Override
    protected void ActionCancel2_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = true;
        this.disposeUIWindow();
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            if (!StringUtil.isEmpty((String)this.tempTableName)) {
                SQLDataAccessFacadeFactory.getRemoteInstance().dropTable(this.tempTableName);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.refresh();
        String txtSN = this.txtSerialNumber.getText();
        if (!StringUtil.isEmpty((String)txtSN)) {
            txtSN = txtSN.trim();
        }
        SerialNumberStatusEnum snStatus = (SerialNumberStatusEnum)((Object)this.comboBox_snStatuas.getSelectedItem());
        this.createTempTable(txtSN, snStatus.getValue());
        this.executeQuery();
    }

    public boolean isCanceled() {
        return this.isCanceld;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.actionQuickQuery_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        KDTable a;
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
        if (e.getClickCount() == 2 && e.getSource() instanceof KDTable && (a = (KDTable)e.getSource()).getName().equals("tblMain")) {
            this.moveTableRow(this.tblMain, this.finalTable);
        }
    }

    @Override
    protected void finalTable_tableClick(KDTMouseEvent e) throws Exception {
        KDTable a;
        if (e.getClickCount() == 1) {
            super.finalTable_tableClick(e);
        }
        if (e.getClickCount() == 2 && e.getSource() instanceof KDTable && (a = (KDTable)e.getSource()).getName().equals("finalTable")) {
            this.deleteTableRow(this.finalTable);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialSerialNumberFactory.getRemoteInstance();
    }
}

