/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractSplitBillDateUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SplitBillDateUI
extends AbstractSplitBillDateUI {
    private static final Logger logger = CoreUIObject.getLogger(SplitBillDateUI.class);
    protected String invAddResource = "com.kingdee.eas.scm.im.inv.InvAddResource";
    private boolean isCancel = true;
    private Date childBillDate = null;
    private boolean isBillSplitChangeDate = false;
    private PeriodInfo currentPeriodInfo = null;
    private PeriodInfo billPeriodInfo = null;
    private boolean isNeedBizDate = true;
    private Date bizDate = null;
    protected HashMap hmResult = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDRadioBtnYes.setSelected(true);
        this.kDRadioBtnNo.setSelected(false);
        this.kDDatePicker1.setEditable(false);
        this.hmResult.clear();
        this.billPeriodInfo = (PeriodInfo)this.getUIContext().get("period");
        this.bizDate = (Date)this.getUIContext().get("bizDate");
    }

    public void initData(String billType, String storageUnitID) {
        try {
            CompanyOrgUnitInfo companyOriUnitInfo = InvClientUtils.getCompanyInfo(storageUnitID);
            this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOriUnitInfo);
            this.isBillSplitChangeDate = InvClientUtils.isSaleIssueBillSplitChangeDate(billType, storageUnitID);
            if (this.isBillSplitChangeDate) {
                this.kDRadioBtnYes.setSelected(true);
                this.kDRadioBtnNo.setSelected(false);
                Timestamp currentLastDate = this.currentPeriodInfo.getEndDate();
                this.billPeriodInfo = (PeriodInfo)this.getUIContext().get("period");
                if (this.billPeriodInfo != null && this.currentPeriodInfo != null) {
                    currentLastDate = this.billPeriodInfo.getBeginDate().before(this.currentPeriodInfo.getBeginDate()) ? this.currentPeriodInfo.getEndDate() : this.billPeriodInfo.getEndDate();
                }
                long time = ((Date)currentLastDate).getTime() + 86400000L;
                Date nextDate = new Date(time);
                this.kDDatePicker1.setValue((Object)nextDate);
                this.kDDatePicker1.setEditable(true);
                this.kDDatePicker1.setEnabled(true);
            } else {
                this.kDRadioBtnYes.setSelected(false);
                this.kDRadioBtnNo.setSelected(true);
                this.kDDatePicker1.setValue(this.getUIContext().get("bizDate"));
                this.kDDatePicker1.setEditable(false);
                this.kDDatePicker1.setEnabled(false);
            }
            this.bizDate = (Date)this.getUIContext().get("bizDate");
            if (this.bizDate != null && this.bizDate.before(this.currentPeriodInfo.getBeginDate())) {
                this.kDDatePicker1.setValue((Object)this.bizDate);
                this.kDDatePicker1.setEditable(false);
                this.kDDatePicker1.setEnabled(false);
                this.isNeedBizDate = false;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.getHmResult().clear();
        super.btnConfirm_actionPerformed(e);
        this.setCancel(false);
        if (this.isBillSplitChangeDate && this.isNeedBizDate) {
            if (this.kDDatePicker1.getSqlDate() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.invAddResource, (String)"ChildBizDateIsNull"));
                SysUtil.abort();
            }
            this.bizDate = (Date)this.getUIContext().get("bizDate");
            boolean isCloseAccounts = this.bizDate.before(this.currentPeriodInfo.getBeginDate());
            java.sql.Date setDate = this.kDDatePicker1.getSqlDate();
            if (setDate.before(this.currentPeriodInfo.getBeginDate()) && !isCloseAccounts) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.invAddResource, (String)"ChildBizDateBeforeCurrentPeriod"));
                SysUtil.abort();
            }
            this.setChildBillDate(this.kDDatePicker1.getSqlDate());
        } else {
            this.setChildBillDate(null);
        }
        this.actionExitCurrent_actionPerformed(e);
        this.getHmResult().put("needSet", new Boolean("true"));
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getHmResult().clear();
        super.btnCancel_actionPerformed(e);
        this.setCancel(true);
        this.kDDatePicker1.setValue(null);
        this.setChildBillDate(null);
        this.actionExitCurrent_actionPerformed(e);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public Date getChildBillDate() {
        return this.childBillDate;
    }

    public void setChildBillDate(Date childBillDate) {
        this.childBillDate = childBillDate;
    }

    public HashMap getHmResult() {
        return this.hmResult;
    }
}

