/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTextField;

public class StockReqClientUtils {
    public static final int DEFAULT_PRECISION = 2;
    public static final String STOCKREQ_RESOURCE = "com.kingdee.eas.scm.im.inv.StockReqResource";

    public static void changePrecision(KDTable table, int rowIndex, String[] colNames, int precision) {
        if (precision < 0) {
            precision = 2;
        }
        if (rowIndex == -1) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                StockReqClientUtils.changePrecision(table, i, colNames, precision);
            }
            return;
        }
        String formatString = PrecisionUtil.getFormatString((int)precision);
        for (int i = 0; i < colNames.length; ++i) {
            KDFormattedTextField txt;
            KDTDefaultCellEditor editor = (KDTDefaultCellEditor)table.getCell(rowIndex, colNames[i]).getEditor();
            if (editor == null) {
                txt = new KDFormattedTextField(1);
                txt.setSupportedEmpty(true);
                txt.setNegatived(false);
                editor = new KDTDefaultCellEditor((JTextField)txt);
                table.getCell(rowIndex, colNames[i]).setEditor((ICellEditor)editor);
            }
            txt = (KDFormattedTextField)editor.getComponent();
            txt.setPrecision(precision);
            table.getCell(rowIndex, colNames[i]).getStyleAttributes().setNumberFormat(formatString);
        }
    }

    public static void setDefaultF7Editor(KDBizPromptBox f7, String queryInfo, KDTable table, String colKey) {
        f7.setQueryInfo(queryInfo);
        table.getColumn(colKey).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
        f7.setEditFormat("$number$");
        f7.setDisplayFormat("$number$");
        f7.setCommitFormat("$number$");
    }

    public static void setDefaultDecimalEditor(KDFormattedTextField txt, KDTDefaultCellEditor editor, KDTable table, String colKey) {
        String formatString = PrecisionUtil.getFormatString((int)2);
        table.getColumn(colKey).setEditor((ICellEditor)editor);
        table.getColumn(colKey).getStyleAttributes().setNumberFormat(formatString);
        table.getColumn(colKey).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static EntityViewInfo getBizStorageFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"REQSTORAGE.ID"));
        return viewInfo;
    }

    public static EntityViewInfo getSupplyStorageFilterForFilterUI(List reqStorageIDs) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        if (reqStorageIDs != null && reqStorageIDs.size() > 0) {
            CoreBaseCollection sous;
            String oql = "select id, requireStorageOrgUnit, supplyStorageOrgUnit, status where requireStorageOrgUnit in " + InvClientUtils.getInStringFromList(reqStorageIDs);
            SupplyRelationCollection supplyRelations = SupplyRelationFactory.getRemoteInstance().getSupplyRelationCollection(oql);
            HashSet<String> supplyStorageIDs = new HashSet<String>();
            for (int i = 0; i < supplyRelations.size(); ++i) {
                supplyStorageIDs.add(supplyRelations.get(i).getSupplyStorageOrgUnit().getId().toString());
            }
            FullOrgUnitCollection orgs = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Storage, (String)"stockReq_view");
            ArrayList<String> listOrgIDs = new ArrayList<String>();
            if (orgs != null) {
                int n = orgs.size();
                for (int i = 0; i < n; ++i) {
                    listOrgIDs.add(orgs.get(i).getId().toString());
                }
            }
            if ((sous = StorageOrgUnitFactory.getRemoteInstance().getCollection("select isBizUnit where id in " + InvClientUtils.getInStringFromList(listOrgIDs))) != null) {
                int n = sous.size();
                for (int i = 0; i < n; ++i) {
                    StorageOrgUnitInfo sou = (StorageOrgUnitInfo)sous.get(i);
                    if (!sou.isIsBizUnit()) continue;
                    supplyStorageIDs.add(sou.getId().toString());
                }
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", supplyStorageIDs, CompareType.INCLUDE));
            view.setFilter(filter);
        }
        return view;
    }

    public static EntityViewInfo getReceiveStorageFilterForFilterUI(List reqStorageIDs) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        if (reqStorageIDs != null && reqStorageIDs.size() > 0) {
            CoreBaseCollection sous;
            String oql = "select id, requireStorageOrgUnit, receiveStorageOrgUnit, status where requireStorageOrgUnit in " + InvClientUtils.getInStringFromList(reqStorageIDs);
            SupplyRelationCollection supplyRelations = SupplyRelationFactory.getRemoteInstance().getSupplyRelationCollection(oql);
            HashSet<String> receiveStorageIDs = new HashSet<String>();
            for (int i = 0; i < supplyRelations.size(); ++i) {
                receiveStorageIDs.add(supplyRelations.get(i).getReceiveStorageOrgUnit().getId().toString());
            }
            FullOrgUnitCollection orgs = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Storage, (String)"stockReq_view");
            ArrayList<String> listOrgIDs = new ArrayList<String>();
            if (orgs != null) {
                int n = orgs.size();
                for (int i = 0; i < n; ++i) {
                    listOrgIDs.add(orgs.get(i).getId().toString());
                }
            }
            if ((sous = StorageOrgUnitFactory.getRemoteInstance().getCollection("select isBizUnit where id in " + InvClientUtils.getInStringFromList(listOrgIDs))) != null) {
                int n = sous.size();
                for (int i = 0; i < n; ++i) {
                    StorageOrgUnitInfo sou = (StorageOrgUnitInfo)sous.get(i);
                    if (!sou.isIsBizUnit()) continue;
                    receiveStorageIDs.add(sou.getId().toString());
                }
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", receiveStorageIDs, CompareType.INCLUDE));
            view.setFilter(filter);
        }
        return view;
    }

    public static String getResource(String key) {
        return EASResource.getString((String)STOCKREQ_RESOURCE, (String)key);
    }

    public static Calendar getReqDateFrom() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(SCMClientUtils.getServerDate2());
        calendar.add(5, 7);
        calendar.set(7, 2);
        return calendar;
    }

    public static boolean equalsID(ObjectBaseInfo val1, ObjectBaseInfo val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        return val1.getId().equals((Object)val2.getId());
    }

    public static Set getSaleOrgId(StorageOrgUnitInfo souInfo) {
        HashSet<String> ids = new HashSet<String>();
        OrgUnitCollection col = InvClientUtils.getSaleOrgUniInfo(souInfo);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            ids.add(((OrgUnitInfo)iter.next()).getId().toString());
        }
        return ids;
    }

    public static EntityViewInfo getSaleOrderView(EntityViewInfo view, MaterialInfo material, StorageOrgUnitInfo souInfo) {
        FilterInfo filter;
        if (view == null) {
            view = new EntityViewInfo();
        }
        if ((filter = view.getFilter()) == null) {
            filter = new FilterInfo();
        }
        filter.getFilterItems().clear();
        if (material != null) {
            filter.appendFilterItem("material.id", (Object)material.getId().toString());
        }
        if (souInfo != null) {
            filter.appendFilterItem("storageOrgUnit.id", (Object)souInfo.getId().toString());
        }
        view.setFilter(filter);
        return view;
    }

    public static void setSaleOrderEntryF7Editor(KDBizPromptBox f7, String queryInfo, KDTable table, String colKey) {
        f7.setQueryInfo(queryInfo);
        f7.setEditFormat("$seq$");
        f7.setDisplayFormat("$seq$");
        f7.setCommitFormat("$seq$");
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$seq"));
        table.getColumn(colKey).setRenderer((IBasicRender)ovr);
        table.getColumn(colKey).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
    }

    public static void setSaleOrderF7Editor(KDBizPromptBox f7, String queryInfo, KDTable table, String colKey) {
        f7.setQueryInfo(queryInfo);
        f7.setEditFormat("$number$");
        f7.setDisplayFormat("$number$");
        f7.setCommitFormat("$parent.number$");
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        table.getColumn(colKey).setRenderer((IBasicRender)ovr);
        table.getColumn(colKey).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
    }
}

