/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractStockReqFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.StockReqClientUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockReqFilterUI
extends AbstractStockReqFilterUI
implements ISCMBillStatusControl,
DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(StockReqFilterUI.class);
    private boolean isBotp = false;

    public StockReqFilterUI() throws Exception {
        this.getElementsInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.prmtReqStorage.setEnabledMultiSelection(true);
        this.prmtSupplyStorage.setEnabledMultiSelection(true);
        this.prmtReceiveStorage.setEnabledMultiSelection(true);
        this.prmtReqStorage.addDataChangeListener((DataChangeListener)this);
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.prmtBizTypeFrom, (Component)this.prmtBizTypeTo));
        elements.add((FilterElement)new RangeFilterElement("entry.sourceBillNumber", (Component)this.txtSourceBillNumberFrom, (Component)this.txtSourceBillNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo));
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("reqStorage.id", (Component)this.prmtReqStorage);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, StockReqClientUtils.getResource("reqStorageIsNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("supplyStorage.number", (Component)this.prmtSupplyStorage));
        elements.add((FilterElement)new SingleFilterElement("receiveStorage.number", (Component)this.prmtReceiveStorage));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cbxBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "reqStorage.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtReqStorage;
    }

    protected String getViewPermission() {
        if (this.isBotp) {
            return null;
        }
        return "stockReq_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "reqStorage.id";
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        EntityViewInfo viewNumber = StockReqClientUtils.getBizStorageFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewNumber);
        this.prmtNumberTo.setEntityViewInfo(viewNumber);
        EntityViewInfo viewBizType = InvClientUtils.getBizTypeFromBill("170");
        this.prmtBizTypeFrom.setEntityViewInfo(viewBizType);
        this.prmtBizTypeTo.setEntityViewInfo(viewBizType);
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.pkBizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.pkBizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.cbxBaseStatus);
    }

    public void afterMainOrgChanged(String ids) {
        if (this.prmtReqStorage.getValue() != null) {
            Object[] sous;
            if (this.prmtReqStorage.getValue() instanceof FullOrgUnitInfo) {
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                FullOrgUnitInfo fou = (FullOrgUnitInfo)this.prmtReqStorage.getValue();
                sou.setId(fou.getId());
            } else if (this.prmtReqStorage.getValue() instanceof Object[] && (sous = (Object[])this.prmtReqStorage.getValue())[0] instanceof FullOrgUnitInfo) {
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                FullOrgUnitInfo fou = (FullOrgUnitInfo)sous[0];
                sou.setId(fou.getId());
            }
        }
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        try {
            if (source.equals(this.prmtReqStorage)) {
                this.reqStorageChanged(e);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void reqStorageChanged(DataChangeEvent e) throws Exception {
        Object o = this.prmtReqStorage.getValue();
        ArrayList<String> reqStorageIDs = new ArrayList<String>();
        if (o instanceof StorageOrgUnitInfo) {
            reqStorageIDs.add(((StorageOrgUnitInfo)o).getId().toString());
        } else if (o instanceof OrgUnitInfo[]) {
            for (int i = 0; i < ((OrgUnitInfo[])o).length; ++i) {
                reqStorageIDs.add(((OrgUnitInfo[])o)[i].getId().toString());
            }
        } else if (o instanceof StorageOrgUnitInfo[] || o instanceof Object[]) {
            for (int i = 0; i < ((Object[])o).length; ++i) {
                reqStorageIDs.add(((StorageOrgUnitInfo)((Object[])o)[i]).getId().toString());
            }
        }
        this.prmtSupplyStorage.setEntityViewInfo(StockReqClientUtils.getSupplyStorageFilterForFilterUI(reqStorageIDs));
        this.prmtReceiveStorage.setEntityViewInfo(StockReqClientUtils.getReceiveStorageFilterForFilterUI(reqStorageIDs));
    }

    public void setBOTPFilter(Map botpMap) {
        if (botpMap != null) {
            String billTypeId = botpMap.get("DESTBILLTYPE.ID").toString();
            if ("MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billTypeId)) {
                return;
            }
            if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(billTypeId)) {
                this.isBotp = true;
                return;
            }
        }
        super.setBOTPFilter(botpMap);
    }
}

