/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.AbstractStorageQueryPanelUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class StorageQueryPanelUI
extends AbstractStorageQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(StorageQueryPanelUI.class);
    private static final String permItem = "inventory";
    private Set authorizedStorageSet = new LinkedHashSet();

    protected void init() throws Exception {
        this.getAuthorizedStorageSet();
        this.setStorageOrgFilter();
        this.kDBizPromptBox1.setRequired(true);
        this.kDBizPromptBox2.setRequired(true);
        this.kDBizPromptBox3.setRequired(true);
        this.kDBizPromptBox3.setEnabled(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.authorizedStorageSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.kDBizPromptBox2.setEntityViewInfo(viewInfo);
        this.setStorageOrgFilter();
        InvClientUtils.getMaterialF7ForFilterUI(this.kDBizPromptBox1, (Object)this);
        this.kDBizPromptBox2.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StorageOrgUnitInfo storageInfoListen = (StorageOrgUnitInfo)StorageQueryPanelUI.this.kDBizPromptBox2.getData();
                String storageOrgNumberListen = null;
                if (storageInfoListen != null) {
                    storageOrgNumberListen = storageInfoListen.getNumber();
                }
                if (storageOrgNumberListen != null) {
                    StorageQueryPanelUI.this.kDBizPromptBox3.setEditable(true);
                    StorageQueryPanelUI.this.kDBizPromptBox3.setEnabled(true);
                    StorageQueryPanelUI.this.kDBizPromptBox3.setData((Object)"");
                    EntityViewInfo view = StorageQueryPanelUI.this.kDBizPromptBox3.getEntityViewInfo();
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    FilterInfo filterinfo = new FilterInfo();
                    FilterItemInfo filterItemInfo = new FilterItemInfo("storageOrgUnit.number", (Object)storageOrgNumberListen, CompareType.EQUALS);
                    filterinfo.getFilterItems().add(filterItemInfo);
                    if (view.getFilter() != null) {
                        try {
                            boolean isHasRowTypeFilter = false;
                            FilterItemInfo tmpFilter = null;
                            int c = view.getFilter().getFilterItems().size();
                            for (int i = 0; i < c; ++i) {
                                tmpFilter = view.getFilter().getFilterItems().get(i);
                                if (tmpFilter.getPropertyName().indexOf("storageOrgUnit.number") < 0) continue;
                                isHasRowTypeFilter = true;
                                view.getFilter().getFilterItems().set(i, filterItemInfo);
                                break;
                            }
                            if (!isHasRowTypeFilter) {
                                view.getFilter().mergeFilter(filterinfo, "and");
                            }
                        }
                        catch (BOSException e1) {
                            StorageQueryPanelUI.this.handUIException(e1);
                        }
                    } else {
                        view.setFilter(filterinfo);
                    }
                    StorageQueryPanelUI.this.kDBizPromptBox3.setEntityViewInfo(view);
                } else {
                    StorageQueryPanelUI.this.kDBizPromptBox3.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected HashMap getQueryConditions() throws Exception {
        ArrayList keyList = this.getKeySequence();
        HashMap map = new HashMap();
        if (this.kDBizPromptBox1.getData() != null && this.kDBizPromptBox1.getData().toString().length() > 0) {
            MaterialInfo materialInfo = (MaterialInfo)this.kDBizPromptBox1.getData();
            String materialNumber = materialInfo.getNumber();
            map.put(keyList.get(0), materialNumber);
        }
        if (this.kDBizPromptBox2.getData() != null && this.kDBizPromptBox2.getData().toString().length() > 0) {
            StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)this.kDBizPromptBox2.getData();
            String storageOrgNumber = storageInfo.getNumber();
            map.put(keyList.get(1), storageOrgNumber);
        }
        if (this.kDBizPromptBox3.getData() != null && this.kDBizPromptBox3.getData().toString().length() > 0) {
            WarehouseInfo warehouseInfo = (WarehouseInfo)this.kDBizPromptBox3.getData();
            String warehouseNumber = warehouseInfo.getNumber();
            map.put(keyList.get(2), warehouseNumber);
        }
        return map;
    }

    protected void loadQueryConditions(HashMap conditionMap) throws Exception {
        String warehouseNumber;
        String storageOrgNumber;
        CoreBaseCollection col;
        FilterInfo filterInfo;
        EntityViewInfo viewInfo;
        String materialNumber;
        ArrayList keyList = this.getKeySequence();
        if (conditionMap.containsKey(keyList.get(0)) && (materialNumber = (String)conditionMap.get(keyList.get(0))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IMaterial iMaterial = MaterialFactory.getRemoteInstance();
            col = iMaterial.getCollection(viewInfo);
            if (col.size() > 0) {
                this.kDBizPromptBox1.setData((Object)col.get(0));
            }
        }
        if (conditionMap.containsKey(keyList.get(1)) && (storageOrgNumber = (String)conditionMap.get(keyList.get(1))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)storageOrgNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            col = iStorageOrgUnit.getCollection(viewInfo);
            if (col.size() > 0) {
                this.kDBizPromptBox2.setData((Object)col.get(0));
            }
        }
        if (conditionMap.containsKey(keyList.get(2)) && (warehouseNumber = (String)conditionMap.get(keyList.get(2))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)warehouseNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
            col = iWarehouse.getCollection(viewInfo);
            if (col.size() > 0) {
                this.kDBizPromptBox3.setData((Object)col.get(0));
            }
        }
    }

    public ArrayList getKeySequence() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("material");
        list.add("storage");
        list.add("warehouse");
        return list;
    }

    protected void setStorageOrgFilter() throws Exception {
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.kDBizPromptBox2, (OrgType)OrgType.Storage, (String)permItem);
    }

    protected void getAuthorizedStorageSet() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int count = storageOrgs.length;
        if (count > 0) {
            OrgUnitInfo orgUnit = null;
            String number = null;
            for (int i = 0; i < count; ++i) {
                orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || (number = orgUnit.getNumber()) == null) continue;
                this.authorizedStorageSet.add(number);
            }
        }
    }

    protected void verify() throws Exception {
        if (this.kDBizPromptBox1.getData() == null || this.kDBizPromptBox1.getData().toString().length() < 1) {
            throw new MobileException(MobileException.MATERIAL_NUMBER_CANT_BE_NULL);
        }
        if (this.kDBizPromptBox2.getData() == null || this.kDBizPromptBox2.getData().toString().length() < 1) {
            throw new MobileException(MobileException.STORAGE_NUMBER_CANT_BE_NULL);
        }
        if (this.kDBizPromptBox3.getData() == null || this.kDBizPromptBox3.getData().toString().length() < 1) {
            throw new MobileException(MobileException.WAREHOUSE_NUMBER_CANT_BE_NULL);
        }
    }

    protected void clear() {
        this.kDBizPromptBox1.setData(null);
        this.kDBizPromptBox2.setData(null);
        this.kDBizPromptBox3.setData(null);
    }
}

