/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractTransferOrderBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.TransferOrderFilterUI;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TransferOrderBillListUI
extends AbstractTransferOrderBillListUI {
    private static final long serialVersionUID = 3958904556454656L;
    private static final Logger logger = CoreUIObject.getLogger(TransferOrderBillListUI.class);
    private static final String TB_ID = "id";
    private static final String TB_ENRYID = "entry.id";
    SCMBillFilterUI filterUI = null;
    private static String TB_QTYOVERRATE = "qtyOverRate";
    private static String TB_QTYLACKRATE = "qtyLackRate";
    protected boolean isBOTP = false;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
    }

    public void onLoad() throws Exception {
        SysContext.getSysContext().setProperty((Object)"storageOrgUnit", null);
        super.onLoad();
        InvClientUtils.setFreezeCol(this.tblMain, "baseStatus");
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionAudit.setEnabled(true);
        this.tblMain.getColumn("creatTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("creatTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.btnDelVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        if (!this.isBOTP) {
            SysContext.getSysContext().setProperty((Object)"storageOrgUnit", null);
        }
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setVisible(true);
        this.menuItemViewInnerPrice.setEnabled(true);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(600);
        this.commonQueryDialog.setHeight(420);
        return this.commonQueryDialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.TransferOrderBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TransferOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{TB_ID, "number", "baseStatus", "bizType", "bizdate", "moveOutOrgUnit", "moveInOrgUnit", "moveOutStorageOrgUnit", "storageOrgUnit", "isInitBill", "creator", "creatTime", "modifier", "modifyTime", "auditor", "auditTime", "processNode", "version"};
        return strMergeColKeys;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "baseQty", "assistantQty", "totalMoveOutQty", "totalMoveInQty", "purInvoiceQty", "saleInvoiceQty", TB_QTYLACKRATE, TB_QTYOVERRATE, "entry.planDeliveryQty", "totalIssuQty", "totalSaleReturnBaseQty", "totalPurReturnBaseQty", "totalSaleReturnQty", "totalPurReturnQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"unitPrice", "purInvoiceAmount", "saleInvoiceAmount", "taxPrice", "taxAmount"};
    }

    public String[] getAmountColumns() {
        return new String[]{"amount", "totalAccountPayable", "totalAccountReceivable", "purInvoiceAmount", "saleInvoiceAmount"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amountPre = 2;
        String[] qtyColumns = new String[]{"entry.qty", "entry.issueQty", "entry.receiptQty", "entry.purInvoiceQty", "entry.saleInvoiceQty", "entry.baseQty", "entry.assistQty"};
        String[] priceCol = new String[]{"entry.price", "entry.taxPrice"};
        String[] amount = new String[]{"entry.amount", "entry.totalAccountPayable", "entry.totalAccountReceivable", "entry.purInvoiceAmount", "entry.saleInvoiceAmount"};
        try {
            rowSet.beforeFirst();
            Map colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])qtyColumns, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])priceCol, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])amount, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    public boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo(TB_ENRYID));
        return sic;
    }

    protected void showSuccessMsg(String key) {
        this.setMessageText(InvClientUtils.getResource(key));
        this.showMessage();
    }

    @Override
    public void actionInitDataFromStock_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"InitDataFromStock_Comfirm")))) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sbBillType = new StringBuffer();
        sbBillType.append("d8e80652-0117-1000-e000-04c5c0a812202407435C");
        sbBillType.append(",");
        sbBillType.append("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=");
        sbBillType.append(",");
        sbBillType.append("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=");
        filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)sbBillType.toString(), CompareType.INCLUDE));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo(TB_ID));
        ev.getSelector().add(new SelectorItemInfo(TB_ENRYID));
        int vSize = 100;
        IStockTransferBill iStockTransferBill = StockTransferBillFactory.getRemoteInstance();
        StockTransferBillCollection coll = iStockTransferBill.getStockTransferBillCollection(ev);
        Vector<StockTransferBillInfo> v = new Vector<StockTransferBillInfo>(vSize);
        ITransferOrderBill iTransferOrderBill = (ITransferOrderBill)this.getBizInterface();
        long start = System.currentTimeMillis();
        long current = System.currentTimeMillis();
        if (coll != null) {
            int i = 0;
            int k = 0;
            int size = coll.size();
            while (i < size) {
                v.add(coll.get(i));
                if (k >= vSize) {
                    iTransferOrderBill.initDataFromST(v);
                    v.clear();
                    k = 0;
                    current = System.currentTimeMillis();
                    logger.info((Object)("\u5206\u79bb\u4e86 " + i + " \u5f20\u5355\u636e, \u82b1\u8d39\u4e86 " + (current - start) / 60000L + " \u5206\u949f"));
                }
                ++i;
                ++k;
            }
            if (v.size() > 0) {
                iTransferOrderBill.initDataFromST(v);
            }
            current = System.currentTimeMillis();
            logger.info((Object)("\u5206\u79bb\u4e86 " + coll.size() + " \u5f20\u5355\u636e, \u82b1\u8d39\u4e86 " + (current - start) / 60000L + " \u5206\u949f"));
        }
        MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"InitDataFromStock_Success", (String[])new String[]{BigDecimal.valueOf(coll.size()).toString(), new BigDecimal((double)(current - start) / 60000.0).setScale(2, 5).toString()}));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        super.getMainBizOrgType();
        return OrgType.Storage;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TransferOrderFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "moveOutStorageOrgUnit.id";
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (srcBillInfos != null && srcBillInfos.size() > 0) {
            destBosTypeList.add("48DA3A71");
            destBosTypeList.add("FC910EF3");
            destBosTypeList.add("783061E3");
            destBosTypeList.add("CC3E933B");
            destBosTypeList.add("9CA9D08F");
        }
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return destBosTypeList;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("ISARAP")) {
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "TransferOrderBillQuery");
        }
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && ((billTypeId = botpMap.get("DESTBILLTYPE.ID").toString()).equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") || billTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || billTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552"))) {
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "TransferOrderBillQuery");
        }
        FilterInfo filter = null;
        if (this.getBOTPViewStatus() == 1) {
            HashMap botpMap2 = this.getBOTPMap();
            if (botpMap2 != null && botpMap2.containsKey("ISARAP") && botpMap2.containsKey("DESTBOSTYPE.ID")) {
                HashSet<String> setBizType;
                String bosType = (String)botpMap2.get("DESTBOSTYPE.ID");
                filter = new FilterInfo();
                CompanyOrgUnitInfo companyOrgInfo = (CompanyOrgUnitInfo)botpMap2.get("ARAPCOMPANY");
                if (bosType.equals("FC910EF3")) {
                    setBizType = new HashSet<String>();
                    setBizType.add("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=");
                    setBizType.add("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=");
                    filter.appendFilterItem("bizType.id", (Object)"d8e80652-0117-1000-e000-04c5c0a812202407435C");
                    filter.appendFilterItem("issueCompanyOrgUnit.id", (Object)companyOrgInfo.getId().toString());
                    filter.getFilterItems().add(new FilterItemInfo("bizType.id", setBizType, CompareType.INCLUDE));
                    filter.appendFilterItem("moveOutOrgUnit.id", (Object)companyOrgInfo.getId().toString());
                    filter.setMaskString("(#0 and #1) OR (#2 and #3)");
                } else if (bosType.equals("48DA3A71")) {
                    setBizType = new HashSet();
                    setBizType.add("d8e80652-0117-1000-e000-04c5c0a812202407435C");
                    setBizType.add("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=");
                    filter.getFilterItems().add(new FilterItemInfo("bizType.id", setBizType, CompareType.INCLUDE));
                    filter.appendFilterItem("receiveCompanyOrgUnit.id", (Object)companyOrgInfo.getId().toString());
                    filter.getFilterItems().add(new FilterItemInfo("bizType.id", setBizType, CompareType.INCLUDE));
                    filter.appendFilterItem("moveInOrgUnit.id", (Object)companyOrgInfo.getId().toString());
                    filter.setMaskString("(#0 and #1) OR (#2 and #3)");
                }
            }
            if (botpMap2 != null && botpMap2.containsKey("DESTBILLTYPE.ID")) {
                StorageOrgUnitInfo storageOrgUnitInfo;
                String billTypeId2 = botpMap2.get("DESTBILLTYPE.ID").toString();
                if (billTypeId2.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                    storageOrgUnitInfo = (StorageOrgUnitInfo)botpMap2.get("MAINBIZORG");
                    filter = new FilterInfo();
                    filter.appendFilterItem("receiveStorageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString());
                    SysContext.getSysContext().setProperty((Object)"storageOrgUnit", (Object)storageOrgUnitInfo);
                    if (this.getUIContext().get("BTPEDITPARAMETER") != null && this.getUIContext().get("BTPEDITPARAMETER") instanceof HashMap) {
                        ((HashMap)this.getUIContext().get("BTPEDITPARAMETER")).put("IGNORE_DATAPERMISSION_CHECK", Boolean.TRUE);
                    }
                    this.isBOTP = true;
                }
                if (billTypeId2.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
                    storageOrgUnitInfo = (StorageOrgUnitInfo)botpMap2.get("MAINBIZORG");
                    filter = new FilterInfo();
                    filter.appendFilterItem("entry.IssueStorageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString());
                }
                if (billTypeId2.equals("510b6503-0105-1000-e000-011bc0a812fd463ED552")) {
                    SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)botpMap2.get("MAINBIZORG");
                    filter = new FilterInfo();
                    filter.appendFilterItem("issueSaleOrgUnit.id", (Object)saleOrgUnitInfo.getId().toString());
                }
                if ("18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(billTypeId2)) {
                    OrgUnitInfo org = (OrgUnitInfo)botpMap2.get("MAINBIZORG");
                    TransportOrgUnitInfo transport = new TransportOrgUnitInfo();
                    transport.setId(org.getId());
                    OrgUnitCollection sous = DtUtils.getStorageCollection(null, transport);
                    LinkedHashSet<String> souIDs = new LinkedHashSet<String>();
                    for (int i = 0; i < sous.size(); ++i) {
                        souIDs.add(sous.get(i).getId().toString());
                    }
                    filter = new FilterInfo();
                    if (souIDs.size() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("entry.issueStorageOrgUnit.id", souIDs, CompareType.INCLUDE));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)"NotExist"));
                    }
                }
            }
        }
        if (filter == null) {
            return super.getBOTPFilterByBillType(BillTypeId, destType, destOrgId);
        }
        return filter;
    }

    protected Object getContextObject() {
        return "transferOrderBill";
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, TransferOrderBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, TransferOrderBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, TB_ID, TB_ENRYID, "number", "entry.seq", "moveOutStorageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"handleClose");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnClose, (String)"handleUnClose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnClose");
        actionProxy.bindTo((AbstractButton)this.btnUnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemUnClose);
        super.initBatchActions();
    }

    @Override
    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        return super.prepareActionAddNew(itemAction);
    }

    @Override
    public RequestContext prepareActionAudit(IItemAction itemAction) throws Exception {
        return super.prepareActionAudit(itemAction);
    }

    public RequestContext prepareActionCreateTo(IItemAction itemAction) throws Exception {
        return super.prepareActionCreateTo(itemAction);
    }

    public RequestContext prepareActionExitCurrent(IItemAction itemAction) throws Exception {
        return null;
    }

    public RequestContext prepareActionTraceDown(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceDown(itemAction);
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        return super.prepareActionView(itemAction);
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareActionAudit() {
        return true;
    }

    public boolean isPrepareActionCreateTo() {
        return true;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionTraceDown() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlert_actionPerformed(ActionEvent e) throws Exception {
        super.actionAlert_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        ITransferOrderBill iBill = TransferOrderBillFactory.getRemoteInstance();
        try {
            this.setOprtState("REVOKE");
            this.pubFireVOChangeListener(ids.get(0).toString());
            iBill.checkAlter((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
        if (selIDs == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BillID", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.im.inv.client.TransferOrderBillVersionUI", (Map)uiContext, null);
        window.show();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        if (!this.getBizInterface().exists((IObjectPK)pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        InvClientUtils.checkBeforeAudit(this.getBizInterface(), (IObjectPK)pk);
        super.actionAudit_actionPerformed(e);
    }

    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrint_actionPerformed(e);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(e);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.TransferOrderPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/Transfer/TransferOrderBill";
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizType", "bizdate", "bizDirection", "moveOutStorageOrgUnit", "storageOrgUnit", "materialNum", "materialName", "model", "unit", "qty", "taxPrice", "issueStorageOrgUnit", "receiptStorageOrgUnit", "taxAmount", "currency"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.TransferOrderBill";
        param.alias = param.alias = ResourceUtils.getMessage((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"transferOrderBill");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    @Override
    public void actionViewInnerPrice_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] transferBillIds = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        if (transferBillIds == null) {
            this.handleException((Exception)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, (Object[])new String[]{SaleUtil.getUIResource((String)"OPERATOR_VIEWINNERPRICE")}));
            return;
        }
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"transferBillIds", (Object)transferBillIds);
        try {
            IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.MultiSidesTransferPricesEditUI", (Map)uiContext, this.dataObjects);
            ui.show();
        }
        catch (Exception ep) {
            this.handUIException(ep);
        }
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.TransferOrderBill";
        param.datataskMode = 1;
        param.alias = ResourceUtils.getMessage((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"transferOrderBill");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    protected String getMainOrgUnitColumnKey() {
        return "moveOutStorageOrgUnit.id";
    }

    protected String[] getQueryHideField() {
        return new String[]{"moveOutStorageOrgUnit.id"};
    }
}

