/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.client.AbstractTransferPriceAdjustConditionUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.sd.sale.util.VerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransferPriceAdjustConditionUI
extends AbstractTransferPriceAdjustConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(TransferPriceAdjustConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.addF7Listener();
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.bizDateFrom.setValue((Object)bd);
        this.bizDateTo.setValue((Object)ed);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtIssueCompanyOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.setBizType();
    }

    private void setBizType() {
        this.prmtBizTypeFrom.setEntityViewInfo(InvClientUtils.getBizTypeEntityViewInfo(true));
        this.prmtBizTypeTo.setEntityViewInfo(InvClientUtils.getBizTypeEntityViewInfo(true));
        try {
            IBizType iBizType = BizTypeFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK("d8e80652-0117-1000-e000-04c5c0a812202407435C");
            BizTypeInfo bizTypeInfo = iBizType.getBizTypeInfo((IObjectPK)pk);
            this.prmtBizTypeFrom.setValue((Object)bizTypeInfo);
            this.prmtBizTypeTo.setValue((Object)bizTypeInfo);
            this.prmtBizTypeFrom.setEditable(false);
            this.prmtBizTypeFrom.setEnabled(false);
            this.prmtBizTypeTo.setEditable(false);
            this.prmtBizTypeTo.setEnabled(false);
            this.prmtBizTypeFrom.setText(bizTypeInfo.getName());
            this.prmtBizTypeTo.setText(bizTypeInfo.getName());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("issueCompanyOrgUnit", this.prmtIssueCompanyOrgUnit.getValue());
        para.setObject("receiptCompanyOrgUnit", this.prmtReceiptCompanyOrgUnit.getValue());
        para.setObject("issueStorageOrgUnit", this.prmtIssueStorageOrgUnit.getValue());
        para.setObject("receiptStorageOrgUnit", this.prmtReceiptStorageOrgUnit.getValue());
        para.setObject("billNumFrom", (Object)this.txtBillNumFrom.getText());
        para.setObject("billNumTo", (Object)this.txtBillNumFrom.getText());
        para.setObject("materialNumFrom", this.prmtMaterialNumFrom.getValue());
        para.setObject("materialNumTo", this.prmtMaterialNumTo.getValue());
        para.setObject("issueWarehouseFrom", this.prmtIssueWarehouseFrom.getValue());
        para.setObject("issueWarehouseTo", this.prmtIssueWarehouseTo.getValue());
        para.setObject("receiptWarehouseFrom", this.prmtReceiptWarehouseFrom.getValue());
        para.setObject("receiptWarehouseTo", this.prmtReceiptWarehouseTo.getValue());
        para.setObject("bizDateFrom", this.bizDateFrom.getValue());
        para.setObject("bizDateTo", this.bizDateTo.getValue());
        para.setObject("bizTypeFrom", this.prmtBizTypeFrom.getValue());
        para.setObject("bizTypeTo", this.prmtBizTypeTo.getValue());
        String companyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtIssueCompanyOrgUnit.getValue()).getId().toString();
        para.setString("COMPANY_ID", companyOrgUnitID);
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtIssueCompanyOrgUnit.setValue(params.getObject("issueCompanyOrgUnit"));
        this.prmtReceiptCompanyOrgUnit.setValue(params.getObject("receiptCompanyOrgUnit"));
        this.prmtIssueStorageOrgUnit.setValue(params.getObject("issueStorageOrgUnit"));
        this.prmtReceiptStorageOrgUnit.setValue(params.getObject("receiptStorageOrgUnit"));
        this.txtBillNumFrom.setText((String)params.getObject("billNumFrom"));
        this.txtBillNumTo.setText((String)params.getObject("billNumTo"));
        this.prmtMaterialNumFrom.setValue(params.getObject("materialNumFrom"));
        this.prmtMaterialNumTo.setValue(params.getObject("materialNumTo"));
        this.prmtIssueWarehouseFrom.setValue(params.getObject("issueWarehouseFrom"));
        this.prmtIssueWarehouseTo.setValue(params.getObject("issueWarehouseTo"));
        this.prmtReceiptWarehouseFrom.setValue(params.getObject("receiptWarehouseFrom"));
        this.prmtReceiptWarehouseTo.setValue(params.getObject("receiptWarehouseTo"));
        this.bizDateFrom.setValue(params.getObject("bizDateFrom"));
        this.bizDateTo.setValue(params.getObject("bizDateTo"));
        this.prmtBizTypeFrom.setValue(params.getObject("bizTypeFrom"));
        this.prmtBizTypeTo.setValue(params.getObject("bizTypeTo"));
    }

    public void clear() {
        super.clear();
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.bizDateFrom.setValue((Object)bd);
        this.bizDateTo.setValue((Object)ed);
        this.txtBillNumFrom.setText("");
        this.txtBillNumTo.setText("");
        this.prmtIssueCompanyOrgUnit.setValue(null);
        this.prmtReceiptCompanyOrgUnit.setValue(null);
        this.prmtIssueStorageOrgUnit.setValue(null);
        this.prmtReceiptStorageOrgUnit.setValue(null);
        this.prmtMaterialNumFrom.setValue(null);
        this.prmtMaterialNumTo.setValue(null);
        this.prmtIssueWarehouseFrom.setValue(null);
        this.prmtIssueWarehouseTo.setValue(null);
        this.prmtReceiptWarehouseFrom.setValue(null);
        this.prmtReceiptWarehouseTo.setValue(null);
    }

    protected void addF7Listener() {
        this.prmtIssueCompanyOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TransferPriceAdjustConditionUI.this.prmtIssueCompanyOrgUnit_dataChanged(e);
                }
                catch (Exception e1) {
                    TransferPriceAdjustConditionUI.this.handUIException(e1);
                }
            }
        });
        this.prmtReceiptCompanyOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TransferPriceAdjustConditionUI.this.prmtReceiptCompanyOrgUnit_dataChanged(e);
                }
                catch (Exception e1) {
                    TransferPriceAdjustConditionUI.this.handUIException(e1);
                }
            }
        });
    }

    public boolean verify() {
        this.verifyF7NotEmpty(this.prmtIssueCompanyOrgUnit, this.labIssueCompanyOrgUnit);
        Date dateFrom = (Date)this.bizDateFrom.getValue();
        Date dateTo = (Date)this.bizDateTo.getValue();
        if (dateFrom != null && dateTo != null && dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.bizDateTo.requestFocus();
            return false;
        }
        return true;
    }

    protected void verifyF7NotEmpty(KDBizPromptBox box, KDLabelContainer label) {
        if (box.getText() == null || box.getText().trim().length() == 0) {
            box.requestFocus();
            VerifyUtils.showCannotBeEmptyMsg((String)label.getBoundLabelText());
        }
    }

    private void prmtIssueCompanyOrgUnit_dataChanged(DataChangeEvent e) {
        if (this.prmtIssueCompanyOrgUnit != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtIssueCompanyOrgUnit.getValue();
            Set set = InvClientUtils.getStoragesIDSet(companyOrgUnitInfo);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            EntityViewInfo viewInfo2 = new EntityViewInfo();
            viewInfo2.setFilter(filterInfo);
            this.prmtIssueStorageOrgUnit.setEntityViewInfo(viewInfo2);
        }
    }

    private void prmtReceiptCompanyOrgUnit_dataChanged(DataChangeEvent e) {
        if (this.prmtReceiptCompanyOrgUnit != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtReceiptCompanyOrgUnit.getValue();
            Set set = InvClientUtils.getStoragesIDSet(companyOrgUnitInfo);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            EntityViewInfo viewInfo2 = new EntityViewInfo();
            viewInfo2.setFilter(filterInfo);
            this.prmtReceiptStorageOrgUnit.setEntityViewInfo(viewInfo2);
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            if (currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected String getViewPermission() {
        return "stockgatherreport_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

