/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.inv.ITransferPriceAdjustFacade;
import com.kingdee.eas.scm.im.inv.TransferPriceAdjustFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractTransferPriceAdjustUI;
import com.kingdee.eas.scm.im.inv.client.TransferPriceAdjustConditionUI;
import com.kingdee.eas.scm.im.inv.client.TransferPriceAdjustFetchUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TransferPriceAdjustUI
extends AbstractTransferPriceAdjustUI {
    private static final Logger logger = CoreUIObject.getLogger(TransferPriceAdjustUI.class);
    private String resFile = "com.kingdee.eas.scm.im.inv.TransferPriceAdjustResource";

    public TransferPriceAdjustUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                TransferPriceAdjustUI.this.tbl_afterDataFill(e);
            }
        });
        this.tbl.getDataRequestManager().setExportMemoryCallback(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnFetchAdjustPrice.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        Object scaleObj = null;
        KDFormattedTextField txtAdjustPrice = new KDFormattedTextField(1);
        txtAdjustPrice.setEditable(true);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JTextField)txtAdjustPrice);
        for (int i = from; i <= last; ++i) {
            scaleObj = this.tbl.getRow(i).getCell("FPricePrecision").getValue();
            if (scaleObj != null) {
                int pricePrecision = Integer.parseInt(scaleObj.toString());
                this.tbl.getRow(i).getCell("FAdjustPrice").setEditor((ICellEditor)itemEditor);
                this.tbl.getRow(i).getCell("FAdjustPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
                this.tbl.getRow(i).getCell("FPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
                this.tbl.getRow(i).getCell("FActualPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
                this.tbl.getRow(i).getCell("FTaxPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
                this.tbl.getRow(i).getCell("FActualTaxPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
            }
            this.tbl.getRow(i).getCell("FAdjustPrice").getStyleAttributes().setBackground(SCMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionFetchAdjustPrice_actionPerformed(ActionEvent e) throws Exception {
        this.params.setString("ACTION", "fetch");
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TransferPriceAdjustFetchUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            ((TransferPriceAdjustFetchUI)uiWindow.getUIObject()).setParentUI(this);
            uiWindow.show();
            this.query();
        }
    }

    public RptParams getQueryParams() {
        return this.params;
    }

    public String getQueryTempTable() {
        return this.getTempTable();
    }

    private Map getResultMapInfo(KDTable tbl, String key) {
        IRow row = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal ZERO = new BigDecimal(0);
        BigDecimal temp = null;
        int count = tbl.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = tbl.getRow(i);
            String id = (String)row.getCell("FID").getValue();
            temp = (BigDecimal)row.getCell(key).getValue();
            if (temp.compareTo(ZERO) <= 0) continue;
            map.put(id, temp);
        }
        return map;
    }

    private void showMessage(String key) {
        this.setMessageText(EASResource.getString((String)this.resFile, (String)key));
        boolean oldbln = this.isShowTextOnly();
        this.setIsShowTextOnly(false);
        this.showMessage();
        if (oldbln) {
            this.setIsShowTextOnly(oldbln);
        }
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        Map map = this.getResultMapInfo(this.tbl, "FAdjustPrice");
        this.params.setString("ACTION", "calculate");
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("issueCompanyOrgUnit");
        ITransferPriceAdjustFacade ifc = TransferPriceAdjustFacadeFactory.getRemoteInstance();
        ifc.calculate(map, companyOrgUnitInfo, this.getTempTable());
        this.showMessage("calculateSuccess");
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.params.setString("ACTION", "refresh");
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.params.setString("ACTION", "refresh");
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        super.actionChart_actionPerformed(e);
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        TransferPriceAdjustConditionUI instance = new TransferPriceAdjustConditionUI();
        return instance;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return TransferPriceAdjustFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        this.params.setString("tempTable", this.getTempTable());
        try {
            ITransferPriceAdjustFacade itf = TransferPriceAdjustFacadeFactory.getRemoteInstance();
            if (start == 0) {
                RptParams result = itf.createTempTable(this.params);
                this.setTempTable(result.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)result.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
            }
            this.params.setString("tempTable", this.getTempTable());
            RptParams rpt = itf.query(this.params, start, length);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            rs.reset();
            KDTableUtil.insertRows((RptRowSet)rs, (int)start, (KDTable)this.tbl, (KDTableInsertHandler)new KDTableInsertHandler(){

                public void setTableRowData(IRow row, Object[] rowData) {
                    int length = rowData.length;
                    int n = length;
                    for (int i = 0; i < n; ++i) {
                        row.getCell(i).setValue(rowData[i]);
                        row.getCell(i).getStyleAttributes().setLocked(true);
                    }
                    row.getCell("FAdjustPrice").getStyleAttributes().setLocked(false);
                }
            });
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }
}

