/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.AbstractSCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.framework.bizflow.IBizFlowFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInvConfigFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.CalculateLotFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.IBillInvConfigFacade;
import com.kingdee.eas.scm.im.inv.invconfig.ICalculateLotFacade;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalculateLotHelper {
    private boolean isUpdateByBaseUnit = false;
    private StorageOrgUnitInfo sou = null;
    private Map<String, String> invPropertyMap = new HashMap<String, String>();
    private IObjectValue billInfo = null;
    private String bosType = null;
    private Map<String, Map<String, Object>> keyDataMap = new HashMap<String, Map<String, Object>>();
    private Context ctx = null;
    private List<String> keyList = null;
    private List<String> keyAssign = null;
    private String entryName = null;
    private Map<String, Map<String, Object>> propMap = null;
    private Map<String, Object> billPropMap = null;
    private Map<String, Object> billEntryPropMap = null;
    private BillInventoryConfigInfo configInfo = null;
    private String transactionTypeID = null;

    private void init(Map<String, Object> conditions) throws BOSException, EASBizException {
        this.sou = (StorageOrgUnitInfo)conditions.get("StorageOrgUnitInfo");
        this.billInfo = (IObjectValue)conditions.get("billInfo");
        this.entryName = (String)conditions.get("entryName");
        this.initBillInfo(this.billInfo);
        if (this.billInfo != null) {
            this.bosType = this.billInfo.getBOSType().toString();
        }
        this.ctx = (Context)conditions.get("context");
        this.initPropList(this.billInfo);
        this.initKeyList();
        this.initInvPropertyMap(this.bosType, this.billInfo);
        this.isUpdateByBaseUnit = (Boolean)conditions.get("isUpdateByBaseUnit");
        if (!(conditions.get("billInfo") instanceof StockTransferBillInfo)) {
            this.transactionTypeID = ((InvBillBaseInfo)conditions.get("billInfo")).getTransactionType().getId().toString();
        }
    }

    private void initBillInfo(IObjectValue model) {
        IObjectCollection entryColl = (IObjectCollection)model.get(this.entryName);
        if (CollectionUtil.isEmpty((IObjectCollection)entryColl) || entryColl.getObject(0) == null || entryColl.getObject(0).getBOSType() == null) {
            return;
        }
        BOSObjectType bosType = null;
        if (StringUtil.isEmpty((String)model.getString("id"))) {
            bosType = model.getBOSType();
            model.put("id", (Object)BOSUuid.create((BOSObjectType)bosType));
        }
        bosType = entryColl.getObject(0).getBOSType();
        IObjectValue entryInfo = null;
        BOSUuid entryID = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.getObject(i);
            if (!StringUtil.isEmpty((String)entryInfo.getString("id"))) continue;
            entryID = BOSUuid.create((BOSObjectType)bosType);
            entryInfo.put("id", (Object)entryID);
        }
    }

    public Map<String, Object> matchLot(List<IObjectValue> billEntryList, Map<String, Object> conditions) throws Exception {
        this.init(conditions);
        IObjectValue billEntryInfo = null;
        for (int i = 0; i < billEntryList.size(); ++i) {
            billEntryInfo = billEntryList.get(i);
            this.billEntryPropMap = this.propMap.get(billEntryInfo.get("id").toString());
            this.buildKey(billEntryInfo);
        }
        ICalculateLotFacade iCalculateLot = this.ctx == null ? CalculateLotFacadeFactory.getRemoteInstance() : CalculateLotFacadeFactory.getLocalInstance(this.ctx);
        conditions.put("keyList", this.keyList);
        conditions.put("isUpdateByBaseUnit", this.isUpdateByBaseUnit);
        Map resMap = iCalculateLot.getInventoryColl(this.keyDataMap, conditions);
        return this.matchLot(resMap, conditions, billEntryList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map<String, Object> matchLot(Map<String, Map<String, Object>> resMap, Map<String, Object> conditions, List<IObjectValue> billEntryList) throws Exception {
        HashMap<String, Object> indexMap = new HashMap<String, Object>();
        AbstractObjectCollection entryColl = (AbstractObjectCollection)this.billInfo.get(this.entryName);
        AbstractObjectCollection newEntryColl = (AbstractObjectCollection)entryColl.clone();
        newEntryColl.clear();
        IObjectValue entryInfo = null;
        CoreBillEntryBaseInfo entryBackup = null;
        String key = null;
        Map<String, Object> dataMap = null;
        boolean isMatch = false;
        StringBuilder errorMsg = new StringBuilder();
        HashMap<String, List<CoreBillEntryBaseInfo>> bizFlowMap = new HashMap<String, List<CoreBillEntryBaseInfo>>();
        HashSet<String> keys = new HashSet<String>();
        boolean isNegativeAndBotp = false;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.getObject(i);
            this.billEntryPropMap = this.propMap.get(entryInfo.get("id").toString());
            key = this.getKey(entryInfo);
            if (key == null || !resMap.containsKey(key) || keys.contains(key)) continue;
            keys.add(key);
            dataMap = resMap.get(key);
            isNegativeAndBotp = (Boolean)dataMap.get("isNegativeAndBotp");
            isMatch = (Boolean)dataMap.get("isMatch");
            if (isMatch || isNegativeAndBotp) continue;
            errorMsg.append(dataMap.get("errorMsg")).append("\r\n");
        }
        int result = this.showErrorMsg(errorMsg.toString());
        List<CoreBillEntryBaseInfo> entryList = null;
        this.keyList.add("FLot");
        int seq = 0;
        ArrayList<CoreBillEntryBaseInfo> entryBackupList = new ArrayList<CoreBillEntryBaseInfo>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, IObjectValue> billEntryMap = new HashMap<String, IObjectValue>();
        for (int i = 0; i < billEntryList.size(); ++i) {
            billEntryMap.put(billEntryList.get(i).getString("id"), billEntryList.get(i));
        }
        IObjectValue entry = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            int j;
            block15: {
                entryInfo = entryColl.getObject(i);
                entry = (IObjectValue)billEntryMap.get(entryInfo.getString("id"));
                if (entry == null) {
                    newEntryColl.addObject(entryInfo);
                    continue;
                }
                this.billEntryPropMap = this.propMap.get(entryInfo.get("id").toString());
                entryInfo.put("seq", (Object)seq++);
                key = this.getKey(entryInfo);
                if (key == null || !resMap.containsKey(key) || conditions.get("isBOTP") != null && (Boolean)conditions.get("isBOTP") == Boolean.TRUE && entryInfo.get("lot") != null) {
                    newEntryColl.addObject(entryInfo);
                    continue;
                }
                BigDecimal qty = (BigDecimal)this.getValueByInvField(entryInfo, "FBaseQty");
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                    newEntryColl.addObject(entryInfo);
                    continue;
                }
                entryBackup = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)entryInfo).clone();
                dataMap = resMap.get(key);
                isMatch = (Boolean)dataMap.get("isMatch");
                if (!isMatch && !isNegativeAndBotp) {
                    if (result == 0) {
                        entryList = this.matchLot(dataMap, entryInfo);
                        if (entryList.size() == 0) {
                            continue;
                        }
                        break block15;
                    } else {
                        newEntryColl.addObject(entryInfo);
                        continue;
                    }
                }
                entryList = this.matchLot(dataMap, entryInfo);
            }
            if (entryInfo.get("id") != null) {
                bizFlowMap.put(entryInfo.get("id").toString(), entryList);
            }
            this.afterMatchLot(entryList, entryBackup);
            CoreBillEntryBaseInfo coreBillEntryBaseInfo = null;
            HashSet<String> ids = new HashSet<String>();
            if (entryList.size() == 0 && isNegativeAndBotp) {
                newEntryColl.addObject(entryInfo);
            }
            for (j = 0; j < entryList.size(); ++j) {
                coreBillEntryBaseInfo = entryList.get(j);
                coreBillEntryBaseInfo.put("isMatchLot", (Object)Boolean.TRUE);
                newEntryColl.addObject((IObjectValue)coreBillEntryBaseInfo);
                ids.add(coreBillEntryBaseInfo.getId().toString());
                if (entryInfo.get("id") == null) continue;
                idMap.put(coreBillEntryBaseInfo.getId().toString(), entryInfo.get("id").toString());
            }
            this.setBizFlowNumber(entryInfo.get("id").toString(), entryInfo.getBOSType().toString(), entryList, this.billInfo);
            entryBackupList.add(entryBackup);
            for (j = 0; j < entryList.size(); ++j) {
                coreBillEntryBaseInfo = entryList.get(j);
                indexMap.put(coreBillEntryBaseInfo.getId().toString(), ids);
            }
        }
        if (bizFlowMap.size() > 0) {
            indexMap.put("bizFlowMap", bizFlowMap);
        }
        indexMap.put("entryBackupList", entryBackupList);
        this.billInfo.put(this.entryName, (Object)newEntryColl);
        indexMap.put("idMap", idMap);
        return indexMap;
    }

    public void setBizFlowNumber(String entryId, String entryBosType, List detailDataList, IObjectValue model) {
        Map<String, String> bizFlowMap = null;
        String bizFlowNumber = "";
        if (model.get("bizFlowMap") != null) {
            bizFlowMap = (Map)model.get("bizFlowMap");
            if (bizFlowMap != null && entryId != null && bizFlowMap.containsKey(entryId)) {
                bizFlowNumber = bizFlowMap.get(entryId).toString();
                bizFlowNumber = bizFlowNumber.substring(0, bizFlowNumber.lastIndexOf("#") + 1);
            } else {
                bizFlowNumber = this.getBizFlowNumber(entryBosType, entryId, model);
            }
        } else {
            bizFlowMap = new HashMap();
            bizFlowNumber = this.getBizFlowNumber(entryBosType, entryId, model);
            if (!StringUtil.isEmpty((String)bizFlowNumber)) {
                bizFlowMap.put(entryId, bizFlowNumber + entryId);
            }
        }
        for (int i = 0; i < detailDataList.size(); ++i) {
            if (StringUtil.isEmpty((String)bizFlowNumber)) continue;
            SCMBillEntryBaseInfo aEntryInfo = (SCMBillEntryBaseInfo)detailDataList.get(i);
            bizFlowMap.put(aEntryInfo.getId().toString(), bizFlowNumber + aEntryInfo.getId().toString());
        }
        model.put("isSplitEntry", (Object)Boolean.TRUE);
        model.put("bizFlowMap", bizFlowMap);
    }

    protected String getBizFlowNumber(String entryBosType, String entryId, IObjectValue model) {
        String bizFlowNumber = "";
        if (this.isBotpBill(model)) {
            HashSet<String> entryIdSet = new HashSet<String>();
            entryIdSet.add(entryId);
            try {
                IBizFlowFacade iBizFlowFacade = this.ctx == null ? BizFlowFacadeFactory.getRemoteInstance() : BizFlowFacadeFactory.getLocalInstance((Context)this.ctx);
                Map bizFlowSplitMap = iBizFlowFacade.setBizFlowRelBySplitLine(entryIdSet, entryBosType);
                if (bizFlowSplitMap != null && bizFlowSplitMap.size() > 0 && bizFlowSplitMap.containsKey(entryId)) {
                    bizFlowNumber = bizFlowSplitMap.get(entryId).toString();
                }
                return bizFlowNumber;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return bizFlowNumber;
    }

    protected boolean isBotpBill(IObjectValue model) {
        if (model == null) {
            return false;
        }
        BillTypeInfo billType = ((AbstractSCMBillBaseInfo)model).getSourceBillType();
        return billType != null;
    }

    private List<CoreBillEntryBaseInfo> matchLot(Map<String, Object> dataMap, IObjectValue billEntryInfo) throws BaseException {
        ArrayList<CoreBillEntryBaseInfo> entryList = new ArrayList<CoreBillEntryBaseInfo>();
        List invList = (List)dataMap.get("invList");
        ArrayList newInvList = new ArrayList();
        Map entryMap = null;
        String qtyField = this.isUpdateByBaseUnit ? "FBaseQty" : "FCurStoreQty";
        BigDecimal qty = (BigDecimal)this.getValueByInvField(billEntryInfo, qtyField);
        BigDecimal thisQty = null;
        CoreBillEntryBaseInfo newBillEntryInfo = null;
        boolean isFinish = false;
        int invListSize = invList.size();
        boolean isNegativeAndBotp = (Boolean)dataMap.get("isNegativeAndBotp");
        boolean isMatch = (Boolean)dataMap.get("isMatch");
        for (int i = 0; i < invListSize; ++i) {
            newBillEntryInfo = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)billEntryInfo).clone();
            if (billEntryInfo != null) {
                String entryBosType = billEntryInfo.getBOSType().toString();
                if (invListSize == 1 && ((CoreBillEntryBaseInfo)billEntryInfo).getId() != null) {
                    newBillEntryInfo.setId(((CoreBillEntryBaseInfo)billEntryInfo).getId());
                } else {
                    newBillEntryInfo.setId(BOSUuid.create((String)entryBosType));
                }
            }
            entryMap = (Map)invList.get(i);
            thisQty = (BigDecimal)entryMap.get(qtyField);
            if (!isMatch && isNegativeAndBotp) {
                if (thisQty.compareTo(BigDecimal.ZERO) > 0 && i + 1 < invListSize) {
                    qty = qty.subtract(thisQty);
                    this.putValueByInvField((IObjectValue)newBillEntryInfo, qtyField, thisQty);
                    this.putData(newBillEntryInfo, entryMap);
                } else {
                    this.putValueByInvField((IObjectValue)newBillEntryInfo, qtyField, qty);
                    this.putData(newBillEntryInfo, entryMap);
                    isFinish = true;
                }
            } else {
                BigDecimal bigDecimal = thisQty = thisQty == null ? BigDecimal.ZERO : thisQty;
                if (qty.compareTo(thisQty) >= 0) {
                    qty = qty.subtract(thisQty);
                    this.putValueByInvField((IObjectValue)newBillEntryInfo, qtyField, thisQty);
                    this.putData(newBillEntryInfo, entryMap);
                } else if (qty.compareTo(thisQty) < 0) {
                    newBillEntryInfo.setId(((CoreBillEntryBaseInfo)billEntryInfo).getId());
                    this.putValueByInvField((IObjectValue)newBillEntryInfo, qtyField, qty);
                    this.putData(newBillEntryInfo, entryMap);
                    thisQty = thisQty.subtract(qty);
                    entryMap.put(qtyField, thisQty);
                    newInvList.add(entryMap);
                    isFinish = true;
                }
            }
            this.setQty((IObjectValue)newBillEntryInfo);
            this.setInvUpdateType((IObjectValue)newBillEntryInfo);
            entryList.add(newBillEntryInfo);
            if (qty.compareTo(BigDecimal.ZERO) > 0 && i + 1 != invListSize && !isFinish) continue;
            for (int j = i + 1; j < invListSize; ++j) {
                newInvList.add(invList.get(j));
            }
            dataMap.put("invList", newInvList);
            break;
        }
        return entryList;
    }

    public void setInvUpdateType(IObjectValue billEntryInfo) throws EASBizException, BOSException {
        Object storeType = billEntryInfo.get("FStoreTypeID");
        Object storeState = billEntryInfo.get("FStoreStatusID");
        if (storeType == null || storeState == null) {
            return;
        }
        String storeTypeId = storeType.toString();
        String storestateId = storeState.toString();
        InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType((Context)this.ctx, (String)this.transactionTypeID, (String)storeTypeId, (String)storestateId);
        InvUpdateTypeInfo defalutInvUpdateType = (InvUpdateTypeInfo)billEntryInfo.get("invUpdateType");
        if (invUpdateType != null || defalutInvUpdateType == null || !defalutInvUpdateType.isIsNotUpdateInv()) {
            billEntryInfo.put("invUpdateType", (Object)invUpdateType);
        }
    }

    private void putData(CoreBillEntryBaseInfo entryInfo, Map<String, Object> entryMap) {
        String key = null;
        String billProperty = null;
        String[] str = null;
        Object billObj = null;
        Object obj = null;
        for (int i = 0; i < this.keyAssign.size(); ++i) {
            Object o;
            key = this.keyAssign.get(i);
            if (key == null) continue;
            billProperty = this.invPropertyMap.get(key);
            if (key.equals("FStoreTypeID")) {
                o = entryMap.get(key);
                String stroTypeId = o != null ? ((StoreTypeInfo)o).getId().toString() : null;
                entryInfo.put(key, (Object)stroTypeId);
            }
            if (key.equals("FStoreStatusID")) {
                o = entryMap.get(key);
                String stroStatusId = o != null ? ((StoreStateInfo)o).getId().toString() : null;
                entryInfo.put(key, (Object)stroStatusId);
            }
            if (!StringUtil.isEmpty((String)billProperty) && billProperty.indexOf(".") != -1 && billProperty.startsWith("__src")) {
                billProperty = billProperty.substring(billProperty.indexOf(".") + 1);
            }
            if (StringUtil.isEmpty((String)billProperty) || billProperty.indexOf(".") == -1) continue;
            str = billProperty.split("\\.");
            billObj = entryInfo.get(str[1]);
            obj = entryMap.get(key);
            if (obj == null) continue;
            entryInfo.put(str[str.length - 1], obj);
        }
        entryInfo.put("exp", entryMap.get("FExp"));
        entryInfo.put("mfg", entryMap.get("FMfg"));
    }

    private String getKey(IObjectValue billEntryInfo) throws Exception {
        StoreStateInfo storeState;
        StoreTypeInfo storeType;
        LocationInfo location;
        WarehouseInfo warehouse;
        TrackNumberInfo trackNumber;
        ProjectInfo project;
        StringBuilder keyBuffer = new StringBuilder();
        keyBuffer.append(this.sou.getId().toString());
        MaterialInfo material = (MaterialInfo)this.getMaterialInfo(billEntryInfo);
        if (material == null) {
            return null;
        }
        IMaterialInventory iMaterialInvtory = this.ctx == null ? MaterialInventoryFactory.getRemoteInstance() : MaterialInventoryFactory.getLocalInstance((Context)this.ctx);
        MaterialInventoryInfo materialInv = iMaterialInvtory.getInventoryInfo(material.getId().toString(), this.sou.getId().toString());
        if (materialInv == null || !materialInv.isIsLotNumber()) {
            return null;
        }
        keyBuffer.append(material.getId().toString());
        String invField = null;
        if (this.isUpdateByBaseUnit) {
            invField = "FBaseUnitID";
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.getPropValue(invField);
            if (baseUnit != null) {
                keyBuffer.append(baseUnit.getId().toString());
            }
        } else {
            invField = "FUnitID";
            MeasureUnitInfo unit = (MeasureUnitInfo)this.getPropValue(invField);
            if (unit != null) {
                keyBuffer.append(unit.getId().toString());
            }
        }
        invField = "FAssistPropertyID";
        AsstAttrValueInfo asstAttr = (AsstAttrValueInfo)this.getPropValue(invField);
        if (asstAttr != null) {
            keyBuffer.append(asstAttr.getId().toString());
        }
        if ((project = (ProjectInfo)this.getPropValue(invField = "FProjectID")) != null && materialInv != null && materialInv.isIsProjectNumber()) {
            keyBuffer.append(project.getId().toString());
        }
        if ((trackNumber = (TrackNumberInfo)this.getPropValue(invField = "FTrackNumberID")) != null && materialInv != null && materialInv.isIsTrackingNumber()) {
            keyBuffer.append(trackNumber.getId().toString());
        }
        if ((warehouse = (WarehouseInfo)this.getPropValue(invField = "FWarehouseID")) != null) {
            keyBuffer.append(warehouse.getId().toString());
        }
        if ((location = (LocationInfo)this.getPropValue(invField = "FLocationID")) != null) {
            keyBuffer.append(location.getId().toString());
        }
        if ((storeType = (StoreTypeInfo)this.getPropValue(invField = "FStoreTypeID")) != null) {
            keyBuffer.append(storeType.getId().toString());
        }
        if ((storeState = (StoreStateInfo)this.getPropValue(invField = "FStoreStatusID")) != null) {
            keyBuffer.append(storeState.getId().toString());
        }
        invField = "FCustomerID";
        CustomerInfo customer = (CustomerInfo)this.getPropValue(invField);
        if (storeType != null && storeType.getId() != null && customer != null && customer.getId() != null && (StoreFlagEnum.CUSTOMER.equals((Object)storeType.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeType.getStoreFlag()))) {
            keyBuffer.append(customer.getId().toString());
        }
        invField = "FSupplierID";
        SupplierInfo supplierInfo = (SupplierInfo)this.getPropValue(invField);
        if (storeType != null && storeType.getId() != null && supplierInfo != null && supplierInfo.getId() != null && (StoreFlagEnum.SUPPLIER.equals((Object)storeType.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeType.getStoreFlag()))) {
            keyBuffer.append(supplierInfo.getId().toString());
        }
        Set<String> defaultKey = this.getDefaultKey();
        Object obj = null;
        String value = null;
        for (int i = 0; i < this.keyList.size(); ++i) {
            invField = this.keyList.get(i);
            if (defaultKey.contains(invField) || (obj = this.getPropValue(invField)) == null) continue;
            value = obj instanceof IObjectValue ? ((IObjectValue)obj).get("id").toString() : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : (obj instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)obj)) : obj.toString()));
            keyBuffer.append(value);
        }
        return keyBuffer.toString();
    }

    private void buildKey(IObjectValue billEntryInfo) throws EASBizException, BOSException {
        StoreStateInfo storeState;
        StoreTypeInfo storeType;
        LocationInfo location;
        WarehouseInfo warehouse;
        TrackNumberInfo trackNumber;
        ProjectInfo project;
        StringBuilder keyBuffer = new StringBuilder();
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        BigDecimal thisQty = BigDecimal.ZERO;
        keyBuffer.append(this.sou.getId().toString());
        keyMap.put("FStorageOrgUnitID", this.sou.getId().toString());
        MaterialInfo material = (MaterialInfo)this.getMaterialInfo(billEntryInfo);
        if (material == null) {
            return;
        }
        IMaterialInventory iMaterialInvtory = this.ctx == null ? MaterialInventoryFactory.getRemoteInstance() : MaterialInventoryFactory.getLocalInstance((Context)this.ctx);
        MaterialInventoryInfo materialInv = iMaterialInvtory.getInventoryInfo(material.getId().toString(), this.sou.getId().toString());
        if (materialInv == null || !materialInv.isIsLotNumber()) {
            return;
        }
        keyBuffer.append(material.getId().toString());
        keyMap.put("FMaterialID", material.getId().toString());
        String invField = null;
        if (this.isUpdateByBaseUnit) {
            invField = "FBaseUnitID";
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.getPropValue(invField);
            if (baseUnit != null) {
                keyBuffer.append(baseUnit.getId().toString());
                keyMap.put("FBaseUnitID", baseUnit.getId().toString());
            }
            thisQty = (BigDecimal)this.getValueByInvField(billEntryInfo, "FBaseQty");
        } else {
            invField = "FUnitID";
            MeasureUnitInfo unit = (MeasureUnitInfo)this.getPropValue(invField);
            if (unit != null) {
                keyBuffer.append(unit.getId().toString());
                keyMap.put("FUnitID", unit.getId().toString());
            }
            thisQty = (BigDecimal)this.getValueByInvField(billEntryInfo, "FCurStoreQty");
        }
        invField = "FAssistPropertyID";
        AsstAttrValueInfo asstAttr = (AsstAttrValueInfo)this.getPropValue(invField);
        if (asstAttr != null) {
            keyBuffer.append(asstAttr.getId().toString());
            keyMap.put("FAssistPropertyID", asstAttr.getId().toString());
        }
        if ((project = (ProjectInfo)this.getPropValue(invField = "FProjectID")) != null && materialInv != null && materialInv.isIsProjectNumber()) {
            keyBuffer.append(project.getId().toString());
            keyMap.put("FProjectID", project.getId().toString());
        }
        if ((trackNumber = (TrackNumberInfo)this.getPropValue(invField = "FTrackNumberID")) != null && materialInv != null && materialInv.isIsTrackingNumber()) {
            keyBuffer.append(trackNumber.getId().toString());
            keyMap.put("FTrackNumberID", trackNumber.getId().toString());
        }
        if ((warehouse = (WarehouseInfo)this.getPropValue(invField = "FWarehouseID")) != null) {
            keyBuffer.append(warehouse.getId().toString());
            keyMap.put("FWarehouseID", warehouse.getId().toString());
        }
        if ((location = (LocationInfo)this.getPropValue(invField = "FLocationID")) != null) {
            keyBuffer.append(location.getId().toString());
            keyMap.put("FLocationID", location.getId().toString());
        }
        if ((storeType = (StoreTypeInfo)this.getPropValue(invField = "FStoreTypeID")) != null) {
            keyBuffer.append(storeType.getId().toString());
            keyMap.put("FStoreTypeID", storeType.getId().toString());
        }
        if ((storeState = (StoreStateInfo)this.getPropValue(invField = "FStoreStatusID")) != null) {
            keyBuffer.append(storeState.getId().toString());
            keyMap.put("FStoreStatusID", storeState.getId().toString());
        }
        invField = "FCustomerID";
        CustomerInfo customer = (CustomerInfo)this.getPropValue(invField);
        if (storeType != null && storeType.getId() != null && customer != null && customer.getId() != null && (StoreFlagEnum.CUSTOMER.equals((Object)storeType.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeType.getStoreFlag()))) {
            keyBuffer.append(customer.getId().toString());
            keyMap.put("FCustomerID", customer.getId().toString());
        }
        invField = "FSupplierID";
        SupplierInfo supplierInfo = (SupplierInfo)this.getPropValue(invField);
        if (storeType != null && storeType.getId() != null && supplierInfo != null && supplierInfo.getId() != null && (StoreFlagEnum.SUPPLIER.equals((Object)storeType.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeType.getStoreFlag()))) {
            keyBuffer.append(supplierInfo.getId().toString());
            keyMap.put("FSupplierID", supplierInfo.getId().toString());
        }
        Set<String> defaultKey = this.getDefaultKey();
        Object obj = null;
        String key = null;
        for (int i = 0; i < this.keyList.size(); ++i) {
            invField = this.keyList.get(i);
            if (defaultKey.contains(invField) || (obj = this.getPropValue(invField)) == null) continue;
            key = obj instanceof IObjectValue ? ((IObjectValue)obj).get("id").toString() : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : (obj instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)obj)) : obj.toString()));
            keyBuffer.append((Object)key);
            keyMap.put(invField, obj);
        }
        Map<String, Object> data = this.keyDataMap.get(keyBuffer.toString());
        if (data == null) {
            data = keyMap;
            data.put("totalQty", thisQty);
        } else {
            BigDecimal totalQty = (BigDecimal)data.get("totalQty");
            totalQty = totalQty == null ? thisQty : totalQty.add(thisQty);
            data.put("totalQty", totalQty);
        }
        this.keyDataMap.put(keyBuffer.toString(), data);
    }

    private Object getPropValue(String invField) {
        Object propValue = this.billEntryPropMap.get(invField);
        if (propValue == null) {
            propValue = this.billPropMap.get(invField);
        }
        return propValue;
    }

    private Object getValueByProperty(IObjectValue value, String property) {
        if (value == null || StringUtil.isEmpty((String)property)) {
            return null;
        }
        Object obj = null;
        IObjectValue tmp = value;
        String[] str = property.split("\\.");
        for (int i = 1; i < str.length - 1; ++i) {
            tmp = tmp.getObjectValue(str[i]);
        }
        if (tmp == null) {
            return null;
        }
        obj = tmp.get(str[str.length - 1]);
        return obj;
    }

    private Object getValueByInvField(IObjectValue value, String invField) {
        String property = this.invPropertyMap.get(invField);
        return this.getValueByProperty(value, property);
    }

    private void putValueByInvField(IObjectValue value, String invField, Object obj) {
        String billProperty = this.invPropertyMap.get(invField);
        if (StringUtil.isEmpty((String)billProperty) || billProperty.indexOf(".") == -1) {
            return;
        }
        String[] str = billProperty.split("\\.");
        value.put(str[1], obj);
    }

    private void initInvPropertyMap(String bosType, IObjectValue billInfo) throws BOSException {
        this.keyAssign = new ArrayList<String>();
        Set<String> defaultKey = this.getDefaultKey();
        BillInventoryConfigEntryInfo entryInfo = null;
        String invField = null;
        for (int i = 0; i < this.configInfo.getEntry().size(); ++i) {
            entryInfo = this.configInfo.getEntry().get(i);
            invField = entryInfo.getInvField();
            if (!defaultKey.contains(invField)) {
                this.keyList.add(invField);
            }
            if (entryInfo.isIsAssign() && !this.getNotBackValueFiles().contains(invField)) {
                this.keyAssign.add(invField);
            }
            this.invPropertyMap.put(invField, entryInfo.getBillProperty());
        }
        if (!this.keyAssign.contains("FLot")) {
            this.keyAssign.add("FLot");
        }
    }

    private void initKeyList() {
        String[] fields = new String[]{"FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FSupplierID", "FCustomerID", "FMaterialID", "FProjectID", "FTrackNumberID", "FAssistPropertyID"};
        this.keyList = new ArrayList<String>(Arrays.asList(fields));
        if (this.isUpdateByBaseUnit) {
            this.keyList.add("FBaseUnitID");
        } else {
            this.keyList.add("FUnitID");
        }
    }

    private Set<String> getDefaultKey() {
        String[] fields = new String[]{"FID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FSupplierID", "FCustomerID", "FMaterialID", "FLot", "FProjectID", "FTrackNumberID", "FUnitID", "FCurStoreQty", "FAssistUnitID", "FCurStoreAssistQty", "FBaseQty", "FAmount", "FBaseUnitID", "FExp", "FAssistPropertyID", "FLockQty", "FLockBaseQty", "FLockAssistQty"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    private Set<String> getNotBackValueFiles() {
        String[] fields = new String[]{"FBaseQty", "FCurStoreQty", "FCurStoreAssistQty"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    private Object getMaterialInfo(IObjectValue billEntryInfo) {
        return this.getPropValue("FMaterialID");
    }

    protected Object getStorageOrgUnitInfo(IObjectValue billInfo, IObjectValue billEntryInfo) {
        Object souInfo = this.getPropValue("FStorageOrgUnitID");
        return souInfo;
    }

    protected BillInventoryConfigInfo getConfigInfo(IObjectValue billInfo) throws BOSException {
        String billTypeId = ((IObjectValue)billInfo.get("billType")).get("id").toString();
        String billEntryBosType = "";
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
            billEntryBosType = "11774BB4";
        }
        return BalanceCfgUtil.getConfigInfo(this.ctx, this.bosType, billEntryBosType, billInfo);
    }

    private MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        IMultiMeasureUnit immu;
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit iMultiMeasureUnit = immu = this.ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    private void setQty(IObjectValue billEntryInfo) throws BaseException {
        if (!this.isUpdateByBaseUnit) {
            return;
        }
        MaterialInfo material = (MaterialInfo)this.getPropValue("FMaterialID");
        MeasureUnitInfo unit = (MeasureUnitInfo)this.getPropValue("FUnitID");
        BigDecimal baseQty = (BigDecimal)this.getValueByInvField(billEntryInfo, "FBaseQty");
        this.putValueByInvField(billEntryInfo, "FCurStoreQty", this.getUnitQty(unit, material, baseQty));
    }

    private BigDecimal getUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal qty = new BigDecimal("0.00");
        if (baseQty != null) {
            qty = baseQty;
        } else {
            baseQty = qty;
        }
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                qty = baseQty.divide(coefficient, precision, 4);
            }
        }
        return qty;
    }

    protected int showErrorMsg(String errorMsg) throws Exception {
        return 0;
    }

    protected void afterMatchLot(List<CoreBillEntryBaseInfo> entryList, CoreBillEntryBaseInfo entryBackup) {
        if ("CC3E933B".equals(this.bosType)) {
            return;
        }
    }

    private void initPropList(IObjectValue billInfo) throws EASBizException, BOSException {
        this.configInfo = this.getConfigInfo(billInfo);
        if (this.configInfo == null) {
            return;
        }
        IBillInvConfigFacade iBillinventoryConfigFacade = this.ctx == null ? BillInvConfigFacadeFactory.getRemoteInstance() : BillInvConfigFacadeFactory.getLocalInstance(this.ctx);
        this.propMap = iBillinventoryConfigFacade.evalConfigValue(this.configInfo, billInfo, billInfo, this.entryName, false, 0);
        if (!CollectionUtil.isEmpty(this.propMap)) {
            this.billPropMap = this.propMap.get("billPropMap");
        }
    }
}

