/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractInventoryHelper {
    protected String loc = "l2";
    protected String resClassName = "com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource";
    protected static final String INV_BALANCEMODEL_ID = "SOYjDrxMRamtGGENYUm98SPUYjI=";
    protected List<String> headRowList = new ArrayList<String>();
    protected Map<String, String> headRowMap = new HashMap<String, String>();
    protected StringBuilder querySQL = new StringBuilder();
    protected StringBuilder filterSQL = new StringBuilder();
    protected KDTable table = null;
    protected StringBuilder createTempTableSQL = null;
    protected List<String> tempTableColList = null;

    public AbstractInventoryHelper() throws Exception {
        this(null);
    }

    public AbstractInventoryHelper(String filterSQL) throws Exception {
        this.initQuerySQL();
        this.initKDTable();
    }

    protected void initKDTable() {
        this.table = new KDTable();
        this.table.removeColumns();
        IRow headRow = this.table.addHeadRow();
        String colKey = null;
        String colName = null;
        IColumn col = null;
        int size = this.headRowList.size();
        for (int colIndex = 0; colIndex < size; ++colIndex) {
            colKey = this.headRowList.get(colIndex);
            col = this.table.addColumn();
            col.setKey(colKey);
            colName = this.headRowMap.get(colKey);
            if (StringUtil.isEmpty((String)colName)) {
                col.getStyleAttributes().setHided(true);
                continue;
            }
            headRow.getCell(colIndex).setValue((Object)colName);
        }
    }

    public KDTable getTable() {
        if (this.table == null) {
            this.initKDTable();
        }
        return this.table;
    }

    public void initQuerySQL() throws Exception {
        this.initTempTable();
        BalanceFieldModelCollection balanceFieldModelCol = this.getBalanceFieldModelCollection();
        String invField = null;
        String tableAlias = null;
        String linkTable = null;
        StringBuilder sqlSelect = this.getSelectSQL();
        StringBuilder sqlFrom = this.getFromSQL();
        BalanceFieldModelInfo fieldModeInfo = null;
        this.headRowList.clear();
        int size = balanceFieldModelCol.size();
        for (int i = 0; i < size; ++i) {
            fieldModeInfo = balanceFieldModelCol.get(i);
            invField = fieldModeInfo.getFieldName();
            if (BizDataTypeEnum.AssistInfo.equals((Object)fieldModeInfo.getBizDataType()) && !fieldModeInfo.isIsSPvisible()) continue;
            if (fieldModeInfo.isIsScheduled()) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.headRowList.add("FMaterialID");
                    this.headRowList.add("MaterialNumber");
                    this.headRowList.add("MaterialName");
                    this.headRowList.add("MaterialModel");
                    this.headRowMap.put("FMaterialNumber", ResourceUtil.getMessage((String)this.resClassName, (String)"materialNumber"));
                    this.headRowMap.put("FMaterialName", fieldModeInfo.getAlias());
                    this.headRowMap.put("FMaterialModel", ResourceUtil.getMessage((String)this.resClassName, (String)"materialModel"));
                    continue;
                }
                if (invField.equalsIgnoreCase("FLot")) {
                    this.headRowList.add("FLot");
                    this.headRowList.add("FMfg");
                    this.headRowList.add("FExp");
                    this.headRowMap.put("FLot", fieldModeInfo.getAlias());
                    this.headRowMap.put("FMfg", ResourceUtil.getMessage((String)this.resClassName, (String)"mfg"));
                    this.headRowMap.put("FExp", ResourceUtil.getMessage((String)this.resClassName, (String)"exp"));
                    continue;
                }
                String key = invField;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                    if (fieldModeInfo.getBaseDataBOSType() == null) {
                        this.headRowList.add("FID");
                        continue;
                    }
                    this.headRowList.add(key);
                    key = this.getDisplayKey(key);
                }
                this.headRowList.add(key);
                this.headRowMap.put(key, fieldModeInfo.getAlias());
                continue;
            }
            tableAlias = "t" + i;
            if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                String displayKey = this.getDisplayKey(invField);
                sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(displayKey).append(" \r\n");
                sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldModeInfo.getBaseDataBOSType()));
                EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                linkTable = entityObjInfo.getTable().getName();
                sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                this.headRowList.add(invField);
                this.headRowList.add(displayKey);
                this.headRowMap.put(displayKey, fieldModeInfo.getAlias());
                this.createTempTableSQL.append(", ").append(invField).append(" varchar(44)");
                this.createTempTableSQL.append(", ").append(displayKey).append(" nvarchar(255)");
                this.tempTableColList.add(invField);
                this.tempTableColList.add(displayKey);
                continue;
            }
            sqlSelect.append(", INVENTORY.").append(invField).append(" as ").append(invField);
            this.headRowList.add(invField);
            this.headRowMap.put(invField, fieldModeInfo.getAlias());
            DataTypeEnum dataType = fieldModeInfo.getDataType();
            if (DataTypeEnum.String.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" nvarchar(255)");
            } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" int");
            } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" datetime");
            } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType)) {
                this.createTempTableSQL.append(", ").append(invField).append(" Decimal(28,10) not null default 0");
            }
            this.tempTableColList.add(invField);
        }
        this.headRowList.remove("FAmount");
        this.headRowList.add("FCurStoreQtyPrecision");
        this.headRowList.add("FBaseQtyPrecision");
        this.headRowList.add("FCurStoreAssistQtyPrecision");
        this.headRowList.add("FBaseQtyConvsRate");
        this.headRowList.add("FCurStoreQtyConvsRate");
        StringBuilder sqlWhere = this.getWhereSQL();
        this.querySQL.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere).append((CharSequence)this.getOrderBySQL());
    }

    protected StringBuilder getSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT \r\n");
        sb.append(" INVENTORY.FID AS FID,  \r\n");
        sb.append(" COMPANYORGUNIT.FID AS FCompanyOrgUnitID, \r\n");
        sb.append(" COMPANYORGUNIT.FName_").append(this.loc).append(" AS FCompanyOrgUnitName, \r\n");
        sb.append(" INVENTORY.FMaterialID AS FMaterialID, \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS FMaterialName, \r\n");
        sb.append(" MATERIAL.FNumber AS FMaterialNumber, \r\n");
        sb.append(" MATERIAL.FModel AS FMaterialModel, \r\n");
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitName, \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS FStorageOrgUnitNumber,  \r\n");
        sb.append(" INVENTORY.FWarehouseID AS FWarehouseID, \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseName, \r\n");
        sb.append(" LOCATION.FID AS FLocationID, \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationName,  \r\n");
        sb.append(" ASSISTPROPERTY.FID AS FAssistPropertyID, \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyName, \r\n");
        sb.append(" CASE WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLOT, \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS FMfg,  \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS FExp,  \r\n");
        sb.append(" SUPPLIER.FID AS FSupplierID, \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierName,  \r\n");
        sb.append(" CUSTOMER.FID AS FCustomerID, \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerName,  \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusName,  \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeName, \r\n");
        sb.append(" PROJECT.FID AS FProjectID, \r\n");
        sb.append(" PROJECT.FNumber AS FProjectNumber,  \r\n");
        sb.append(" TRACKNUMBER.FID AS FTrackNumberID, \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberNumber,  \r\n");
        sb.append(" UNIT.FID AS FUnitID, \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitName, \r\n");
        sb.append(" BASEUNIT.FID AS FBaseUnitID, \r\n");
        sb.append(" BASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitName,  \r\n");
        sb.append(" ASSISTUNIT.FID AS FAssistUnitID, \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitName,  \r\n");
        sb.append(" INVENTORY.FBaseQty AS FBaseQty,  \r\n");
        sb.append(" INVENTORY.FCurStoreQty AS FCurStoreQty,  \r\n");
        sb.append(" INVENTORY.FCurStoreAssistQty AS FCurStoreAssistQty,  \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS FCurStoreQtyPrecision,  \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS FBaseQtyPrecision,  \r\n");
        sb.append(" MULTIASSITUNIT.FQtyPrecision AS FCurStoreAssistQtyPrecision,  \r\n");
        sb.append(" MULTIBASEUNIT.FBaseConvsRate AS FBaseQtyConvsRate,  \r\n");
        sb.append(" MULTIUNIT.FBaseConvsRate AS FCurStoreQtyConvsRate,  \r\n");
        sb.append(" Reservation.FReservationQty AS FReservationQty, \r\n");
        sb.append(" Reservation.FReservationBaseQty AS FReservationBaseQty,  \r\n");
        sb.append(" Reservation.FReservationAssistQty AS FReservationAssistQty, \r\n");
        sb.append(" INVENTORYUNIT.FName_").append(this.loc).append(" AS INVENTORYUNITNAME, \r\n");
        sb.append(" ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision) AS CURMATSTOREQTY, \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS32  \r\n");
        return sb;
    }

    protected StringBuilder getFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSITUNIT ON INVENTORY.FMaterialID = MULTIASSITUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSITUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON INVENTORY.FBaseUnitID = BASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialCost AS MATERIALCOST ON INVENTORY.FCompanyOrgUnitID = MATERIALCOST.FOrgUnit AND INVENTORY.FMaterialID = MATERIALCOST.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATERIALINVENTORY ON INVENTORY.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATERIALINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup AS MATERIALGROUP ON MATERIAL.FMaterialGroupID = MATERIALGROUP.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATERIALINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATERIALINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATERIALINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append(" LFET OUTER JOIN T_IM_Reservation AS Reservation ON Reservation.FInventoryID = INVENTORY.FID \r\n");
        return sb;
    }

    protected StringBuilder getWhereSQL() {
        return this.filterSQL;
    }

    protected StringBuilder getOrderBySQL() {
        return null;
    }

    public BalanceFieldModelCollection getBalanceFieldModelCollection() throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getRemoteInstance().getBalanceModelInfo((IObjectPK)new ObjectUuidPK(INV_BALANCEMODEL_ID), selector);
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        coll.sort("seq");
        Map<String, BalanceFieldModelInfo> balanceFieldMap = this.getBalanceFieldModelMap(coll);
        BalanceFieldModelCollection orderColl = new BalanceFieldModelCollection();
        Object[] orderFields = this.getOrderFields();
        if (ArrayUtil.isEmpty((Object[])orderFields)) {
            orderColl = coll;
        } else {
            Object field2 = null;
            BalanceFieldModelInfo fieldInfo = null;
            for (Object field2 : orderFields) {
                fieldInfo = balanceFieldMap.get(field2);
                if (fieldInfo == null) continue;
                orderColl.add(fieldInfo);
                coll.remove(fieldInfo);
            }
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
                orderColl.addCollection(coll);
            }
        }
        return orderColl;
    }

    private Map<String, BalanceFieldModelInfo> getBalanceFieldModelMap(BalanceFieldModelCollection coll) {
        BalanceFieldModelInfo fieldInfo = null;
        HashMap<String, BalanceFieldModelInfo> balanceFieldMap = new HashMap<String, BalanceFieldModelInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            balanceFieldMap.put(fieldInfo.getFieldName(), fieldInfo);
        }
        return balanceFieldMap;
    }

    protected String[] getOrderFields() {
        String[] orderFields = new String[]{"FID", "FMaterialID", "FLot", "FUnitID", "FCurStoreQty", "FBaseUnitID", "FBaseQty", "FAssistUnitID", "FCurStoreAssistQty", "FAssistPropertyID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FProjectID", "FTrackNumberID", "FCustomerID", "FSupplierID", "FStorageOrgUnitID"};
        return orderFields;
    }

    protected String getDisplayKey(String key) {
        if (StringUtil.isEmpty((String)key) || !key.endsWith("ID")) {
            return null;
        }
        StringBuilder displayKey = new StringBuilder();
        displayKey.append(key.substring(0, key.indexOf("ID")));
        if (key.equals("FProjectID") || key.equals("FTrackNumberID")) {
            displayKey.append("Number");
        } else {
            displayKey.append("Name");
        }
        return displayKey.toString();
    }

    private void initTempTable() {
        this.initCreateTempTableSQL();
        this.initTempTableColList();
    }

    protected void initCreateTempTableSQL() {
        this.createTempTableSQL = new StringBuilder();
        this.createTempTableSQL.append(" create table temp_table(");
        this.createTempTableSQL.append(" FID varchar(44),");
        this.createTempTableSQL.append(" FCompanyOrgUnitID varchar(44),");
        this.createTempTableSQL.append(" FCompanyOrgUnitName nvarchar(255),");
        this.createTempTableSQL.append(" FMaterialID varchar(44),");
        this.createTempTableSQL.append(" FMaterialName nvarchar(255),");
        this.createTempTableSQL.append(" FMaterialNumber nvarchar(80),");
        this.createTempTableSQL.append(" FMaterialModel nvarchar(255),");
        this.createTempTableSQL.append(" FStorageOrgUnitID varchar(44),");
        this.createTempTableSQL.append(" FStorageOrgUnitName nvarchar(255),");
        this.createTempTableSQL.append(" FStorageOrgUnitNumber nvarchar(80),");
        this.createTempTableSQL.append(" FWarehouseID varchar(44),");
        this.createTempTableSQL.append(" FWarehouseName nvarchar(255),");
        this.createTempTableSQL.append(" FLocationID varchar(44),");
        this.createTempTableSQL.append(" FLocationName nvarchar(255),");
        this.createTempTableSQL.append(" FAssistPropertyID varchar(44),");
        this.createTempTableSQL.append(" FAssistPropertyName nvarchar(255),");
        this.createTempTableSQL.append(" FLOT nvarchar(80),");
        this.createTempTableSQL.append(" FMfg datetime,");
        this.createTempTableSQL.append(" FExp datetime,");
        this.createTempTableSQL.append(" FSupplierID varchar(44),");
        this.createTempTableSQL.append(" FSupplierName nvarchar(255),");
        this.createTempTableSQL.append(" FCustomerID varchar(44),");
        this.createTempTableSQL.append(" FCustomerName nvarchar(255),");
        this.createTempTableSQL.append(" FStoreStatusID varchar(44),");
        this.createTempTableSQL.append(" FStoreStatusName nvarchar(255),");
        this.createTempTableSQL.append(" FStoreTypeID varchar(44),");
        this.createTempTableSQL.append(" FStoreTypeName nvarchar(255),");
        this.createTempTableSQL.append(" FProjectID varchar(44),");
        this.createTempTableSQL.append(" FProjectNumber nvarchar(255),");
        this.createTempTableSQL.append(" FTrackNumberID varchar(44),");
        this.createTempTableSQL.append(" FTrackNumberNumber nvarchar(255),");
        this.createTempTableSQL.append(" FUnitID varchar(44),");
        this.createTempTableSQL.append(" FUnitName nvarchar(255),");
        this.createTempTableSQL.append(" FBaseUnitID varchar(44),");
        this.createTempTableSQL.append(" FBaseUnitName nvarchar(255),");
        this.createTempTableSQL.append(" FAssistUnitID varchar(44),");
        this.createTempTableSQL.append(" FAssistUnitName nvarchar(255),");
        this.createTempTableSQL.append(" FBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FCurStoreQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FCurStoreAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FCurStoreQtyPrecision int,");
        this.createTempTableSQL.append(" FBaseQtyPrecision int,");
        this.createTempTableSQL.append(" FCurStoreAssistQtyPrecision int,");
        this.createTempTableSQL.append(" FBaseQtyConvsRate int,");
        this.createTempTableSQL.append(" FCurStoreQtyConvsRate int,");
        this.createTempTableSQL.append(" FReservationQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationAssistQty Decimal(28,10) not null default 0");
    }

    protected void initTempTableColList() {
        String[] colNames = new String[]{"FID", "FCompanyOrgUnitID", "FCompanyOrgUnitName", "FMaterialID", "FMaterialName", "FMaterialNumber", "FMaterialModel", "FStorageOrgUnitID", "FStorageOrgUnitName", "FStorageOrgUnitNumber", "FWarehouseID", "FWarehouseName", "FLocationID", "FLocationName", "FAssistPropertyID", "FAssistPropertyName", "FLOT", "FMfg", "FExp", "FSupplierID", "FSupplierName", "FCustomerID", "FCustomerName", "FStoreStatusID", "FStoreStatusName", "FStoreTypeID", "FStoreTypeName", "FProjectID", "FProjectNumber", "FTrackNumberID", "FTrackNumberNumber", "FUnitID", "FUnitName", "FBaseUnitID", "FBaseUnitName", "FAssistUnitID", "FAssistUnitName", "FBaseQty", "FCurStoreQty", "FCurStoreAssistQty", "FCurStoreQtyPrecision", "FBaseQtyPrecision", "FCurStoreAssistQtyPrecision", "FBaseQtyConvsRate", "FCurStoreQtyConvsRate", "FReservationQty", "FReservationBaseQty", "FReservationAssistQty"};
        this.tempTableColList = Arrays.asList(colNames);
    }
}

