/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryException;
import com.kingdee.eas.scm.im.inv.invconfig.client.AbstractBillInventoryConfigListUI;
import com.kingdee.eas.scm.im.inv.invconfig.client.BillInventoryConfigEditUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;

public class BillInventoryConfigListUI
extends AbstractBillInventoryConfigListUI {
    private static final long serialVersionUID = 1L;

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            String message;
            BillInventoryConfigInfo info = BillInventoryConfigFactory.getRemoteInstance().getBillInventoryConfigInfo((IObjectPK)new ObjectUuidPK(strId));
            if (info.getStatus().getValue() == 1) {
                message = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"active_cantEdit");
                MsgBox.showInfo((String)message);
                SysUtil.abort();
            }
            if (info.isIsScheduled()) {
                message = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"SysCanNotEdit");
                MsgBox.showInfo((String)message);
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            String message;
            BillInventoryConfigInfo info = BillInventoryConfigFactory.getRemoteInstance().getBillInventoryConfigInfo((IObjectPK)new ObjectUuidPK(strId));
            if (info.getStatus().getValue() == 1) {
                message = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"cannotRemove");
                MsgBox.showInfo((String)message);
                SysUtil.abort();
            }
            if (info.isIsScheduled()) {
                message = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"SysCanNotDelete");
                MsgBox.showInfo((String)message);
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.INACTIVE);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.ACTIVE);
    }

    private void setStatus(UseStatusEnum status) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        HashSet pks = new HashSet(ids);
        ArrayList errors = BillInventoryConfigFactory.getRemoteInstance().setStatus(pks, status);
        if (errors.size() > 0) {
            BillInventoryException e = (BillInventoryException)((Object)errors.get(0));
            MsgBox.showError((String)e.getMessage());
        }
        this.refresh(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BillInventoryConfigFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BillInventoryConfigEditUI.class.getName();
    }

    private void initUI() {
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sic = viewInfo.getSorter();
        if (sic.size() == 1 && sic.get(0).getPropertyName().equals("id")) {
            sic.clear();
            SorterItemInfo item = new SorterItemInfo("number");
            item.setSortType(SortType.ASCEND);
            sic.add(item);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isBOSTypeConfiged() throws BOSException, EASBizException {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

