/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.InventoryF7List;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.MatAssembleAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.invconfig.client.InventoryHelper;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InventoryF7Helper
extends InventoryHelper {
    protected String billTypeId = null;
    private static final String strResource = "com.kingdee.eas.scm.common.SCMResource.";

    public int actionInventoryF7Query(IObjectValue billInfo, IObjectValue billEntryInfo, IObjectValue tti, UIContext uiContext) throws Exception {
        if (tti != null) {
            this.transactionTypeID = tti.get("id").toString();
            this.billTypeId = ((TransactionTypeInfo)tti).getBillType().getId().toString();
        }
        this.entryName = (String)uiContext.get((Object)"entryName");
        String bosType = billInfo.getBOSType().toString();
        String billEntryBosType = billEntryInfo.getBOSType().toString();
        this.buildConfigMapping(bosType, billEntryBosType, billInfo, billEntryInfo, 1);
        String sql = this.getQuerySQL(bosType, billInfo, billEntryInfo);
        IUIWindow invUIWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InventoryF7List.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        InventoryF7List invF7List = (InventoryF7List)invUIWin.getUIObject();
        this.resMap.put("createTempTableSQL", this.createTempTableSQL.toString() + ");");
        this.resMap.put("fieldSQL", this.fieldSQL.toString());
        invF7List.actionQuery(this.tableHeadKeyList, this.resMap, sql);
        String[] storageOrgIDs = (String[])uiContext.get((Object)"storageOrgIDs");
        String storageOrgID = (String)uiContext.get((Object)"storageOrgID");
        String companyOrgID = (String)uiContext.get((Object)"companyOrgID");
        if (storageOrgID != null || companyOrgID != null) {
            invUIWin.show();
        } else if (storageOrgIDs != null && storageOrgIDs.length > 0 && !storageOrgIDs[0].equals("")) {
            invUIWin.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.ORG_NOT_DELEGATE_STORAGE"));
            return 0;
        }
        if (!invF7List.isCanceled()) {
            List results = invF7List.getResults();
            List<CoreBillEntryBaseInfo> entryInfoList = this.fetchData(results, billEntryInfo);
            CoreBillEntryBaseInfo coreEntryInfo = null;
            if (this.entryName == null) {
                return 0;
            }
            AbstractObjectCollection coreEntryCol = (AbstractObjectCollection)billInfo.get(this.entryName);
            String material = (String)this.mapping.get("FMaterialID");
            if (!StringUtil.isEmpty((String)material)) {
                String[] str = material.split("\\.");
                material = str[str.length - 1];
                if (coreEntryCol.size() == 1 && coreEntryCol.getObject(0) != null && coreEntryCol.getObject(0).get(material) == null) {
                    coreEntryCol.clear();
                }
            }
            int size = entryInfoList.size();
            for (int i = 0; i < size; ++i) {
                coreEntryInfo = entryInfoList.get(i);
                coreEntryCol.addObject((IObjectValue)coreEntryInfo);
            }
            return results.size();
        }
        return 0;
    }

    public int actionAfterInventoryF7Query(IObjectValue billInfo, IObjectValue billEntryInfo, IObjectValue tti, UIContext uiContext, KDTable kdtBeforeEntrys) throws Exception {
        if (tti != null) {
            this.transactionTypeID = tti.get("id").toString();
            this.billTypeId = ((TransactionTypeInfo)tti).getBillType().getId().toString();
        }
        this.entryName = (String)uiContext.get((Object)"entryName");
        String bosType = billInfo.getBOSType().toString();
        String billEntryBosType = billEntryInfo.getBOSType().toString();
        this.buildConfigMapping(bosType, billEntryBosType, billInfo, billEntryInfo, 1);
        String sql = this.getQuerySQL(bosType, billInfo, billEntryInfo);
        IUIWindow invUIWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InventoryF7List.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        InventoryF7List invF7List = (InventoryF7List)invUIWin.getUIObject();
        this.resMap.put("createTempTableSQL", this.createTempTableSQL.toString() + ");");
        this.resMap.put("fieldSQL", this.fieldSQL.toString());
        invF7List.actionQuery(this.tableHeadKeyList, this.resMap, sql);
        String[] storageOrgIDs = (String[])uiContext.get((Object)"storageOrgIDs");
        String storageOrgID = (String)uiContext.get((Object)"storageOrgID");
        String companyOrgID = (String)uiContext.get((Object)"companyOrgID");
        if (storageOrgID != null || companyOrgID != null) {
            invUIWin.show();
        } else if (storageOrgIDs != null && storageOrgIDs.length > 0 && !storageOrgIDs[0].equals("")) {
            invUIWin.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.ORG_NOT_DELEGATE_STORAGE"));
            return 0;
        }
        if (!invF7List.isCanceled()) {
            List results = invF7List.getResults();
            List<CoreBillEntryBaseInfo> entryInfoList = this.fetchData(results, billEntryInfo);
            Object coreEntryInfo = null;
            if (this.entryName == null) {
                return 0;
            }
            MatAssembleBeforeEntryCollection coll = ((MatAssembleBillInfo)billInfo).getEntry();
            MatAssembleBeforeEntryInfo mabeforeEntryInfo = null;
            int selectIndex = kdtBeforeEntrys.getSelectManager().getActiveRowIndex();
            mabeforeEntryInfo = coll.get(selectIndex);
            AbstractObjectCollection coreEntryCol = (AbstractObjectCollection)mabeforeEntryInfo.get(this.entryName);
            String material = (String)this.mapping.get("FMaterialID");
            if (!StringUtil.isEmpty((String)material)) {
                String[] str = material.split("\\.");
                material = str[str.length - 1];
                if (coreEntryCol != null && coreEntryCol.size() == 1 && coreEntryCol.getObject(0) != null && coreEntryCol.getObject(0).get(material) == null) {
                    coreEntryCol.clear();
                }
            }
            int size = entryInfoList.size();
            for (int i = 0; i < size; ++i) {
                MatAssembleAfterEntryInfo matAssembleAfterEntryInfo = (MatAssembleAfterEntryInfo)entryInfoList.get(i);
                MaterialInfo materialInfo = matAssembleAfterEntryInfo.getMaterial();
                BigDecimal afterQty = matAssembleAfterEntryInfo.getUnitQty().multiply(mabeforeEntryInfo.getBaseQty()).setScale(materialInfo.getPricePrecision());
                matAssembleAfterEntryInfo.setQty(afterQty);
                matAssembleAfterEntryInfo.setBaseQty(afterQty);
                if (materialInfo.getAssistUnit() != null) {
                    matAssembleAfterEntryInfo.setAssistQty(InvClientUtils.getMultiUnitQty(materialInfo.getBaseUnit(), materialInfo.getAssistUnit(), materialInfo, afterQty));
                }
                coreEntryCol.addObject((IObjectValue)matAssembleAfterEntryInfo);
            }
            return results.size();
        }
        return 0;
    }

    private List<CoreBillEntryBaseInfo> fetchData(List<HashMap<String, Object>> results, IObjectValue billEntryInfo) throws BOSException, EASBizException {
        ArrayList<CoreBillEntryBaseInfo> entryList = new ArrayList<CoreBillEntryBaseInfo>();
        HashMap<String, Object> hmResult = null;
        CoreBillEntryBaseInfo value = (CoreBillEntryBaseInfo)billEntryInfo;
        int size = results.size();
        for (int index = 0; index < size; ++index) {
            hmResult = results.get(index);
            String invField = null;
            String billProperty = null;
            if (index == 0) {
                value = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)billEntryInfo).clone();
            } else {
                value = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)billEntryInfo).clone();
                if (billEntryInfo.getBOSType() != null) {
                    BOSUuid id = BOSUuid.create((String)billEntryInfo.getBOSType().toString());
                    value.put("id", (Object)id);
                }
            }
            if (value instanceof MatAttrChangeBeforeEntryInfo) {
                ((MatAttrChangeBeforeEntryInfo)value).getEntry1().clear();
            }
            int hsize = this.tableHeadKeyList.size();
            for (int i = 0; i < hsize; ++i) {
                invField = (String)this.tableHeadKeyList.get(i);
                billProperty = (String)this.mapping.get(invField);
                this.putData(billProperty, invField, hmResult, (IObjectValue)value);
            }
            this.setInvUpdateType((IObjectValue)value);
            value.put("inventoryID", hmResult.get("id"));
            entryList.add(value);
        }
        return entryList;
    }

    private void putData(String billProperty, String invField, Map<String, Object> hmResult, IObjectValue billEntryInfo) throws BOSException, EASBizException {
        String[] str;
        if (billProperty == null || billProperty.indexOf(".") == -1 || invField == null) {
            return;
        }
        boolean isInvUpdateType = this.isInvUpdateType();
        Object obj = null;
        String key = invField;
        if (key.toLowerCase(Locale.ENGLISH).endsWith("id") && hmResult.get(key) != null) {
            if (isInvUpdateType && (invField.equals("FStoreTypeID") || invField.equals("FStoreStatusID"))) {
                billEntryInfo.put(invField, hmResult.get(key));
            } else {
                String id = hmResult.get(key).toString();
                ICoreBase coreBase = this.getICoreBase(invField, id);
                obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(id));
            }
        } else {
            BigDecimal qty;
            obj = hmResult.get(invField);
            if ((invField.equals("FBaseQty") || invField.equals("FCurStoreQty") || invField.equals("FCurStoreAssistQty")) && obj instanceof BigDecimal && BigDecimal.ZERO.compareTo(qty = (BigDecimal)obj) > 0) {
                obj = BigDecimal.ZERO;
            }
        }
        if (billProperty.startsWith("__src")) {
            billProperty = billProperty.substring(billProperty.indexOf(".") + 1);
        }
        if (!"invUpdateType".equals((str = billProperty.split("\\."))[1])) {
            if (billEntryInfo instanceof MatAssembleAfterEntryInfo) {
                billEntryInfo.put(str[2], obj);
            } else {
                billEntryInfo.put(str[1], obj);
            }
        }
    }

    @Override
    protected String getQuerySQL(String bosType, IObjectValue billInfo, IObjectValue billEntryInfo) throws Exception {
        String invField = null;
        this.initDefaultProperty();
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        StringBuilder extendFilterSQL = new StringBuilder();
        this.initCreateTempTableSQL();
        this.initFieldSQL();
        String linkTable = null;
        String tableAlias = null;
        BalanceFieldModelCollection coll = this.getBalanceFieldModelCollInOrder();
        BalanceFieldModelInfo fieldInfo = null;
        this.tableHeadKeyList.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            if (DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType())) {
                this.boolPropSet.add(invField);
            } else if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                this.linkPropBosTypeMap.put(invField, fieldInfo.getBaseDataBOSType());
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("MaterialNumber");
                    this.tableHeadKeyList.add("MaterialName");
                    this.tableHeadKeyList.add("MaterialModel");
                    this.resMap.put("MaterialNumber", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialNumber"));
                    this.resMap.put("MaterialName", fieldInfo.getAlias());
                    this.resMap.put("MaterialModel", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialModel"));
                } else if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("Mfg");
                    this.tableHeadKeyList.add("Exp");
                    this.resMap.put(invField, fieldInfo.getAlias());
                    this.resMap.put("Mfg", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg"));
                    this.resMap.put("Exp", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp"));
                } else {
                    this.tableHeadKeyList.add(invField);
                    String key = invField;
                    if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                        if (fieldInfo.getBaseDataBOSType() == null) {
                            this.tableHeadKeyList.add("id");
                            continue;
                        }
                        key = invField + "pk_hide";
                        this.tableHeadKeyList.add(key);
                    }
                    this.resMap.put(key, fieldInfo.getAlias());
                }
            } else {
                this.tableHeadKeyList.add(invField);
                tableAlias = "t" + i;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField + "pk_hide").append(" \r\n");
                    sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                    EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                    linkTable = entityObjInfo.getTable().getName();
                    sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                    String key = invField + "pk_hide";
                    this.tableHeadKeyList.add(key);
                    this.resMap.put(key, fieldInfo.getAlias());
                    this.createTempTableSQL.append(", ").append(invField + "pk_hide").append(" nvarchar(255)");
                    this.createTempTableSQL.append(", ").append(invField).append(" varchar(44)");
                    this.fieldSQL.append(" , ").append(invField + "pk_hide");
                    this.fieldSQL.append(" , ").append(invField);
                } else {
                    sqlSelect.append(", INVENTORY.").append(invField);
                    this.resMap.put(invField, fieldInfo.getAlias());
                    DataTypeEnum dataType = fieldInfo.getDataType();
                    if (DataTypeEnum.String.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" nvarchar(255)");
                    } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType) || DataTypeEnum.Enum.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" int");
                    } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" datetime");
                    } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                        this.createTempTableSQL.append(", ").append(invField).append(" Decimal(28,10) default 0");
                    }
                    this.fieldSQL.append(" , ").append(invField);
                }
            }
            if (invField.equals("FCustomerID") && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.billTypeId) || invField.equals("FSupplierID") && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.billTypeId)) {
                IObjectValue objVal = (IObjectValue)this.propMap.get(invField);
                if (objVal == null) continue;
                extendFilterSQL = this.getSupCustomerWhereSQL(invField, objVal.getString("id").toString());
                continue;
            }
            Object propValue = this.propMap.get(invField);
            String propStr = this.getPropStringValue(propValue);
            if (StringUtil.isEmpty((String)propStr)) continue;
            extendFilterSQL.append(" and inventory.").append(invField);
            if (propValue instanceof Date) {
                extendFilterSQL.append(" = to_date('").append(propStr).append("') ");
                continue;
            }
            extendFilterSQL.append(" = '").append(propStr).append("' ");
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FLockQty");
        this.tableHeadKeyList.remove("FLockBaseQty");
        this.tableHeadKeyList.remove("FLockAssistQty");
        this.resMap.put("boolFieldSet", this.boolPropSet);
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.tableHeadKeyList.add("FReservationAssistQty");
        this.tableHeadKeyList.remove("FEntrySeq");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationQty"));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationBaseQty"));
        this.resMap.put("FReservationAssistQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationAssistQty"));
        this.resMap.put("FCurStoreQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realQty"));
        this.resMap.put("FCurStoreAssistQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realAssistQty"));
        this.resMap.put("FBaseQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realBaseQty"));
        StringBuilder sql = new StringBuilder();
        if (!StringUtil.isEmpty((String)extendFilterSQL.toString())) {
            sqlWhere.append((CharSequence)extendFilterSQL);
        }
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere);
        return sql.toString();
    }

    @Override
    public String getCreateTempTableSQL() {
        return this.createTempTableSQL.toString() + ");";
    }

    @Override
    protected void initCreateTempTableSQL() {
        this.createTempTableSQL = new StringBuilder();
        this.createTempTableSQL.append(" create table temp_table(");
        this.createTempTableSQL.append(" id varchar(44),");
        this.createTempTableSQL.append(" FWarehouseID varchar(44),");
        this.createTempTableSQL.append(" WAREHOUSENUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FWarehouseIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FLocationID varchar(44),");
        this.createTempTableSQL.append(" LOCATIONNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FLocationIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStoreTypeID varchar(44),");
        this.createTempTableSQL.append(" STORETYPENUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStoreTypeIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FCurStoreQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FAssistUnitID varchar(44),");
        this.createTempTableSQL.append(" ASSISTUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FAssistUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FCurStoreAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FLOT nvarchar(80),");
        this.createTempTableSQL.append(" FCustomerID varchar(44),");
        this.createTempTableSQL.append(" FCustomerIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" CUSTOMERNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FSupplierID varchar(44),");
        this.createTempTableSQL.append(" SUPPLIERNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FSupplierIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FStorageOrgUnitID varchar(44),");
        this.createTempTableSQL.append(" STORAGEORGUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStorageOrgUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FAssistPropertyIDpk_hide nvarchar(2000),");
        this.createTempTableSQL.append(" FStoreStatusID varchar(44),");
        this.createTempTableSQL.append(" STORESTATUSNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FStoreStatusIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" FAssistPropertyID varchar(44),");
        this.createTempTableSQL.append(" ASSISTPROPERTYTYPE nvarchar(2000),");
        this.createTempTableSQL.append(" ASSISTPROPERTYNUMBER nvarchar(510),");
        this.createTempTableSQL.append(" FReservationBaseQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" FReservationAssistQty Decimal(28,10) not null default 0,");
        this.createTempTableSQL.append(" COMPANYORGUNITID varchar(44),");
        this.createTempTableSQL.append(" FProjectID varchar(44),");
        this.createTempTableSQL.append(" FProjectIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" FTrackNumberID varchar(44),");
        this.createTempTableSQL.append(" FTrackNumberIDpk_hide nvarchar(80),");
        this.createTempTableSQL.append(" MaterialModel nvarchar(255),");
        this.createTempTableSQL.append(" MaterialName nvarchar(255),");
        this.createTempTableSQL.append(" MaterialNumber nvarchar(80),");
        this.createTempTableSQL.append(" FMaterialID varchar(44),");
        this.createTempTableSQL.append(" FUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" UNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FUnitID varchar(44),");
        this.createTempTableSQL.append(" FBaseUnitIDpk_hide nvarchar(255),");
        this.createTempTableSQL.append(" BBASEUNITNUMBER nvarchar(80),");
        this.createTempTableSQL.append(" FBaseUnitID varchar(44),");
        this.createTempTableSQL.append(" MULTIUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MULTIBASEUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MULTIASSISTUNITQTYPRECISION int,");
        this.createTempTableSQL.append(" MFG datetime,");
        this.createTempTableSQL.append(" EXP datetime");
    }

    @Override
    public String getFieldSQL() {
        return this.fieldSQL.toString();
    }

    @Override
    protected void initFieldSQL() {
        this.fieldSQL = new StringBuilder();
        this.fieldSQL.append(" id, ");
        this.fieldSQL.append(" FWarehouseID, ");
        this.fieldSQL.append(" WAREHOUSENUMBER, ");
        this.fieldSQL.append(" FWarehouseIDpk_hide, ");
        this.fieldSQL.append(" FLocationID, ");
        this.fieldSQL.append(" LOCATIONNUMBER, ");
        this.fieldSQL.append(" FLocationIDpk_hide, ");
        this.fieldSQL.append(" FStoreTypeID, ");
        this.fieldSQL.append(" STORETYPENUMBER, ");
        this.fieldSQL.append(" FStoreTypeIDpk_hide, ");
        this.fieldSQL.append(" FCurStoreQty, ");
        this.fieldSQL.append(" FBaseQty, ");
        this.fieldSQL.append(" FAssistUnitID, ");
        this.fieldSQL.append(" ASSISTUNITNUMBER, ");
        this.fieldSQL.append(" FAssistUnitIDpk_hide, ");
        this.fieldSQL.append(" FCurStoreAssistQty, ");
        this.fieldSQL.append(" FLOT, ");
        this.fieldSQL.append(" FCustomerID, ");
        this.fieldSQL.append(" FCustomerIDpk_hide, ");
        this.fieldSQL.append(" CUSTOMERNUMBER, ");
        this.fieldSQL.append(" FSupplierID, ");
        this.fieldSQL.append(" SUPPLIERNUMBER, ");
        this.fieldSQL.append(" FSupplierIDpk_hide, ");
        this.fieldSQL.append(" FStorageOrgUnitID, ");
        this.fieldSQL.append(" STORAGEORGUNITNUMBER, ");
        this.fieldSQL.append(" FStorageOrgUnitIDpk_hide, ");
        this.fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        this.fieldSQL.append(" FStoreStatusID, ");
        this.fieldSQL.append(" STORESTATUSNUMBER, ");
        this.fieldSQL.append(" FStoreStatusIDpk_hide, ");
        this.fieldSQL.append(" FAssistPropertyID, ");
        this.fieldSQL.append(" ASSISTPROPERTYTYPE, ");
        this.fieldSQL.append(" ASSISTPROPERTYNUMBER, ");
        this.fieldSQL.append(" FReservationBaseQty, ");
        this.fieldSQL.append(" FReservationQty, ");
        this.fieldSQL.append(" FReservationAssistQty, ");
        this.fieldSQL.append(" COMPANYORGUNITID, ");
        this.fieldSQL.append(" FProjectID, ");
        this.fieldSQL.append(" FProjectIDpk_hide, ");
        this.fieldSQL.append(" FTrackNumberID, ");
        this.fieldSQL.append(" FTrackNumberIDpk_hide, ");
        this.fieldSQL.append(" MaterialModel, ");
        this.fieldSQL.append(" MaterialName, ");
        this.fieldSQL.append(" MaterialNumber, ");
        this.fieldSQL.append(" FMaterialID, ");
        this.fieldSQL.append(" FUnitIDpk_hide, ");
        this.fieldSQL.append(" UNITNUMBER, ");
        this.fieldSQL.append(" FUnitID, ");
        this.fieldSQL.append(" FBaseUnitIDpk_hide, ");
        this.fieldSQL.append(" BBASEUNITNUMBER, ");
        this.fieldSQL.append(" FBaseUnitID, ");
        this.fieldSQL.append(" MULTIUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIBASEUNITQTYPRECISION, ");
        this.fieldSQL.append(" MULTIASSISTUNITQTYPRECISION, ");
        this.fieldSQL.append(" MFG, ");
        this.fieldSQL.append(" EXP ");
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT INVENTORY.FID AS id, \r\n");
        sb.append(" CASE  WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END AS FWarehouseID,  \r\n");
        sb.append(" WAREHOUSE.FNumber AS WAREHOUSENUMBER,  \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseIDpk_hide,  \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE INVENTORY.FLocationID END AS FLocationID,  \r\n");
        sb.append(" LOCATION.FNumber AS LOCATIONNUMBER,  \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationIDpk_hide,  \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  \r\n");
        sb.append(" STORETYPE.FNumber AS STORETYPENUMBER,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeIDpk_hide,  \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreQty, 0) ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) ");
        sb.append(" AS FCurStoreQty,  \r\n");
        sb.append(" ISNULL(INVENTORY.FBaseQty, 0) - ISNULL(RESERVATION.FReservationBaseQty, 0) AS FBaseQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistUnitID = '").append("EgkAAAA5EWFbglxX").append("' THEN NULL ELSE INVENTORY.FAssistUnitID END AS FAssistUnitID,   \r\n");
        sb.append(" ASSISTUNIT.FNumber AS ASSISTUNITNUMBER,   \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitIDpk_hide,   \r\n");
        sb.append(" ISNULL(INVENTORY.FCurStoreAssistQty, 0) - ISNULL(RESERVATION.FReservationAssistQty, 0) AS FCurStoreAssistQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLot,  \r\n");
        sb.append(" CASE  WHEN INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE INVENTORY.FCustomerID END AS FCustomerID,   \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerIDpk_hide,  \r\n");
        sb.append(" CUSTOMER.FNumber AS CUSTOMERNUMBER,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE INVENTORY.FSupplierID END AS FSupplierID,   \r\n");
        sb.append(" SUPPLIER.FNumber AS SUPPLIERNUMBER,   \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS STORAGEORGNUMBER,  \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitIDpk_hide,  \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID,  \r\n");
        sb.append(" STORESTATUS.FNumber AS STORESTATUSNUMBER,   \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE INVENTORY.FAssistPropertyID END AS FAssistPropertyID,    \r\n");
        sb.append(" ASSISTPROPERTY.FType AS ASSISTPROPERTYTYPE,   \r\n");
        sb.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationBaseQty,0) AS FReservationBaseQty,    \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationQty, 0) AS FReservationQty,   \r\n");
        sb.append(" ISNULL(RESERVATION.FReservationAssistQty, 0) AS FReservationAssistQty,   \r\n");
        sb.append(" INVENTORY.FCompanyOrgUnitID AS COMPANYORGUNITID,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE INVENTORY.FProjectID END AS FProjectID,   \r\n");
        sb.append(" PROJECT.FNumber AS FProjectIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE INVENTORY.FTrackNumberID END AS FTrackNumberID,   \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberIDpk_hide,    \r\n");
        sb.append(" MATERIAL.FModel AS MaterialModel,   \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS MaterialName,    \r\n");
        sb.append(" MATERIAL.FNumber AS MaterialNumber,    \r\n");
        sb.append(" INVENTORY.FMaterialID AS FMaterialID,    \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitIDpk_hide,    \r\n");
        sb.append(" UNIT.FNumber AS UNITNUMBER,    \r\n");
        sb.append(" INVENTORY.FUnitID AS FUnitID,     \r\n");
        sb.append(" BBASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitIDpk_hide,     \r\n");
        sb.append(" BBASEUNIT.FNumber AS BBASEUNITNUMBER,    \r\n");
        sb.append(" INVENTORY.FBaseUnitID AS FBaseUnitID,     \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,    \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,     \r\n");
        sb.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,    \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS Mfg,     \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS Exp    \r\n");
        return sb;
    }

    @Override
    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" INNER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" INNER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" INNER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" INNER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" INNER JOIN T_BD_MeasureUnit AS BBASEUNIT ON INVENTORY.FBaseUnitID = BBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" INNER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON (INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID) \r\n");
        sb.append(" INNER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON (INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID) \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON (INVENTORY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID) \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    @Override
    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ((INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0)) <> 0) ");
        return sb;
    }

    private StringBuilder getSupCustomerWhereSQL(String invField, String objValueID) {
        StringBuilder sb = new StringBuilder();
        if (invField.equals("FCustomerID")) {
            sb.append(" AND ((STORETYPE.FStoreFlag = 3 OR STORETYPE.FStoreFlag = 4) AND ");
            sb.append(" INVENTORY.FCustomerID = '").append(objValueID).append("' ");
            sb.append(" OR (STORETYPE.FStoreFlag <> 3 AND STORETYPE.FStoreFlag <> 4)) ");
        } else if (invField.equals("FSupplierID")) {
            sb.append(" AND ((STORETYPE.FStoreFlag = 2 OR STORETYPE.FStoreFlag = 5) AND ");
            sb.append(" INVENTORY.FSupplierID = '").append(objValueID).append("' ");
            sb.append(" OR (STORETYPE.FStoreFlag <> 2 AND STORETYPE.FStoreFlag <> 5)) ");
        }
        return sb;
    }

    @Override
    protected StringBuilder getDefaultOrderBySQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ORDER BY WAREHOUSE.NUMBER ASC, LOCATION.NUMBER ASC, MATERIAL.NUMBER ASC");
        return sb;
    }
}

