/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.invconfig.client.InventoryHelper;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InventoryListHelper
extends InventoryHelper {
    protected List<String> headRowList = new ArrayList<String>();
    protected Map<String, String> headRowMap = new HashMap<String, String>();
    protected StringBuilder querySQL = new StringBuilder();
    protected IRowSet rowSet = null;
    protected FilterInfo filterInfo = null;

    public InventoryListHelper(FilterInfo filterInfo) throws Exception {
        this.filterInfo = filterInfo;
        this.initQuerySQL();
        this.rowSet = this.executeQuerySQL(this.querySQL.toString());
    }

    public void initQuerySQL() throws Exception {
        this.initDefaultProperty();
        BalanceFieldModelCollection balanceFieldModelCol = this.getBalanceFieldModelCollInOrder();
        String invField = null;
        String tableAlias = null;
        String linkTable = null;
        StringBuilder sqlSelect = this.getSelectSQL();
        StringBuilder sqlFrom = this.getFromSQL();
        BalanceFieldModelInfo fieldModeInfo = null;
        this.headRowList.clear();
        int size = balanceFieldModelCol.size();
        for (int i = 0; i < size; ++i) {
            fieldModeInfo = balanceFieldModelCol.get(i);
            invField = fieldModeInfo.getFieldName();
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.headRowList.add("FMaterialID");
                    this.headRowList.add("FMaterialName");
                    this.headRowList.add("FMaterialNumber");
                    this.headRowList.add("FMaterialModel");
                    this.headRowMap.put("FMaterialNumber", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialNumber"));
                    this.headRowMap.put("FMaterialName", fieldModeInfo.getAlias());
                    this.headRowMap.put("FMaterialModel", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"materialModel"));
                    continue;
                }
                if (invField.equalsIgnoreCase("FLot")) {
                    this.headRowList.add("FLot");
                    this.headRowList.add("FMfg");
                    this.headRowList.add("FExp");
                    this.headRowMap.put("FLot", fieldModeInfo.getAlias());
                    this.headRowMap.put("FMfg", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg"));
                    this.headRowMap.put("FExp", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp"));
                    continue;
                }
                String key = invField;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                    if (fieldModeInfo.getBaseDataBOSType() == null) {
                        this.headRowList.add("FID");
                        continue;
                    }
                    this.headRowList.add(key);
                    key = this.getDisplayKey(key);
                }
                this.headRowList.add(key);
                this.headRowMap.put(key, fieldModeInfo.getAlias());
                continue;
            }
            tableAlias = "t" + i;
            if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                String displayKey = this.getDisplayKey(invField);
                sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(displayKey).append(" \r\n");
                sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField).append(" \r\n");
                IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldModeInfo.getBaseDataBOSType()));
                EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                linkTable = entityObjInfo.getTable().getName();
                sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                this.headRowList.add(invField);
                this.headRowList.add(displayKey);
                this.headRowMap.put(displayKey, fieldModeInfo.getAlias());
                continue;
            }
            sqlSelect.append(", INVENTORY.").append(invField).append(" as ").append(invField);
            this.headRowList.add(invField);
            this.headRowMap.put(invField, fieldModeInfo.getAlias());
        }
        this.headRowList.remove("FAmount");
        this.headRowList.add("FCurStoreQtyPrecision");
        this.headRowList.add("FBaseQtyPrecision");
        this.headRowList.add("FCurStoreAssistQtyPrecision");
        this.headRowList.add("FBaseQtyConvsRate");
        this.headRowList.add("FCurStoreQtyConvsRate");
        StringBuilder sqlWhere = this.getExtendWhereSQL();
        this.querySQL.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom).append((CharSequence)sqlWhere).append((CharSequence)this.getDefaultOrderBySQL());
    }

    protected StringBuilder getSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT \r\n");
        sb.append(" INVENTORY.FID AS FID,  \r\n");
        sb.append(" COMPANYORGUNIT.FID AS FCompanyOrgUnitID, \r\n");
        sb.append(" COMPANYORGUNIT.FName_").append(this.loc).append(" AS FCompanyOrgUnitName, \r\n");
        sb.append(" INVENTORY.FMaterialID AS FMaterialID, \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS FMaterialName, \r\n");
        sb.append(" MATERIAL.FNumber AS FMaterialNumber, \r\n");
        sb.append(" MATERIAL.FModel AS FMaterialModel, \r\n");
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitName, \r\n");
        sb.append(" STORAGEORGUNIT.FNumber AS FStorageOrgUnitNumber,  \r\n");
        sb.append(" INVENTORY.FWarehouseID AS FWarehouseID, \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseName, \r\n");
        sb.append(" LOCATION.FID AS FLocationID, \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationName,  \r\n");
        sb.append(" ASSISTPROPERTY.FID AS FAssistPropertyID, \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyName, \r\n");
        sb.append(" CASE WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLOT, \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS FMfg,  \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS FExp,  \r\n");
        sb.append(" SUPPLIER.FID AS FSupplierID, \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierName,  \r\n");
        sb.append(" CUSTOMER.FID AS FCustomerID, \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerName,  \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusName,  \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeName, \r\n");
        sb.append(" PROJECT.FID AS FProjectID, \r\n");
        sb.append(" PROJECT.FNumber AS FProjectNumber,  \r\n");
        sb.append(" TRACKNUMBER.FID AS FTrackNumberID, \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberNumber,  \r\n");
        sb.append(" UNIT.FID AS FUnitID, \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitName, \r\n");
        sb.append(" BASEUNIT.FID AS FBaseUnitID, \r\n");
        sb.append(" BASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitName,  \r\n");
        sb.append(" ASSISTUNIT.FID AS FAssistUnitID, \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitName,  \r\n");
        sb.append(" INVENTORY.FBaseQty AS FBaseQty,  \r\n");
        sb.append(" INVENTORY.FCurStoreQty AS FCurStoreQty,  \r\n");
        sb.append(" INVENTORY.FCurStoreAssistQty AS FCurStoreAssistQty,  \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS FCurStoreQtyPrecision,  \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS FBaseQtyPrecision,  \r\n");
        sb.append(" MULTIASSITUNIT.FQtyPrecision AS FCurStoreAssistQtyPrecision,  \r\n");
        sb.append(" MULTIBASEUNIT.FBaseConvsRate AS FBaseQtyConvsRate,  \r\n");
        sb.append(" MULTIUNIT.FBaseConvsRate AS FCurStoreQtyConvsRate,  \r\n");
        sb.append(" INVENTORY.FLockQty AS FLockQty, \r\n");
        sb.append(" INVENTORY.FLockBaseQty AS FLockBaseQty,  \r\n");
        sb.append(" INVENTORY.FLockAssistQty AS FLockAssistQty, \r\n");
        sb.append(" INVENTORYUNIT.FName_").append(this.loc).append(" AS INVENTORYUNITNAME, \r\n");
        sb.append(" ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision) AS CURMATSTOREQTY, \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS32  \r\n");
        return sb;
    }

    protected StringBuilder getFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSITUNIT ON INVENTORY.FMaterialID = MULTIASSITUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSITUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON INVENTORY.FBaseUnitID = BASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialCost AS MATERIALCOST ON INVENTORY.FCompanyOrgUnitID = MATERIALCOST.FOrgUnit AND INVENTORY.FMaterialID = MATERIALCOST.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATERIALINVENTORY ON INVENTORY.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATERIALINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup AS MATERIALGROUP ON MATERIAL.FMaterialGroupID = MATERIALGROUP.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATERIALINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATERIALINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATERIALINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        return sb;
    }

    protected String getDisplayKey(String key) {
        if (StringUtil.isEmpty((String)key) || !key.endsWith("ID")) {
            return null;
        }
        StringBuilder displayKey = new StringBuilder();
        displayKey.append(key.substring(0, key.indexOf("ID")));
        if (key.equals("FProjectID") || key.equals("FTrackNumberID")) {
            displayKey.append("Number");
        } else {
            displayKey.append("Name");
        }
        return displayKey.toString();
    }

    protected StringBuilder getWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE ((INVENTORY.FBaseQty <> 0) OR (INVENTORY.FLockBaseQty <> 0) OR (INVENTORY.FCurStoreQty <> 0) OR (INVENTORY.FCurStoreAssistQty <> 0)) \r\n");
        return sb;
    }

    protected StringBuilder getExtendWhereSQL() {
        StringBuilder whereSQL = this.getWhereSQL();
        if (this.filterInfo == null) {
            return whereSQL;
        }
        FilterItemInfo itemInfo = null;
        String propertyName = null;
        int size = this.filterInfo.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            itemInfo = this.filterInfo.getFilterItems().get(i);
            propertyName = itemInfo.getPropertyName();
            if (StringUtil.isEmpty((String)propertyName) || propertyName.contains(".")) continue;
            itemInfo.setPropertyName("inventory." + propertyName);
        }
        String extendSQL = this.filterInfo.toSql();
        if (!StringUtil.isEmpty((String)extendSQL)) {
            whereSQL.append(" AND ").append(extendSQL);
        }
        return whereSQL;
    }

    protected IRowSet executeQuerySQL(String sql) throws BOSException {
        return new SQLExecutor(sql.toString()).executeSQL();
    }

    public List<String> getHeadRowList() {
        return this.headRowList;
    }

    public Map<String, String> getHeadRowMap() {
        return this.headRowMap;
    }

    public IRowSet getRowSet() {
        return this.rowSet;
    }
}

