/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.client.config.InventorySumConditionInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInvConfigFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.client.InventoryHelper;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InventorySumHelper
extends InventoryHelper {
    private static final String invColName = "inventorySum";
    private static final String invUnitColName = "unitInventorySum";
    private static final String invAssistUnitColName = "assistUnitInventorySum";
    private String entryIDColName = "id";
    InventorySumConditionInfo inventorySumConditionInfo = null;
    private Set<String> billIDs = null;
    private SelectorItemCollection selectors = null;
    private String tempTableName = null;
    private static final String inventoryAlias = "INVENTORY.";
    private static final String reservationAlias = "RESERVATION.";
    private boolean isBatch = false;
    private static final String permItem = "inventory";
    private Set<String> authorizedOrgIDSet = null;
    private Map<String, MaterialInventoryInfo> matInvMap = new HashMap<String, MaterialInventoryInfo>();
    private Map<String, Object> paramFlagCache = new HashMap<String, Object>();

    public InventorySumHelper(InventorySumConditionInfo inventorySumConditionInfo) {
        this.inventorySumConditionInfo = inventorySumConditionInfo;
    }

    public InventorySumHelper(KDTable table, String baseQtyColName, String entryName, Set<String> billIDs, SelectorItemCollection selectors) {
        this.inventorySumConditionInfo = new InventorySumConditionInfo();
        this.inventorySumConditionInfo.setBillEntryName(entryName);
        this.inventorySumConditionInfo.setTable(table);
        this.inventorySumConditionInfo.setQtyName(baseQtyColName);
        this.billIDs = billIDs;
        this.selectors = selectors;
        this.entryIDColName = entryName + ".id";
        this.isBatch = true;
    }

    public InventorySumHelper(InventorySumConditionInfo inventorySumConditionInfo, String entryName, SelectorItemCollection selectors) {
        this.inventorySumConditionInfo = inventorySumConditionInfo;
        this.billIDs = new HashSet(inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap().keySet());
        this.selectors = selectors;
        this.entryIDColName = entryName + ".id";
        this.isBatch = true;
    }

    private void addColumn() {
        IColumn col;
        KDTable table = this.inventorySumConditionInfo.getTable();
        if (table.getColumn(invColName) != null && table.getColumn(invUnitColName) != null) {
            this.clear();
        }
        int colIndex = -1;
        int colUnitIndex = -1;
        int colAssistUnitIndex = -1;
        if (table.getColumn(invUnitColName) == null) {
            colUnitIndex = table.getColumnIndex(this.inventorySumConditionInfo.getQtyName()) + 1;
            col = table.addColumn(colUnitIndex);
            col.setKey(invUnitColName);
            col.setWidth(100);
            col.getStyleAttributes().setLocked(true);
        }
        if (table.getColumn(invColName) == null) {
            colIndex = table.getColumnIndex(this.inventorySumConditionInfo.getQtyName()) + 2;
            col = table.addColumn(colIndex);
            col.setKey(invColName);
            col.setWidth(100);
            col.getStyleAttributes().setLocked(true);
        }
        if (table.getColumn(invAssistUnitColName) == null) {
            colAssistUnitIndex = table.getColumnIndex(this.inventorySumConditionInfo.getQtyName()) + 3;
            col = table.addColumn(colAssistUnitIndex);
            col.setKey(invAssistUnitColName);
            col.setWidth(100);
            col.getStyleAttributes().setLocked(true);
        }
        int count = this.inventorySumConditionInfo.getTable().getHeadRowCount();
        for (int i = 0; i < count; ++i) {
            if (colIndex != -1) {
                table.getHeadRow(i).getCell(colIndex).setValue((Object)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"inventorSum"));
            }
            if (colUnitIndex != -1) {
                table.getHeadRow(i).getCell(colUnitIndex).setValue((Object)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"unitInventorSum"));
            }
            if (colAssistUnitIndex == -1) continue;
            table.getHeadRow(i).getCell(colAssistUnitIndex).setValue((Object)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)invAssistUnitColName));
        }
    }

    public void doProcess() throws Exception {
        if (!this.dataCheck()) {
            return;
        }
        this.addColumn();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        this.authorizedOrgIDSet = PermissionUtil.getAuthorizedOrgIDSet(null, (IObjectPK)userPK, (String)permItem);
        if (this.isBatch) {
            this.batchSummaryByStep();
        } else {
            this.summaryByStep();
        }
        KDTable table = this.inventorySumConditionInfo.getTable();
        int colIndex = table.getColumnIndex(invUnitColName);
        int assistUnitColIndex = table.getColumnIndex(invAssistUnitColName);
        table.getEditManager().editCellAt(0, colIndex);
        KDTSelectBlock block = new KDTSelectBlock();
        block.setMode(4);
        block.setLeft(assistUnitColIndex);
        block.setRight(colIndex);
        table.getSelectManager().select(block);
    }

    private boolean dataCheck() {
        if (this.inventorySumConditionInfo == null) {
            return false;
        }
        if (!this.isBatch && (this.inventorySumConditionInfo.getObjValue() == null || StringUtil.isEmpty((String)this.inventorySumConditionInfo.getBillEntryName()))) {
            return false;
        }
        return this.inventorySumConditionInfo.getTable().getRowCount() > 0;
    }

    private void batchSummaryByStep() throws Exception {
        this.createTempTable();
        this.batchInsertData();
        this.calculateUnitQty();
        this.calculateAssistUnitQty();
        IRowSet rs = this.getSummaryData();
        this.batchLoadData(rs);
        this.dropTempTable();
    }

    private void calculateAssistUnitQty() throws EASBizException, BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("update " + this.tempTableName + " a set fTotalAssistQty = ").append("(").append(" select case WHEN temp1.fAssistUnitId IS NULL then round(fTotalAssistQty,0) else round(fTotalAssistQty,b.FQtyPrecision) end ").append(" from " + this.tempTableName + " temp1 left join T_BD_MultiMeasureUnit b ").append(" on temp1.fMateiralId = b.FMaterialID and temp1.fAssistUnitId = b.FMeasureUnitID  ").append(" where a.FEntryID=temp1.FEntryID ").append(")");
        String[] sqls = new String[]{buf.toString()};
        SQLDataAccessFacadeFactory.getRemoteInstance().executeBatch(sqls);
    }

    private void summaryByStep() throws Exception {
        BillInventoryConfigInfo configInfo = this.getConfigInfo();
        this.createTempTable();
        this.insertData(configInfo);
        this.calculateUnitQty();
        this.calculateAssistUnitQty();
        IRowSet rs = this.getSummaryData();
        this.loadData(rs);
        this.dropTempTable();
    }

    private void calculateUnitQty() throws EASBizException, BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("update " + this.tempTableName + " a set fTotalUnitQty = ").append("(").append(" select round(decimal(temp1.FTotalBaseQty/b.FBaseConvsRate,21,8),b.FQtyPrecision) ").append(" from " + this.tempTableName + " temp1 inner join T_BD_MultiMeasureUnit b ").append(" on temp1.fMateiralId = b.FMaterialID and temp1.fUnitId = b.FMeasureUnitID  ").append(" where a.FEntryID=temp1.FEntryID ").append(")");
        String[] sqls = new String[]{buf.toString()};
        SQLDataAccessFacadeFactory.getRemoteInstance().executeBatch(sqls);
    }

    private void loadData(IRowSet rs) throws SQLException, BaseException {
        int seq = 0;
        BigDecimal baseQty = null;
        BigDecimal qty = null;
        BigDecimal assistQty = null;
        KDTable table = this.inventorySumConditionInfo.getTable();
        DecimalFormat d1 = new DecimalFormat("#,##0.########");
        d1.setRoundingMode(RoundingMode.FLOOR);
        table.getEditManager().editCellAt(-1, -1);
        while (rs.next()) {
            seq = rs.getInt("fseq");
            baseQty = rs.getBigDecimal("FTotalBaseQty");
            if (baseQty != null) {
                table.getCell(seq, invColName).setValue((Object)d1.format(baseQty));
            }
            if ((qty = rs.getBigDecimal("fTotalUnitQty")) != null) {
                table.getCell(seq, invUnitColName).setValue((Object)d1.format(qty));
            }
            if ((assistQty = rs.getBigDecimal("fTotalAssistQty")) == null) continue;
            table.getCell(seq, invAssistUnitColName).setValue((Object)d1.format(assistQty));
        }
    }

    private void batchLoadData(IRowSet rs) throws SQLException {
        HashMap<String, BigDecimal> baseQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> unitQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> assistUnitQtyMap = new HashMap<String, BigDecimal>();
        String entryId = null;
        BigDecimal baseQty = null;
        BigDecimal qty = null;
        BigDecimal assistQty = null;
        while (rs.next()) {
            entryId = rs.getString("fentryid");
            baseQty = rs.getBigDecimal("FTotalBaseQty");
            baseQtyMap.put(entryId, baseQty);
            qty = rs.getBigDecimal("fTotalUnitQty");
            unitQtyMap.put(entryId, qty);
            assistQty = rs.getBigDecimal("fTotalAssistQty");
            assistUnitQtyMap.put(entryId, assistQty);
        }
        IRow row = null;
        DecimalFormat d1 = new DecimalFormat("#,##0.########");
        int count = this.inventorySumConditionInfo.getTable().getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.inventorySumConditionInfo.getTable().getRow(i);
            entryId = (String)row.getCell(this.entryIDColName).getValue();
            if (baseQtyMap.get(entryId) != null) {
                row.getCell(invColName).setValue((Object)d1.format(baseQtyMap.get(entryId)));
            }
            if (unitQtyMap.get(entryId) != null) {
                row.getCell(invUnitColName).setValue((Object)d1.format(unitQtyMap.get(entryId)));
            }
            if (assistUnitQtyMap.get(entryId) == null) continue;
            row.getCell(invAssistUnitColName).setValue((Object)d1.format(assistUnitQtyMap.get(entryId)));
        }
    }

    private IRowSet getSummaryData() throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder(100);
        sql.append("select fentryid, fseq, FTotalBaseQty,fTotalUnitQty,fTotalAssistQty  from ").append(this.tempTableName);
        return SQLDataAccessFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
    }

    private void insertData(BillInventoryConfigInfo configInfo) throws EASBizException, BOSException {
        IObjectValue srcObjectValue = this.inventorySumConditionInfo.getObjValue();
        IObjectValue srcParentObjectValue = this.inventorySumConditionInfo.getParentObjValue();
        String entryName = this.inventorySumConditionInfo.getBillEntryName();
        ArrayList valueList = BillInvConfigFacadeFactory.getRemoteInstance().evalBillInventoryConfigValue(configInfo, srcObjectValue, srcParentObjectValue, entryName, false, 0);
        Map billIdAndStorageIdMap = this.inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap();
        HashSet<String> materialIDSet = new HashSet<String>();
        HashSet<String> souIDSet = new HashSet<String>();
        for (int j = 0; j < valueList.size(); ++j) {
            if (((Map)valueList.get(j)).get("FMaterialID") != null) {
                materialIDSet.add(((MaterialInfo)((Map)valueList.get(j)).get("FMaterialID")).getId().toString());
            }
            if (billIdAndStorageIdMap != null || ((Map)valueList.get(j)).get("FStorageOrgUnitID") == null) continue;
            souIDSet.add(((StorageOrgUnitInfo)((Map)valueList.get(j)).get("FStorageOrgUnitID")).getId().toString());
        }
        if (billIdAndStorageIdMap != null) {
            souIDSet.addAll(billIdAndStorageIdMap.values());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", souIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            this.matInvMap.put(coll.get(i).getMaterial().getId().toString() + coll.get(i).getOrgUnit().getId().toString(), coll.get(i));
        }
        ArrayList<String> sqlList = this.getInsertSQL(configInfo, valueList);
        if (CollectionUtil.isEmpty(sqlList)) {
            return;
        }
        SQLDataAccessFacadeFactory.getRemoteInstance().executeBatch(sqlList.toArray(new String[0]));
    }

    private void batchInsertData() throws Exception {
        int i;
        String billId;
        String entryName;
        CoreBaseCollection billInfoColl = BalanceCfgUtil.getBillInfoColl(this.billIDs, this.selectors);
        Map<String, BillInventoryConfigInfo> configInfoMap = BalanceCfgUtil.getConfigInfoMap(null, billInfoColl, entryName = this.inventorySumConditionInfo.getBillEntryName());
        if (configInfoMap == null || configInfoMap.size() == 0) {
            return;
        }
        Map entryPropMap = BillInvConfigFacadeFactory.getRemoteInstance().evalBillInventoryConfigValue((IObjectCollection)billInfoColl, entryName, false, 0, configInfoMap);
        ArrayList<String> billSQLs = new ArrayList<String>();
        ArrayList valueList = null;
        BillInventoryConfigInfo configInfo = null;
        CoreBaseInfo objValue = null;
        HashSet<String> materialIDSet = new HashSet<String>();
        HashSet<String> souIDSet = new HashSet<String>();
        Map billIdAndStorageOrgUnitIdMap = this.inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap();
        int size = billInfoColl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            objValue = billInfoColl.get(i2);
            billId = objValue.get("id").toString();
            valueList = (ArrayList)entryPropMap.get(billId);
            for (int j = 0; j < valueList.size(); ++j) {
                if (((Map)valueList.get(j)).get("FMaterialID") != null) {
                    materialIDSet.add(((MaterialInfo)((Map)valueList.get(j)).get("FMaterialID")).getId().toString());
                }
                if (billIdAndStorageOrgUnitIdMap != null || ((Map)valueList.get(j)).get("FStorageOrgUnitID") == null) continue;
                souIDSet.add(((StorageOrgUnitInfo)((Map)valueList.get(j)).get("FStorageOrgUnitID")).getId().toString());
            }
        }
        if (billIdAndStorageOrgUnitIdMap != null) {
            souIDSet.addAll(billIdAndStorageOrgUnitIdMap.values());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", souIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        MaterialInventoryCollection coll = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        for (i = 0; i < coll.size(); ++i) {
            this.matInvMap.put(coll.get(i).getMaterial().getId().toString() + coll.get(i).getOrgUnit().getId().toString(), coll.get(i));
        }
        int size2 = billInfoColl.size();
        for (i = 0; i < size2; ++i) {
            objValue = billInfoColl.get(i);
            this.inventorySumConditionInfo.setObjValue((IObjectValue)objValue);
            this.inventorySumConditionInfo.setParentObjValue((IObjectValue)objValue);
            billId = objValue.get("id").toString();
            valueList = (ArrayList)entryPropMap.get(billId);
            configInfo = configInfoMap.get(billId);
            ArrayList<String> sqls = this.getInsertSQL(configInfo, valueList);
            billSQLs.addAll(sqls);
        }
        SQLDataAccessFacadeFactory.getRemoteInstance().executeBatch(billSQLs.toArray(new String[0]));
    }

    private ArrayList<String> getInsertSQL(BillInventoryConfigInfo configInfo, ArrayList<Map<String, Object>> valueList) throws EASBizException, BOSException {
        IObjectValue billInfo = this.inventorySumConditionInfo.getParentObjValue();
        AbstractObjectCollection billEntryColl = (AbstractObjectCollection)billInfo.get(this.inventorySumConditionInfo.getBillEntryName());
        String sql = null;
        ArrayList<String> sqls = new ArrayList<String>();
        Map<String, Object> billPropMap = valueList.get(valueList.size() - 1);
        Map<String, Object> entryPropMap = null;
        IObjectValue billEntryInfo = null;
        String billId = billInfo.get("id") != null ? billInfo.get("id").toString() : null;
        String billEntryID = "";
        int size = billEntryColl.size();
        for (int i = 0; i < size; ++i) {
            billEntryInfo = billEntryColl.getObject(i);
            entryPropMap = valueList.get(i);
            if (entryPropMap.get("FMaterialID") == null || entryPropMap.get("FUnitID") == null || !this.isAuthorized(billPropMap, entryPropMap, billId) || StringUtil.isEmpty((String)(sql = this.getInsertSQL(configInfo, billId, billEntryID = billEntryInfo.get("id") != null ? billEntryInfo.get("id").toString() : BOSUuid.create((String)"ABF2CCE2").toString(), i, billPropMap, entryPropMap)))) continue;
            sqls.add(sql);
        }
        return sqls;
    }

    private String getInsertSQL(BillInventoryConfigInfo configInfo, String billId, String billEntryID, int seq, Map<String, Object> billPropMap, Map<String, Object> entryPropMap) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into ").append(this.tempTableName).append(" (FEntryID, FSeq, FTotalBaseQty, fMateiralId, fUnitId,fTotalAssistQty,fAssistUnitId) ");
        sql.append(" select '").append(billEntryID).append("', ").append(seq);
        sql.append(" , sum( ").append(inventoryAlias).append("fbaseqty ").append(" - ").append(" isnull(").append(reservationAlias).append("FReservationBaseQty, 0)), ").append(" '" + ((MaterialInfo)entryPropMap.get("FMaterialID")).getId().toString() + "', ").append("'" + ((MeasureUnitInfo)entryPropMap.get("FUnitID")).getId().toString() + "',").append(" sum( ").append(inventoryAlias).append("FCurStoreAssistQty ").append(" - ").append(" isnull(").append(reservationAlias).append("FReservationAssistQty, 0)), ");
        if ((MeasureUnitInfo)entryPropMap.get("FAssistUnitID") != null) {
            sql.append("'" + ((MeasureUnitInfo)entryPropMap.get("FAssistUnitID")).getId().toString() + "'");
        } else {
            sql.append(" null ");
        }
        sql.append(" from t_im_inventory inventory ");
        sql.append((CharSequence)this.getReservationSQL());
        BillInventoryConfigEntryCollection configEntryCol = configInfo.getEntry();
        BillInventoryConfigEntryInfo configEntryInfo = null;
        StoreTypeInfo storeTypeInfo = (StoreTypeInfo)entryPropMap.get("FStoreTypeID");
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)billPropMap.get("FStorageOrgUnitID");
        MaterialInfo materialInfo = (MaterialInfo)entryPropMap.get("FMaterialID");
        boolean isSupplierFilter = this.isSupplierFilter(storeTypeInfo);
        boolean isCustomerFilter = this.isCustomerFilter(storeTypeInfo);
        boolean isTrackNumberFilter = false;
        boolean isProjectNumberFilter = false;
        boolean isAllPropNULL = true;
        StringBuilder whereSQL = new StringBuilder(" where ");
        StringBuilder groupbySQL = new StringBuilder(" group by ");
        String invField = null;
        Object compareValue = null;
        String paramFlag = this.getIsBaseUnitUpdateParamFlag(configEntryCol, entryPropMap, billPropMap);
        int size = configEntryCol.size();
        for (int i = 0; i < size; ++i) {
            configEntryInfo = configEntryCol.get(i);
            if (!configEntryInfo.isIsMatQueryFilter() || "FSupplierID".equals(invField = configEntryInfo.getInvField()) && !isSupplierFilter || "FCustomerID".equals(invField) && !isCustomerFilter || "FTrackNumberID".equals(invField) && !isTrackNumberFilter || "FProjectID".equals(invField) && !isProjectNumberFilter) continue;
            Object propValue = entryPropMap.get(invField);
            if (propValue == null) {
                propValue = billPropMap.get(invField);
            }
            if ("true".equalsIgnoreCase(paramFlag) && ("FUnitID".equals(invField) || "FBaseUnitID".equals(invField)) || (compareValue = this.getCompareValue(propValue)) == null) continue;
            if ("FStorageOrgUnitID".equals(invField)) {
                isTrackNumberFilter = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FTrackNumber", compareValue);
                isProjectNumberFilter = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FProjectNumber", compareValue);
                if (this.inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap() != null) {
                    compareValue = this.inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap().get(billId);
                }
            }
            isAllPropNULL = false;
            if (propValue instanceof Date) {
                whereSQL.append(inventoryAlias).append(invField).append("= to_date('").append(compareValue).append("') and ");
            } else {
                whereSQL.append(inventoryAlias).append(invField).append("='").append(compareValue).append("' and ");
            }
            groupbySQL.append(invField).append(",");
        }
        if (isAllPropNULL) {
            return null;
        }
        whereSQL.setLength(whereSQL.length() - 4);
        groupbySQL.setLength(groupbySQL.length() - 1);
        sql.append((CharSequence)whereSQL).append((CharSequence)groupbySQL);
        return sql.toString();
    }

    private String getIsBaseUnitUpdateParamFlag(BillInventoryConfigEntryCollection configEntryCol, Map<String, Object> entryPropMap, Map<String, Object> billPropMap) throws BOSException, EASBizException {
        String paramFlag = "false";
        int size = configEntryCol.size();
        for (int i = 0; i < size; ++i) {
            String key;
            Object paramFlagObject;
            BillInventoryConfigEntryInfo configEntryInfo = configEntryCol.get(i);
            String invField = configEntryInfo.getInvField();
            if (!"FStorageOrgUnitID".equals(invField)) continue;
            Object propValue = entryPropMap.get(invField);
            if (propValue == null) {
                propValue = billPropMap.get(invField);
            }
            if ((paramFlagObject = this.paramFlagCache.get(key = ((StorageOrgUnitInfo)propValue).getId().toString())) != null) {
                paramFlag = String.valueOf(paramFlagObject);
                break;
            }
            paramFlag = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(key), "INM004");
            this.paramFlagCache.put(key, paramFlag);
            break;
        }
        return paramFlag;
    }

    private boolean isCustomerFilter(StoreTypeInfo storeTypeInfo) {
        if (storeTypeInfo == null) {
            return false;
        }
        return StoreFlagEnum.CUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeTypeInfo.getStoreFlag());
    }

    private boolean isSupplierFilter(StoreTypeInfo storeTypeInfo) {
        if (storeTypeInfo == null) {
            return false;
        }
        return StoreFlagEnum.SUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeTypeInfo.getStoreFlag());
    }

    private boolean isTrackNumberOrProjectNumberFilter(MaterialInfo materialInfo, String trOrPr, Object compareValue) throws EASBizException, BOSException {
        if (materialInfo == null) {
            return false;
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getRemoteInstance();
        MaterialInventoryInfo inventoryInfo = null;
        inventoryInfo = this.matInvMap.get(materialInfo.getId().toString() + compareValue);
        if (trOrPr.equals("FTrackNumber")) {
            return inventoryInfo == null ? false : inventoryInfo.isIsTrackingNumber();
        }
        if (trOrPr.equals("FProjectNumber")) {
            return inventoryInfo == null ? false : inventoryInfo.isIsProjectNumber();
        }
        return false;
    }

    private void createTempTable() throws EASBizException, BOSException {
        StringBuilder createTempTableSQL = new StringBuilder();
        createTempTableSQL.append(" create table temp_table(");
        createTempTableSQL.append(" fentryid varchar(44), ");
        createTempTableSQL.append(" fseq int,");
        createTempTableSQL.append(" fMateiralId varchar(44),");
        createTempTableSQL.append(" fUnitId varchar(44),");
        createTempTableSQL.append(" fAssistUnitId varchar(44),");
        createTempTableSQL.append(" fTotalUnitQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" fTotalAssistQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FTotalBaseQty Decimal(28,10) not null default 0);");
        this.tempTableName = SQLDataAccessFacadeFactory.getRemoteInstance().createTempTable(createTempTableSQL.toString(), null, null, null);
    }

    private void dropTempTable() throws EASBizException, BOSException {
        SQLDataAccessFacadeFactory.getRemoteInstance().dropTable(this.tempTableName);
    }

    private BillInventoryConfigInfo getConfigInfo() throws BOSException {
        AbstractObjectCollection objColl;
        String billEntryBosType;
        IObjectValue srcParentObj = this.inventorySumConditionInfo.getParentObjValue();
        String billBosType = this.inventorySumConditionInfo.getObjValue().getBOSType().toString();
        BillInventoryConfigInfo configInfo = BalanceCfgUtil.getConfigInfo(null, billBosType, billEntryBosType = (objColl = (AbstractObjectCollection)srcParentObj.get(this.inventorySumConditionInfo.getBillEntryName())).getObject(0).getBOSType().toString(), this.inventorySumConditionInfo.getObjValue());
        if (configInfo == null) {
            String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"configInfoInvalid");
            MsgBox.showConfirm2((String)msg);
            SysUtil.abort();
        }
        return configInfo;
    }

    private Object getCompareValue(Object propValue) {
        if (propValue == null) {
            return null;
        }
        String compareValue = null;
        compareValue = propValue instanceof IObjectValue ? ((IObjectValue)propValue).get("id").toString() : (propValue instanceof Boolean ? ((Boolean)propValue != false ? "1" : "0") : (propValue instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)propValue)) : StringUtils.replace((String)propValue.toString(), (String)"'", (String)"''")));
        return compareValue;
    }

    private boolean isAuthorized(Map<String, Object> billPropMap, Map<String, Object> entryPropMap, String billId) {
        Map billAndStorageOrgUnitMap;
        String storageOrgUnitId = null;
        IObjectValue storeOrgUnit = (IObjectValue)entryPropMap.get("FStorageOrgUnitID");
        if (storeOrgUnit == null) {
            storeOrgUnit = (IObjectValue)billPropMap.get("FStorageOrgUnitID");
        }
        if (storeOrgUnit != null) {
            storageOrgUnitId = storeOrgUnit.get("id").toString();
        }
        if ((billAndStorageOrgUnitMap = this.inventorySumConditionInfo.getBillIdAndStorageOrgUnitIdMap()) != null) {
            storageOrgUnitId = (String)billAndStorageOrgUnitMap.get(billId);
        }
        if (StringUtil.isEmpty((String)storageOrgUnitId)) {
            return false;
        }
        return this.authorizedOrgIDSet.contains(storageOrgUnitId);
    }

    private void clear() {
        KDTable table = this.inventorySumConditionInfo.getTable();
        table.removeColumn(table.getColumnIndex(invColName));
        table.removeColumn(table.getColumnIndex(invUnitColName));
    }
}

