/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class CompareValueUtil {
    public static int compareValue(Object value, Object compareValue) {
        if (value instanceof Boolean || compareValue instanceof Boolean) {
            Boolean bool1 = value == null ? Boolean.FALSE : (Boolean)value;
            Boolean bool2 = compareValue == null ? Boolean.FALSE : (Boolean)compareValue;
            return bool1.compareTo(bool2);
        }
        if (value instanceof Integer) {
            return ((Integer)value).compareTo((Integer)compareValue);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo((BigDecimal)compareValue);
        }
        if (value instanceof String) {
            return ((String)value).compareTo((String)compareValue);
        }
        if (value instanceof Date || value instanceof Timestamp) {
            if (DateTimeUtils.dayEquals((Date)((Date)value), (Date)((Date)compareValue))) {
                return 0;
            }
            if (DateTimeUtils.dayBefore((Date)((Date)value), (Date)((Date)compareValue))) {
                return 1;
            }
            return 0;
        }
        if (value instanceof Time) {
            return ((Time)value).compareTo((Time)compareValue);
        }
        if (value instanceof Enum) {
            return ((Enum)value).compareTo((Enum)compareValue);
        }
        return -2;
    }

    public static boolean isLike(Object value, Object compareValue) {
        String comValueStr;
        if (!(value instanceof String)) {
            return false;
        }
        String valueStr = (String)value;
        if (valueStr.startsWith("%")) {
            valueStr = valueStr.substring(1);
        }
        if (valueStr.endsWith("%")) {
            valueStr = valueStr.substring(0, valueStr.length() - 1);
        }
        return (comValueStr = (String)compareValue).indexOf(valueStr) != -1;
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    public static boolean isMatch(CompareType compareType, Object value, IObjectValue billInfo, String property) {
        Object propertyValue = CompareValueUtil.getValueByProperty(billInfo, property);
        if (CompareValueUtil.isEmptyObject(value) && CompareValueUtil.isEmptyObject(propertyValue)) {
            return true;
        }
        if (CompareValueUtil.isEmptyObject(value) || CompareValueUtil.isEmptyObject(propertyValue)) {
            if (compareType.equals((Object)CompareType.EMPTY) || compareType.equals((Object)CompareType.IS)) {
                return CompareValueUtil.isEmptyObject(propertyValue);
            }
            if (compareType.equals((Object)CompareType.NOTEMPTY) || compareType.equals((Object)CompareType.ISNOT)) {
                return !CompareValueUtil.isEmptyObject(propertyValue);
            }
            return false;
        }
        if (compareType.equals((Object)CompareType.EQUALS)) {
            return CompareValueUtil.compareValue(propertyValue, value) == 0;
        }
        if (compareType.equals((Object)CompareType.GREATER)) {
            return CompareValueUtil.compareValue(propertyValue, value) > 0;
        }
        if (compareType.equals((Object)CompareType.LESS)) {
            return CompareValueUtil.compareValue(propertyValue, value) < 0;
        }
        if (compareType.equals((Object)CompareType.GREATER_EQUALS)) {
            return CompareValueUtil.compareValue(propertyValue, value) >= 0;
        }
        if (compareType.equals((Object)CompareType.LESS_EQUALS)) {
            return CompareValueUtil.compareValue(propertyValue, value) <= 0;
        }
        if (compareType.equals((Object)CompareType.NOTEQUALS)) {
            return CompareValueUtil.compareValue(propertyValue, value) != 0;
        }
        if (compareType.equals((Object)CompareType.LIKE)) {
            return CompareValueUtil.isLike(propertyValue, value);
        }
        if (compareType.equals((Object)CompareType.NOTLIKE)) {
            return !CompareValueUtil.isLike(propertyValue, value);
        }
        return false;
    }

    public static boolean isMatch(FilterInfo filter, IObjectValue billInfo) throws BOSException, ParserException {
        if (filter == null || StringUtil.isEmpty((String)filter.toSql())) {
            return true;
        }
        String sql = filter.toSql();
        SqlExpr sqlExpr = ViewParseUtils.parseFilterExpr((String)sql);
        if (sqlExpr != null) {
            return CompareValueUtil.isMatch(sqlExpr, billInfo);
        }
        return true;
    }

    private static boolean isMatch(SqlExpr sqlExpr, IObjectValue billInfo) throws ParserException {
        if (sqlExpr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)sqlExpr;
            switch (binaryOpExpr.operator) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 23: 
                case 40: 
                case 41: {
                    FilterItemInfo filterItemInfo = new FilterItemInfo(binaryOpExpr.toString());
                    return CompareValueUtil.isMatch(filterItemInfo.getCompareType(), filterItemInfo.getCompareValue(), billInfo, filterItemInfo.getPropertyName());
                }
                case 8: {
                    return CompareValueUtil.isMatch(binaryOpExpr.left, billInfo) || CompareValueUtil.isMatch(binaryOpExpr.right, billInfo);
                }
                case 7: {
                    return CompareValueUtil.isMatch(binaryOpExpr.left, billInfo) && CompareValueUtil.isMatch(binaryOpExpr.right, billInfo);
                }
            }
            throw new ParserException("Illegal Format of FilterInfo : " + sqlExpr.toString());
        }
        return false;
    }

    private static Object getValueByProperty(IObjectValue billInfo, String property) {
        if (StringUtil.isEmpty((String)property)) {
            return null;
        }
        String[] str = property.split("\\.");
        IObjectValue objValue = billInfo;
        String key = str[0];
        int len = str.length - 1;
        for (int i = 0; i < len; ++i) {
            if ((objValue = objValue.getObjectValue(str[i])) == null) {
                return null;
            }
            key = str[i + 1];
        }
        return objValue.get(key);
    }
}

