/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.sms;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.scm.im.inv.sms.SupportInvMobileFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class InvMobileSupport
extends AbstractBaseBizFunction {
    private static String RES = "com.kingdee.eas.scm.im.sms.SupportINVMobileResource";
    private static String PERM_NUM = "inventory";
    private Context ctx;
    private BizFuncParamObj msg;
    private IObjectPK userId;
    private StorageOrgUnitInfo storageInfo;

    public BizReturnObj executeSendAction(BizFuncParamObj paramObj) {
        this.msg = paramObj;
        BizReturnObj bizReturnObj = this.check();
        if (bizReturnObj != null) {
            return bizReturnObj;
        }
        String retMsg = null;
        try {
            retMsg = SupportInvMobileFacadeFactory.getLocalInstance(this.ctx).getInvMobileSupport(this.msg.getCommandParams()[0], this.msg.getCommandParams()[1], this.msg.getCommandParams()[2]);
        }
        catch (Exception e) {
            bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"91_InvMobileSupport"));
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(false);
            return bizReturnObj;
        }
        if (retMsg == null || retMsg.length() < 1) {
            bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"92_InvMobileSupport"));
            bizReturnObj.setSucceed(true);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText("");
        bizReturnObj.setReturnText(retMsg);
        bizReturnObj.setSucceed(true);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    private BizReturnObj check() {
        this.ctx = this.msg.getCtx();
        this.userId = new ObjectUuidPK(this.msg.getUserID());
        String materialNum = this.msg.getCommandParams()[0];
        String storageNum = this.msg.getCommandParams()[1];
        String warehouseNum = this.msg.getCommandParams()[2];
        if (materialNum == null || materialNum.length() < 1 || storageNum == null || storageNum.length() < 1 || warehouseNum == null || warehouseNum.length() < 1) {
            StringBuffer errBuf = new StringBuffer();
            if (materialNum == null || materialNum.length() < 1) {
                errBuf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"93_InvMobileSupport"));
            }
            if (storageNum == null || storageNum.length() < 1) {
                errBuf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"94_InvMobileSupport"));
            }
            if (warehouseNum == null || warehouseNum.length() < 1) {
                errBuf.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"95_InvMobileSupport"));
            }
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(errBuf.toString());
            bizReturnObj.setSucceed(true);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        try {
            this.storageInfo = this.getStorageOrgInfo(this.ctx, storageNum);
        }
        catch (BOSException e) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"96_InvMobileSupport"));
            bizReturnObj.setSucceed(true);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        boolean ret = false;
        try {
            ret = this.hasPermission();
        }
        catch (Exception e) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"97_InvMobileSupport"));
            bizReturnObj.setSucceed(true);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        if (!ret) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText("");
            bizReturnObj.setReturnText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"98_InvMobileSupport"));
            bizReturnObj.setSucceed(true);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        return null;
    }

    private StorageOrgUnitInfo getStorageOrgInfo(Context ctx, String sotageOrgNum) throws BOSException {
        StorageOrgUnitInfo org = null;
        IStorageOrgUnit ie = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)sotageOrgNum));
        view.setFilter(filter);
        CoreBaseCollection bc = ie.getCollection(view);
        if (bc.size() == 1) {
            org = (StorageOrgUnitInfo)bc.get(0);
        }
        return org;
    }

    private String getResource(String key) {
        return ResourceBase.getString((String)RES, (String)key, (Locale)this.ctx.getLocale());
    }

    protected boolean hasPermission() throws BOSException, EASBizException {
        boolean flag = true;
        flag = PermissionFactory.getLocalInstance((Context)this.ctx).hasFunctionPermission(this.userId, (IObjectPK)new ObjectUuidPK(this.storageInfo.getId()), PERM_NUM);
        return flag;
    }
}

