/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractBatchEditPriceUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleClientUtils;
import com.kingdee.eas.scm.im.inv.vmi.info.BatchEditPriceInfo;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.obj.ObjectUtils;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchEditPriceUI
extends AbstractBatchEditPriceUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(BatchEditPriceUI.class);
    private boolean isEditPrice = false;
    private CompanyOrgUnitInfo cou;
    private int defaultPrecision = 8;
    private BatchEditPriceInfo priceInfo = null;

    public boolean isEditPrice() {
        return this.isEditPrice;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    private void beforeLoad() {
        this.cou = (CompanyOrgUnitInfo)this.getUIContext().get("cou");
    }

    private void afterLoad() {
        this.bizPromptCompanyOrgUnit.setValue((Object)this.cou);
        try {
            this.setControl();
            this.loadFields();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setControl() throws EASBizException, BOSException {
        this.txtSettlePrice.setMinimumValue((Comparable)new BigDecimal("0.00000001"));
        this.txtSettlePrice.setPrecision(this.defaultPrecision);
        this.txtSettlePrice.setNegatived(false);
        this.txtSettlePrice.setDataType(1);
        this.txtSettlePrice.setRemoveingZeroInDispaly(false);
        this.txtSettlePrice.setHorizontalAlignment(4);
        this.bizPromptCompanyOrgUnit.setEnabled(false);
        this.bizPromptCompanyOrgUnit.setEditable(false);
        this.setFilter();
        this.setDefaultValue();
    }

    private void setFilter() throws EASBizException, BOSException {
        Set souIDs;
        Set idSet = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizPromptCompanyOrgUnit);
        if (idSet != null && idSet.size() > 0 && (souIDs = VMISettleClientUtils.getStorageOrgUnitInfos(idSet)) != null && souIDs.size() > 0) {
            this.setStorageOrgUnitFilter(this.bizStorageOrgUnit, souIDs);
            this.setMaterialFilter(this.bizMaterialFrom, souIDs);
            this.setMaterialFilter(this.bizMaterialTo, souIDs);
            IMRptUtils.setRptWarehouseFilter(souIDs.toArray(), this.bizWarehouseFrom);
            this.bizWarehouseFrom.setDisplayFormat("$name$");
            this.bizWarehouseFrom.setEditFormat("$number$");
            this.bizWarehouseFrom.setCommitFormat("$number$");
            IMRptUtils.setRptWarehouseFilter(souIDs.toArray(), this.bizWarehouseTo);
            this.bizWarehouseTo.setDisplayFormat("$name$");
            this.bizWarehouseTo.setEditFormat("$number$");
            this.bizWarehouseTo.setCommitFormat("$number$");
        }
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
    }

    private void setDefaultValue() {
    }

    private KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptCompanyOrgUnit;
    }

    private void setStorageOrgUnitFilter(KDBizPromptBox box, Set storageIDs) {
        if (storageIDs.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)storageIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            box.setEntityViewInfo(viewInfo);
        }
    }

    private void setMaterialFilter(KDBizPromptBox box, Set storageIDs) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageIDs, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)box, "com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI", (Object)this, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id", QueryInfoConstants.getMaterialQueryOrgId((OrgType)this.getMainBizOrgType()));
        box.setCommitParser((IParser)new MainDataParser(box));
        box.setSelector((KDPromptSelector)selectorLisenterMaterial);
        box.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        box.setCommitFormat("$number$");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery");
        box.setEntityViewInfo(view);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.addEventLisener();
    }

    private void addEventLisener() {
        this.bizStorageOrgUnit.addDataChangeListener((DataChangeListener)this);
        this.bizMaterialFrom.addDataChangeListener((DataChangeListener)this);
        this.bizMaterialTo.addDataChangeListener((DataChangeListener)this);
    }

    private void removeEventLisener() {
        this.bizStorageOrgUnit.removeDataChangeListener((DataChangeListener)this);
        this.bizMaterialFrom.removeDataChangeListener((DataChangeListener)this);
        this.bizMaterialTo.removeDataChangeListener((DataChangeListener)this);
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && ObjectUtils.isEquals((Object)e.getNewValue(), (Object)e.getOldValue())) {
            return;
        }
        if (e.getSource().equals(this.bizStorageOrgUnit)) {
            try {
                this.bizStorageOrgUnit_dataChanged(e);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        if (e.getSource().equals(this.bizMaterialFrom)) {
            this.bizMaterial_dataChanged(e);
        }
        if (e.getSource().equals(this.bizMaterialTo)) {
            this.bizMaterial_dataChanged(e);
        }
    }

    private void bizStorageOrgUnit_dataChanged(DataChangeEvent e) {
        Set souIDs = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizStorageOrgUnit);
        if (souIDs != null && souIDs.size() > 0) {
            this.setMaterialFilter(this.bizMaterialFrom, souIDs);
            this.setMaterialFilter(this.bizMaterialTo, souIDs);
            IMRptUtils.setRptWarehouseFilter(souIDs.toArray(), this.bizWarehouseFrom);
            IMRptUtils.setRptWarehouseFilter(souIDs.toArray(), this.bizWarehouseTo);
        }
    }

    private void bizMaterial_dataChanged(DataChangeEvent e) {
        int precision = this.defaultPrecision;
        MaterialInfo materialFrom = (MaterialInfo)this.bizMaterialFrom.getValue();
        MaterialInfo materialTo = (MaterialInfo)this.bizMaterialTo.getValue();
        if (materialFrom != null || materialTo != null) {
            if (materialFrom == null) {
                precision = materialTo.getPricePrecision();
            } else if (materialTo == null) {
                precision = materialFrom.getPricePrecision();
            } else if (materialFrom.getId().toString().equals(materialTo.getId().toString())) {
                precision = materialFrom.getPricePrecision();
            }
        }
        String minimumValue = "0.";
        for (int i = 1; i < precision; ++i) {
            minimumValue = minimumValue + "0";
        }
        minimumValue = minimumValue + "1";
        this.txtSettlePrice.setMinimumValue((Comparable)new BigDecimal(minimumValue));
        this.txtSettlePrice.setPrecision(precision);
    }

    protected String getViewPermission() {
        return "vmisettle_batcheditprice";
    }

    private boolean verify() {
        if (this.bizMaterialFrom.getValue() == null && this.bizMaterialTo.getValue() == null) {
            this.bizMaterialFrom.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("MaterialIsNotNull"));
            return false;
        }
        if (this.txtSettlePrice.getText() == null || StringUtil.isEmpty((String)this.txtSettlePrice.getText())) {
            this.txtSettlePrice.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("SettlePriceIsNotNull"));
            return false;
        }
        return true;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            this.isEditPrice = false;
            return;
        }
        this.isEditPrice = true;
        this.setPriceInfo();
        this.getUIWindow().hide();
    }

    private void setPriceInfo() {
        Set souIDs = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizStorageOrgUnit);
        String[] souIds = null;
        if (souIDs != null && souIDs.size() > 0) {
            souIds = new String[souIDs.size()];
            souIDs.toArray(souIds);
        }
        this.priceInfo = new BatchEditPriceInfo();
        this.priceInfo.setCompanyOrgUnit(this.cou.getId().toString());
        this.priceInfo.setStorageOrgUnit(souIds);
        this.priceInfo.setMaterialFrom(this.getF7Number(this.bizMaterialFrom));
        this.priceInfo.setMaterialTo(this.getF7Number(this.bizMaterialTo));
        this.priceInfo.setAsstAttrFrom(this.getF7Number(this.bizAsstAttrFrom));
        this.priceInfo.setAsstAttrTo(this.getF7Number(this.bizAsstAttrTo));
        this.priceInfo.setProjectNumFrom(this.getF7Number(this.prmtProjectNumFrom));
        this.priceInfo.setProjectNumTo(this.getF7Number(this.prmtProjectNumTo));
        this.priceInfo.setTrackNumFrom(this.getF7Number(this.prmtTrackNumFrom));
        this.priceInfo.setTrackNumTo(this.getF7Number(this.prmtTrackNumTo));
        this.priceInfo.setWarehouseFrom(this.getF7Number(this.bizWarehouseFrom));
        this.priceInfo.setWarehouseTo(this.getF7Number(this.bizWarehouseTo));
        this.priceInfo.setLocationFrom(this.getF7Number(this.bizLocationFrom));
        this.priceInfo.setLocationTo(this.getF7Number(this.bizLocationTo));
        this.priceInfo.setLotFrom(this.txtLotFrom.getText());
        this.priceInfo.setLotFrom(this.txtLotTo.getText());
        this.priceInfo.setSettlePrice(this.txtSettlePrice.getBigDecimalValue());
    }

    private String getF7Number(KDBizPromptBox box) {
        String number = null;
        IObjectValue value = (IObjectValue)box.getValue();
        if (value != null) {
            number = (String)value.get("number");
        }
        return number;
    }

    public BatchEditPriceInfo getPriceInfo() {
        return this.priceInfo;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isEditPrice = false;
        this.getUIWindow().hide();
    }
}

