/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefFactory;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractFieldEditUI;
import com.kingdee.eas.scm.im.inv.vmi.client.FieldSelectUI;
import com.kingdee.eas.scm.im.inv.vmi.client.QueryEditUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldEditUI
extends AbstractFieldEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FieldEditUI.class);
    private KDTEditAdapter kdtEditEventListener = new KDTEditAdapter(){

        public void editStarting(KDTEditEvent e) {
            try {
                FieldEditUI.this.tbl_ChangedStarting(e);
            }
            catch (Exception e1) {
                FieldEditUI.this.handUIException(e1);
            }
        }

        public void editStopped(KDTEditEvent e) {
        }
    };
    private static final String TB_FIELDNAME = "fieldName";
    private static final String TB_FIELDALIAS = "fieldAlias";
    private static final String TB_ISSCHEDULED = "isScheduled";
    private static final String TB_ISVISIBLE = "isVisible";
    private static final String TB_ISMERGE = "isMerge";
    private static final String TB_ISORDER = "isOrder";
    private boolean isUpdated = false;

    @Override
    public void loadFields() {
        this.removeListener();
        this.beforeLoadFields();
        super.loadFields();
        this.addListener();
        this.setTableFormat();
    }

    private void setTableFormat() {
        if (this.getDetailTable().getRowCount() == 0) {
            return;
        }
        IRow row = null;
        int rowCount = this.getDetailTable().getRowCount();
        boolean isScheduled = false;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getDetailTable().getRow(i);
            isScheduled = (Boolean)row.getCell(TB_ISSCHEDULED).getValue();
            if (!isScheduled) continue;
            row.getStyleAttributes().setBackground(new Color(192, 192, 192));
        }
    }

    protected void tbl_ChangedStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        boolean isScheduled = false;
        isScheduled = (Boolean)this.getDetailTable().getRow(rowIndex).getCell(TB_ISSCHEDULED).getValue();
        if (isScheduled) {
            e.setCancel(true);
            return;
        }
    }

    private void removeListener() {
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this.kdtEditEventListener);
    }

    private void addListener() {
        this.kdtEntry.addKDTEditListener((KDTEditListener)this.kdtEditEventListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.initButtonStatus();
    }

    private void initButtonStatus() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.btnTop.setEnabled(false);
            this.btnBottom.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(true);
            this.btnTop.setEnabled(true);
            this.btnBottom.setEnabled(true);
            this.btnUp.setEnabled(true);
            this.btnDown.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("query.*"));
        return sic;
    }

    private void beforeLoadFields() {
        this.prmtQuery.setReadOnly(true);
        this.handlerNotBinderFields();
    }

    private void handlerNotBinderFields() {
        if (this.editData.getBillBosTypeName() != null) {
            this.bizBillType.setValue((Object)this.editData.getBillBosTypeName());
        }
        if (this.editData != null && this.editData.getQuery() != null) {
            this.prmtQuery.setValue((Object)this.editData.getQuery());
        }
    }

    @Override
    protected void prmtQuery_willShow(SelectorEvent e) throws Exception {
        String key = VMISettleClientUtils.getQueryDefKeyValue(this.editData.getBillBosType());
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"ID", (Object)key);
        RealModeIDList idList = new RealModeIDList();
        idList.add(key);
        uiContext.put((Object)"IDList", (Object)idList);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("editData", this.editData);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FieldSelectUI.class.getName(), (Map)uiContext);
        FieldSelectUI fieldSelectUI = (FieldSelectUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!fieldSelectUI.isCancel()) {
            this.setSeq();
            this.loadFields();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initButtonStatus();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.setSeq();
        super.actionSave_actionPerformed(e);
        this.isUpdated = true;
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            SysUtil.abort();
        }
        if (this.checkIsScheduled()) {
            MsgBox.showInfo((String)this.getResource("ScheduleDataNotDelete"));
            SysUtil.abort();
        }
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.kdtEntry);
        FieldEntryDefInfo fieldEntry = (FieldEntryDefInfo)row.getUserObject();
        this.editData.getEntry().remove(fieldEntry);
        this.setSeq();
        this.loadFields();
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    private void setSeq() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, "seq").setValue((Object)(i + 1 + ""));
        }
    }

    private boolean checkTblIsSelect() {
        return this.kdtEntry.getSelectManager().get(0) != null;
    }

    private boolean checkIsScheduled() {
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        boolean isScheduled = false;
        isScheduled = (Boolean)this.getDetailTable().getRow(rowIndex).getCell(TB_ISSCHEDULED).getValue();
        return isScheduled;
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        if (rowIndex == this.kdtEntry.getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void actionTop_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = 0;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    @Override
    public void actionBottom_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkTblIsSelect()) {
            return;
        }
        int rowIndex = this.kdtEntry.getSelectManager().get(0).getTop();
        if (rowIndex == this.kdtEntry.getRowCount() - 1) {
            return;
        }
        int toRowIndex = this.kdtEntry.getRowCount() - 1;
        this.kdtEntry.moveRow(rowIndex, toRowIndex);
        this.kdtEntry.getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FieldDefFactory.getRemoteInstance();
    }

    public Boolean isUpdated() {
        return this.isUpdated;
    }
}

