/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.im.inv.vmi.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.QueryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractFieldSelectUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleClientUtils;
import com.kingdee.eas.scm.im.inv.vmi.model.PropertyMeta;
import com.kingdee.eas.scm.im.inv.vmi.util.QueryTreeUtil;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FieldSelectUI
extends AbstractFieldSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(FieldSelectUI.class);
    private FieldDefInfo editData = null;
    private QueryDefInfo query = null;
    private boolean isCancel;

    public FieldSelectUI() throws Exception {
        this.fieldSelectTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FieldSelectUI.this.fieldSelectTree_mouseClicked(e);
                }
                catch (Exception e1) {
                    FieldSelectUI.this.handleException(e1);
                }
            }
        });
        this.fieldSelectedList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    FieldSelectUI.this.fieldSelectList_mouseClicked(e);
                }
                catch (Exception e1) {
                    FieldSelectUI.this.handleException(e1);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void fieldSelectTree_mouseClicked(MouseEvent e) throws Exception {
        TreePath tp = this.fieldSelectTree.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        if (e.getClickCount() == 2) {
            this.fieldSelectTreeDoubleClick(treeNode);
        }
    }

    private void fieldSelectTreeDoubleClick(DefaultKingdeeTreeNode treeNode) throws Exception {
        Object obj;
        if (treeNode != null && treeNode.isLeaf() && (obj = treeNode.getUserObject()) instanceof PropertyMeta) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeNode.getParent();
            int childIndex = parent.getIndex((TreeNode)treeNode);
            ListObject listObject = new ListObject((PropertyMeta)obj, parent);
            this.fieldSelectedList.addElement((Object)listObject);
            this.deleteTreeNode(treeNode);
        }
    }

    private void fieldSelectList_mouseClicked(MouseEvent e) throws Exception {
        int selectIndex = this.fieldSelectedList.getSelectedIndex();
        if (selectIndex == -1) {
            return;
        }
        Object selectedValue = this.fieldSelectedList.getSelectedValue();
        if (e.getClickCount() == 2) {
            this.fieldSelectListDoubleClick(selectedValue);
        }
    }

    private void fieldSelectListDoubleClick(Object selectedValue) {
        ListObject listObject = null;
        if (selectedValue == null) {
            return;
        }
        if (selectedValue instanceof ListObject) {
            listObject = (ListObject)selectedValue;
            this.fieldSelectedList.removeElement(selectedValue);
            this.insertNodeInto(listObject);
        }
    }

    private void insertNodeInto(ListObject listObject) {
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)listObject.getProperyMeta());
        treeNode.setText(listObject.getProperyMeta().getName() + "(" + listObject.getProperyMeta().getAlias() + ")");
        int seq = listObject.getProperyMeta().getSeq();
        DefaultKingdeeTreeNode parent = listObject.getParent();
        this.expandNodes(true, (TreeNode)parent);
        DefaultKingdeeTreeNode child = null;
        PropertyMeta dataObject = null;
        int insertIndex = 0;
        child = (DefaultKingdeeTreeNode)parent.getChildAt(parent.getChildCount() - 1);
        dataObject = (PropertyMeta)child.getUserObject();
        if (seq > dataObject.getSeq()) {
            insertIndex = parent.getChildCount();
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                child = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                dataObject = (PropertyMeta)child.getUserObject();
                if (seq >= dataObject.getSeq()) continue;
                insertIndex = i;
                break;
            }
        }
        this.fieldSelectTree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)listObject.getParent(), insertIndex);
        this.fieldSelectTree.repaint();
    }

    public void expandNodes(boolean expand, TreeNode node) {
        if (!node.isLeaf()) {
            DefaultMutableTreeNode defnode = (DefaultMutableTreeNode)node;
            Object[] pathtoRoot = defnode.getPath();
            TreePath path = new TreePath(pathtoRoot);
            for (int childcount = defnode.getChildCount() - 1; childcount >= 0; --childcount) {
                TreeNode child = defnode.getChildAt(childcount);
            }
            if (expand) {
                this.fieldSelectTree.expandPath(path);
            } else {
                this.fieldSelectTree.collapsePath(path);
            }
        }
    }

    private void deleteTreeNode(DefaultKingdeeTreeNode node) throws Exception {
        if (node == null) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        for (int i = 0; i < count; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.deleteTreeNode(child);
        }
        this.fieldSelectTree.removeAllChildrenFromParent((MutableTreeNode)node);
        this.fieldSelectTree.removeNodeFromParent((MutableTreeNode)node);
        this.fieldSelectTree.repaint();
    }

    private void afterLoad() {
        this.editData = (FieldDefInfo)this.getUIContext().get("editData");
        try {
            this.query = VMISettleClientUtils.loadQueryDefInfo(this.editData.getBillBosType());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initDataQueryTree();
    }

    private void initDataQueryTree() {
        DefaultKingdeeTreeNode root = QueryTreeUtil.getFieldSelectTree(this.query, this.editData);
        if (root == null) {
            this.fieldSelectTree.setModel(null);
        } else {
            this.fieldSelectTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.fieldSelectTree.expandOnLevel(1);
            this.fieldSelectTree.setToggleClickCount(1);
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] treePaths = this.fieldSelectTree.getSelectionPaths();
        if (treePaths == null || treePaths.length == 0) {
            return;
        }
        for (int i = 0; i < treePaths.length; ++i) {
            TreePath treePath = treePaths[i];
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            this.fieldSelectTreeDoubleClick(treeNode);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Object[] selectObjs = this.fieldSelectedList.getSelectedValues();
        if (selectObjs == null || selectObjs.length == 0) {
            return;
        }
        for (int i = 0; i < selectObjs.length; ++i) {
            this.fieldSelectListDoubleClick(selectObjs[i]);
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        ListObject listObject = null;
        for (int i = 0; i < this.fieldSelectedList.getElementCount(); ++i) {
            listObject = (ListObject)this.fieldSelectedList.getElement(i);
            this.editData.getEntry().add(this.createNewFieldEntryData(listObject));
        }
        this.disposeUIWindow();
    }

    private FieldEntryDefInfo createNewFieldEntryData(ListObject listObject) {
        FieldEntryDefInfo entryInfo = new FieldEntryDefInfo();
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        entryInfo.setFieldName(listObject.getProperyMeta().getFieldName());
        entryInfo.setFieldTableName(listObject.getProperyMeta().getFullSQLFieldName(SysContext.getSysContext().getOriginLocale()));
        entryInfo.setFieldAlias(listObject.getProperyMeta().getFieldAlias());
        entryInfo.setFieldFullAlias(listObject.getProperyMeta().getFieldFullAlias());
        entryInfo.setIsScheduled(false);
        entryInfo.setIsVisible(true);
        entryInfo.setIsMerge(true);
        entryInfo.setIsOrder(false);
        this.setFieldEntryData(entryInfo, listObject.getProperyMeta().getProperty());
        return entryInfo;
    }

    private void setFieldEntryData(FieldEntryDefInfo entryInfo, PropertyInfo property) {
        String dataType = property.getString("dataType");
        String enumSource = null;
        DataTypeEnum dataTypeEnum = null;
        if (property instanceof LinkPropertyInfo) {
            dataTypeEnum = DataTypeEnum.LinkedProperty;
        } else if ("Enum".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.Enum;
            enumSource = (String)property.get("metadataRef");
        } else if ("Boolean".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.Boolean;
        } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.Date;
        } else if ("BigDecimal".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.BigDecimal;
        } else if ("Integer".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.Integer;
        } else if ("String".equals(dataType)) {
            dataTypeEnum = DataTypeEnum.String;
        } else if ("BOSUuid".endsWith(dataType)) {
            dataTypeEnum = DataTypeEnum.BOSUuid;
        }
        entryInfo.setIsMultilingual(Boolean.valueOf(property.get("isMultilingual").toString()));
        entryInfo.setDataType(dataTypeEnum);
        entryInfo.setEnumSource(enumSource);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    class ListObject {
        PropertyMeta properyMeta;
        DefaultKingdeeTreeNode parent;

        public ListObject(PropertyMeta properyMeta, DefaultKingdeeTreeNode parent) {
            this.properyMeta = properyMeta;
            this.parent = parent;
        }

        public String toString() {
            return this.properyMeta.toString();
        }

        public PropertyMeta getProperyMeta() {
            return this.properyMeta;
        }

        public void setProperyMeta(PropertyMeta properyMeta) {
            this.properyMeta = properyMeta;
        }

        public DefaultKingdeeTreeNode getParent() {
            return this.parent;
        }

        public void setParent(DefaultKingdeeTreeNode parent) {
            this.parent = parent;
        }
    }
}

